

<?php $__env->startSection('content'); ?>
<div class="bg-white rounded-lg shadow-sm p-6">
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">M-Pesa Transactions</h1>
            <p class="text-gray-600 mt-1">View all payment transactions</p>
        </div>
        <div class="flex space-x-3">
            <div class="relative">
                <select id="statusFilter" class="appearance-none bg-white border border-gray-300 rounded-lg px-4 py-2 pr-8 text-sm focus:ring-2 focus:ring-[#0A9961] focus:border-transparent">
                    <option value="">All Status</option>
                    <option value="success">Success</option>
                    <option value="pending">Pending</option>
                    <option value="failed">Failed</option>
                </select>
                <i class="fas fa-chevron-down absolute right-3 top-1/2 transform -translate-y-1/2 text-gray-400 pointer-events-none"></i>
            </div>
            <button onclick="printTransactions()" class="bg-gray-100 hover:bg-gray-200 text-gray-700 px-4 py-2 rounded-lg text-sm font-medium transition-colors duration-200">
                <i class="fas fa-print mr-2"></i>Print
            </button>
            <button onclick="exportTransactions()" class="bg-gray-100 hover:bg-gray-200 text-gray-700 px-4 py-2 rounded-lg text-sm font-medium transition-colors duration-200">
                <i class="fas fa-download mr-2"></i>Export
            </button>
        </div>
    </div>

    <!-- Stats Overview -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-6">
        <div class="bg-gradient-to-br from-green-50 to-green-100 border border-green-200 rounded-lg p-4">
            <div class="flex items-center">
                <div class="bg-green-100 p-3 rounded-lg">
                    <i class="fas fa-check-circle text-green-600 text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm text-green-800 font-medium">Successful</p>
                    <p class="text-2xl font-bold text-green-900"><?php echo e(\App\Models\MpesaTransaction::where('status', 'success')->count()); ?></p>
                </div>
            </div>
        </div>
        
        <div class="bg-gradient-to-br from-yellow-50 to-yellow-100 border border-yellow-200 rounded-lg p-4">
            <div class="flex items-center">
                <div class="bg-yellow-100 p-3 rounded-lg">
                    <i class="fas fa-clock text-yellow-600 text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm text-yellow-800 font-medium">Pending</p>
                    <p class="text-2xl font-bold text-yellow-900"><?php echo e(\App\Models\MpesaTransaction::where('status', 'pending')->count()); ?></p>
                </div>
            </div>
        </div>
        
        <div class="bg-gradient-to-br from-red-50 to-red-100 border border-red-200 rounded-lg p-4">
            <div class="flex items-center">
                <div class="bg-red-100 p-3 rounded-lg">
                    <i class="fas fa-times-circle text-red-600 text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm text-red-800 font-medium">Failed</p>
                    <p class="text-2xl font-bold text-red-900"><?php echo e(\App\Models\MpesaTransaction::where('status', 'failed')->count()); ?></p>
                </div>
            </div>
        </div>
        
        <div class="bg-gradient-to-br from-blue-50 to-blue-100 border border-blue-200 rounded-lg p-4">
            <div class="flex items-center">
                <div class="bg-blue-100 p-3 rounded-lg">
                    <i class="fas fa-money-bill-wave text-blue-600 text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm text-blue-800 font-medium">Total Amount</p>
                    <p class="text-2xl font-bold text-blue-900">Ksh <?php echo e(number_format(\App\Models\MpesaTransaction::sum('amount'), 2)); ?></p>
                </div>
            </div>
        </div>
    </div>

    <!-- Transactions Table -->
    <div class="overflow-x-auto rounded-lg border border-gray-200">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Transaction ID</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Customer/Phone</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Amount</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Order</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Date</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr class="hover:bg-gray-50 transition-colors duration-150">
                    <td class="px-6 py-4 whitespace-nowrap">
                        <div class="text-sm font-mono text-gray-900">
                            <?php if($transaction->transaction_id): ?>
                                <?php echo e($transaction->transaction_id); ?>

                            <?php else: ?>
                                <span class="text-gray-400">N/A</span>
                            <?php endif; ?>
                        </div>
                        <?php if($transaction->checkout_request_id): ?>
                        <div class="text-xs text-gray-500">
                            <?php echo e(substr($transaction->checkout_request_id, 0, 12)); ?>...
                        </div>
                        <?php endif; ?>
                    </td>
                    <td class="px-6 py-4">
                        <div class="flex items-center">
                            <div class="flex-shrink-0 h-8 w-8">
                                <div class="h-8 w-8 rounded-full bg-gradient-to-br from-[#0A9961] to-[#10B981] flex items-center justify-center text-white font-semibold">
                                    <i class="fas fa-user text-sm"></i>
                                </div>
                            </div>
                            <div class="ml-4">
                                <div class="text-sm font-medium text-gray-900">
                                    <?php if($transaction->user): ?>
                                        <?php echo e($transaction->user->name); ?>

                                    <?php else: ?>
                                        Guest
                                    <?php endif; ?>
                                </div>
                                <div class="text-sm text-gray-500">
                                    <i class="fas fa-phone text-xs mr-1"></i><?php echo e($transaction->phone_number); ?>

                                </div>
                            </div>
                        </div>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <div class="text-sm font-bold text-gray-900">Ksh <?php echo e(number_format($transaction->amount, 2)); ?></div>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <?php if($transaction->order): ?>
                        <a href="<?php echo e(route('admin.orders.show', $transaction->order)); ?>" 
                           class="text-[#0A9961] hover:text-[#088753] hover:underline text-sm font-medium">
                            <?php echo e($transaction->order->order_number); ?>

                        </a>
                        <?php else: ?>
                        <span class="text-gray-400 text-sm">No order</span>
                        <?php endif; ?>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <?php
                            $statusColors = [
                                'success' => 'bg-green-100 text-green-800',
                                'pending' => 'bg-yellow-100 text-yellow-800',
                                'failed' => 'bg-red-100 text-red-800'
                            ];
                            $color = $statusColors[$transaction->status] ?? 'bg-gray-100 text-gray-800';
                        ?>
                        <span class="px-3 py-1 inline-flex text-xs leading-5 font-semibold rounded-full <?php echo e($color); ?>">
                            <?php echo e(ucfirst($transaction->status)); ?>

                        </span>
                        <?php if($transaction->response_code && $transaction->response_code != '0'): ?>
                        <div class="text-xs text-red-600 mt-1">
                            Code: <?php echo e($transaction->response_code); ?>

                        </div>
                        <?php endif; ?>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <div class="text-sm text-gray-900"><?php echo e($transaction->created_at->format('M d, Y')); ?></div>
                        <div class="text-sm text-gray-500"><?php echo e($transaction->created_at->format('h:i A')); ?></div>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                        <div class="flex space-x-2">
                            <a href="<?php echo e(route('admin.transactions.show', $transaction)); ?>" 
                               class="text-[#0A9961] hover:text-[#088753] hover:bg-[#0A9961]/10 p-2 rounded-lg transition-colors duration-200"
                               title="View Details">
                                <i class="fas fa-eye"></i>
                            </a>
                            <?php if($transaction->order): ?>
                            <a href="<?php echo e(route('admin.orders.show', $transaction->order)); ?>" 
                               class="text-blue-600 hover:text-blue-800 hover:bg-blue-50 p-2 rounded-lg transition-colors duration-200"
                               title="View Order">
                                <i class="fas fa-shopping-cart"></i>
                            </a>
                            <?php endif; ?>
                        </div>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="7" class="px-6 py-12 text-center">
                        <div class="text-gray-400">
                            <i class="fas fa-money-bill-wave text-4xl mb-3"></i>
                            <p class="text-lg font-medium text-gray-500">No transactions found</p>
                            <p class="text-gray-400 mt-1">M-Pesa transactions will appear here once payments are made</p>
                        </div>
                    </td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    <?php if($transactions->hasPages()): ?>
    <div class="mt-6">
        <?php echo e($transactions->links()); ?>

    </div>
    <?php endif; ?>
</div>

<script>
function printTransactions() {
    window.print();
}

function exportTransactions() {
    alert('Export feature coming soon!');
}

// Filter transactions by status
document.getElementById('statusFilter').addEventListener('change', function() {
    const status = this.value;
    if(status) {
        window.location.href = "<?php echo e(route('admin.transactions.index')); ?>?status=" + status;
    } else {
        window.location.href = "<?php echo e(route('admin.transactions.index')); ?>";
    }
});

// Update filter based on URL parameter
document.addEventListener('DOMContentLoaded', function() {
    const urlParams = new URLSearchParams(window.location.search);
    const status = urlParams.get('status');
    if(status) {
        document.getElementById('statusFilter').value = status;
    }
});
</script>

<style>
@media  print {
    header, footer, aside, .no-print {
        display: none !important;
    }
    
    body {
        padding: 0 !important;
        margin: 0 !important;
    }
    
    .rounded-lg, .shadow-sm {
        border-radius: 0 !important;
        box-shadow: none !important;
    }
}
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\finepoint\resources\views/admin/transactions/index.blade.php ENDPATH**/ ?>