

<?php $__env->startSection('content'); ?>
<div class="container-fluid px-4">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-bold text-gray-900">Deals Management</h1>
        <a href="<?php echo e(route('admin.deals.create')); ?>" 
           class="bg-[#0A9961] hover:bg-[#088552] text-white font-medium py-2 px-4 rounded-lg no-underline flex items-center">
            <i class="fas fa-plus mr-2"></i> Create New Deal
        </a>
    </div>

    <!-- Stats Cards -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-6">
        <div class="bg-white rounded-lg shadow-sm p-4 border border-gray-200">
            <div class="flex items-center">
                <div class="w-10 h-10 rounded-lg bg-blue-100 flex items-center justify-center mr-3">
                    <i class="fas fa-tag text-blue-600"></i>
                </div>
                <div>
                    <div class="text-2xl font-bold text-gray-900"><?php echo e($deals->total()); ?></div>
                    <div class="text-sm text-gray-600">Total Deals</div>
                </div>
            </div>
        </div>
        
        <div class="bg-white rounded-lg shadow-sm p-4 border border-gray-200">
            <div class="flex items-center">
                <div class="w-10 h-10 rounded-lg bg-green-100 flex items-center justify-center mr-3">
                    <i class="fas fa-fire text-green-600"></i>
                </div>
                <div>
                    <div class="text-2xl font-bold text-gray-900"><?php echo e($deals->where('is_active', true)->where('end_date', '>=', now())->count()); ?></div>
                    <div class="text-sm text-gray-600">Active Deals</div>
                </div>
            </div>
        </div>
        
        <div class="bg-white rounded-lg shadow-sm p-4 border border-gray-200">
            <div class="flex items-center">
                <div class="w-10 h-10 rounded-lg bg-yellow-100 flex items-center justify-center mr-3">
                    <i class="fas fa-star text-yellow-600"></i>
                </div>
                <div>
                    <div class="text-2xl font-bold text-gray-900"><?php echo e($deals->where('featured', true)->count()); ?></div>
                    <div class="text-sm text-gray-600">Featured Deals</div>
                </div>
            </div>
        </div>
        
        <div class="bg-white rounded-lg shadow-sm p-4 border border-gray-200">
            <div class="flex items-center">
                <div class="w-10 h-10 rounded-lg bg-red-100 flex items-center justify-center mr-3">
                    <i class="fas fa-clock text-red-600"></i>
                </div>
                <div>
                    <div class="text-2xl font-bold text-gray-900"><?php echo e($deals->where('end_date', '<', now())->count()); ?></div>
                    <div class="text-sm text-gray-600">Expired Deals</div>
                </div>
            </div>
        </div>
    </div>

    <!-- Deals Table -->
    <div class="bg-white rounded-lg shadow-sm overflow-hidden">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Deal</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Type</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Discount</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Dates</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Products</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php $__empty_1 = true; $__currentLoopData = $deals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr class="hover:bg-gray-50">
                        <!-- Deal Info -->
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="flex items-center">
                                <?php if($deal->image): ?>
                                <div class="h-10 w-10 flex-shrink-0">
                                    <img class="h-10 w-10 rounded-lg object-cover" src="<?php echo e(asset('storage/' . $deal->image)); ?>" alt="<?php echo e($deal->title); ?>">
                                </div>
                                <?php else: ?>
                                <div class="h-10 w-10 flex-shrink-0 bg-gray-100 rounded-lg flex items-center justify-center">
                                    <i class="fas fa-tag text-gray-400"></i>
                                </div>
                                <?php endif; ?>
                                <div class="ml-4">
                                    <div class="text-sm font-medium text-gray-900"><?php echo e($deal->title); ?></div>
                                    <div class="text-xs text-gray-500 truncate max-w-xs"><?php echo e(Str::limit($deal->description, 50)); ?></div>
                                    <?php if($deal->featured): ?>
                                    <span class="inline-block mt-1 px-2 py-1 text-xs font-medium bg-yellow-100 text-yellow-800 rounded">Featured</span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </td>
                        
                        <!-- Type -->
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="px-2 py-1 text-xs font-medium rounded-full 
                                <?php if($deal->type == 'percentage'): ?> bg-blue-100 text-blue-800
                                <?php elseif($deal->type == 'fixed'): ?> bg-green-100 text-green-800
                                <?php elseif($deal->type == 'bundle'): ?> bg-purple-100 text-purple-800
                                <?php else: ?> bg-gray-100 text-gray-800
                                <?php endif; ?>">
                                <?php echo e(strtoupper($deal->type)); ?>

                            </span>
                        </td>
                        
                        <!-- Discount -->
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="text-sm text-gray-900 font-medium">
                                <?php if($deal->type == 'percentage'): ?>
                                    <?php echo e($deal->discount_value); ?>% OFF
                                <?php elseif($deal->type == 'fixed'): ?>
                                    Ksh <?php echo e(number_format($deal->discount_value)); ?>

                                <?php else: ?>
                                    Special
                                <?php endif; ?>
                            </div>
                            <?php if($deal->min_purchase): ?>
                            <div class="text-xs text-gray-500">Min: Ksh <?php echo e(number_format($deal->min_purchase)); ?></div>
                            <?php endif; ?>
                        </td>
                        
                        <!-- Status -->
                        <td class="px-6 py-4 whitespace-nowrap">
                            <?php if($deal->end_date < now()): ?>
                                <span class="px-2 py-1 text-xs font-medium bg-red-100 text-red-800 rounded">Expired</span>
                            <?php elseif(!$deal->is_active): ?>
                                <span class="px-2 py-1 text-xs font-medium bg-gray-100 text-gray-800 rounded">Inactive</span>
                            <?php else: ?>
                                <span class="px-2 py-1 text-xs font-medium bg-green-100 text-green-800 rounded">Active</span>
                            <?php endif; ?>
                            
                            <div class="text-xs text-gray-500 mt-1">
                                Used: <?php echo e($deal->used_count); ?>

                                <?php if($deal->usage_limit): ?>
                                / <?php echo e($deal->usage_limit); ?>

                                <?php endif; ?>
                            </div>
                        </td>
                        
                        <!-- Dates -->
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="text-sm text-gray-900"><?php echo e($deal->start_date->format('M d, Y')); ?></div>
                            <div class="text-xs text-gray-500">to <?php echo e($deal->end_date->format('M d, Y')); ?></div>
                            <div class="text-xs text-gray-500 mt-1">
                                <?php if($deal->end_date > now()): ?>
                                    <?php echo e($deal->end_date->diffForHumans()); ?> left
                                <?php else: ?>
                                    <?php echo e($deal->end_date->diffForHumans()); ?> ago
                                <?php endif; ?>
                            </div>
                        </td>
                        
                        <!-- Products -->
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="text-sm font-medium text-gray-900"><?php echo e($deal->products->count()); ?></div>
                            <div class="text-xs text-gray-500">products</div>
                        </td>
                        
                        <!-- Actions -->
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                            <div class="flex items-center space-x-2">
                                <a href="<?php echo e(route('deals.show', $deal->slug)); ?>" 
                                   target="_blank"
                                   class="text-blue-600 hover:text-blue-900 no-underline"
                                   title="View Deal">
                                    <i class="fas fa-eye"></i>
                                </a>
                                
                                <a href="<?php echo e(route('admin.deals.edit', $deal)); ?>" 
                                   class="text-green-600 hover:text-green-900 no-underline"
                                   title="Edit">
                                    <i class="fas fa-edit"></i>
                                </a>
                                
                                <form action="<?php echo e(route('admin.deals.toggle-status', $deal)); ?>" method="POST" class="inline">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" 
                                            class="text-<?php echo e($deal->is_active ? 'yellow' : 'green'); ?>-600 hover:text-<?php echo e($deal->is_active ? 'yellow' : 'green'); ?>-900"
                                            title="<?php echo e($deal->is_active ? 'Deactivate' : 'Activate'); ?>">
                                        <i class="fas fa-<?php echo e($deal->is_active ? 'toggle-on' : 'toggle-off'); ?>"></i>
                                    </button>
                                </form>
                                
                                <form action="<?php echo e(route('admin.deals.destroy', $deal)); ?>" method="POST" class="inline" 
                                      onsubmit="return confirm('Are you sure you want to delete this deal?')">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" 
                                            class="text-red-600 hover:text-red-900"
                                            title="Delete">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="7" class="px-6 py-12 text-center">
                            <div class="text-gray-500">
                                <i class="fas fa-tag text-3xl mb-3"></i>
                                <p class="text-lg">No deals found</p>
                                <p class="text-sm mt-2">Create your first deal to get started</p>
                                <a href="<?php echo e(route('admin.deals.create')); ?>" 
                                   class="inline-block mt-4 text-[#0A9961] hover:text-[#088552] font-medium no-underline">
                                    Create New Deal →
                                </a>
                            </div>
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        
        <!-- Pagination -->
        <?php if($deals->hasPages()): ?>
        <div class="bg-white px-4 py-3 border-t border-gray-200 sm:px-6">
            <?php echo e($deals->links()); ?>

        </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\finepoint\resources\views/admin/deals/index.blade.php ENDPATH**/ ?>