<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Payment Verified - Order #<?php echo e($order->order_number); ?></title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
            background-color: #f9f9f9;
        }
        .container {
            background-color: #ffffff;
            border-radius: 8px;
            padding: 30px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            border: 1px solid #e0e0e0;
        }
        .header {
            background-color: #e8f5e9;
            padding: 25px;
            border-radius: 8px 8px 0 0;
            margin: -30px -30px 30px -30px;
            border-bottom: 1px solid #c8e6c9;
            text-align: center;
        }
        .logo {
            font-size: 24px;
            font-weight: bold;
            color: #0A9961;
            margin-bottom: 15px;
        }
        .success-icon {
            font-size: 48px;
            color: #28a745;
            margin-bottom: 15px;
        }
        .title {
            color: #333;
            font-size: 22px;
            margin: 0 0 10px 0;
        }
        .subtitle {
            color: #666;
            font-size: 16px;
            margin: 0;
        }
        .order-details {
            background-color: #f8f9fa;
            border-radius: 5px;
            padding: 20px;
            margin: 20px 0;
        }
        .next-steps {
            background-color: #e3f2fd;
            border: 1px solid #bbdefb;
            border-radius: 5px;
            padding: 20px;
            margin: 25px 0;
        }
        .btn {
            display: inline-block;
            padding: 12px 24px;
            background-color: #0A9961;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            font-weight: bold;
            margin: 10px 5px;
            transition: background-color 0.3s;
        }
        .btn:hover {
            background-color: #088552;
        }
        .footer {
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #e0e0e0;
            color: #666;
            font-size: 12px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 10px 0;
        }
        table th {
            background-color: #f1f1f1;
            padding: 10px;
            text-align: left;
            border: 1px solid #ddd;
        }
        table td {
            padding: 10px;
            border: 1px solid #ddd;
        }
        .highlight {
            background-color: #e8f5e9;
            padding: 3px 6px;
            border-radius: 3px;
            font-weight: bold;
        }
        .status-badge {
            display: inline-block;
            padding: 5px 10px;
            background-color: #28a745;
            color: white;
            border-radius: 20px;
            font-size: 12px;
            font-weight: bold;
            margin-left: 10px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <div class="success-icon">✅</div>
            <div class="logo"><?php echo e(config('app.name', 'ElectroShop')); ?></div>
            <h1 class="title">Payment Verified Successfully!</h1>
            <p class="subtitle">Your order #<?php echo e($order->order_number); ?> is now being processed</p>
        </div>

        <p>Dear <?php echo e($order->customer_name); ?>,</p>
        
        <p>We're pleased to inform you that your payment for <strong>Order #<?php echo e($order->order_number); ?></strong> 
           has been verified and approved by our team. Your order is now being processed!</p>

        <div class="order-details">
            <h3>📋 Order Summary</h3>
            <p><strong>Order Number:</strong> #<?php echo e($order->order_number); ?></p>
            <p><strong>Payment Method:</strong> Direct Paybill <span class="status-badge">VERIFIED</span></p>
            <p><strong>Order Date:</strong> <?php echo e($order->created_at->format('F d, Y h:i A')); ?></p>
            <p><strong>Total Amount Paid:</strong> <span class="highlight">Ksh <?php echo e(number_format($order->total, 2)); ?></span></p>
            <p><strong>Current Status:</strong> <strong style="color: #0A9961;">Processing</strong></p>
        </div>

        <h3>📦 Order Items</h3>
        <table>
            <thead>
                <tr>
                    <th>Product</th>
                    <th>Qty</th>
                    <th>Price</th>
                    <th>Total</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $order->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($item->product_name); ?></td>
                    <td><?php echo e($item->quantity); ?></td>
                    <td>Ksh <?php echo e(number_format($item->price, 2)); ?></td>
                    <td>Ksh <?php echo e(number_format($item->total, 2)); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
            <tfoot>
                <tr>
                    <td colspan="3" style="text-align: right;"><strong>Total:</strong></td>
                    <td><strong>Ksh <?php echo e(number_format($order->total, 2)); ?></strong></td>
                </tr>
            </tfoot>
        </table>

        <div class="next-steps">
            <h3>🚀 What Happens Next?</h3>
            <ol>
                <li><strong>Order Processing:</strong> Our team is now preparing your items for shipping</li>
                <li><strong>Shipping Details:</strong> We'll contact you within 24 hours to discuss shipping options and costs</li>
                <li><strong>Delivery:</strong> Once shipping is arranged, we'll provide you with delivery updates</li>
                <li><strong>Support:</strong> If you have any questions, reply to this email or contact our support team</li>
            </ol>
            
            <p style="text-align: center; margin-top: 20px;">
                <a href="<?php echo e($orderUrl); ?>" class="btn">View Your Order</a>
            </p>
        </div>

        <h3>🚚 Shipping Information</h3>
        <?php
            $shippingAddress = is_array($order->shipping_address) ? $order->shipping_address : json_decode($order->shipping_address, true);
        ?>
        <?php if(is_array($shippingAddress)): ?>
        <p><strong>Address:</strong> <?php echo e($shippingAddress['address'] ?? ''); ?></p>
        <p><strong>City/State:</strong> <?php echo e($shippingAddress['city'] ?? ''); ?>, <?php echo e($shippingAddress['state'] ?? ''); ?> <?php echo e($shippingAddress['zip'] ?? ''); ?></p>
        <p><strong>Country:</strong> <?php echo e($shippingAddress['country'] ?? ''); ?></p>
        <p><strong>Phone:</strong> <?php echo e($shippingAddress['phone'] ?? $order->customer_phone); ?></p>
        <?php endif; ?>

        <div class="footer">
            <p><strong>Need Help?</strong></p>
            <p>If you have any questions about your order, please reply to this email or contact our support team.</p>
            <p>© <?php echo e(date('Y')); ?> <?php echo e(config('app.name', 'ElectroShop')); ?>. All rights reserved.</p>
            <p>This is an automated message, please do not reply directly to this email.</p>
        </div>
    </div>
</body>
</html><?php /**PATH C:\wamp64\www\finepoint\resources\views/emails/paybill-approved.blade.php ENDPATH**/ ?>