

<?php $__env->startSection('content'); ?>
<div class="mb-6">
    <!-- Settings Header -->
    <div class="bg-gradient-to-r from-[#0A9961] to-[#10B981] rounded-xl shadow-lg overflow-hidden">
        <div class="px-6 py-8 md:px-10 md:py-10">
            <div class="flex flex-col md:flex-row md:items-center justify-between">
                <div class="mb-4 md:mb-0">
                    <h1 class="text-2xl md:text-3xl font-bold text-white mb-2">Settings</h1>
                    <p class="text-white/90 text-sm md:text-base">Manage your profile, password, and system settings</p>
                </div>
                <div class="flex items-center space-x-2">
                    <span class="px-3 py-1 bg-white/20 backdrop-blur-sm text-white text-xs font-medium rounded-lg">
                        <i class="fas fa-cog mr-1"></i> Control Panel
                    </span>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Success/Error Messages -->
<?php if(session('success')): ?>
<div class="mb-6 p-4 bg-green-50 border border-green-200 rounded-lg">
    <div class="flex items-center">
        <i class="fas fa-check-circle text-green-600 mr-3"></i>
        <p class="text-green-800"><?php echo e(session('success')); ?></p>
    </div>
</div>
<?php endif; ?>

<?php if(session('error')): ?>
<div class="mb-6 p-4 bg-red-50 border border-red-200 rounded-lg">
    <div class="flex items-center">
        <i class="fas fa-exclamation-circle text-red-600 mr-3"></i>
        <p class="text-red-800"><?php echo e(session('error')); ?></p>
    </div>
</div>
<?php endif; ?>

<div class="grid grid-cols-1 lg:grid-cols-4 gap-6">
    <!-- Left Sidebar - Settings Navigation -->
    <div class="lg:col-span-1">
        <div class="bg-white rounded-xl shadow-sm border border-gray-200">
            <div class="p-4 border-b border-gray-200">
                <h3 class="text-lg font-semibold text-gray-900">Settings Menu</h3>
            </div>
            <nav class="p-2">
                <a href="#profile" 
                   onclick="showTab('profile')"
                   class="settings-tab flex items-center px-3 py-3 text-sm font-medium rounded-lg mb-1 transition-all duration-200 
                          <?php echo e(session('active_tab', 'profile') == 'profile' ? 'active-link' : 'text-gray-700 hover:bg-gray-100 hover:text-[#0A9961]'); ?>"
                   data-tab="profile">
                    <i class="fas fa-user-circle w-5 mr-3"></i>
                    Profile
                </a>
                <a href="#password" 
                   onclick="showTab('password')"
                   class="settings-tab flex items-center px-3 py-3 text-sm font-medium rounded-lg mb-1 transition-all duration-200 
                          <?php echo e(session('active_tab', 'profile') == 'password' ? 'active-link' : 'text-gray-700 hover:bg-gray-100 hover:text-[#0A9961]'); ?>"
                   data-tab="password">
                    <i class="fas fa-key w-5 mr-3"></i>
                    Password
                </a>
                <a href="#system" 
                   onclick="showTab('system')"
                   class="settings-tab flex items-center px-3 py-3 text-sm font-medium rounded-lg transition-all duration-200 
                          <?php echo e(session('active_tab', 'profile') == 'system' ? 'active-link' : 'text-gray-700 hover:bg-gray-100 hover:text-[#0A9961]'); ?>"
                   data-tab="system">
                    <i class="fas fa-cog w-5 mr-3"></i>
                    System Settings
                </a>
            </nav>
        </div>
    </div>

    <!-- Right Content Area -->
    <div class="lg:col-span-3">
        <!-- Profile Tab -->
        <div id="profile-tab" class="settings-content <?php echo e(session('active_tab', 'profile') == 'profile' ? '' : 'hidden'); ?>">
            <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
                <div class="flex items-center justify-between mb-6">
                    <h2 class="text-xl font-semibold text-gray-900">Profile Information</h2>
                    <span class="text-xs font-medium text-[#0A9961] bg-[#0A9961]/10 px-3 py-1 rounded-full">Personal</span>
                </div>
                
                <form method="POST" action="<?php echo e(route('admin.settings.profile.update')); ?>">
                    <?php echo csrf_field(); ?>
                    <div class="space-y-6">
                        <!-- Profile Image -->
                        <div class="flex items-center space-x-4">
                            <div class="relative">
                                <img class="w-24 h-24 rounded-full border-4 border-white shadow-lg" 
                                     src="https://ui-avatars.com/api/?name=<?php echo e(urlencode($user->name ?? $user->email)); ?>&background=0A9961&color=fff&size=200" 
                                     alt="<?php echo e($user->name ?? $user->email); ?>">
                                <button type="button" class="absolute bottom-0 right-0 bg-[#0A9961] text-white p-2 rounded-full shadow-lg hover:bg-[#088552] transition-colors duration-200">
                                    <i class="fas fa-camera text-xs"></i>
                                </button>
                            </div>
                            <div>
                                <h3 class="font-medium text-gray-900"><?php echo e($user->name); ?></h3>
                                <p class="text-sm text-gray-500"><?php echo e($user->email); ?></p>
                                <p class="text-xs text-gray-400 mt-1">Admin since <?php echo e($user->created_at->format('M d, Y')); ?></p>
                            </div>
                        </div>

                        <!-- Name Field -->
                        <div>
                            <label for="name" class="block text-sm font-medium text-gray-700 mb-1">Full Name</label>
                            <input type="text" 
                                   id="name" 
                                   name="name" 
                                   value="<?php echo e(old('name', $user->name)); ?>"
                                   class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#0A9961] focus:border-transparent transition duration-200"
                                   placeholder="Enter your full name">
                            <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Email Field -->
                        <div>
                            <label for="email" class="block text-sm font-medium text-gray-700 mb-1">Email Address</label>
                            <input type="email" 
                                   id="email" 
                                   name="email" 
                                   value="<?php echo e(old('email', $user->email)); ?>"
                                   class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#0A9961] focus:border-transparent transition duration-200"
                                   placeholder="Enter your email address">
                            <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Submit Button -->
                        <div class="pt-4">
                            <button type="submit" 
                                    class="px-6 py-3 bg-[#0A9961] text-white font-medium rounded-lg hover:bg-[#088552] transition-colors duration-200 flex items-center">
                                <i class="fas fa-save mr-2"></i>
                                Update Profile
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <!-- Password Tab -->
        <div id="password-tab" class="settings-content <?php echo e(session('active_tab', 'profile') == 'password' ? '' : 'hidden'); ?>">
            <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
                <div class="flex items-center justify-between mb-6">
                    <h2 class="text-xl font-semibold text-gray-900">Change Password</h2>
                    <span class="text-xs font-medium text-[#0A9961] bg-[#0A9961]/10 px-3 py-1 rounded-full">Security</span>
                </div>
                
                <form method="POST" action="<?php echo e(route('admin.settings.password.update')); ?>">
                    <?php echo csrf_field(); ?>
                    <div class="space-y-6">
                        <!-- Current Password -->
                        <div>
                            <label for="current_password" class="block text-sm font-medium text-gray-700 mb-1">Current Password</label>
                            <div class="relative">
                                <input type="password" 
                                       id="current_password" 
                                       name="current_password"
                                       class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#0A9961] focus:border-transparent transition duration-200"
                                       placeholder="Enter current password">
                                <button type="button" onclick="togglePassword('current_password')" class="absolute right-3 top-1/2 transform -translate-y-1/2 text-gray-400 hover:text-gray-600">
                                    <i class="fas fa-eye"></i>
                                </button>
                            </div>
                            <?php $__errorArgs = ['current_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- New Password -->
                        <div>
                            <label for="new_password" class="block text-sm font-medium text-gray-700 mb-1">New Password</label>
                            <div class="relative">
                                <input type="password" 
                                       id="new_password" 
                                       name="new_password"
                                       class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#0A9961] focus:border-transparent transition duration-200"
                                       placeholder="Enter new password">
                                <button type="button" onclick="togglePassword('new_password')" class="absolute right-3 top-1/2 transform -translate-y-1/2 text-gray-400 hover:text-gray-600">
                                    <i class="fas fa-eye"></i>
                                </button>
                            </div>
                            <?php $__errorArgs = ['new_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Confirm Password -->
                        <div>
                            <label for="new_password_confirmation" class="block text-sm font-medium text-gray-700 mb-1">Confirm New Password</label>
                            <div class="relative">
                                <input type="password" 
                                       id="new_password_confirmation" 
                                       name="new_password_confirmation"
                                       class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#0A9961] focus:border-transparent transition duration-200"
                                       placeholder="Confirm new password">
                                <button type="button" onclick="togglePassword('new_password_confirmation')" class="absolute right-3 top-1/2 transform -translate-y-1/2 text-gray-400 hover:text-gray-600">
                                    <i class="fas fa-eye"></i>
                                </button>
                            </div>
                        </div>

                        <!-- Password Requirements -->
                        <div class="p-4 bg-gray-50 rounded-lg border border-gray-200">
                            <h4 class="text-sm font-medium text-gray-900 mb-2">Password Requirements:</h4>
                            <ul class="text-xs text-gray-600 space-y-1">
                                <li class="flex items-center">
                                    <i class="fas fa-check-circle text-green-500 mr-2 text-xs"></i>
                                    Minimum 8 characters
                                </li>
                                <li class="flex items-center">
                                    <i class="fas fa-check-circle text-green-500 mr-2 text-xs"></i>
                                    Include letters and numbers
                                </li>
                                <li class="flex items-center">
                                    <i class="fas fa-check-circle text-green-500 mr-2 text-xs"></i>
                                    Avoid common passwords
                                </li>
                            </ul>
                        </div>

                        <!-- Submit Button -->
                        <div class="pt-4">
                            <button type="submit" 
                                    class="px-6 py-3 bg-[#0A9961] text-white font-medium rounded-lg hover:bg-[#088552] transition-colors duration-200 flex items-center">
                                <i class="fas fa-key mr-2"></i>
                                Change Password
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>

<!-- System Settings Tab -->
<div id="system-tab" class="settings-content <?php echo e(session('active_tab', 'profile') == 'system' ? '' : 'hidden'); ?>">
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
        <div class="flex items-center justify-between mb-6">
            <h2 class="text-xl font-semibold text-gray-900">System Settings</h2>
            <span class="text-xs font-medium text-[#0A9961] bg-[#0A9961]/10 px-3 py-1 rounded-full">Configuration</span>
        </div>
        
        <form method="POST" action="<?php echo e(route('admin.settings.system.update')); ?>">
            <?php echo csrf_field(); ?>
            <div class="space-y-6">
                <!-- Site Information -->
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label for="site_name" class="block text-sm font-medium text-gray-700 mb-1">Site Name</label>
                        <input type="text" 
                               id="site_name" 
                               name="site_name" 
                               value="<?php echo e(old('site_name', $systemSettings['site_name'])); ?>"
                               class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#0A9961] focus:border-transparent transition duration-200"
                               placeholder="Enter site name">
                    </div>

                    <div>
                        <label for="site_email" class="block text-sm font-medium text-gray-700 mb-1">Site Email</label>
                        <input type="email" 
                               id="site_email" 
                               name="site_email" 
                               value="<?php echo e(old('site_email', $systemSettings['site_email'])); ?>"
                               class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#0A9961] focus:border-transparent transition duration-200"
                               placeholder="admin@example.com">
                    </div>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label for="site_phone" class="block text-sm font-medium text-gray-700 mb-1">Contact Phone</label>
                        <input type="text" 
                               id="site_phone" 
                               name="site_phone" 
                               value="<?php echo e(old('site_phone', $systemSettings['site_phone'])); ?>"
                               class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#0A9961] focus:border-transparent transition duration-200"
                               placeholder="+254 XXX XXX XXX">
                    </div>

                    <div>
                        <label for="currency" class="block text-sm font-medium text-gray-700 mb-1">Currency</label>
                        <select id="currency" 
                                name="currency"
                                class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#0A9961] focus:border-transparent transition duration-200">
                            <option value="KES" <?php echo e($systemSettings['currency'] == 'KES' ? 'selected' : ''); ?>>Kenyan Shilling (KES)</option>
                            <option value="USD" <?php echo e($systemSettings['currency'] == 'USD' ? 'selected' : ''); ?>>US Dollar (USD)</option>
                            <option value="EUR" <?php echo e($systemSettings['currency'] == 'EUR' ? 'selected' : ''); ?>>Euro (EUR)</option>
                            <option value="GBP" <?php echo e($systemSettings['currency'] == 'GBP' ? 'selected' : ''); ?>>British Pound (GBP)</option>
                        </select>
                    </div>
                </div>

                <!-- Address -->
                <div>
                    <label for="site_address" class="block text-sm font-medium text-gray-700 mb-1">Business Address</label>
                    <textarea id="site_address" 
                              name="site_address"
                              rows="3"
                              class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#0A9961] focus:border-transparent transition duration-200"
                              placeholder="Enter your business address"><?php echo e(old('site_address', $systemSettings['site_address'])); ?></textarea>
                </div>

                <!-- Timezone -->
                <div>
                    <label for="timezone" class="block text-sm font-medium text-gray-700 mb-1">Timezone</label>
                    <select id="timezone" 
                            name="timezone"
                            class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#0A9961] focus:border-transparent transition duration-200">
                        <option value="Africa/Nairobi" <?php echo e($systemSettings['timezone'] == 'Africa/Nairobi' ? 'selected' : ''); ?>>Africa/Nairobi (EAT)</option>
                        <option value="UTC" <?php echo e($systemSettings['timezone'] == 'UTC' ? 'selected' : ''); ?>>UTC</option>
                        <option value="America/New_York" <?php echo e($systemSettings['timezone'] == 'America/New_York' ? 'selected' : ''); ?>>America/New_York (EST)</option>
                        <option value="Europe/London" <?php echo e($systemSettings['timezone'] == 'Europe/London' ? 'selected' : ''); ?>>Europe/London (GMT)</option>
                    </select>
                </div>

                <!-- Payment Settings -->
                <div class="pt-4 border-t border-gray-200">
                    <h3 class="text-lg font-medium text-gray-900 mb-4">Payment Settings</h3>
                    
                    <!-- Payment Methods Toggles -->
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-6">
                        <div>
                            <label class="flex items-center">
                                <input type="checkbox" 
                                    name="mpesa_enabled"
                                    value="1" 
                                    class="h-4 w-4 text-[#0A9961] border-gray-300 rounded focus:ring-[#0A9961]"
                                    <?php echo e($systemSettings['mpesa_enabled'] ? 'checked' : ''); ?>>
                                <span class="ml-2 text-sm text-gray-700">Enable M-Pesa Payments</span>
                            </label>
                            <p class="text-xs text-gray-500 mt-1">Allow customers to pay via M-Pesa STK Push</p>
                        </div>
                        
                        <div>
                            <label class="flex items-center">
                               <input type="checkbox" 
                                    name="cash_on_delivery_enabled"
                                    value="1" 
                                    class="h-4 w-4 text-[#0A9961] border-gray-300 rounded focus:ring-[#0A9961]"
                                    <?php echo e($systemSettings['cash_on_delivery_enabled'] ? 'checked' : ''); ?>>
                                <span class="ml-2 text-sm text-gray-700">Enable Cash on Delivery</span>
                            </label>
                            <p class="text-xs text-gray-500 mt-1">Allow customers to pay on delivery</p>
                        </div>
                        
                        <!-- Direct Paybill Toggle -->
                        <div>
                            <label class="flex items-center">
                               <input type="checkbox" 
                                    name="direct_paybill_enabled"
                                    value="1" 
                                    class="h-4 w-4 text-[#0A9961] border-gray-300 rounded focus:ring-[#0A9961]"
                                    <?php echo e($systemSettings['direct_paybill_enabled'] ?? false ? 'checked' : ''); ?>>
                                <span class="ml-2 text-sm text-gray-700">Enable Direct Paybill</span>
                            </label>
                            <p class="text-xs text-gray-500 mt-1">Customers pay via bank paybill number</p>
                        </div>
                    </div>
                    
                    <!-- Direct Paybill Details -->
                    <div id="paybill_details" class="mt-4 p-4 bg-gray-50 border border-gray-200 rounded-lg <?php echo e(($systemSettings['direct_paybill_enabled'] ?? false) ? '' : 'hidden'); ?>">
                        <h4 class="text-md font-medium text-gray-900 mb-3">Direct Paybill Details</h4>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label for="paybill_number" class="block text-xs font-medium text-gray-700 mb-1">Paybill Number</label>
                                <input type="text" 
                                       id="paybill_number" 
                                       name="paybill_number" 
                                       value="<?php echo e(old('paybill_number', $systemSettings['paybill_number'] ?? '')); ?>"
                                       class="w-full px-3 py-2 text-sm border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#0A9961] focus:border-transparent"
                                       placeholder="e.g., 247247">
                                <p class="text-xs text-gray-500 mt-1">The Paybill number customers will use</p>
                            </div>
                            
                            <div>
                                <label for="paybill_account_number" class="block text-xs font-medium text-gray-700 mb-1">Account Number</label>
                                <input type="text" 
                                       id="paybill_account_number" 
                                       name="paybill_account_number" 
                                       value="<?php echo e(old('paybill_account_number', $systemSettings['paybill_account_number'] ?? '')); ?>"
                                       class="w-full px-3 py-2 text-sm border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#0A9961] focus:border-transparent"
                                       placeholder="e.g., 0715822306">
                                <p class="text-xs text-gray-500 mt-1">Account number for payment reference</p>
                            </div>
                        </div>
                        
                        <div class="mt-3">
                            <label for="paybill_instructions" class="block text-xs font-medium text-gray-700 mb-1">Payment Instructions (Optional)</label>
                            <textarea id="paybill_instructions" 
                                      name="paybill_instructions"
                                      rows="2"
                                      class="w-full px-3 py-2 text-sm border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#0A9961] focus:border-transparent"
                                      placeholder="Additional instructions for customers"><?php echo e(old('paybill_instructions', $systemSettings['paybill_instructions'] ?? '')); ?></textarea>
                            <p class="text-xs text-gray-500 mt-1">Custom instructions shown to customers</p>
                        </div>
                    </div>
                </div>

                <!-- Submit Button -->
                <div class="pt-6 border-t border-gray-200">
                    <button type="submit" 
                            class="px-6 py-3 bg-[#0A9961] text-white font-medium rounded-lg hover:bg-[#088552] transition-colors duration-200 flex items-center">
                        <i class="fas fa-save mr-2"></i>
                        Save System Settings
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>

<script>
    // Tab Switching Function
    function showTab(tabName) {
        // Hide all content tabs
        document.querySelectorAll('.settings-content').forEach(tab => {
            tab.classList.add('hidden');
        });
        
        // Remove active class from all tabs
        document.querySelectorAll('.settings-tab').forEach(link => {
            link.classList.remove('active-link');
            link.classList.add('text-gray-700', 'hover:bg-gray-100', 'hover:text-[#0A9961]');
        });
        
        // Show selected tab
        document.getElementById(tabName + '-tab').classList.remove('hidden');
        
        // Add active class to clicked tab
        const activeTab = document.querySelector(`[data-tab="${tabName}"]`);
        activeTab.classList.add('active-link');
        activeTab.classList.remove('text-gray-700', 'hover:bg-gray-100', 'hover:text-[#0A9961]');
        
        // Update URL hash without scrolling
        history.replaceState(null, null, '#' + tabName);
    }

    // Show/hide paybill details based on toggle
    document.addEventListener('DOMContentLoaded', function() {
        const paybillToggle = document.querySelector('input[name="direct_paybill_enabled"]');
        const paybillDetails = document.getElementById('paybill_details');
        
        function togglePaybillDetails() {
            if (paybillToggle.checked) {
                paybillDetails.classList.remove('hidden');
            } else {
                paybillDetails.classList.add('hidden');
            }
        }
        
        // Initial state
        togglePaybillDetails();
        
        // Add event listener
        if (paybillToggle) {
            paybillToggle.addEventListener('change', togglePaybillDetails);
        }
    });
    
    // Password Toggle Function
    function togglePassword(fieldId) {
        const field = document.getElementById(fieldId);
        const type = field.getAttribute('type') === 'password' ? 'text' : 'password';
        field.setAttribute('type', type);
        
        // Toggle eye icon
        const button = field.nextElementSibling;
        const icon = button.querySelector('i');
        if (type === 'text') {
            icon.classList.remove('fa-eye');
            icon.classList.add('fa-eye-slash');
        } else {
            icon.classList.remove('fa-eye-slash');
            icon.classList.add('fa-eye');
        }
    }
    
    // Check URL hash on page load
    document.addEventListener('DOMContentLoaded', function() {
        const hash = window.location.hash.substring(1);
        if (hash && ['profile', 'password', 'system'].includes(hash)) {
            showTab(hash);
        }
        
        // Highlight tab based on session or default
        const activeTabFromSession = '<?php echo e(session('active_tab', 'profile')); ?>';
        showTab(activeTabFromSession);
    });
    
    // Form Validation Enhancement
    document.querySelectorAll('form').forEach(form => {
        form.addEventListener('submit', function(e) {
            const submitButton = this.querySelector('button[type="submit"]');
            if (submitButton) {
                submitButton.disabled = true;
                submitButton.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i> Saving...';
            }
        });
    });
</script>

<style>
    .settings-tab.active-link {
        background-color: rgba(10, 153, 97, 0.1);
        border-left: 4px solid #0A9961;
        color: #0A9961;
    }
    
    .settings-tab i {
        transition: color 0.2s;
    }
    
    .settings-tab:hover i {
        color: #0A9961;
    }
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\finepoint\resources\views/admin/settings/index.blade.php ENDPATH**/ ?>