

<?php
// Get payment settings from database
$mpesaEnabled = \App\Models\SystemSetting::getValue('mpesa_enabled', false);
$codEnabled = \App\Models\SystemSetting::getValue('cash_on_delivery_enabled', false);
$paybillEnabled = \App\Models\SystemSetting::getValue('direct_paybill_enabled', false);
$paybillDetails = \App\Models\SystemSetting::getPaybillDetails();

// Determine default payment method
$defaultPaymentMethod = 'cod'; // Default to COD
if (!$codEnabled && $mpesaEnabled) {
    $defaultPaymentMethod = 'mpesa';
} elseif (!$mpesaEnabled && !$codEnabled && $paybillEnabled) {
    $defaultPaymentMethod = 'paybill';
} elseif (!$mpesaEnabled && !$codEnabled && !$paybillEnabled) {
    $defaultPaymentMethod = null;
}

// Calculate totals with deals
$originalSubtotal = 0;
$discountTotal = 0;
$subtotal = 0;

foreach ($cartItems as $item) {
    if (is_object($item)) {
        // Database cart item
        $originalPrice = $item->original_price ?? $item->product->price;
        $actualPrice = $item->actual_price ?? $item->product->price;
        $quantity = $item->quantity;
        
        $originalSubtotal += $originalPrice * $quantity;
        $subtotal += $actualPrice * $quantity;
        $discountTotal += ($originalPrice - $actualPrice) * $quantity;
    } else {
        // Session cart item
        $originalPrice = $item['original_price'] ?? $item['price'];
        $actualPrice = $item['price'];
        $quantity = $item['quantity'];
        
        $originalSubtotal += $originalPrice * $quantity;
        $subtotal += $actualPrice * $quantity;
        $discountTotal += ($originalPrice - $actualPrice) * $quantity;
    }
}

$total = $subtotal; // Total is subtotal (shipping calculated separately)
?>

<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-4 py-8">
    <h1 class="text-3xl font-bold mb-6">Checkout</h1>
    
    <!-- Display Success/Error Messages -->
    <?php if(session('success')): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>
    
    <?php if(session('error')): ?>
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
            <?php echo e(session('error')); ?>

        </div>
    <?php endif; ?>

    <!-- Validation Errors Display -->
    <?php if($errors->any()): ?>
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
            <strong class="font-bold">Please fix the following errors:</strong>
            <ul class="mt-1 list-disc list-inside text-sm">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>
    
    <!-- M-Pesa Pending Payment Alert -->
    <?php if(session('mpesa_pending')): ?>
        <div class="bg-yellow-100 border border-yellow-400 text-yellow-700 px-4 py-3 rounded mb-4" id="mpesa-pending-alert">
            <div class="flex items-center">
                <i class="fas fa-info-circle mr-2"></i>
                <span><?php echo e(session('success') ?? 'M-Pesa payment initiated. Please check your phone.'); ?></span>
            </div>
        </div>
    <?php endif; ?>
    
    <!-- Deal Savings Alert -->
    <?php if($discountTotal > 0): ?>
    <div class="bg-green-50 border border-green-200 rounded-lg p-4 mb-4">
        <div class="flex items-center">
            <i class="fas fa-tag text-green-600 mr-3 text-xl"></i>
            <div>
                <p class="font-medium text-green-800">You're saving Ksh <?php echo e(number_format($discountTotal, 2)); ?> with deals!</p>
                <p class="text-sm text-green-700 mt-1">Deal prices have been applied to your order.</p>
            </div>
        </div>
    </div>
    <?php endif; ?>
    
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
        <!-- Shipping Information -->
        <div class="lg:col-span-2">
            <div class="bg-white rounded-lg shadow-sm p-6 mb-6">
                <h2 class="text-xl font-bold mb-4">Shipping Information</h2>
                
                <form action="<?php echo e(route('checkout.process')); ?>" method="POST" id="checkout-form">
                    <?php echo csrf_field(); ?>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Full Name *</label>
                            <input type="text" name="shipping_name" required
                                   class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#0A9961] focus:border-transparent"
                                   value="<?php echo e(old('shipping_name', Auth::user()->name ?? '')); ?>">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Email *</label>
                            <input type="email" name="shipping_email" required
                                   class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#0A9961] focus:border-transparent"
                                   value="<?php echo e(old('shipping_email', Auth::user()->email ?? '')); ?>">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Phone Number *</label>
                            <input type="text" name="shipping_phone" id="shipping_phone" required
                                   class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#0A9961] focus:border-transparent"
                                   placeholder="07XX XXX XXX"
                                   value="<?php echo e(old('shipping_phone')); ?>">
                            <p class="text-xs text-gray-500 mt-1">Enter your contact phone number</p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Address *</label>
                            <input type="text" name="shipping_address" required
                                   class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#0A9961] focus:border-transparent"
                                   value="<?php echo e(old('shipping_address')); ?>">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">City *</label>
                            <input type="text" name="shipping_city" required
                                   class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#0A9961] focus:border-transparent"
                                   value="<?php echo e(old('shipping_city')); ?>">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">State/Region *</label>
                            <input type="text" name="shipping_state" required
                                   class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#0A9961] focus:border-transparent"
                                   value="<?php echo e(old('shipping_state')); ?>">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Zip/Postal Code *</label>
                            <input type="text" name="shipping_zip" required
                                   class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#0A9961] focus:border-transparent"
                                   value="<?php echo e(old('shipping_zip')); ?>"
                                   placeholder="00100">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Country *</label>
                            <select name="shipping_country" required
                                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#0A9961] focus:border-transparent">
                                <option value="">Select Country</option>
                                <option value="Kenya" <?php echo e(old('shipping_country', 'Kenya') == 'Kenya' ? 'selected' : ''); ?>>Kenya</option>
                                <option value="Uganda" <?php echo e(old('shipping_country') == 'Uganda' ? 'selected' : ''); ?>>Uganda</option>
                                <option value="Tanzania" <?php echo e(old('shipping_country') == 'Tanzania' ? 'selected' : ''); ?>>Tanzania</option>
                                <option value="Rwanda" <?php echo e(old('shipping_country') == 'Rwanda' ? 'selected' : ''); ?>>Rwanda</option>
                                <option value="Burundi" <?php echo e(old('shipping_country') == 'Burundi' ? 'selected' : ''); ?>>Burundi</option>
                                <option value="Ethiopia" <?php echo e(old('shipping_country') == 'Ethiopia' ? 'selected' : ''); ?>>Ethiopia</option>
                                <option value="South Sudan" <?php echo e(old('shipping_country') == 'South Sudan' ? 'selected' : ''); ?>>South Sudan</option>
                                <option value="Somalia" <?php echo e(old('shipping_country') == 'Somalia' ? 'selected' : ''); ?>>Somalia</option>
                            </select>
                        </div>
                        <div class="md:col-span-2">
                            <label class="block text-sm font-medium text-gray-700 mb-1">Additional Notes (Optional)</label>
                            <textarea name="shipping_notes" rows="2"
                                      class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#0A9961] focus:border-transparent"
                                      placeholder="Any special instructions for delivery"><?php echo e(old('shipping_notes')); ?></textarea>
                        </div>
                    </div>
                    
                    <!-- Billing Address -->
                    <div class="mb-4">
                        <label class="flex items-center">
                            <input type="checkbox" name="billing_same" id="billing_same" checked 
                                   class="mr-2 rounded border-gray-300 text-[#0A9961] focus:ring-[#0A9961]">
                            <span class="text-sm font-medium text-gray-700">Billing address same as shipping</span>
                        </label>
                    </div>
                    
                    <div id="billing_address" class="hidden grid grid-cols-1 md:grid-cols-2 gap-4 mb-6">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Billing Name *</label>
                            <input type="text" name="billing_name"
                                   class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#0A9961] focus:border-transparent"
                                   value="<?php echo e(old('billing_name')); ?>">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Billing Address *</label>
                            <input type="text" name="billing_address"
                                   class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#0A9961] focus:border-transparent"
                                   value="<?php echo e(old('billing_address')); ?>">
                        </div>
                    </div>
                    
                   <!-- Payment Method -->
                    <div class="mb-6">
                        <h3 class="text-lg font-semibold mb-3">Payment Method</h3>
                        
                        <?php if(!$mpesaEnabled && !$codEnabled && !$paybillEnabled): ?>
                        <div class="bg-red-50 border border-red-200 rounded-lg p-4 mb-4">
                            <div class="flex items-center">
                                <i class="fas fa-exclamation-circle text-red-500 mr-3"></i>
                                <div>
                                    <p class="font-medium text-red-800">No payment methods available</p>
                                    <p class="text-sm text-red-600">Please contact support or check back later.</p>
                                </div>
                            </div>
                        </div>
                        <?php else: ?>
                        <div class="space-y-2">
                            <?php if($codEnabled): ?>
                            <label class="flex items-center p-4 border border-gray-300 rounded-lg cursor-pointer hover:bg-gray-50 <?php echo e(!$codEnabled ? 'opacity-50 cursor-not-allowed' : ''); ?>">
                                <input type="radio" name="payment_method" value="cod" id="cod_payment" 
                                    <?php echo e(old('payment_method', $defaultPaymentMethod) == 'cod' ? 'checked' : ''); ?>

                                    class="mr-3 h-5 w-5 text-[#0A9961] focus:ring-[#0A9961]"
                                    <?php echo e(!$codEnabled ? 'disabled' : ''); ?>>
                                <div>
                                    <span class="font-medium <?php echo e(!$codEnabled ? 'text-gray-400' : 'text-gray-900'); ?>">Cash on Delivery</span>
                                    <p class="text-sm <?php echo e(!$codEnabled ? 'text-gray-400' : 'text-gray-500'); ?>">Pay when you receive the order</p>
                                    <?php if(!$codEnabled): ?>
                                    <p class="text-xs text-red-500 mt-1">Currently unavailable</p>
                                    <?php endif; ?>
                                </div>
                            </label>
                            <?php endif; ?>
                            
                            <?php if($mpesaEnabled): ?>
                            <label class="flex items-center p-4 border border-gray-300 rounded-lg cursor-pointer hover:bg-gray-50 <?php echo e(!$mpesaEnabled ? 'opacity-50 cursor-not-allowed' : ''); ?>">
                                <input type="radio" name="payment_method" value="mpesa" id="mpesa_payment"
                                    <?php echo e(old('payment_method', $defaultPaymentMethod) == 'mpesa' ? 'checked' : ''); ?>

                                    class="mr-3 h-5 w-5 text-[#0A9961] focus:ring-[#0A9961]"
                                    <?php echo e(!$mpesaEnabled ? 'disabled' : ''); ?>>
                                <div>
                                    <span class="font-medium <?php echo e(!$mpesaEnabled ? 'text-gray-400' : 'text-gray-900'); ?>">M-Pesa</span>
                                    <p class="text-sm <?php echo e(!$mpesaEnabled ? 'text-gray-400' : 'text-gray-500'); ?>">Pay securely with Lipa na M-Pesa</p>
                                    <?php if(!$mpesaEnabled): ?>
                                    <p class="text-xs text-red-500 mt-1">Currently unavailable</p>
                                    <?php endif; ?>
                                </div>
                            </label>
                            <?php endif; ?>
                            
                            <?php if($paybillEnabled): ?>
                            <label class="flex items-center p-4 border border-gray-300 rounded-lg cursor-pointer hover:bg-gray-50 <?php echo e(!$paybillEnabled ? 'opacity-50 cursor-not-allowed' : ''); ?>">
                                <input type="radio" name="payment_method" value="paybill" id="paybill_payment"
                                    <?php echo e(old('payment_method', $defaultPaymentMethod) == 'paybill' ? 'checked' : ''); ?>

                                    class="mr-3 h-5 w-5 text-[#0A9961] focus:ring-[#0A9961]"
                                    <?php echo e(!$paybillEnabled ? 'disabled' : ''); ?>>
                                <div>
                                    <span class="font-medium <?php echo e(!$paybillEnabled ? 'text-gray-400' : 'text-gray-900'); ?>">Direct Paybill</span>
                                    <p class="text-sm <?php echo e(!$paybillEnabled ? 'text-gray-400' : 'text-gray-500'); ?>">Pay via bank paybill number</p>
                                    <?php if(!$paybillEnabled): ?>
                                    <p class="text-xs text-red-500 mt-1">Currently unavailable</p>
                                    <?php endif; ?>
                                </div>
                            </label>
                            <?php endif; ?>
                            
                            <?php if(($mpesaEnabled && $codEnabled) || ($mpesaEnabled && $paybillEnabled) || ($codEnabled && $paybillEnabled)): ?>
                            <p class="text-xs text-gray-500 mt-2">Select your preferred payment method</p>
                            <?php endif; ?>
                        </div>
                        <?php endif; ?>
                        
                        <!-- Direct Paybill Instructions Section (Hidden by default) -->
                        <div id="paybill_instructions_section" class="hidden mt-4 p-4 bg-blue-50 border border-blue-200 rounded-lg">
                            <h4 class="text-md font-medium text-blue-900 mb-3">How to Pay via Paybill</h4>
                            <div class="space-y-3">
                                <div class="flex items-start">
                                    <div class="flex-shrink-0 mt-1">
                                        <div class="w-6 h-6 rounded-full bg-blue-100 flex items-center justify-center">
                                            <span class="text-blue-600 text-xs font-bold">1</span>
                                        </div>
                                    </div>
                                    <div class="ml-3">
                                        <p class="text-sm font-medium text-gray-900">Go to M-Pesa Menu</p>
                                        <p class="text-xs text-gray-600">Select <strong>Lipa na M-Pesa</strong> then <strong>Paybill</strong></p>
                                    </div>
                                </div>
                                
                                <div class="flex items-start">
                                    <div class="flex-shrink-0 mt-1">
                                        <div class="w-6 h-6 rounded-full bg-blue-100 flex items-center justify-center">
                                            <span class="text-blue-600 text-xs font-bold">2</span>
                                        </div>
                                    </div>
                                    <div class="ml-3">
                                        <p class="text-sm font-medium text-gray-900">Enter Paybill Details</p>
                                        <p class="text-xs text-gray-600">
                                            <strong>Business No:</strong> 
                                            <span class="font-mono text-blue-700"><?php echo e($paybillDetails['paybill_number'] ?? '247247'); ?></span>
                                        </p>
                                    </div>
                                </div>
                                
                                <div class="flex items-start">
                                    <div class="flex-shrink-0 mt-1">
                                        <div class="w-6 h-6 rounded-full bg-blue-100 flex items-center justify-center">
                                            <span class="text-blue-600 text-xs font-bold">3</span>
                                        </div>
                                    </div>
                                    <div class="ml-3">
                                        <p class="text-sm font-medium text-gray-900">Enter Account Number</p>
                                        <p class="text-xs text-gray-600">
                                            <strong>Account No:</strong> 
                                            <span class="font-mono text-blue-700"><?php echo e($paybillDetails['account_number'] ?? '0715822306'); ?></span>
                                        </p>
                                        <p class="text-xs text-gray-500 mt-1">Use your name or order number as reference</p>
                                    </div>
                                </div>
                                
                                <div class="flex items-start">
                                    <div class="flex-shrink-0 mt-1">
                                        <div class="w-6 h-6 rounded-full bg-blue-100 flex items-center justify-center">
                                            <span class="text-blue-600 text-xs font-bold">4</span>
                                        </div>
                                    </div>
                                    <div class="ml-3">
                                        <p class="text-sm font-medium text-gray-900">Enter Amount</p>
                                        <p class="text-xs text-gray-600">Enter <strong>Ksh <?php echo e(number_format($total, 2)); ?></strong> (Products Only)</p>
                                        <p class="text-xs text-yellow-600 mt-1"><i class="fas fa-info-circle mr-1"></i> Shipping fee will be calculated separately</p>
                                    </div>
                                </div>
                                
                                <?php if(!empty($paybillDetails['instructions'])): ?>
                                <div class="mt-3 p-3 bg-blue-100 border border-blue-300 rounded">
                                    <p class="text-xs text-blue-800">
                                        <i class="fas fa-lightbulb mr-1"></i>
                                        <?php echo e($paybillDetails['instructions']); ?>

                                    </p>
                                </div>
                                <?php endif; ?>
                                
                                <div class="mt-4 p-3 bg-yellow-50 border border-yellow-200 rounded">
                                    <p class="text-xs text-yellow-700">
                                        <i class="fas fa-exclamation-triangle mr-1"></i>
                                        <strong>Important:</strong> After paying, our admin will verify your payment before processing your order. You'll receive an email confirmation once payment is verified.
                                    </p>
                                </div>
                            </div>
                        </div>
                        
                        <!-- M-Pesa Phone Input Section (Hidden by default) -->
                        <div id="mpesa_phone_section" class="hidden mt-4 p-4 bg-gray-50 rounded-lg">
                            <div class="mb-3">
                                <label class="block text-sm font-medium text-gray-700 mb-1">
                                    M-Pesa Phone Number *
                                </label>
                                <div class="flex">
                                    <input type="tel" id="mpesa_phone" 
                                           placeholder="0712 345 678"
                                           class="flex-1 px-4 py-2 border border-gray-300 rounded-l-lg focus:ring-2 focus:ring-[#0A9961] focus:border-transparent">
                                    <button type="button" id="use_shipping_phone" 
                                            class="bg-gray-200 hover:bg-gray-300 text-gray-700 px-4 py-2 border border-gray-300 border-l-0 rounded-r-lg">
                                        Use shipping phone
                                    </button>
                                </div>
                                <p class="text-xs text-gray-500 mt-1">
                                    Enter the phone number registered with M-Pesa
                                </p>
                            </div>
                            <div class="text-center">
                                <button type="button" id="initiate_mpesa" 
                                        class="w-full bg-[#0A9961] hover:bg-[#088753] text-white py-3 px-4 rounded-lg font-medium transition-colors duration-200">
                                    <i class="fas fa-mobile-alt mr-2"></i>
                                    Pay Ksh <?php echo e(number_format($total, 2)); ?> for Products
                                </button>
                                <p class="text-xs text-gray-500 mt-2">
                                    You'll receive a prompt on your phone to enter your M-Pesa PIN
                                </p>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Hidden fields for M-Pesa -->
                    <input type="hidden" name="payment_verified" id="payment_verified" value="0">
                    <input type="hidden" name="checkout_request_id" id="checkout_request_id" value="">
                    <!-- Hidden field to store cart data with deals -->
                    <input type="hidden" name="cart_data" id="cart_data" value="<?php echo e(json_encode($cartItems)); ?>">
                </form>
            </div>
        </div>
        
        <!-- Order Summary Sidebar -->
        <div class="lg:col-span-1">
            <div class="bg-white rounded-lg shadow-sm p-6 sticky top-6">
                <h2 class="text-xl font-bold mb-4">Order Summary</h2>
                
                <div class="space-y-3 mb-4 max-h-64 overflow-y-auto pr-2">
                    <?php $__empty_1 = true; $__currentLoopData = $cartItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <?php
                        if (is_object($item)) {
                            // Database cart item
                            $productName = $item->product->name;
                            $quantity = $item->quantity;
                            $originalPrice = $item->original_price ?? $item->product->price;
                            $actualPrice = $item->actual_price ?? $item->product->price;
                            $hasDeal = !empty($item->deal_id);
                            $dealType = $item->deal_type ?? null;
                            $dealDiscount = $item->deal_discount_value ?? null;
                        } else {
                            // Session cart item
                            $productName = $item['name'];
                            $quantity = $item['quantity'];
                            $originalPrice = $item['original_price'] ?? $item['price'];
                            $actualPrice = $item['price'];
                            $hasDeal = !empty($item['deal_id']);
                            $dealType = $item['deal_type'] ?? null;
                            $dealDiscount = $item['deal_discount_value'] ?? null;
                        }
                        $itemTotal = $actualPrice * $quantity;
                        $itemOriginalTotal = $originalPrice * $quantity;
                        $itemDiscount = $itemOriginalTotal - $itemTotal;
                    ?>
                    
                    <div class="flex justify-between items-center pb-3 border-b border-gray-100">
                        <div class="flex-1">
                            <p class="font-medium"><?php echo e($productName); ?></p>
                            <p class="text-sm text-gray-500">Qty: <?php echo e($quantity); ?></p>
                            
                            <?php if($hasDeal && $itemDiscount > 0): ?>
                                <div class="mt-1">
                                    <?php if($dealType == 'percentage'): ?>
                                        <span class="text-xs bg-red-100 text-red-800 px-2 py-0.5 rounded"><?php echo e($dealDiscount); ?>% OFF</span>
                                    <?php elseif($dealType == 'fixed'): ?>
                                        <span class="text-xs bg-red-100 text-red-800 px-2 py-0.5 rounded">SAVE Ksh <?php echo e(number_format($dealDiscount)); ?></span>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="text-right">
                            <?php if($hasDeal && $itemDiscount > 0): ?>
                                <p class="font-medium whitespace-nowrap">Ksh <?php echo e(number_format($itemTotal, 2)); ?></p>
                                <p class="text-xs text-gray-500 line-through">Ksh <?php echo e(number_format($itemOriginalTotal, 2)); ?></p>
                            <?php else: ?>
                                <p class="font-medium whitespace-nowrap">Ksh <?php echo e(number_format($itemTotal, 2)); ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="text-center py-4 text-gray-500">
                        <i class="fas fa-shopping-cart text-2xl mb-2"></i>
                        <p>Your cart is empty</p>
                    </div>
                    <?php endif; ?>
                </div>
                
                <div class="border-t border-gray-200 pt-4 space-y-2">
                    <?php if($discountTotal > 0): ?>
                    <div class="flex justify-between">
                        <span class="text-gray-600">Original Subtotal</span>
                        <span class="line-through text-gray-500">Ksh <?php echo e(number_format($originalSubtotal, 2)); ?></span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-600">Discount</span>
                        <span class="text-green-600 font-medium">- Ksh <?php echo e(number_format($discountTotal, 2)); ?></span>
                    </div>
                    <?php endif; ?>
                    
                    <div class="flex justify-between">
                        <span class="text-gray-600">Subtotal</span>
                        <span>Ksh <?php echo e(number_format($subtotal, 2)); ?></span>
                    </div>
                    
                    <!-- Shipping Information Note -->
                    <div class="bg-blue-50 border border-blue-200 rounded-lg p-3 mt-3">
                        <div class="flex items-start">
                            <i class="fas fa-info-circle text-blue-500 mt-1 mr-2"></i>
                            <div>
                                <p class="text-sm text-blue-800 font-medium">Shipping Information</p>
                                <p class="text-xs text-blue-600 mt-1">
                                    Shipping fee will be calculated based on your location and order size. 
                                    Our team will contact you with the shipping cost before processing your order.
                                </p>
                            </div>
                        </div>
                    </div>
                    
                    <?php if($discountTotal > 0): ?>
                    <div class="bg-green-50 border border-green-100 rounded-lg p-3">
                        <div class="flex items-center">
                            <i class="fas fa-tag text-green-600 mr-2"></i>
                            <div>
                                <p class="text-sm text-green-800 font-medium">Great deal!</p>
                                <p class="text-xs text-green-700">You saved Ksh <?php echo e(number_format($discountTotal, 2)); ?></p>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>
                    
                    <div class="flex justify-between text-lg font-bold pt-2 border-t border-gray-300">
                        <span>Total (Products Only)</span>
                        <span class="text-[#0A9961]">Ksh <?php echo e(number_format($total, 2)); ?></span>
                    </div>
                </div>
                
                <button type="submit" form="checkout-form" id="place_order_btn"
                        class="w-full mt-6 bg-[#0A9961] hover:bg-[#088753] text-white py-3 px-4 rounded-lg font-medium transition-colors duration-200 flex items-center justify-center">
                    <i class="fas fa-lock mr-2"></i>
                    <span id="place_order_text">Place Order</span>
                </button>
                
                <p class="text-xs text-gray-500 mt-4 text-center">
                    <i class="fas fa-shield-alt mr-1"></i>
                    Secure checkout · Your payment information is encrypted
                </p>
            </div>
        </div>
    </div>
</div>

<!-- Payment Processing Modal -->
<div id="payment_modal" class="hidden fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50 p-4">
    <div class="bg-white rounded-lg p-6 max-w-md w-full">
        <div class="text-center mb-4">
            <div class="inline-flex items-center justify-center w-16 h-16 bg-blue-100 rounded-full mb-4">
                <i class="fas fa-mobile-alt text-blue-600 text-2xl"></i>
            </div>
            <h3 class="text-xl font-bold mb-2">Processing M-Pesa Payment</h3>
            <p class="text-gray-600 mb-4" id="modal_message">Initiating payment request...</p>
        </div>
        
        <div class="bg-gray-50 rounded-lg p-4 mb-4">
            <div class="flex justify-between mb-2">
                <span class="text-gray-600">Amount:</span>
                <span class="font-bold">Ksh <?php echo e(number_format($total, 2)); ?> (Products Only)</span>
            </div>
            <div class="flex justify-between">
                <span class="text-gray-600">Phone:</span>
                <span class="font-bold" id="modal_phone"></span>
            </div>
            <?php if($discountTotal > 0): ?>
            <div class="mt-2 p-2 bg-green-50 border border-green-100 rounded">
                <div class="flex justify-between text-sm">
                    <span class="text-green-700">Deal Savings:</span>
                            <span class="text-green-700 font-medium">Ksh <?php echo e(number_format($discountTotal, 2)); ?></span>
                </div>
            </div>
            <?php endif; ?>
            <div class="bg-yellow-50 border border-yellow-200 rounded p-3 mt-2 text-sm">
                <i class="fas fa-exclamation-circle text-yellow-500 mr-1"></i>
                Shipping fee will be calculated separately and you'll be contacted.
            </div>
        </div>
        
        <div class="text-center">
            <div class="animate-spin rounded-full h-8 w-8 border-b-2 border-[#0A9961] mx-auto mb-4"></div>
            <p class="text-sm text-gray-500 mb-2">Please check your phone</p>
            <p class="text-xs text-gray-400">Enter your M-Pesa PIN when prompted</p>
        </div>
        
        <div class="mt-6 flex justify-center space-x-3">
            <button type="button" id="cancel_payment" 
                    class="px-4 py-2 border border-gray-300 text-gray-700 rounded-lg hover:bg-gray-50">
                Cancel
            </button>
            <button type="button" id="check_status" 
                    class="px-4 py-2 bg-blue-100 text-blue-700 rounded-lg hover:bg-blue-200">
                Check Status
            </button>
        </div>
    </div>
</div>

<!-- Font Awesome Icons -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">

<style>
    .disabled-payment {
        opacity: 0.5;
        cursor: not-allowed;
        pointer-events: none;
    }
    
    .disabled-payment input[type="radio"] {
        cursor: not-allowed;
    }
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Elements
    const checkoutForm = document.getElementById('checkout-form');
    const codPayment = document.getElementById('cod_payment');
    const mpesaPayment = document.getElementById('mpesa_payment');
    const paybillPayment = document.getElementById('paybill_payment');
    const mpesaPhoneSection = document.getElementById('mpesa_phone_section');
    const paybillInstructionsSection = document.getElementById('paybill_instructions_section');
    const shippingPhoneInput = document.getElementById('shipping_phone');
    const mpesaPhoneInput = document.getElementById('mpesa_phone');
    const useShippingPhoneBtn = document.getElementById('use_shipping_phone');
    const initiateMpesaBtn = document.getElementById('initiate_mpesa');
    const placeOrderBtn = document.getElementById('place_order_btn');
    const placeOrderText = document.getElementById('place_order_text');
    const paymentVerifiedInput = document.getElementById('payment_verified');
    const checkoutRequestIdInput = document.getElementById('checkout_request_id');
    const cartDataInput = document.getElementById('cart_data');
    
    // Modal elements
    const paymentModal = document.getElementById('payment_modal');
    const modalMessage = document.getElementById('modal_message');
    const modalPhone = document.getElementById('modal_phone');
    const cancelPaymentBtn = document.getElementById('cancel_payment');
    const checkStatusBtn = document.getElementById('check_status');
    
    // Variables
    let currentCheckoutRequestId = '';
    let statusCheckInterval = null;
    let isProcessingPayment = false;
    let paymentCompleted = false;
    
    // 1. Toggle payment method sections
    function togglePaymentSections() {
        // Reset all sections
        mpesaPhoneSection.classList.add('hidden');
        paybillInstructionsSection.classList.add('hidden');
        placeOrderBtn.disabled = false;
        placeOrderBtn.classList.remove('opacity-50', 'cursor-not-allowed');
        
        // Check which payment method is selected
        if (mpesaPayment && mpesaPayment.checked && !mpesaPayment.disabled) {
            mpesaPhoneSection.classList.remove('hidden');
            placeOrderBtn.disabled = true;
            placeOrderBtn.classList.add('opacity-50', 'cursor-not-allowed');
            placeOrderText.textContent = 'Complete M-Pesa Payment First';
            
            // Auto-fill M-Pesa phone if shipping phone exists
            if (shippingPhoneInput.value.trim()) {
                mpesaPhoneInput.value = shippingPhoneInput.value;
            }
        } 
        else if (paybillPayment && paybillPayment.checked && !paybillPayment.disabled) {
            paybillInstructionsSection.classList.remove('hidden');
            placeOrderText.textContent = 'Place Order (Paybill)';
            
            // Update form action for paybill
            updateFormAction();
        }
        else {
            // COD or no special requirements
            placeOrderText.textContent = 'Place Order';
            
            // Update form action for COD
            updateFormAction();
        }
    }
    
    // 2. Update form action based on payment method
    function updateFormAction() {
        const selectedPayment = document.querySelector('input[name="payment_method"]:checked');
        
        if (selectedPayment) {
            if (selectedPayment.value === 'cod') {
                checkoutForm.action = '<?php echo e(route("checkout.process.cod")); ?>';
            } else if (selectedPayment.value === 'mpesa') {
                checkoutForm.action = '<?php echo e(route("checkout.process")); ?>';
            } else if (selectedPayment.value === 'paybill') {
                checkoutForm.action = '<?php echo e(route("checkout.process.paybill")); ?>';
            }
        }
    }
    
    // 3. Use shipping phone for M-Pesa
    useShippingPhoneBtn.addEventListener('click', function() {
        if (shippingPhoneInput.value.trim()) {
            mpesaPhoneInput.value = shippingPhoneInput.value;
        }
    });
    
    // 4. Validate phone number
    function validatePhoneNumber(phone) {
        // Remove all non-digit characters
        phone = phone.replace(/\D/g, '');
        
        // Check if it's a valid Kenyan mobile number
        if (phone.length === 9 && /^[17]\d{8}$/.test(phone)) {
            return '254' + phone;
        } else if (phone.length === 10 && phone.startsWith('0') && /^0[17]\d{8}$/.test(phone)) {
            return '254' + phone.substring(1);
        } else if (phone.length === 12 && phone.startsWith('254') && /^254[17]\d{8}$/.test(phone)) {
            return phone;
        }
        return null;
    }
    
    // 5. Initiate M-Pesa payment (unchanged from original)
    initiateMpesaBtn.addEventListener('click', async function() {
        const phone = mpesaPhoneInput.value.trim();
        const formattedPhone = validatePhoneNumber(phone);
        
        if (!formattedPhone) {
            alert('Please enter a valid Kenyan phone number (e.g., 0712345678)');
            mpesaPhoneInput.focus();
            return;
        }
        
        if (isProcessingPayment) return;
        isProcessingPayment = true;
        paymentCompleted = false;
        
        // Disable button
        initiateMpesaBtn.disabled = true;
        initiateMpesaBtn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i>Processing...';
        
        // Show modal
        modalPhone.textContent = phone;
        modalMessage.textContent = 'Initiating payment request...';
        modalMessage.className = 'text-gray-600';
        paymentModal.classList.remove('hidden');
        
        try {
            const response = await fetch('<?php echo e(route("process.mpesa.payment")); ?>', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                    'Accept': 'application/json'
                },
                body: JSON.stringify({
                    phone: phone,
                    amount: <?php echo e($total); ?>,
                    order_id: 'ORDER_' + Date.now()
                })
            });
            
            const result = await response.json();
            
            if (result.success) {
                // Store checkout request ID
                currentCheckoutRequestId = result.checkout_request_id;
                checkoutRequestIdInput.value = currentCheckoutRequestId;
                
                // Update modal message
                modalMessage.textContent = result.customer_message || 'Check your phone and enter your M-Pesa PIN';
                
                // Re-enable button
                initiateMpesaBtn.disabled = false;
                initiateMpesaBtn.innerHTML = '<i class="fas fa-mobile-alt mr-2"></i>Pay Ksh <?php echo e(number_format($total, 2)); ?> for Products';
                
                // Start checking payment status
                startPaymentStatusCheck();
                
            } else {
                modalMessage.textContent = result.message || 'Failed to initiate payment';
                modalMessage.classList.add('text-red-600');
                setTimeout(() => {
                    paymentModal.classList.add('hidden');
                }, 3000);
                isProcessingPayment = false;
                initiateMpesaBtn.disabled = false;
                initiateMpesaBtn.innerHTML = '<i class="fas fa-mobile-alt mr-2"></i>Pay Ksh <?php echo e(number_format($total, 2)); ?> for Products';
            }
            
        } catch (error) {
            console.error('Payment error:', error);
            modalMessage.textContent = 'Network error. Please try again.';
            modalMessage.classList.add('text-red-600');
            setTimeout(() => {
                paymentModal.classList.add('hidden');
            }, 3000);
            isProcessingPayment = false;
            initiateMpesaBtn.disabled = false;
            initiateMpesaBtn.innerHTML = '<i class="fas fa-mobile-alt mr-2"></i>Pay Ksh <?php echo e(number_format($total, 2)); ?> for Products';
        }
    });
    
    // 6. Check payment status - FIXED with auto-submit
    function startPaymentStatusCheck() {
        if (statusCheckInterval) {
            clearInterval(statusCheckInterval);
        }
        
        let checkCount = 0;
        const maxChecks = 30; // 1.5 minutes at 3-second intervals
        
        statusCheckInterval = setInterval(async () => {
            if (!currentCheckoutRequestId) {
                clearInterval(statusCheckInterval);
                return;
            }
            
            checkCount++;
            
            if (checkCount > maxChecks) {
                clearInterval(statusCheckInterval);
                modalMessage.textContent = 'Payment timeout. Please refresh and try again.';
                modalMessage.classList.add('text-yellow-600');
                isProcessingPayment = false;
                return;
            }
            
            console.log(`Checking payment status #${checkCount} for request:`, currentCheckoutRequestId);
            
            try {
                const response = await fetch(`<?php echo e(route('check.payment.status')); ?>?checkout_request_id=${currentCheckoutRequestId}&_=${Date.now()}`, {
                    headers: {
                        'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                        'Accept': 'application/json'
                    }
                });
                
                const result = await response.json();
                console.log('Payment status response:', result);
                
                if (result.success) {
                    if (result.status === 'completed') {
                        // Payment successful
                        clearInterval(statusCheckInterval);
                        paymentCompleted = true;
                        
                        // Update UI
                        modalMessage.textContent = '✅ Payment successful! Completing order...';
                        modalMessage.classList.remove('text-gray-600');
                        modalMessage.classList.add('text-green-600');
                        
                        // Update form fields
                        paymentVerifiedInput.value = '1';
                        checkoutRequestIdInput.value = currentCheckoutRequestId;
                        
                        // Enable place order button
                        placeOrderBtn.disabled = false;
                        placeOrderBtn.classList.remove('opacity-50', 'cursor-not-allowed');
                        placeOrderText.textContent = 'Complete Order';
                        
                        // Auto-submit the form after 1.5 seconds
                        setTimeout(() => {
                            console.log('Auto-submitting form after payment success');
                            
                            // Ensure form action is correct
                            updateFormAction();
                            
                            // Show loading on button
                            const originalText = placeOrderBtn.innerHTML;
                            placeOrderBtn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i>Completing Order...';
                            placeOrderBtn.disabled = true;
                            
                            // Submit the form
                            checkoutForm.submit();
                        }, 1500);
                        
                    } else if (result.status === 'failed') {
                        // Payment failed
                        clearInterval(statusCheckInterval);
                        modalMessage.textContent = '❌ Payment failed: ' + result.message;
                        modalMessage.classList.remove('text-gray-600');
                        modalMessage.classList.add('text-red-600');
                        isProcessingPayment = false;
                        
                        // Enable retry button
                        initiateMpesaBtn.disabled = false;
                        initiateMpesaBtn.innerHTML = '<i class="fas fa-mobile-alt mr-2"></i>Try Again';
                    }
                    // If still pending, continue checking
                    
                } else {
                    // API returned error
                    console.error('Payment check error:', result.message);
                }
                
            } catch (error) {
                console.error('Status check error:', error);
            }
        }, 3000); // Check every 3 seconds
    }
    
    // 7. Manual status check
    checkStatusBtn.addEventListener('click', async function() {
        if (!currentCheckoutRequestId) return;
        
        try {
            const response = await fetch(`<?php echo e(route('check.payment.status')); ?>?checkout_request_id=${currentCheckoutRequestId}`);
            const result = await response.json();
            
            if (result.success && result.status === 'completed') {
                modalMessage.textContent = 'Payment verified!';
                modalMessage.classList.add('text-green-600');
            } else {
                modalMessage.textContent = result.message || 'Still waiting for payment...';
            }
        } catch (error) {
            modalMessage.textContent = 'Unable to check status';
        }
    });
    
    // 8. Cancel payment
    cancelPaymentBtn.addEventListener('click', function() {
        if (statusCheckInterval) {
            clearInterval(statusCheckInterval);
        }
        paymentModal.classList.add('hidden');
        isProcessingPayment = false;
        paymentCompleted = false;
    });
    
    // 9. Form submission validation - UPDATED for Paybill
    checkoutForm.addEventListener('submit', function(e) {
        const mpesaRadio = document.getElementById('mpesa_payment');
        const paybillRadio = document.getElementById('paybill_payment');
        
        console.log('Form submitting...');
        console.log('Payment method:', document.querySelector('input[name="payment_method"]:checked')?.value);
        console.log('Payment verified value:', paymentVerifiedInput.value);
        console.log('Form action:', checkoutForm.action);
        
        // For M-Pesa, ensure payment is verified
        if (mpesaRadio && mpesaRadio.checked && !mpesaRadio.disabled) {
            if (paymentVerifiedInput.value !== '1' && !paymentCompleted) {
                e.preventDefault();
                alert('Please complete the M-Pesa payment before placing your order.');
                if (initiateMpesaBtn) {
                    initiateMpesaBtn.focus();
                }
                return false;
            }
            
            // Show processing state
            placeOrderBtn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i>Processing Order...';
            placeOrderBtn.disabled = true;
        }
        // For Paybill, just continue (no special validation needed)
        else if (paybillRadio && paybillRadio.checked && !paybillRadio.disabled) {
            // Show processing state for Paybill
            placeOrderBtn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i>Creating Order...';
            placeOrderBtn.disabled = true;
            
            // Add a confirmation message for Paybill users
            if (!confirm('You have selected Direct Paybill. Please make sure to complete your payment via Paybill. Our admin will verify your payment before processing your order.')) {
                e.preventDefault();
                placeOrderBtn.innerHTML = '<i class="fas fa-lock mr-2"></i><span id="place_order_text">Place Order</span>';
                placeOrderBtn.disabled = false;
                return false;
            }
        }
        
        // Allow form to submit normally
        return true;
    });
    
    // 10. Billing address toggle
    document.getElementById('billing_same').addEventListener('change', function() {
        const billingDiv = document.getElementById('billing_address');
        if (this.checked) {
            billingDiv.classList.add('hidden');
        } else {
            billingDiv.classList.remove('hidden');
        }
    });
    
    // 11. Listen for payment method changes
    document.querySelectorAll('input[name="payment_method"]').forEach(radio => {
        radio.addEventListener('change', function() {
            togglePaymentSections();
            updateFormAction();
        });
    });
    
    // 12. Auto-format phone number
    [shippingPhoneInput, mpesaPhoneInput].forEach(input => {
        input.addEventListener('input', function(e) {
            let value = e.target.value.replace(/\D/g, '');
            if (value.length > 0) {
                if (value.startsWith('0')) {
                    value = value.substring(0, 10);
                } else if (value.startsWith('254')) {
                    value = value.substring(0, 12);
                } else {
                    value = value.substring(0, 9);
                }
                
                // Format with spaces
                if (value.length <= 9) {
                    value = value.replace(/(\d{3})(\d{3})(\d{3})/, '$1 $2 $3');
                } else if (value.length === 10) {
                    value = value.replace(/(\d{1})(\d{3})(\d{3})(\d{3})/, '$1$2 $3 $4');
                } else if (value.length === 12) {
                    value = value.replace(/(\d{3})(\d{3})(\d{3})(\d{3})/, '$1 $2 $3 $4');
                }
            }
            e.target.value = value;
        });
    });
    
    // 13. Initialize
    togglePaymentSections();
    updateFormAction();
    
    // Debug function - can be called from browser console
    window.debugSubmitForm = function() {
        console.log('Manually submitting form...');
        console.log('Form action:', checkoutForm.action);
        console.log('Payment verified:', paymentVerifiedInput.value);
        console.log('Checkout Request ID:', checkoutRequestIdInput.value);
        
        paymentVerifiedInput.value = '1';
        updateFormAction();
        checkoutForm.submit();
    };
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\finepoint\resources\views/checkout.blade.php ENDPATH**/ ?>