<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo $__env->yieldContent('title', 'Finepoint Electronics'); ?></title>

    <!-- Styles -->
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        @import  url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');
        body { font-family: 'Inter', sans-serif; }
        
        /* Dropdown styles */
        .group:hover .group-hover\:visible {
            visibility: visible;
        }
        .group:hover .group-hover\:opacity-100 {
            opacity: 1;
        }
        
        /* Custom scrollbar for dropdown */
        .dropdown-scroll {
            max-height: 400px;
            overflow-y: auto;
        }
        
        .dropdown-scroll::-webkit-scrollbar {
            width: 6px;
        }
        
        .dropdown-scroll::-webkit-scrollbar-track {
            background: #f1f1f1;
            border-radius: 3px;
        }
        
        .dropdown-scroll::-webkit-scrollbar-thumb {
            background: #c1c1c1;
            border-radius: 3px;
        }
        
        .dropdown-scroll::-webkit-scrollbar-thumb:hover {
            background: #a1a1a1;
        }
        
        /* Image hover effects */
        .category-image {
            transition: transform 0.3s ease;
        }
        
        .category-card:hover .category-image {
            transform: scale(1.05);
        }
        
        /* Responsive dropdown width */
        @media (max-width: 1024px) {
            .dropdown-responsive {
                width: calc(100vw - 2rem);
                left: 50% !important;
                transform: translateX(-50%) !important;
            }
            
            /* Hide desktop navigation completely on mobile/tablet */
            .desktop-nav {
                display: none !important;
            }
            
            /* Show mobile menu button */
            .mobile-menu-button {
                display: block !important;
            }
        }
        
        /* Mobile footer links */
        @media (max-width: 500px) {
            .footer-mobile-links {
                display: flex;
                flex-wrap: wrap;
                justify-content: center;
                gap: 1.5rem;
            }
            
            .footer-mobile-link {
                flex: 0 0 auto;
                text-align: center;
            }
        }
        
        /* Ensure images are responsive */
        img {
            max-width: 100%;
            height: auto;
        }
        
        /* Sidebar Mobile Menu */
        .mobile-sidebar {
            position: fixed;
            top: 0;
            right: -100%;
            width: 85%;
            max-width: 320px;
            height: 100vh;
            background: white;
            box-shadow: -4px 0 20px rgba(0, 0, 0, 0.1);
            z-index: 1000;
            transition: right 0.3s ease-in-out;
            overflow-y: auto;
        }
        
        .mobile-sidebar-open {
            right: 0;
        }
        
        .mobile-sidebar-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            z-index: 999;
            opacity: 0;
            visibility: hidden;
            transition: opacity 0.3s ease, visibility 0.3s ease;
        }
        
        .mobile-sidebar-overlay-open {
            opacity: 1;
            visibility: visible;
        }
        
        /* Default hide mobile menu button on desktop */
        .mobile-menu-button {
            display: none;
        }
        
        /* Prevent body scroll when sidebar is open */
        body.sidebar-open {
            overflow: hidden;
        }
    </style>

    <?php echo $__env->yieldPushContent('styles'); ?>
</head>
<body class="bg-gray-50">
    <!-- Navigation -->
    <nav class="bg-white shadow-sm sticky top-0 z-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6">
            <div class="flex justify-between h-14 items-center">
                <!-- Logo -->
                <a href="<?php echo e(route('home')); ?>" class="flex items-center no-underline">
                    <div class="h-8 w-8 rounded-md bg-[#0A9961] flex items-center justify-center mr-2">
                        <i class="fas fa-microchip text-white text-sm"></i>
                    </div>
                    <span class="text-lg font-bold text-gray-900">Finepoint</span>
                    <span class="text-lg font-bold text-[#0A9961]">Electronics</span>
                </a>
                
                <!-- Desktop Navigation Links - HIDDEN ON MOBILE -->
                <div class="desktop-nav lg:flex items-center space-x-6">
                    <a href="<?php echo e(route('home')); ?>" class="text-gray-600 hover:text-[#0A9961] text-sm no-underline">Home</a>
                    <a href="<?php echo e(route('products.public')); ?>" class="text-gray-600 hover:text-[#0A9961] text-sm no-underline">Products</a>
                    
                    <!-- Categories Dropdown - Updated with Grid Layout -->
                    <div class="relative group">
                        <button class="text-gray-600 hover:text-[#0A9961] text-sm no-underline flex items-center focus:outline-none bg-transparent border-none">
                            Categories
                            <i class="fas fa-chevron-down ml-1 text-xs"></i>
                        </button>
                        
                        <!-- Dropdown Menu with Grid -->
                        <div class="absolute left-0 mt-2 w-80 lg:w-96 bg-white rounded-md shadow-lg border border-gray-200 z-50 opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-200 transform group-hover:translate-y-0 -translate-y-2 dropdown-responsive">
                            <div class="p-4">
                                <!-- Header -->
                                <div class="mb-4 pb-2 border-b border-gray-100">
                                    <h3 class="font-semibold text-gray-900 text-sm flex items-center">
                                        <i class="fas fa-th-large mr-2 text-[#0A9961]"></i>
                                        Browse Categories
                                    </h3>
                                </div>
                                
                                <?php
                                    // Get categories for dropdown - limit to 12 for better grid display
                                    $dropdownCategories = \App\Models\Category::where('is_active', true)
                                        ->whereNull('parent_id')
                                        ->withCount(['products' => function ($query) {
                                            $query->where('is_active', true);
                                        }])
                                        ->orderBy('products_count', 'desc')
                                        ->limit(12)
                                        ->get();
                                ?>
                                
                                <?php if($dropdownCategories->count() > 0): ?>
                                    <!-- Grid Layout -->
                                    <div class="dropdown-scroll">
                                        <div class="grid grid-cols-2 sm:grid-cols-3 gap-2 lg:gap-3">
                                            <?php $__currentLoopData = $dropdownCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <a href="<?php echo e(route('category.products', $cat)); ?>" 
                                               class="category-card group block p-2 lg:p-3 bg-gray-50 hover:bg-white rounded-lg border border-gray-200 hover:border-[#0A9961] hover:shadow-md transition-all duration-200 no-underline">
                                                <!-- Image Container -->
                                                <div class="relative w-full h-16 lg:h-20 mb-2 overflow-hidden rounded-md bg-white">
                                                    <?php if($cat->image_url): ?>
                                                        <img src="<?php echo e($cat->image_url); ?>" 
                                                             alt="<?php echo e($cat->name); ?>"
                                                             class="category-image w-full h-full object-cover">
                                                        <div class="absolute inset-0 bg-gradient-to-t from-black/20 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-200"></div>
                                                    <?php else: ?>
                                                        <div class="w-full h-full flex items-center justify-center bg-gradient-to-br from-gray-100 to-gray-200">
                                                            <i class="fas fa-folder text-gray-400 text-xl lg:text-2xl"></i>
                                                        </div>
                                                    <?php endif; ?>
                                                </div>
                                                
                                                <!-- Category Info -->
                                                <div class="text-center">
                                                    <h4 class="font-medium text-gray-900 text-xs truncate mb-1 group-hover:text-[#0A9961]">
                                                        <?php echo e($cat->name); ?>

                                                    </h4>
                                                    <?php if($cat->products_count > 0): ?>
                                                        <div class="inline-flex items-center px-2 py-0.5 rounded-full bg-white border border-gray-300 text-xs text-gray-600">
                                                            <i class="fas fa-box text-[10px] mr-1"></i>
                                                            <?php echo e($cat->products_count); ?>

                                                        </div>
                                                    <?php else: ?>
                                                        <div class="inline-flex items-center px-2 py-0.5 rounded-full bg-gray-100 text-xs text-gray-500">
                                                            No products
                                                        </div>
                                                    <?php endif; ?>
                                                </div>
                                                
                                                <!-- Hover Arrow -->
                                                <div class="absolute top-2 right-2 opacity-0 group-hover:opacity-100 transition-opacity duration-200">
                                                    <i class="fas fa-arrow-right text-[#0A9961] text-xs"></i>
                                                </div>
                                            </a>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                        
                                        <!-- View All Link -->
                                        <?php if($dropdownCategories->count() >= 12): ?>
                                        <div class="mt-4 pt-3 border-t border-gray-100 text-center">
                                            <a href="<?php echo e(route('categories.index')); ?>" 
                                               class="inline-flex items-center text-xs text-[#0A9961] hover:text-[#088552] font-medium no-underline">
                                                <i class="fas fa-th mr-1 text-xs"></i>
                                                View All Categories
                                            </a>
                                        </div>
                                        <?php endif; ?>
                                    </div>
                                <?php else: ?>
                                    <!-- Empty State -->
                                    <div class="py-8 text-center">
                                        <div class="w-12 h-12 rounded-full bg-gray-100 flex items-center justify-center mx-auto mb-3">
                                            <i class="fas fa-folder-open text-gray-400"></i>
                                        </div>
                                        <p class="text-gray-500 text-sm">No categories available</p>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    
                    <a href="<?php echo e(route('deals.index')); ?>" class="text-gray-600 hover:text-[#0A9961] text-sm no-underline">Deals</a>
                    <a href="<?php echo e(route('home')); ?>" class="text-gray-600 hover:text-[#0A9961] text-sm no-underline">Contacts</a>
                </div>
                
                <!-- Actions -->
                <div class="flex items-center space-x-3">
                    <!-- Mobile Menu Button - SHOWN ON MOBILE/TABLET -->
                    <button id="mobile-menu-button" class="mobile-menu-button lg:hidden p-2 text-gray-600 hover:text-[#0A9961]">
                        <i class="fas fa-bars text-lg"></i>
                    </button>
                    
                    <a href="<?php echo e(route('products.public')); ?>" class="p-2 text-gray-500 hover:text-[#0A9961] no-underline hidden lg:block">
                        <i class="fas fa-search"></i>
                    </a>
                    <a href="<?php echo e(route('cart.view')); ?>" class="p-2 text-gray-500 hover:text-[#0A9961] relative no-underline">
                        <i class="fas fa-shopping-cart"></i>
                        <span id="cart-count" class="absolute -top-1 -right-1 bg-[#0A9961] text-white text-xs rounded-full w-4 h-4 flex items-center justify-center">0</span>
                    </a>
                    
                    <?php if(auth()->guard()->check()): ?>
                        <?php if(auth()->user()->isAdmin()): ?>
                            <a href="<?php echo e(route('admin.dashboard')); ?>" class="bg-[#0A9961] hover:bg-[#088552] text-white px-3 py-1.5 rounded text-sm no-underline hidden lg:inline-block">
                                Admin
                            </a>
                        <?php else: ?>
                            <form method="POST" action="<?php echo e(route('logout')); ?>" class="inline hidden lg:inline">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="text-gray-600 hover:text-[#0A9961] text-sm bg-transparent border-none cursor-pointer">
                                    Logout
                                </button>
                            </form>
                        <?php endif; ?>
                    <?php else: ?>
                        <a href="<?php echo e(route('login')); ?>" class="text-gray-600 hover:text-[#0A9961] text-sm no-underline hidden lg:inline">
                            Login
                        </a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </nav>

    <!-- Mobile Sidebar Menu -->
    <div id="mobile-sidebar" class="mobile-sidebar lg:hidden">
        <!-- Sidebar Header -->
        <div class="flex items-center justify-between p-4 border-b border-gray-200">
            <div class="flex items-center">
                <div class="h-8 w-8 rounded-md bg-[#0A9961] flex items-center justify-center mr-2">
                    <i class="fas fa-microchip text-white text-sm"></i>
                </div>
                <span class="font-bold text-gray-900">Finepoint</span>
                <span class="font-bold text-[#0A9961]">Electronics</span>
            </div>
            <button id="close-sidebar" class="p-2 text-gray-500 hover:text-gray-700">
                <i class="fas fa-times text-lg"></i>
            </button>
        </div>
        
        <!-- Sidebar Content -->
        <div class="p-4">
            <div class="space-y-2">
                <a href="<?php echo e(route('home')); ?>" class="flex items-center py-3 px-4 text-gray-700 hover:text-[#0A9961] hover:bg-gray-50 rounded-lg no-underline">
                    <i class="fas fa-home mr-3 text-[#0A9961]"></i>
                    <span>Home</span>
                </a>
                
                <a href="<?php echo e(route('products.public')); ?>" class="flex items-center py-3 px-4 text-gray-700 hover:text-[#0A9961] hover:bg-gray-50 rounded-lg no-underline">
                    <i class="fas fa-box mr-3 text-[#0A9961]"></i>
                    <span>Products</span>
                </a>
                
                <!-- Categories Section -->
                <div class="py-2">
                    <div class="flex items-center py-3 px-4 text-gray-700">
                        <i class="fas fa-folder mr-3 text-[#0A9961]"></i>
                        <span class="font-medium">Categories</span>
                    </div>
                    <div class="pl-10 space-y-1">
                        <?php
                            $mobileCategories = \App\Models\Category::where('is_active', true)
                                ->whereNull('parent_id')
                                ->withCount('products')
                                ->limit(6)
                                ->get();
                        ?>
                        
                        <?php $__currentLoopData = $mobileCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <a href="<?php echo e(route('category.products', $cat)); ?>" 
                           class="flex items-center justify-between py-2 px-4 text-sm text-gray-600 hover:text-[#0A9961] hover:bg-gray-50 rounded no-underline">
                            <div class="flex items-center">
                                <?php if($cat->image_url): ?>
                                    <img src="<?php echo e($cat->image_url); ?>" alt="<?php echo e($cat->name); ?>" class="w-6 h-6 rounded-full object-cover mr-2">
                                <?php else: ?>
                                    <div class="w-6 h-6 rounded-full bg-gray-200 flex items-center justify-center mr-2">
                                        <i class="fas fa-folder text-gray-400 text-xs"></i>
                                    </div>
                                <?php endif; ?>
                                <span><?php echo e($cat->name); ?></span>
                            </div>
                            <?php if($cat->products_count > 0): ?>
                                <span class="text-xs bg-gray-100 text-gray-600 px-2 py-1 rounded-full">
                                    <?php echo e($cat->products_count); ?>

                                </span>
                            <?php endif; ?>
                        </a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        
                        <?php if($mobileCategories->count() > 0): ?>
                        <a href="<?php echo e(route('categories.index')); ?>" 
                           class="flex items-center py-2 px-4 text-sm text-[#0A9961] font-medium hover:bg-gray-50 rounded no-underline">
                            <i class="fas fa-eye mr-2"></i>
                            View All Categories
                        </a>
                        <?php endif; ?>
                    </div>
                </div>
                
                <a href="<?php echo e(route('deals.index')); ?>" class="flex items-center py-3 px-4 text-gray-700 hover:text-[#0A9961] hover:bg-gray-50 rounded-lg no-underline">
                    <i class="fas fa-fire mr-3 text-[#0A9961]"></i>
                    <span>Deals</span>
                </a>
                
                <a href="<?php echo e(route('home')); ?>" class="flex items-center py-3 px-4 text-gray-700 hover:text-[#0A9961] hover:bg-gray-50 rounded-lg no-underline">
                    <i class="fas fa-address-book mr-3 text-[#0A9961]"></i>
                    <span>Contacts</span>
                </a>
                
                <!-- Search in Sidebar -->
                <div class="py-2 px-4">
                    <div class="relative">
                        <input type="text" 
                               placeholder="Search products..." 
                               class="w-full px-4 py-2 pl-10 text-sm border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[#0A9961] focus:border-transparent">
                        <i class="fas fa-search absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-400"></i>
                    </div>
                </div>
                
                <!-- User Actions -->
                <div class="pt-4 border-t border-gray-200 mt-4">
                    <?php if(auth()->guard()->check()): ?>
                        <?php if(auth()->user()->isAdmin()): ?>
                            <a href="<?php echo e(route('admin.dashboard')); ?>" class="flex items-center py-3 px-4 text-gray-700 hover:text-[#0A9961] hover:bg-gray-50 rounded-lg no-underline">
                                <i class="fas fa-cog mr-3 text-[#0A9961]"></i>
                                <span>Admin Panel</span>
                            </a>
                            <form method="POST" action="<?php echo e(route('logout')); ?>" class="w-full">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="flex items-center w-full py-3 px-4 text-gray-700 hover:text-[#0A9961] hover:bg-gray-50 rounded-lg no-underline bg-transparent border-none cursor-pointer text-left">
                                    <i class="fas fa-sign-out-alt mr-3 text-[#0A9961]"></i>
                                    <span>Logout</span>
                                </button>
                            </form>
                        <?php else: ?>
                            <form method="POST" action="<?php echo e(route('logout')); ?>" class="w-full">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="flex items-center w-full py-3 px-4 text-gray-700 hover:text-[#0A9961] hover:bg-gray-50 rounded-lg no-underline bg-transparent border-none cursor-pointer text-left">
                                    <i class="fas fa-sign-out-alt mr-3 text-[#0A9961]"></i>
                                    <span>Logout</span>
                                </button>
                            </form>
                        <?php endif; ?>
                    <?php else: ?>
                        <a href="<?php echo e(route('login')); ?>" class="flex items-center py-3 px-4 text-gray-700 hover:text-[#0A9961] hover:bg-gray-50 rounded-lg no-underline">
                            <i class="fas fa-sign-in-alt mr-3 text-[#0A9961]"></i>
                            <span>Login</span>
                        </a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        
        <!-- Sidebar Footer -->
        <div class="absolute bottom-0 left-0 right-0 p-4 border-t border-gray-200 bg-gray-50">
            <div class="text-center text-xs text-gray-500">
                <p>&copy; <?php echo e(date('Y')); ?> Finepoint Electronics</p>
            </div>
        </div>
    </div>
    
    <!-- Sidebar Overlay -->
    <div id="sidebar-overlay" class="mobile-sidebar-overlay lg:hidden"></div>

    <!-- Main Content -->
    <main class="min-h-[calc(100vh-300px)]">
        <?php echo $__env->yieldContent('content'); ?>
    </main>

    <!-- FOOTER -->
    <footer class="bg-gray-900 text-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 py-8">
            <!-- Mobile Layout (Hidden on desktop) -->
            <div class="block lg:hidden">
                <!-- Horizontal Quick Links -->
                <div class="footer-mobile-links mb-6">
                    <div class="footer-mobile-link">
                        <a href="<?php echo e(route('home')); ?>" class="flex flex-col items-center text-gray-400 hover:text-white no-underline">
                            <i class="fas fa-home text-lg mb-1"></i>
                            <span class="text-xs">Home</span>
                        </a>
                    </div>
                    <div class="footer-mobile-link">
                        <a href="<?php echo e(route('products.public')); ?>" class="flex flex-col items-center text-gray-400 hover:text-white no-underline">
                            <i class="fas fa-box text-lg mb-1"></i>
                            <span class="text-xs">Products</span>
                        </a>
                    </div>
                    <div class="footer-mobile-link">
                        <a href="<?php echo e(route('categories.index')); ?>" class="flex flex-col items-center text-gray-400 hover:text-white no-underline">
                            <i class="fas fa-folder text-lg mb-1"></i>
                            <span class="text-xs">Categories</span>
                        </a>
                    </div>
                    <div class="footer-mobile-link">
                        <a href="<?php echo e(route('cart.view')); ?>" class="flex flex-col items-center text-gray-400 hover:text-white no-underline">
                            <i class="fas fa-shopping-cart text-lg mb-1"></i>
                            <span class="text-xs">Cart</span>
                        </a>
                    </div>
                </div>
                
                <!-- Brand Info -->
                <div class="text-center mb-6">
                    <div class="flex items-center justify-center mb-3">
                        <div class="h-6 w-6 rounded-md bg-[#0A9961] flex items-center justify-center mr-2">
                            <i class="fas fa-microchip text-white text-xs"></i>
                        </div>
                        <span class="font-bold">Finepoint</span>
                        <span class="font-bold text-[#0A9961]">Electronics</span>
                    </div>
                    <p class="text-gray-400 text-xs mb-4">Your trusted electronics store</p>
                </div>
                
                <!-- Contact Info -->
                <div class="text-center">
                    <h3 class="font-medium mb-3 text-sm">Contact</h3>
                    <div class="space-y-2">
                        <div class="flex items-center justify-center">
                            <i class="fas fa-phone mr-2 text-[#0A9961] text-xs"></i>
                            <span class="text-gray-400 text-xs">+254700 123 456</span>
                        </div>
                        <div class="flex items-center justify-center">
                            <i class="fas fa-envelope mr-2 text-[#0A9961] text-xs"></i>
                            <span class="text-gray-400 text-xs"><a href="mailto:support@finepoint.com" class="text-gray-400 hover:text-white no-underline">support@finepoint.com</a></span>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Desktop Layout (Hidden on mobile) -->
            <div class="hidden lg:grid lg:grid-cols-3 gap-8">
                <!-- Brand Column -->
                <div>
                    <div class="flex items-center mb-3">
                        <div class="h-6 w-6 rounded-md bg-[#0A9961] flex items-center justify-center mr-2">
                            <i class="fas fa-microchip text-white text-xs"></i>
                        </div>
                        <span class="font-bold">Finepoint</span>
                        <span class="font-bold text-[#0A9961]">Electronics</span>
                    </div>
                    <p class="text-gray-400 text-xs">Your trusted electronics store for quality products.</p>
                </div>
                
                <!-- Quick Links Column -->
                <div>
                    <h3 class="font-medium mb-3 text-sm">Quick Links</h3>
                    <ul class="space-y-2 text-xs text-gray-400">
                        <li><a href="<?php echo e(route('home')); ?>" class="hover:text-white no-underline flex items-center">
                            <i class="fas fa-home mr-2 text-[#0A9961]"></i> Home
                        </a></li>
                        <li><a href="<?php echo e(route('products.public')); ?>" class="hover:text-white no-underline flex items-center">
                            <i class="fas fa-box mr-2 text-[#0A9961]"></i> Products
                        </a></li>
                        <li><a href="<?php echo e(route('categories.index')); ?>" class="hover:text-white no-underline flex items-center">
                            <i class="fas fa-folder mr-2 text-[#0A9961]"></i> Categories
                        </a></li>
                        <li><a href="<?php echo e(route('cart.view')); ?>" class="hover:text-white no-underline flex items-center">
                            <i class="fas fa-shopping-cart mr-2 text-[#0A9961]"></i> Cart
                        </a></li>
                    </ul>
                </div>
                
                <!-- Contact Column -->
                <div>
                    <h3 class="font-medium mb-3 text-sm">Contact</h3>
                    <ul class="space-y-2 text-xs text-gray-400">
                        <li class="flex items-center">
                            <i class="fas fa-phone mr-2 text-[#0A9961] text-xs"></i>
                            +254700 123 456
                        </li>
                        <li class="flex items-center">
                            <i class="fas fa-envelope mr-2 text-[#0A9961] text-xs"></i>
                            support@finepoint.com
                        </li>
                    </ul>
                </div>
            </div>
            
            <!-- Copyright (Both mobile and desktop) -->
            <div class="border-t border-gray-800 mt-6 pt-6 text-center text-gray-400 text-xs">
                <p>&copy; <?php echo e(date('Y')); ?> Finepoint Electronics. All rights reserved. Developed by info@dicesystems.co.ke</p>
            </div>
        </div>
    </footer>
    <!-- END FOOTER -->

    <!-- JavaScript -->
    <script>
        // Function to update cart count
        function updateCartCount() {
            fetch('<?php echo e(route("cart.count")); ?>')
                .then(response => response.json())
                .then(data => {
                    const cartCountElement = document.getElementById('cart-count');
                    if (cartCountElement) {
                        cartCountElement.textContent = data.cart_count;
                    }
                })
                .catch(error => {
                    console.error('Error fetching cart count:', error);
                });
        }
        
        // Sidebar functionality
        const mobileMenuButton = document.getElementById('mobile-menu-button');
        const closeSidebarButton = document.getElementById('close-sidebar');
        const sidebar = document.getElementById('mobile-sidebar');
        const overlay = document.getElementById('sidebar-overlay');
        const body = document.body;
        
        function openSidebar() {
            sidebar.classList.add('mobile-sidebar-open');
            overlay.classList.add('mobile-sidebar-overlay-open');
            body.classList.add('sidebar-open');
        }
        
        function closeSidebar() {
            sidebar.classList.remove('mobile-sidebar-open');
            overlay.classList.remove('mobile-sidebar-overlay-open');
            body.classList.remove('sidebar-open');
        }
        
        // Open sidebar when hamburger is clicked
        if (mobileMenuButton) {
            mobileMenuButton.addEventListener('click', openSidebar);
        }
        
        // Close sidebar when close button is clicked
        if (closeSidebarButton) {
            closeSidebarButton.addEventListener('click', closeSidebar);
        }
        
        // Close sidebar when overlay is clicked
        if (overlay) {
            overlay.addEventListener('click', closeSidebar);
        }
        
        // Close sidebar when pressing Escape key
        document.addEventListener('keydown', function(event) {
            if (event.key === 'Escape') {
                closeSidebar();
                
                // Also close dropdowns if open
                const openDropdowns = document.querySelectorAll('.opacity-100.visible');
                openDropdowns.forEach(dropdown => {
                    dropdown.classList.add('opacity-0', 'invisible');
                    dropdown.classList.remove('opacity-100', 'visible');
                });
            }
        });
        
        // Close dropdown when clicking outside
        document.addEventListener('click', function(event) {
            const dropdowns = document.querySelectorAll('.group');
            dropdowns.forEach(dropdown => {
                if (!dropdown.contains(event.target)) {
                    const menu = dropdown.querySelector('.opacity-0');
                    if (menu && !menu.classList.contains('invisible')) {
                        menu.classList.add('opacity-0', 'invisible');
                        menu.classList.remove('opacity-100', 'visible');
                    }
                }
            });
        });
        
        // Initialize cart count on page load
        document.addEventListener('DOMContentLoaded', function() {
            updateCartCount();
        });
    </script>

    <?php echo $__env->yieldPushContent('scripts'); ?>
     <?php echo $__env->yieldContent('scripts'); ?>
</body>
</html><?php /**PATH C:\wamp64\www\finepoint\resources\views/layouts/app.blade.php ENDPATH**/ ?>