<?php
echo "<h3>Testing Internet Connection</h3>";

// Test 1: Check if we can resolve DNS
echo "<p>1. Testing DNS resolution...</p>";
$ip = gethostbyname('sandbox.safaricom.co.ke');
if ($ip === 'sandbox.safaricom.co.ke') {
    echo "<p style='color: red;'>✗ Cannot resolve sandbox.safaricom.co.ke</p>";
} else {
    echo "<p style='color: green;'>✓ sandbox.safaricom.co.ke resolves to: $ip</p>";
}

// Test 2: Check if we can connect
echo "<p>2. Testing connection...</p>";
$ch = curl_init('https://sandbox.safaricom.co.ke/');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 10);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
$response = curl_exec($ch);

if (curl_errno($ch)) {
    echo "<p style='color: red;'>✗ Connection error: " . curl_error($ch) . "</p>";
} else {
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    echo "<p style='color: green;'>✓ Connected! HTTP Code: $httpCode</p>";
}
curl_close($ch);

// Test 3: Check file_get_contents
echo "<p>3. Testing file_get_contents...</p>";
$context = stream_context_create([
    'ssl' => [
        'verify_peer' => false,
        'verify_peer_name' => false,
    ],
]);

try {
    $content = @file_get_contents('https://sandbox.safaricom.co.ke/', false, $context);
    if ($content === false) {
        echo "<p style='color: red;'>✗ file_get_contents failed</p>";
    } else {
        echo "<p style='color: green;'>✓ file_get_contents successful</p>";
    }
} catch (Exception $e) {
    echo "<p style='color: red;'>✗ Exception: " . $e->getMessage() . "</p>";
}