import http from 'k6/http';
import { check, sleep } from 'k6';
import { Rate } from 'k6/metrics';

// Custom metric for failure rate
const failureRate = new Rate('failed_requests');

export const options = {
  stages: [
    { duration: '30s', target: 20 },   // Ramp up to 20 users
    { duration: '1m', target: 20 },    // Stay at 20 users
    { duration: '30s', target: 50 },   // Ramp up to 50 users
    { duration: '1m', target: 50 },    // Stay at 50 users
    { duration: '30s', target: 100 },  // Ramp up to 100 users
    { duration: '1m', target: 100 },   // Peak load
    { duration: '30s', target: 0 },    // Ramp down
  ],
  thresholds: {
    http_req_duration: ['p(95)<2000'], // 95% of requests < 2s
    failed_requests: ['rate<0.1'],     // <10% failures
  },
};

export default function () {
  const BASE_URL = 'http://your-site.test'; // Change to your URL
  
  // Test 1: Visit checkout page (most critical)
  const checkoutPage = http.get(`${BASE_URL}/checkout`);
  
  // Test 2: Simulate checkout submission
  const payload = JSON.stringify({
    shipping_name: `Test User ${Math.random()}`,
    shipping_email: `test${Math.random()}@example.com`,
    shipping_phone: '0712' + Math.floor(Math.random() * 1000000),
    shipping_address: 'Test Address',
    payment_method: 'cod',
    _token: 'simulated_token'
  });
  
  const headers = {
    'Content-Type': 'application/json',
  };
  
  const checkoutSubmit = http.post(`${BASE_URL}/checkout/process`, payload, { headers });
  
  // Check if requests succeeded
  const checks = check(checkoutSubmit, {
    'status is 200 or 302': (r) => r.status === 200 || r.status === 302,
    'response time < 3s': (r) => r.timings.duration < 3000,
  });
  
  // Record failure
  failureRate.add(!checks);
  
  // Simulate think time between actions
  sleep(2);
}4