-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Host: 127.0.0.1:3306
-- Generation Time: Dec 16, 2025 at 07:47 AM
-- Server version: 9.1.0
-- PHP Version: 8.3.14

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `finepoint`
--

-- --------------------------------------------------------

--
-- Table structure for table `carts`
--

DROP TABLE IF EXISTS `carts`;
CREATE TABLE IF NOT EXISTS `carts` (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` bigint UNSIGNED NOT NULL,
  `product_id` bigint UNSIGNED NOT NULL,
  `quantity` int NOT NULL DEFAULT '1',
  `original_price` decimal(10,2) DEFAULT NULL,
  `deal_id` bigint UNSIGNED DEFAULT NULL,
  `deal_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deal_discount_value` decimal(10,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `carts_user_id_product_id_unique` (`user_id`,`product_id`),
  KEY `carts_product_id_foreign` (`product_id`),
  KEY `carts_deal_id_foreign` (`deal_id`)
) ENGINE=MyISAM AUTO_INCREMENT=36 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `carts`
--

INSERT INTO `carts` (`id`, `user_id`, `product_id`, `quantity`, `original_price`, `deal_id`, `deal_type`, `deal_discount_value`, `created_at`, `updated_at`) VALUES
(19, 5, 1, 1, NULL, NULL, NULL, NULL, '2025-12-05 11:27:13', '2025-12-05 11:27:13'),
(33, 5, 8, 1, 15000.00, NULL, NULL, NULL, '2025-12-15 05:28:34', '2025-12-15 05:28:34'),
(18, 5, 4, 1, NULL, NULL, NULL, NULL, '2025-12-05 10:53:06', '2025-12-05 10:53:06');

-- --------------------------------------------------------

--
-- Table structure for table `categories`
--

DROP TABLE IF EXISTS `categories`;
CREATE TABLE IF NOT EXISTS `categories` (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` bigint UNSIGNED DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `meta_title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_description` text COLLATE utf8mb4_unicode_ci,
  `meta_keywords` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `categories_slug_unique` (`slug`),
  KEY `categories_parent_id_foreign` (`parent_id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `categories`
--

INSERT INTO `categories` (`id`, `name`, `slug`, `description`, `image`, `parent_id`, `is_active`, `meta_title`, `meta_description`, `meta_keywords`, `order`, `created_at`, `updated_at`) VALUES
(1, 'Phones', 'phones', 'all phones', 'categories/FgjcGM13GHc8YNWEbr2RgBx0W45V1tcXrJXJ8I8d.jpg', NULL, 1, 'Phones | finepoint', NULL, NULL, 0, '2025-12-01 17:50:13', '2025-12-03 07:14:37'),
(2, 'tv', 'tv', 'tvs', 'categories/BlpIWMV8jX57ByOV8uzQ4Ei1LJwX9hg1ZvK826Pn.jpg', NULL, 1, 'tv | finepoint', NULL, NULL, 0, '2025-12-02 13:03:06', '2025-12-03 07:14:02'),
(3, 'remotes', 'remotes', 'tv remotes', 'categories/bNWYusl80MnWGYHW1skA7KyupP9kELD3OuvmVqDE.jpg', NULL, 1, 'organisation design | finepoint', NULL, NULL, 0, '2025-12-03 01:45:12', '2025-12-03 07:15:20'),
(4, 'iPhones', 'iphones', 'iphones-brand new', 'categories/ZZYHinu11pByGTdmY4P0xVAWTMQXRNmgNfLYvEFz.jpg', NULL, 1, 'Phones | finepoint', NULL, NULL, 0, '2025-12-03 03:05:00', '2025-12-03 03:05:00'),
(5, 'fridges', 'fridges', '2-door-fridge', 'categories/mCNyfadECpa7ChikeQ5dRDHsodbqN3EQockllPbR.jpg', NULL, 1, 'fridges | finepoint', NULL, NULL, 0, '2025-12-03 06:23:29', '2025-12-03 06:23:29'),
(6, 'Memory card', 'memory card', 'sony sd card', 'categories/zynlU0mqQQqke4yTtJjimwStsFXHhQSnuCF5aDTE.jpg', 1, 1, 'Memory card | finepoint', NULL, NULL, 0, '2025-12-05 10:25:49', '2025-12-05 10:25:49'),
(7, 'remote tv', 'remotes-tv', 'remotes', 'categories/QPpCu5O6mrk3A5y3EqSdO8lxBQ7IWWk3SmApEwF5.jpg', NULL, 1, 'remote tv | finepoint', NULL, NULL, 0, '2025-12-12 09:19:23', '2025-12-12 09:19:23');

-- --------------------------------------------------------

--
-- Table structure for table `deals`
--

DROP TABLE IF EXISTS `deals`;
CREATE TABLE IF NOT EXISTS `deals` (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` enum('percentage','fixed','bundle','special') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'percentage',
  `discount_value` decimal(10,2) DEFAULT NULL,
  `min_purchase` decimal(10,2) DEFAULT NULL,
  `usage_limit` int DEFAULT NULL,
  `used_count` int NOT NULL DEFAULT '0',
  `start_date` datetime NOT NULL,
  `end_date` datetime NOT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `featured` tinyint(1) NOT NULL DEFAULT '0',
  `sort_order` int NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `deals_slug_unique` (`slug`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `deals`
--

INSERT INTO `deals` (`id`, `title`, `slug`, `description`, `image`, `type`, `discount_value`, `min_purchase`, `usage_limit`, `used_count`, `start_date`, `end_date`, `is_active`, `featured`, `sort_order`, `created_at`, `updated_at`) VALUES
(6, 'hoooooooooooooot', 'hoooooooooooooot', 'ghfgszgzds', 'deals/4SYrurV79gbl6Ce3xK2HH3FxzVLo5aJOnOuE0MBf.jpg', 'percentage', 20.00, NULL, NULL, 0, '2025-12-03 17:26:00', '2025-12-09 17:26:00', 1, 1, 1, '2025-12-04 14:27:24', '2025-12-05 10:35:01'),
(2, 'sizzzzling', 'sizzzzling', 'sizzling', 'deals/NpQgOmg2NHGzx9drYaZQUCw3bhfg4mng1rMb60zL.jpg', 'fixed', 5000.00, NULL, NULL, 0, '2025-12-03 16:49:00', '2025-12-04 17:49:00', 1, 1, 0, '2025-12-04 10:50:05', '2025-12-04 11:34:48'),
(4, 'teeeest', 'teeeest', 'weeeeeeeeeeee', 'deals/apLkoeq6wbmXFTvGbjFKuCu8udbur35WIH2PanxH.jpg', 'percentage', 15.00, NULL, NULL, 0, '2025-12-02 17:01:00', '2025-12-12 17:01:00', 1, 1, 0, '2025-12-04 14:02:12', '2025-12-04 14:02:12'),
(5, 'tesdfe', 'tesdfe', 'ewsfxfx', 'deals/GwPBR5nruW3y3CfK6NBT8O0ePXn3wX0Lk5sd1qu7.jpg', 'percentage', 15.00, NULL, NULL, 0, '2025-12-03 17:11:00', '2025-12-10 17:11:00', 1, 1, 0, '2025-12-04 14:11:35', '2025-12-04 14:11:35'),
(7, 'testttttt', 'testttttt', 'ertggeg', 'deals/mt94EC11KZMoc5hOgjZYzau5adqpcZH4QZLgKt18.jpg', 'bundle', 63000.00, 25000.00, 1, 0, '2025-12-05 13:35:00', '2025-12-06 13:35:00', 1, 1, 0, '2025-12-05 10:40:59', '2025-12-05 10:40:59'),
(8, 'cheappppppp', 'cheappppppp', 'kaa chonjoooooo', NULL, 'special', 10000.00, 20000.00, 2, 0, '2025-12-05 13:50:00', '2025-12-05 18:50:00', 1, 1, 0, '2025-12-05 10:52:23', '2025-12-05 10:52:23');

-- --------------------------------------------------------

--
-- Table structure for table `deal_product`
--

DROP TABLE IF EXISTS `deal_product`;
CREATE TABLE IF NOT EXISTS `deal_product` (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `deal_id` bigint UNSIGNED NOT NULL,
  `product_id` bigint UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `deal_product_deal_id_product_id_unique` (`deal_id`,`product_id`),
  KEY `deal_product_product_id_foreign` (`product_id`)
) ENGINE=MyISAM AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `deal_product`
--

INSERT INTO `deal_product` (`id`, `deal_id`, `product_id`, `created_at`, `updated_at`) VALUES
(23, 6, 7, NULL, NULL),
(22, 6, 3, NULL, NULL),
(21, 6, 5, NULL, NULL),
(20, 6, 1, NULL, NULL),
(14, 4, 5, NULL, NULL),
(6, 2, 5, NULL, NULL),
(7, 2, 3, NULL, NULL),
(8, 2, 4, NULL, NULL),
(15, 4, 3, NULL, NULL),
(13, 4, 1, NULL, NULL),
(16, 5, 1, NULL, NULL),
(17, 5, 5, NULL, NULL),
(18, 5, 3, NULL, NULL),
(19, 5, 4, NULL, NULL),
(24, 7, 1, NULL, NULL),
(25, 7, 5, NULL, NULL),
(26, 7, 3, NULL, NULL),
(27, 8, 4, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `failed_jobs`
--

DROP TABLE IF EXISTS `failed_jobs`;
CREATE TABLE IF NOT EXISTS `failed_jobs` (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `uuid` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `migrations`
--

DROP TABLE IF EXISTS `migrations`;
CREATE TABLE IF NOT EXISTS `migrations` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `migrations`
--

INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES
(1, '2014_10_12_000000_create_users_table', 1),
(2, '2014_10_12_100000_create_password_resets_table', 1),
(3, '2019_08_19_000000_create_failed_jobs_table', 1),
(4, '2019_12_14_000001_create_personal_access_tokens_table', 1),
(5, '2025_12_01_124958_create_products_table', 2),
(6, '2025_12_01_165936_add_name_to_users_table', 3),
(7, '2025_12_01_172248_add_role_to_users_table', 4),
(8, '2025_12_01_202104_create_categories_table', 5),
(9, '2025_12_01_205134_add_category_id_to_products_table', 6),
(10, '2025_12_01_205646_add_missing_columns_to_products_table', 7),
(11, '2025_12_02_073417_create_orders_table', 8),
(12, '2025_12_02_161144_create_mpesa_transactions_table', 9),
(13, '2025_12_03_105414_create_deals_table', 10),
(14, '2025_12_03_161927_create_carts_table', 11),
(15, '2025_12_04_154429_create_system_settings_table', 12),
(16, '2025_12_12_155749_add_deal_columns_to_carts_table', 13),
(17, '2025_12_12_190519_add_paybill_settings', 14);

-- --------------------------------------------------------

--
-- Table structure for table `mpesa_transactions`
--

DROP TABLE IF EXISTS `mpesa_transactions`;
CREATE TABLE IF NOT EXISTS `mpesa_transactions` (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `transaction_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `merchant_request_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `checkout_request_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone_number` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `account_reference` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transaction_desc` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transaction_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'CustomerPayBillOnline',
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `response_code` text COLLATE utf8mb4_unicode_ci,
  `response_description` text COLLATE utf8mb4_unicode_ci,
  `customer_message` text COLLATE utf8mb4_unicode_ci,
  `request_data` text COLLATE utf8mb4_unicode_ci,
  `response_data` text COLLATE utf8mb4_unicode_ci,
  `transaction_time` timestamp NULL DEFAULT NULL,
  `order_id` bigint UNSIGNED DEFAULT NULL,
  `user_id` bigint UNSIGNED DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mpesa_transactions_transaction_id_unique` (`transaction_id`),
  KEY `mpesa_transactions_order_id_foreign` (`order_id`),
  KEY `mpesa_transactions_user_id_foreign` (`user_id`),
  KEY `mpesa_transactions_transaction_id_index` (`transaction_id`),
  KEY `mpesa_transactions_checkout_request_id_index` (`checkout_request_id`),
  KEY `mpesa_transactions_phone_number_index` (`phone_number`),
  KEY `mpesa_transactions_status_index` (`status`),
  KEY `mpesa_transactions_created_at_index` (`created_at`)
) ENGINE=MyISAM AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `mpesa_transactions`
--

INSERT INTO `mpesa_transactions` (`id`, `transaction_id`, `merchant_request_id`, `checkout_request_id`, `phone_number`, `amount`, `account_reference`, `transaction_desc`, `transaction_type`, `status`, `response_code`, `response_description`, `customer_message`, `request_data`, `response_data`, `transaction_time`, `order_id`, `user_id`, `created_at`, `updated_at`) VALUES
(1, NULL, '0121-43a0-8e9c-16b67e37c80b11854', 'ws_CO_03122025225716700723210538', '0723210538', 27260.00, 'FP_1764791834_3', 'Payment for electronics purchase - Finepoint', 'CustomerPayBillOnline', 'failed', '4999', 'The transaction is still under processing', NULL, '{\"phone\":\"0723 210 538\",\"amount\":27260,\"order_id\":\"ORDER_1764791833869\"}', '{\"ResultCode\":\"4999\",\"ResultDesc\":\"The transaction is still under processing\",\"response_data\":{\"ResponseCode\":\"0\",\"ResponseDescription\":\"The service request has been accepted successfully\",\"MerchantRequestID\":\"0121-43a0-8e9c-16b67e37c80b11854\",\"CheckoutRequestID\":\"ws_CO_03122025225716700723210538\",\"ResultCode\":\"4999\",\"ResultDesc\":\"The transaction is still under processing\"}}', NULL, NULL, 3, '2025-12-03 16:57:14', '2025-12-03 16:57:23'),
(2, NULL, '9c32-4c0a-a12b-6102e4469c0613800', 'ws_CO_03122025234727357723210538', '0723210538', 23200.00, 'FP_1764794839_2', 'Payment for electronics purchase - Finepoint', 'CustomerPayBillOnline', 'failed', '4999', 'The transaction is still under processing', NULL, '{\"phone\":\"0723 210 538\",\"amount\":23200,\"order_id\":\"ORDER_1764794838053\"}', '{\"ResultCode\":\"4999\",\"ResultDesc\":\"The transaction is still under processing\",\"response_data\":{\"ResponseCode\":\"0\",\"ResponseDescription\":\"The service request has been accepted successfully\",\"MerchantRequestID\":\"9c32-4c0a-a12b-6102e4469c0613800\",\"CheckoutRequestID\":\"ws_CO_03122025234727357723210538\",\"ResultCode\":\"4999\",\"ResultDesc\":\"The transaction is still under processing\"}}', NULL, NULL, 2, '2025-12-03 17:47:20', '2025-12-03 17:47:34'),
(14, NULL, NULL, NULL, '0742934531', 6381.16, 'FP_1764941436_5', 'Payment for electronics purchase - Finepoint', 'CustomerPayBillOnline', 'failed', 'STK_FAILED', 'Failed to authenticate with M-Pesa. Please try again.', NULL, '{\"phone\":\"0742 934 531\",\"amount\":6381.16,\"order_id\":\"ORDER_1764941436174\"}', '{\"success\":false,\"message\":\"Failed to authenticate with M-Pesa. Please try again.\"}', NULL, NULL, 5, '2025-12-05 10:30:36', '2025-12-05 10:30:48'),
(13, NULL, NULL, NULL, '0723710025', 201.16, 'FP_1764921754_5', 'Payment for electronics purchase - Finepoint', 'CustomerPayBillOnline', 'failed', 'STK_FAILED', 'Payment service is temporarily unavailable. Please try again.', NULL, '{\"phone\":\"0723 710 025\",\"amount\":201.16,\"order_id\":\"ORDER_1764921754140\"}', '{\"success\":false,\"message\":\"Payment service is temporarily unavailable. Please try again.\"}', NULL, NULL, 5, '2025-12-05 05:02:34', '2025-12-05 05:02:35'),
(12, NULL, NULL, NULL, '0723210538', 202.32, 'FP_1764914359_5', 'Payment for electronics purchase - Finepoint', 'CustomerPayBillOnline', 'failed', 'STK_FAILED', 'Payment service is temporarily unavailable. Please try again.', NULL, '{\"phone\":\"0723 210 538\",\"amount\":202.32,\"order_id\":\"ORDER_1764914359102\"}', '{\"success\":false,\"message\":\"Payment service is temporarily unavailable. Please try again.\"}', NULL, NULL, 5, '2025-12-05 02:59:21', '2025-12-05 02:59:27'),
(11, NULL, NULL, NULL, '0748718421', 23200.00, 'FP_1764864319_5', 'Payment for electronics purchase - Finepoint', 'CustomerPayBillOnline', 'failed', 'STK_FAILED', 'Failed to authenticate with M-Pesa. Please try again.', NULL, '{\"phone\":\"0748718421\",\"amount\":23200,\"order_id\":\"ORDER_1764864318944\"}', '{\"success\":false,\"message\":\"Failed to authenticate with M-Pesa. Please try again.\"}', NULL, NULL, 5, '2025-12-04 13:05:19', '2025-12-04 13:05:31'),
(8, NULL, NULL, NULL, '0748718421', 23200.00, 'FP_1764836045_5', 'Payment for electronics purchase - Finepoint', 'CustomerPayBillOnline', 'failed', 'STK_FAILED', 'Failed to authenticate with M-Pesa. Please try again.', NULL, '{\"phone\":\"0748 718 421\",\"amount\":23200,\"order_id\":\"ORDER_1764836045294\"}', '{\"success\":false,\"message\":\"Failed to authenticate with M-Pesa. Please try again.\"}', NULL, NULL, 5, '2025-12-04 05:14:05', '2025-12-04 05:14:17'),
(9, NULL, '1c7a-4384-a656-b48667853e3a18278', 'ws_CO_04122025164657538715822306', '0715822306', 23200.00, 'FP_1764856012_5', 'Payment for electronics purchase - Finepoint', 'CustomerPayBillOnline', 'failed', '1032', 'Request cancelled by user', NULL, '{\"phone\":\"0715 822 306\",\"amount\":23200,\"order_id\":\"ORDER_1764856012422\"}', '{\"ResultCode\":\"1032\",\"ResultDesc\":\"Request cancelled by user\",\"response_data\":{\"ResponseCode\":\"0\",\"ResponseDescription\":\"The service request has been accepted successfully\",\"MerchantRequestID\":\"1c7a-4384-a656-b48667853e3a18278\",\"CheckoutRequestID\":\"ws_CO_04122025164657538715822306\",\"ResultCode\":\"1032\",\"ResultDesc\":\"Request Cancelled by user.\"}}', NULL, NULL, 5, '2025-12-04 10:46:53', '2025-12-04 10:47:14'),
(10, NULL, '61f1-4673-953a-d6445487c49d18394', 'ws_CO_04122025165757096715822306', '0715822306', 23200.00, 'FP_1764856675_5', 'Payment for electronics purchase - Finepoint', 'CustomerPayBillOnline', 'failed', '1037', 'Timeout - No response from user', NULL, '{\"phone\":\"0715 822 306\",\"amount\":23200,\"order_id\":\"ORDER_1764856675510\"}', '{\"ResultCode\":\"1037\",\"ResultDesc\":\"Timeout - No response from user\",\"response_data\":{\"ResponseCode\":\"0\",\"ResponseDescription\":\"The service request has been accepted successfully\",\"MerchantRequestID\":\"61f1-4673-953a-d6445487c49d18394\",\"CheckoutRequestID\":\"ws_CO_04122025165757096715822306\",\"ResultCode\":\"1037\",\"ResultDesc\":\"DS timeout user cannot be reached.\"}}', NULL, NULL, 5, '2025-12-04 10:57:55', '2025-12-04 10:58:06'),
(15, NULL, NULL, NULL, '0742934531', 6381.16, 'FP_1764941458_5', 'Payment for electronics purchase - Finepoint', 'CustomerPayBillOnline', 'failed', 'STK_FAILED', 'Failed to authenticate with M-Pesa. Please try again.', NULL, '{\"phone\":\"0742 934 531\",\"amount\":6381.16,\"order_id\":\"ORDER_1764941457628\"}', '{\"success\":false,\"message\":\"Failed to authenticate with M-Pesa. Please try again.\"}', NULL, NULL, 5, '2025-12-05 10:30:58', '2025-12-05 10:31:09'),
(16, NULL, 'f799-4471-95b9-213b7e8c16507479', 'ws_CO_12122025175540002723210538', '0723210538', 1.00, 'FP_1765551335_3', 'Payment for electronics purchase - Finepoint', 'CustomerPayBillOnline', 'success', '0', 'The service request is processed successfully.', NULL, '{\"phone\":\"0723 210 538\",\"amount\":1,\"order_id\":\"ORDER_1765551335446\"}', '{\"ResultCode\":\"0\",\"ResultDesc\":\"The service request is processed successfully.\",\"response_data\":{\"ResponseCode\":\"0\",\"ResponseDescription\":\"The service request has been accepted successfully\",\"MerchantRequestID\":\"f799-4471-95b9-213b7e8c16507479\",\"CheckoutRequestID\":\"ws_CO_12122025175540002723210538\",\"ResultCode\":\"0\",\"ResultDesc\":\"The service request is processed successfully.\"}}', '2025-12-12 11:57:57', NULL, 3, '2025-12-12 11:55:35', '2025-12-12 11:57:57'),
(17, NULL, 'f799-4471-95b9-213b7e8c16507654', 'ws_CO_12122025181155645723210538', '0723210538', 1.00, 'FP_1765552313_3', 'Payment for electronics purchase - Finepoint', 'CustomerPayBillOnline', 'success', '0', 'The service request is processed successfully.', NULL, '{\"phone\":\"0723 210 538\",\"amount\":1,\"order_id\":\"ORDER_1765552313506\"}', '{\"ResultCode\":\"0\",\"ResultDesc\":\"The service request is processed successfully.\",\"response_data\":{\"ResponseCode\":\"0\",\"ResponseDescription\":\"The service request has been accepted successfully\",\"MerchantRequestID\":\"f799-4471-95b9-213b7e8c16507654\",\"CheckoutRequestID\":\"ws_CO_12122025181155645723210538\",\"ResultCode\":\"0\",\"ResultDesc\":\"The service request is processed successfully.\"}}', '2025-12-12 12:12:09', NULL, 3, '2025-12-12 12:11:53', '2025-12-12 12:12:09'),
(18, NULL, 'f799-4471-95b9-213b7e8c16507830', 'ws_CO_12122025182803916723210538', '0723210538', 1.00, 'FP_1765553282_3', 'Payment for electronics purchase - Finepoint', 'CustomerPayBillOnline', 'pending', NULL, NULL, NULL, '{\"phone\":\"0723 210 538\",\"amount\":1,\"order_id\":\"ORDER_1765553281806\"}', '{\"success\":true,\"message\":\"Payment request sent successfully\",\"checkout_request_id\":\"ws_CO_12122025182803916723210538\",\"merchant_request_id\":\"f799-4471-95b9-213b7e8c16507830\",\"customer_message\":\"Success. Request accepted for processing\"}', NULL, NULL, 3, '2025-12-12 12:28:02', '2025-12-12 12:28:08'),
(19, NULL, 'f799-4471-95b9-213b7e8c16507836', 'ws_CO_12122025182846586723210538', '0723210538', 1.00, 'FP_1765553325_3', 'Payment for electronics purchase - Finepoint', 'CustomerPayBillOnline', 'pending', NULL, NULL, NULL, '{\"phone\":\"0723 210 538\",\"amount\":1,\"order_id\":\"ORDER_1765553325159\"}', '{\"success\":true,\"message\":\"Payment request sent successfully\",\"checkout_request_id\":\"ws_CO_12122025182846586723210538\",\"merchant_request_id\":\"f799-4471-95b9-213b7e8c16507836\",\"customer_message\":\"Success. Request accepted for processing\"}', NULL, NULL, 3, '2025-12-12 12:28:45', '2025-12-12 12:28:51'),
(20, NULL, 'f799-4471-95b9-213b7e8c16507859', 'ws_CO_12122025183003439723210538', '0723210538', 1.00, 'FP_1765553402_3', 'Payment for electronics purchase - Finepoint', 'CustomerPayBillOnline', 'pending', NULL, NULL, NULL, '{\"phone\":\"0723 210 538\",\"amount\":1,\"order_id\":\"ORDER_1765553401913\"}', '{\"success\":true,\"message\":\"Payment request sent successfully\",\"checkout_request_id\":\"ws_CO_12122025183003439723210538\",\"merchant_request_id\":\"f799-4471-95b9-213b7e8c16507859\",\"customer_message\":\"Success. Request accepted for processing\"}', NULL, NULL, 3, '2025-12-12 12:30:02', '2025-12-12 12:30:08'),
(21, NULL, 'd4b7-41bb-bb8a-cc6ec5ea8bfa5089', 'ws_CO_12122025183410351723210538', '0723210538', 1.00, 'FP_1765553648_3', 'Payment for electronics purchase - Finepoint', 'CustomerPayBillOnline', 'pending', NULL, NULL, NULL, '{\"phone\":\"0723 210 538\",\"amount\":1,\"order_id\":\"ORDER_1765553648818\"}', '{\"success\":true,\"message\":\"Payment request sent successfully\",\"checkout_request_id\":\"ws_CO_12122025183410351723210538\",\"merchant_request_id\":\"d4b7-41bb-bb8a-cc6ec5ea8bfa5089\",\"customer_message\":\"Success. Request accepted for processing\"}', NULL, NULL, 3, '2025-12-12 12:34:08', '2025-12-12 12:34:15'),
(22, NULL, NULL, NULL, '0723210538', 15000.00, 'FP_1765787554_2', 'Payment for electronics purchase - Finepoint', 'CustomerPayBillOnline', 'failed', 'STK_FAILED', 'Failed to authenticate with M-Pesa. Please try again.', NULL, '{\"phone\":\"0723 210 538\",\"amount\":15000,\"order_id\":\"ORDER_1765787553567\"}', '{\"success\":false,\"message\":\"Failed to authenticate with M-Pesa. Please try again.\"}', NULL, NULL, 2, '2025-12-15 05:32:35', '2025-12-15 05:32:51');

-- --------------------------------------------------------

--
-- Table structure for table `orders`
--

DROP TABLE IF EXISTS `orders`;
CREATE TABLE IF NOT EXISTS `orders` (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `order_number` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint UNSIGNED NOT NULL,
  `subtotal` decimal(10,2) NOT NULL,
  `tax` decimal(10,2) NOT NULL DEFAULT '0.00',
  `shipping` decimal(10,2) NOT NULL DEFAULT '0.00',
  `total` decimal(10,2) NOT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `payment_status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `payment_method` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_address` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `billing_address` text COLLATE utf8mb4_unicode_ci,
  `customer_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `customer_email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `customer_phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `notes` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `orders_order_number_unique` (`order_number`),
  KEY `orders_user_id_foreign` (`user_id`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `orders`
--

INSERT INTO `orders` (`id`, `order_number`, `user_id`, `subtotal`, `tax`, `shipping`, `total`, `status`, `payment_status`, `payment_method`, `shipping_address`, `billing_address`, `customer_name`, `customer_email`, `customer_phone`, `notes`, `created_at`, `updated_at`) VALUES
(1, 'ORD-20251212-693C1831C6314', 3, 20000.00, 3200.00, 0.00, 23200.00, 'pending', 'pending', 'cod', '\"{\\\"name\\\":\\\"denzy\\\",\\\"email\\\":\\\"denzykim4@gmail.com\\\",\\\"phone\\\":\\\"0748 718 421\\\",\\\"address\\\":\\\"Kitale 30200\\\",\\\"city\\\":\\\"Kitale\\\",\\\"state\\\":\\\"nairobi\\\",\\\"zip\\\":\\\"2002\\\",\\\"country\\\":\\\"Kenya\\\",\\\"notes\\\":null}\"', '\"{\\\"name\\\":\\\"denzy\\\",\\\"email\\\":\\\"denzykim4@gmail.com\\\",\\\"phone\\\":\\\"0748 718 421\\\",\\\"address\\\":\\\"Kitale 30200\\\",\\\"city\\\":\\\"Kitale\\\",\\\"state\\\":\\\"nairobi\\\",\\\"zip\\\":\\\"2002\\\",\\\"country\\\":\\\"Kenya\\\",\\\"notes\\\":null}\"', 'denzy', 'denzykim4@gmail.com', '0748 718 421', NULL, '2025-12-12 10:27:13', '2025-12-12 10:27:13'),
(2, 'ORD-20251212-693C28AF74CBC', 3, 5500.00, 0.00, 0.00, 5500.00, 'pending', 'pending', 'cod', '\"{\\\"name\\\":\\\"denzy\\\",\\\"email\\\":\\\"denzykim4@gmail.com\\\",\\\"phone\\\":\\\"0723 210 538\\\",\\\"address\\\":\\\"P.O BOX 123-20200\\\",\\\"city\\\":\\\"kericho\\\",\\\"state\\\":\\\"nairobi\\\",\\\"zip\\\":\\\"20200\\\",\\\"country\\\":\\\"Kenya\\\",\\\"notes\\\":null}\"', '\"{\\\"name\\\":\\\"denzy\\\",\\\"email\\\":\\\"denzykim4@gmail.com\\\",\\\"phone\\\":\\\"0723 210 538\\\",\\\"address\\\":\\\"P.O BOX 123-20200\\\",\\\"city\\\":\\\"kericho\\\",\\\"state\\\":\\\"nairobi\\\",\\\"zip\\\":\\\"20200\\\",\\\"country\\\":\\\"Kenya\\\",\\\"notes\\\":null}\"', 'denzy', 'denzykim4@gmail.com', '0723 210 538', 'COD Order - Shipping fee to be calculated. Customer will be contacted.', '2025-12-12 11:37:35', '2025-12-12 11:37:35'),
(3, 'ORD-20251212-693C319A187A2', 3, 1.00, 0.00, 0.00, 1.00, 'pending', 'pending', 'cod', '\"{\\\"name\\\":\\\"denzy\\\",\\\"email\\\":\\\"denzykim4@gmail.com\\\",\\\"phone\\\":\\\"0723 210 538\\\",\\\"address\\\":\\\"P.O BOX 123-20200\\\",\\\"city\\\":\\\"kericho\\\",\\\"state\\\":\\\"nairobi\\\",\\\"zip\\\":\\\"20200\\\",\\\"country\\\":\\\"Kenya\\\",\\\"notes\\\":null}\"', '\"{\\\"name\\\":\\\"denzy\\\",\\\"email\\\":\\\"denzykim4@gmail.com\\\",\\\"phone\\\":\\\"0723 210 538\\\",\\\"address\\\":\\\"P.O BOX 123-20200\\\",\\\"city\\\":\\\"kericho\\\",\\\"state\\\":\\\"nairobi\\\",\\\"zip\\\":\\\"20200\\\",\\\"country\\\":\\\"Kenya\\\",\\\"notes\\\":null}\"', 'denzy', 'denzykim4@gmail.com', '0723 210 538', 'COD Order - Shipping fee to be calculated. Customer will be contacted.', '2025-12-12 12:15:38', '2025-12-12 12:15:38'),
(4, 'ORD-20251212-693C3341D7CEC', 3, 1.00, 0.00, 0.00, 1.00, 'pending', 'pending', 'cod', '\"{\\\"name\\\":\\\"denzy\\\",\\\"email\\\":\\\"denzykim4@gmail.com\\\",\\\"phone\\\":\\\"0723 210 538\\\",\\\"address\\\":\\\"P.O BOX 123-20200\\\",\\\"city\\\":\\\"kericho\\\",\\\"state\\\":\\\"kenya\\\",\\\"zip\\\":\\\"20200\\\",\\\"country\\\":\\\"Kenya\\\",\\\"notes\\\":null}\"', '\"{\\\"name\\\":\\\"denzy\\\",\\\"email\\\":\\\"denzykim4@gmail.com\\\",\\\"phone\\\":\\\"0723 210 538\\\",\\\"address\\\":\\\"P.O BOX 123-20200\\\",\\\"city\\\":\\\"kericho\\\",\\\"state\\\":\\\"kenya\\\",\\\"zip\\\":\\\"20200\\\",\\\"country\\\":\\\"Kenya\\\",\\\"notes\\\":null}\"', 'denzy', 'denzykim4@gmail.com', '0723 210 538', 'COD Order - Shipping fee to be calculated. Customer will be contacted.', '2025-12-12 12:22:41', '2025-12-12 12:22:41'),
(5, 'ORD-20251212-693C36A6306AA', 3, 1.00, 0.00, 0.00, 1.00, 'pending', 'pending', 'cod', '\"{\\\"name\\\":\\\"denzy\\\",\\\"email\\\":\\\"denzykim4@gmail.com\\\",\\\"phone\\\":\\\"0723 210 538\\\",\\\"address\\\":\\\"P.O BOX 123-20200\\\",\\\"city\\\":\\\"kericho\\\",\\\"state\\\":\\\"nairobi\\\",\\\"zip\\\":\\\"20200\\\",\\\"country\\\":\\\"Kenya\\\",\\\"notes\\\":null}\"', '\"{\\\"name\\\":\\\"denzy\\\",\\\"email\\\":\\\"denzykim4@gmail.com\\\",\\\"phone\\\":\\\"0723 210 538\\\",\\\"address\\\":\\\"P.O BOX 123-20200\\\",\\\"city\\\":\\\"kericho\\\",\\\"state\\\":\\\"nairobi\\\",\\\"zip\\\":\\\"20200\\\",\\\"country\\\":\\\"Kenya\\\",\\\"notes\\\":null}\"', 'denzy', 'denzykim4@gmail.com', '0723 210 538', 'COD Order - Shipping fee to be calculated. Customer will be contacted.', '2025-12-12 12:37:10', '2025-12-12 12:37:10'),
(6, 'ORD-20251212-693C4335426C3', 3, 20000.00, 0.00, 0.00, 20000.00, 'pending', 'pending', 'cod', '\"{\\\"name\\\":\\\"denzy\\\",\\\"email\\\":\\\"denzykim4@gmail.com\\\",\\\"phone\\\":\\\"0723 210 538\\\",\\\"address\\\":\\\"P.O BOX 123-20200\\\",\\\"city\\\":\\\"kericho\\\",\\\"state\\\":\\\"nairobi\\\",\\\"zip\\\":\\\"20200\\\",\\\"country\\\":\\\"Kenya\\\",\\\"notes\\\":null}\"', '\"{\\\"name\\\":\\\"denzy\\\",\\\"email\\\":\\\"denzykim4@gmail.com\\\",\\\"phone\\\":\\\"0723 210 538\\\",\\\"address\\\":\\\"P.O BOX 123-20200\\\",\\\"city\\\":\\\"kericho\\\",\\\"state\\\":\\\"nairobi\\\",\\\"zip\\\":\\\"20200\\\",\\\"country\\\":\\\"Kenya\\\",\\\"notes\\\":null}\"', 'denzy', 'denzykim4@gmail.com', '0723 210 538', 'COD Order - Shipping fee to be calculated. Customer will be contacted.', '2025-12-12 13:30:45', '2025-12-12 13:30:45'),
(7, 'ORD-20251212-693C701161A71', 3, 1.00, 0.00, 0.00, 1.00, 'processing', 'paid', 'paybill', '\"{\\\"name\\\":\\\"denzy\\\",\\\"email\\\":\\\"denzykim4@gmail.com\\\",\\\"phone\\\":\\\"0723 210 538\\\",\\\"address\\\":\\\"P.O BOX 123-20200\\\",\\\"city\\\":\\\"kericho\\\",\\\"state\\\":\\\"nairobi\\\",\\\"zip\\\":\\\"20200\\\",\\\"country\\\":\\\"Kenya\\\",\\\"notes\\\":null}\"', '\"{\\\"name\\\":\\\"denzy\\\",\\\"email\\\":\\\"denzykim4@gmail.com\\\",\\\"phone\\\":\\\"0723 210 538\\\",\\\"address\\\":\\\"P.O BOX 123-20200\\\",\\\"city\\\":\\\"kericho\\\",\\\"state\\\":\\\"nairobi\\\",\\\"zip\\\":\\\"20200\\\",\\\"country\\\":\\\"Kenya\\\",\\\"notes\\\":null}\"', 'denzy', 'denzykim4@gmail.com', '0723 210 538', 'Direct Paybill Order - Payment pending verification. Paybill: 247247, Account: N/A. \nPayment verified by admin on 2025-12-13 08:03:46', '2025-12-12 16:42:09', '2025-12-13 05:03:46'),
(8, 'ORD-20251212-693C718F6BFD2', 3, 1.00, 0.00, 0.00, 1.00, 'processing', 'paid', 'paybill', '\"{\\\"name\\\":\\\"denzy\\\",\\\"email\\\":\\\"denzykim4@gmail.com\\\",\\\"phone\\\":\\\"0748 718 421\\\",\\\"address\\\":\\\"Kitale 30200\\\",\\\"city\\\":\\\"Kitale\\\",\\\"state\\\":\\\"nairobi\\\",\\\"zip\\\":\\\"2002\\\",\\\"country\\\":\\\"Kenya\\\",\\\"notes\\\":null}\"', '\"{\\\"name\\\":\\\"denzy\\\",\\\"email\\\":\\\"denzykim4@gmail.com\\\",\\\"phone\\\":\\\"0748 718 421\\\",\\\"address\\\":\\\"Kitale 30200\\\",\\\"city\\\":\\\"Kitale\\\",\\\"state\\\":\\\"nairobi\\\",\\\"zip\\\":\\\"2002\\\",\\\"country\\\":\\\"Kenya\\\",\\\"notes\\\":null}\"', 'denzy', 'denzykim4@gmail.com', '0748 718 421', 'Direct Paybill Order - Payment pending verification. Paybill: 247247, Account: N/A. \r\nPayment verified by admin on 2025-12-13 07:51:01', '2025-12-12 16:48:31', '2025-12-13 04:51:43'),
(9, 'ORD-20251212-693C76EE7E262', 3, 20000.00, 0.00, 0.00, 20000.00, 'processing', 'paid', 'paybill', '\"{\\\"name\\\":\\\"denzy\\\",\\\"email\\\":\\\"denzykim4@gmail.com\\\",\\\"phone\\\":\\\"0748 718 421\\\",\\\"address\\\":\\\"Kitale 30200\\\",\\\"city\\\":\\\"Kitale\\\",\\\"state\\\":\\\"nairobi\\\",\\\"zip\\\":\\\"2002\\\",\\\"country\\\":\\\"Kenya\\\",\\\"notes\\\":null}\"', '\"{\\\"name\\\":\\\"denzy\\\",\\\"email\\\":\\\"denzykim4@gmail.com\\\",\\\"phone\\\":\\\"0748 718 421\\\",\\\"address\\\":\\\"Kitale 30200\\\",\\\"city\\\":\\\"Kitale\\\",\\\"state\\\":\\\"nairobi\\\",\\\"zip\\\":\\\"2002\\\",\\\"country\\\":\\\"Kenya\\\",\\\"notes\\\":null}\"', 'denzy', 'denzykim4@gmail.com', '0748 718 421', 'Direct Paybill Order - Payment pending verification. Paybill: 247247, Account: N/A. \r\nPayment verified by admin on 2025-12-13 07:52:04', '2025-12-12 17:11:26', '2025-12-13 04:52:23'),
(10, 'ORD-20251215-693FC886DEBD7', 2, 15000.00, 0.00, 0.00, 15000.00, 'shipped', 'paid', 'paybill', '\"{\\\"name\\\":\\\"Admin User\\\",\\\"email\\\":\\\"dice@dicesystems.com\\\",\\\"phone\\\":\\\"0723 210 538\\\",\\\"address\\\":\\\"ssdsds\\\",\\\"city\\\":\\\"sdsd\\\",\\\"state\\\":\\\"kenya\\\",\\\"zip\\\":\\\"222\\\",\\\"country\\\":\\\"Kenya\\\",\\\"notes\\\":null}\"', '\"{\\\"name\\\":\\\"Admin User\\\",\\\"email\\\":\\\"dice@dicesystems.com\\\",\\\"phone\\\":\\\"0723 210 538\\\",\\\"address\\\":\\\"ssdsds\\\",\\\"city\\\":\\\"sdsd\\\",\\\"state\\\":\\\"kenya\\\",\\\"zip\\\":\\\"222\\\",\\\"country\\\":\\\"Kenya\\\",\\\"notes\\\":null}\"', 'Admin User', 'dice@dicesystems.com', '0723 210 538', 'Direct Paybill Order - Payment pending verification. Paybill: 247247, Account: 0712345678. \r\nPayment verified by admin on 2025-12-15 08:38:17', '2025-12-15 05:36:22', '2025-12-15 05:38:56'),
(11, 'ORD-20251216-69410D2F27C1D', 3, 15000.00, 0.00, 0.00, 15000.00, 'shipped', 'paid', 'paybill', '\"{\\\"name\\\":\\\"denzy\\\",\\\"email\\\":\\\"denzykim4@gmail.com\\\",\\\"phone\\\":\\\"0723 210 538\\\",\\\"address\\\":\\\"P.O BOX 123-20200\\\",\\\"city\\\":\\\"kericho\\\",\\\"state\\\":\\\"kenya\\\",\\\"zip\\\":\\\"20200\\\",\\\"country\\\":\\\"Kenya\\\",\\\"notes\\\":null}\"', '\"{\\\"name\\\":\\\"denzy\\\",\\\"email\\\":\\\"denzykim4@gmail.com\\\",\\\"phone\\\":\\\"0723 210 538\\\",\\\"address\\\":\\\"P.O BOX 123-20200\\\",\\\"city\\\":\\\"kericho\\\",\\\"state\\\":\\\"kenya\\\",\\\"zip\\\":\\\"20200\\\",\\\"country\\\":\\\"Kenya\\\",\\\"notes\\\":null}\"', 'denzy', 'denzykim4@gmail.com', '0723 210 538', 'Direct Paybill Order - Payment pending verification. Paybill: 247247, Account: 0712345678. \r\nPayment verified by admin on 2025-12-16 07:42:10', '2025-12-16 04:41:35', '2025-12-16 04:42:51');

-- --------------------------------------------------------

--
-- Table structure for table `order_items`
--

DROP TABLE IF EXISTS `order_items`;
CREATE TABLE IF NOT EXISTS `order_items` (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `order_id` bigint UNSIGNED NOT NULL,
  `product_id` bigint UNSIGNED NOT NULL,
  `product_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `total` decimal(10,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `order_items_order_id_foreign` (`order_id`),
  KEY `order_items_product_id_foreign` (`product_id`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `order_items`
--

INSERT INTO `order_items` (`id`, `order_id`, `product_id`, `product_name`, `price`, `quantity`, `total`, `created_at`, `updated_at`) VALUES
(1, 1, 1, 'samsung s24', 20000.00, 1, 20000.00, '2025-12-12 10:27:13', '2025-12-12 10:27:13'),
(2, 2, 10, 'SD card', 5500.00, 1, 5500.00, '2025-12-12 11:37:35', '2025-12-12 11:37:35'),
(3, 3, 9, 'microphone s22', 1.00, 1, 1.00, '2025-12-12 12:15:38', '2025-12-12 12:15:38'),
(4, 4, 9, 'microphone s22', 1.00, 1, 1.00, '2025-12-12 12:22:41', '2025-12-12 12:22:41'),
(5, 5, 9, 'microphone s22', 1.00, 1, 1.00, '2025-12-12 12:37:10', '2025-12-12 12:37:10'),
(6, 6, 1, 'samsung s24', 20000.00, 1, 20000.00, '2025-12-12 13:30:45', '2025-12-12 13:30:45'),
(7, 7, 9, 'microphone s22', 1.00, 1, 1.00, '2025-12-12 16:42:09', '2025-12-12 16:42:09'),
(8, 8, 9, 'microphone s22', 1.00, 1, 1.00, '2025-12-12 16:48:31', '2025-12-12 16:48:31'),
(9, 9, 7, 'infinix', 20000.00, 1, 20000.00, '2025-12-12 17:11:26', '2025-12-12 17:11:26'),
(10, 10, 11, 'laptops', 15000.00, 1, 15000.00, '2025-12-15 05:36:22', '2025-12-15 05:36:22'),
(11, 11, 11, 'laptops', 15000.00, 1, 15000.00, '2025-12-16 04:41:35', '2025-12-16 04:41:35');

-- --------------------------------------------------------

--
-- Table structure for table `password_resets`
--

DROP TABLE IF EXISTS `password_resets`;
CREATE TABLE IF NOT EXISTS `password_resets` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `personal_access_tokens`
--

DROP TABLE IF EXISTS `personal_access_tokens`;
CREATE TABLE IF NOT EXISTS `personal_access_tokens` (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tokenable_id` bigint UNSIGNED NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `abilities` text COLLATE utf8mb4_unicode_ci,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `products`
--

DROP TABLE IF EXISTS `products`;
CREATE TABLE IF NOT EXISTS `products` (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `category_id` bigint UNSIGNED DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `brand` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `price` decimal(10,2) NOT NULL,
  `stock` int NOT NULL DEFAULT '0',
  `sku` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `meta_title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_description` text COLLATE utf8mb4_unicode_ci,
  `meta_keywords` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `products_slug_unique` (`slug`),
  KEY `products_category_id_foreign` (`category_id`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `products`
--

INSERT INTO `products` (`id`, `category_id`, `name`, `slug`, `brand`, `description`, `price`, `stock`, `sku`, `is_active`, `meta_title`, `meta_description`, `meta_keywords`, `image`, `created_at`, `updated_at`) VALUES
(1, 1, 'samsung s24', 'samsung-s24', 'samsung', NULL, 20000.00, 3, 'PROD-FKCCEQC5', 1, 'samsung s24 | finepoint', 'Buy samsung s24 at the best price. Free shipping available.', NULL, 'storage/products/ktda-1764622635.png', '2025-12-01 17:57:15', '2025-12-12 13:30:45'),
(5, 2, '24\" smart tv', '24\"-smart-tv', 'vitron', NULL, 20500.00, 100, 'PROD-EWQV11AF', 1, '24\" smart tv | finepoint', 'Buy 24\" smart tv at the best price. Free shipping available.', NULL, 'storage/products/buy-roku-40-inch-1080p-full-hd-smart-roku-tv-with-1764753716.jpeg', '2025-12-03 06:21:56', '2025-12-03 06:21:56'),
(3, 1, 'samsung s20', 'samsung-s20', 'samsung', NULL, 99999.99, 25, 'PROD-3ZH8OMRX', 1, 'samsung s20 | finepoint', 'Buy samsung s20 at the best price. Free shipping available.', NULL, 'storage/products/iphone-16-1764745263.jpeg', '2025-12-03 04:01:03', '2025-12-03 04:01:03'),
(4, 2, 'tecno', 'tecno', 'tecno', NULL, 20000.00, 21, 'PROD-EDNK8FG7', 1, 'tecno | finepoint', 'Buy tecno at the best price. Free shipping available.', NULL, 'storage/products/tecno-spark-20-1764745472.jpeg', '2025-12-03 04:04:32', '2025-12-03 04:04:32'),
(6, 5, '2-door-fridge', '2-door-fridge', 'samsung', NULL, 23500.00, 100, 'PROD-6A3PJWNL', 1, '2-door-fridge | finepoint', 'Buy 2-door-fridge at the best price. Free shipping available.', NULL, 'storage/products/discover-the-best-refrigerator-brands-and-how-1764753849.jpeg', '2025-12-03 06:24:09', '2025-12-03 06:24:09'),
(7, 4, 'infinix', 'infinix', 'tecno', NULL, 20000.00, 99, 'PROD-JFFOECVP', 1, 'infinix | finepoint', 'Buy infinix at the best price. Free shipping available.', NULL, 'storage/products/introducing-the-infinix-hot-50-5g-1764754158.jpeg', '2025-12-03 06:29:18', '2025-12-13 04:52:04'),
(8, 4, 'tecno spark 5', 't', 'tecno', NULL, 15000.00, 20, 'PROD-2BG1DE9D', 1, 'tecno spark 5 | finepoint', 'Buy tecno spark 5 at the best price. Free shipping available.', NULL, 'storage/products/infinix-smart-5-2gb-ram-32gb-rom-mobile-phones-1764756302.jpeg', '2025-12-03 07:05:02', '2025-12-03 07:05:02'),
(9, 3, 'microphone s22', 'microphone-s22', 'vitron', NULL, 1.00, 45, 'PROD-9MWTZUVZ', 1, 'microphone s22 | finepoint', 'Buy microphone s22 at the best price. Free shipping available.', NULL, 'storage/products/original-lg-42le7300-tv-fernbedienung-das-1764856553.jpeg', '2025-12-04 10:55:53', '2025-12-13 05:03:46'),
(10, 6, 'SD card', 'SD card', 'sony', 'hogsedtghyuj', 5500.00, 94, 'PROD-9MWTZUVZ', 1, 'Sony SD card | finepoint', 'Buy Sony SD card at the best price. Free shipping available.', NULL, 'storage/products/the-best-android-phones-must-read-since-hubby-1764941277.jpeg', '2025-12-05 10:27:57', '2025-12-12 11:37:35'),
(11, 1, 'laptops', 'laptops', 'hp', NULL, 15000.00, 48, 'PROD-CCUK9FYS', 1, 'laptops | finepoint', 'Buy laptops at the best price. Free shipping available.', NULL, 'storage/products/discover-the-best-refrigerator-brands-and-how-1765787465.jpeg', '2025-12-15 05:31:06', '2025-12-16 04:42:10');

-- --------------------------------------------------------

--
-- Table structure for table `system_settings`
--

DROP TABLE IF EXISTS `system_settings`;
CREATE TABLE IF NOT EXISTS `system_settings` (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'string',
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `system_settings_key_unique` (`key`)
) ENGINE=MyISAM AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `system_settings`
--

INSERT INTO `system_settings` (`id`, `key`, `value`, `type`, `description`, `created_at`, `updated_at`) VALUES
(1, 'site_name', 'Finepoint Electronics', 'string', 'Name of the website/store', '2025-12-04 12:57:09', '2025-12-12 16:41:10'),
(2, 'site_email', 'finepointelectronic@gmail.com', 'string', 'Default email for the site', '2025-12-04 12:57:09', '2025-12-13 08:03:10'),
(3, 'site_phone', '+254700 123 457', 'string', 'Contact phone number', '2025-12-04 12:57:09', '2025-12-16 04:14:48'),
(4, 'site_address', 'Nairobi, Kenya', 'string', 'Business physical address', '2025-12-04 12:57:09', '2025-12-12 16:41:10'),
(5, 'currency', 'KES', 'string', 'Default currency for the store', '2025-12-04 12:57:09', '2025-12-12 16:41:10'),
(6, 'timezone', 'Africa/Nairobi', 'string', 'Default timezone for the store', '2025-12-04 12:57:09', '2025-12-12 16:41:10'),
(7, 'mpesa_enabled', '0', 'boolean', 'Enable/disable M-Pesa STK Push payments', '2025-12-04 12:57:09', '2025-12-16 04:44:12'),
(8, 'cash_on_delivery_enabled', '1', 'boolean', 'Enable/disable Cash on Delivery payments', '2025-12-04 12:57:09', '2025-12-12 16:41:10'),
(9, 'store_status', '1', 'boolean', 'Store online status (1=open, 0=closed)', '2025-12-04 12:57:09', '2025-12-04 12:57:09'),
(10, 'min_order_amount', '100', 'integer', 'Minimum order amount', '2025-12-04 12:57:09', '2025-12-04 12:57:09'),
(11, 'free_shipping_threshold', '1000', 'integer', 'Amount for free shipping', '2025-12-04 12:57:09', '2025-12-04 12:57:09'),
(12, 'shipping_fee', '200', 'integer', 'Default shipping fee', '2025-12-04 12:57:09', '2025-12-04 12:57:09'),
(13, 'tax_rate', '16', 'integer', 'Tax rate percentage', '2025-12-04 12:57:09', '2025-12-04 12:57:09'),
(14, 'direct_paybill_enabled', '1', 'boolean', 'Enable/disable Direct Paybill payments', '2025-12-12 16:07:02', '2025-12-12 16:41:10'),
(15, 'paybill_number', '247247', 'string', 'Bank Paybill number for manual payments', '2025-12-12 16:07:02', '2025-12-12 16:41:10'),
(16, 'paybill_account_number', '0712345678', 'string', 'Account number for paybill payments', '2025-12-12 16:07:02', '2025-12-13 05:34:54'),
(17, 'paybill_instructions', NULL, 'text', 'Instructions shown to customers for paybill payments', '2025-12-12 16:07:02', '2025-12-12 16:41:10');

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
CREATE TABLE IF NOT EXISTS `users` (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `role` enum('admin','customer') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'customer',
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `users`
--

INSERT INTO `users` (`id`, `name`, `email`, `email_verified_at`, `password`, `role`, `remember_token`, `created_at`, `updated_at`) VALUES
(2, 'Admin User', 'dice@dicesystems.com', NULL, '$2y$10$z5f7rld9pQVZM/q6JZQkZuXphTMN/VtxhYWSMEr8AB3T0KM6e5Nry', 'admin', NULL, '2025-12-01 14:35:41', '2025-12-12 16:43:37'),
(3, 'denzy', 'denzykim4@gmail.com', NULL, '$2y$10$oEFsRK.Bkk2.vZVkXnxgseNlohfwCGzAQ1HklwDCUahowvP./6XG.', 'customer', NULL, '2025-12-01 14:37:16', '2025-12-01 14:37:16'),
(5, 'dennis kimotho', 'astracoding409@gmail.com', NULL, '$2y$10$xc2AjKeSLwzzSIRZ78M2sO9LEZ00wMbz5vgxZjEYk5sxwWeGawirW', 'customer', NULL, '2025-12-04 05:11:25', '2025-12-04 05:11:25'),
(8, 'charity', 'charityngari144@gmail.com', NULL, '$2y$10$BOlUBvdllkaB0mtK1jCRbOOwnr/Aotp6emEzgaeUalotJbm1RvLvO', 'customer', NULL, '2025-12-04 14:23:05', '2025-12-04 14:23:05');
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
