
<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('carts', function (Blueprint $table) {
            // Add these columns
            $table->decimal('original_price', 10, 2)->nullable()->after('quantity');
            $table->foreignId('deal_id')->nullable()->after('original_price')->constrained('deals')->nullOnDelete();
            $table->string('deal_type')->nullable()->after('deal_id');
            $table->decimal('deal_discount_value', 10, 2)->nullable()->after('deal_type');
        });
    }

    public function down()
    {
        Schema::table('carts', function (Blueprint $table) {
            $table->dropForeign(['deal_id']);
            $table->dropColumn(['original_price', 'deal_id', 'deal_type', 'deal_discount_value']);
        });
    }
};