<?php

namespace App\Mail;

use App\Models\Order;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class PaybillPaymentVerification extends Mailable
{
    use Queueable, SerializesModels;

    public $order;
    public $paybillDetails;
    public $totalDiscount;
    public $verificationUrl;

    /**
     * Create a new message instance.
     */
    public function __construct(Order $order, $paybillDetails = [], $totalDiscount = 0)
    {
        $this->order = $order;
        $this->paybillDetails = $paybillDetails;
        $this->totalDiscount = $totalDiscount;
        $this->verificationUrl = route('admin.orders.show', $order->id);
    }

    /**
     * Build the message.
     */
    public function build()
    {
        return $this->subject('⚠️ Paybill Payment Verification Required - Order #' . $this->order->order_number)
                   ->view('emails.paybill-verification')
                   ->with([
                       'order' => $this->order,
                       'paybillDetails' => $this->paybillDetails,
                       'totalDiscount' => $this->totalDiscount,
                       'verificationUrl' => $this->verificationUrl,
                   ]);
    }
}