<?php

namespace App\Mail;

use App\Models\Order;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class NewOrderNotification extends Mailable
{
    use Queueable, SerializesModels;

    public $order;
    public $paymentMethod;
    public $totalDiscount;

    public function __construct(Order $order, $paymentMethod = 'cod', $totalDiscount = 0)
    {
        $this->order = $order;
        $this->paymentMethod = $paymentMethod;
        $this->totalDiscount = $totalDiscount;
    }

    public function build()
    {
        $subject = $this->paymentMethod === 'cod'
            ? 'New COD Order Received: #' . $this->order->order_number
            : 'New Order Received: #' . $this->order->order_number;
            
        return $this->subject($subject)
                    ->view('emails.new-order-notification')
                    ->with([
                        'order' => $this->order,
                        'paymentMethod' => $this->paymentMethod,
                        'totalDiscount' => $this->totalDiscount,
                    ]);
    }
}