<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        @import  url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');
        body { 
            font-family: 'Inter', sans-serif; 
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }
        
        /* Custom scrollbar */
        .sidebar-scroll::-webkit-scrollbar {
            width: 6px;
        }
        
        .sidebar-scroll::-webkit-scrollbar-track {
            background: #f1f1f1;
            border-radius: 3px;
        }
        
        .sidebar-scroll::-webkit-scrollbar-thumb {
            background: #c1c1c1;
            border-radius: 3px;
        }
        
        .sidebar-scroll::-webkit-scrollbar-thumb:hover {
            background: #a1a1a1;
        }
        
        /* Active link styles */
        .active-link {
            background-color: rgba(10, 153, 97, 0.1);
            border-left: 4px solid #0A9961;
            color: #0A9961;
        }
        
        /* Smooth transitions */
        .transition-all {
            transition-property: all;
            transition-timing-function: cubic-bezier(0.4, 0, 0.2, 1);
            transition-duration: 300ms;
        }
        
        /* Sticky footer */
        .main-container {
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }
        
        .main-content {
            flex: 1 0 auto;
            padding-bottom: 80px; /* Space for footer */
        }
        
        .sticky-footer {
            flex-shrink: 0;
            background: white;
            border-top: 1px solid #e5e7eb;
            box-shadow: 0 -4px 6px -1px rgba(0, 0, 0, 0.1), 0 -2px 4px -1px rgba(0, 0, 0, 0.06);
        }
    </style>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title>Admin Dashboard - <?php echo e(config('app.name', 'E-commerce')); ?></title>

    <!-- Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Alpine.js for interactivity -->
    <script src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js" defer></script>
</head>
<body class="bg-gray-50" x-data="{ sidebarOpen: false, quickActionsOpen: false, notificationsOpen: false }">
    <!-- Mobile Sidebar Overlay -->
    <div x-show="sidebarOpen" 
         x-transition:enter="transition-opacity ease-linear duration-300"
         x-transition:enter-start="opacity-0"
         x-transition:enter-end="opacity-100"
         x-transition:leave="transition-opacity ease-linear duration-300"
         x-transition:leave-start="opacity-100"
         x-transition:leave-end="opacity-0"
         @click="sidebarOpen = false"
         class="fixed inset-0 z-40 bg-gray-900 bg-opacity-50 lg:hidden">
    </div>

    <!-- Sidebar -->
    <aside class="fixed inset-y-0 left-0 z-50 w-64 bg-white shadow-lg transform lg:translate-x-0 transition-transform duration-300 ease-in-out"
           :class="sidebarOpen ? 'translate-x-0' : '-translate-x-full'"
           x-transition:enter="transition ease-in-out duration-300 transform"
           x-transition:enter-start="-translate-x-full"
           x-transition:enter-end="translate-x-0"
           x-transition:leave="transition ease-in-out duration-300 transform"
           x-transition:leave-start="translate-x-0"
           x-transition:leave-end="-translate-x-full">
        
        <!-- Sidebar Header -->
        <div class="flex items-center justify-between h-16 px-6 border-b border-gray-200 bg-white">
            <div class="flex items-center space-x-3">
                <div class="w-10 h-10 rounded-lg bg-gradient-to-br from-[#0A9961] to-[#10B981] flex items-center justify-center">
                    <i class="fas fa-store text-white text-lg"></i>
                </div>
                <div>
                    <h1 class="text-lg font-bold text-gray-900">E-Shop<span class="text-[#0A9961]">Admin</span></h1>
                    <p class="text-xs text-gray-500">Finepoint Electronics</p>
                    <p class="text-xs text-gray-500">Dashboard</p>
                </div>
            </div>
            <button @click="sidebarOpen = false" class="lg:hidden text-gray-500 hover:text-gray-700">
                <i class="fas fa-times text-xl"></i>
            </button>
        </div>

        <!-- Sidebar Content - Made scrollable -->
        <div class="flex flex-col h-[calc(100vh-8rem)]">
            <!-- Scrollable Navigation Area -->
            <div class="flex-1 overflow-y-auto sidebar-scroll">
                <!-- User Profile -->
                <div class="px-6 py-4 border-b border-gray-100">
                    <div class="flex items-center space-x-3">
                        <div class="relative">
                            <img class="w-10 h-10 rounded-full border-2 border-[#0A9961]/20" 
                                 src="https://ui-avatars.com/api/?name=<?php echo e(urlencode(auth()->user()->name ?? auth()->user()->email)); ?>&background=0A9961&color=fff" 
                                 alt="<?php echo e(auth()->user()->name ?? auth()->user()->email); ?>">
                            <div class="absolute bottom-0 right-0 w-3 h-3 bg-green-500 rounded-full border-2 border-white"></div>
                        </div>
                        <div>
                            <h3 class="text-sm font-semibold text-gray-900"><?php echo e(auth()->user()->name ?? auth()->user()->email); ?></h3>
                            <p class="text-xs text-gray-500"><?php echo e(auth()->user()->email); ?></p>
                        </div>
                    </div>
                </div>

                <!-- Navigation Menu -->
                <nav class="mt-4 px-4 pb-4">
                    <div class="space-y-1">
                        <!-- Dashboard -->
                        <a href="<?php echo e(route('admin.dashboard')); ?>" 
                           class="group flex items-center px-3 py-3 text-sm font-medium rounded-lg transition-all duration-200 
                                  <?php echo e(request()->routeIs('admin.dashboard') ? 'active-link' : 'text-gray-700 hover:bg-gray-100 hover:text-[#0A9961]'); ?>">
                            <i class="fas fa-chart-line w-5 mr-3 <?php echo e(request()->routeIs('admin.dashboard') ? 'text-[#0A9961]' : 'text-gray-400 group-hover:text-[#0A9961]'); ?>"></i>
                            Dashboard
                        </a>

                        <!-- Products -->
                        <div x-data="{ open: <?php echo e(request()->routeIs('admin.products.*') || request()->routeIs('admin.categories.*') ? 'true' : 'false'); ?> }">
                            <button @click="open = !open" 
                                    class="w-full flex items-center justify-between px-3 py-3 text-sm font-medium rounded-lg text-gray-700 hover:bg-gray-100 hover:text-[#0A9961] transition-all duration-200">
                                <div class="flex items-center">
                                    <i class="fas fa-box w-5 mr-3 text-gray-400 group-hover:text-[#0A9961]"></i>
                                    Products
                                </div>
                                <i class="fas fa-chevron-down text-xs transition-transform duration-200" :class="open ? 'rotate-180' : ''"></i>
                            </button>
                            
                            <div x-show="open" x-collapse class="ml-8 mt-1 space-y-1">
                                <a href="<?php echo e(route('admin.products.index')); ?>" 
                                   class="flex items-center px-3 py-2 text-sm rounded-lg transition-all duration-200 
                                          <?php echo e(request()->routeIs('admin.products.index') ? 'text-[#0A9961] bg-[#0A9961]/5' : 'text-gray-600 hover:text-[#0A9961] hover:bg-gray-50'); ?>">
                                    <i class="fas fa-list w-4 mr-2"></i>
                                    All Products
                                </a>
                                <a href="<?php echo e(route('admin.products.create')); ?>" 
                                   class="flex items-center px-3 py-2 text-sm rounded-lg transition-all duration-200 
                                          <?php echo e(request()->routeIs('admin.products.create') ? 'text-[#0A9961] bg-[#0A9961]/5' : 'text-gray-600 hover:text-[#0A9961] hover:bg-gray-50'); ?>">
                                    <i class="fas fa-plus w-4 mr-2"></i>
                                    Add New
                                </a>
                                <a href="<?php echo e(route('admin.categories.index')); ?>" 
                                   class="flex items-center px-3 py-2 text-sm rounded-lg transition-all duration-200 
                                          <?php echo e(request()->routeIs('admin.categories.*') ? 'text-[#0A9961] bg-[#0A9961]/5' : 'text-gray-600 hover:text-[#0A9961] hover:bg-gray-50'); ?>">
                                    <i class="fas fa-tags w-4 mr-2"></i>
                                    Categories
                                </a>
                                <a href="#" class="flex items-center px-3 py-2 text-sm text-gray-600 hover:text-[#0A9961] hover:bg-gray-50 rounded-lg transition-all duration-200">
                                    <i class="fas fa-star w-4 mr-2"></i>
                                    Reviews
                                </a>
                            </div>
                        </div>

                        <!-- Orders -->
                        <a href="<?php echo e(route('admin.orders.index')); ?>" 
                        class="group flex items-center px-3 py-3 text-sm font-medium rounded-lg transition-all duration-200 
                                <?php echo e(request()->routeIs('admin.orders.*') ? 'active-link' : 'text-gray-700 hover:bg-gray-100 hover:text-[#0A9961]'); ?>">
                            <i class="fas fa-shopping-cart w-5 mr-3 <?php echo e(request()->routeIs('admin.orders.*') ? 'text-[#0A9961]' : 'text-gray-400 group-hover:text-[#0A9961]'); ?>"></i>
                            Orders
                            <span class="ml-auto bg-red-100 text-red-800 text-xs font-semibold px-2 py-1 rounded-full">0</span>
                        </a>

                        <!-- M-Pesa Transactions -->
                        <a href="<?php echo e(route('admin.transactions.index')); ?>" 
                        class="flex items-center px-3 py-3 text-sm font-medium text-gray-700 hover:bg-gray-100 hover:text-[#0A9961] rounded-lg transition-colors duration-200">
                            <i class="fas fa-mobile-alt w-5 mr-3 text-gray-400"></i>
                            Transactions
                        </a>

                        <!-- Deals -->
                        <a href="<?php echo e(route('admin.deals.index')); ?>" 
                        class="flex items-center px-3 py-3 text-sm font-medium text-gray-700 hover:bg-gray-100 hover:text-[#0A9961] rounded-lg transition-colors duration-200">
                            <i class="fas fa-tag w-5 mr-3 text-gray-400"></i>
                            Deals
                        </a>

                        <!-- Users Management -->
                        <a href="<?php echo e(route('admin.users.index')); ?>" 
                        class="group flex items-center px-3 py-3 text-sm font-medium rounded-lg transition-all duration-200 
                                <?php echo e(request()->routeIs('admin.users.*') ? 'active-link' : 'text-gray-700 hover:bg-gray-100 hover:text-[#0A9961]'); ?>">
                            <i class="fas fa-users w-5 mr-3 <?php echo e(request()->routeIs('admin.users.*') ? 'text-[#0A9961]' : 'text-gray-400 group-hover:text-[#0A9961]'); ?>"></i>
                            Users
                        </a>

                        <!-- Inventory -->
                        <a href="#" 
                           class="group flex items-center px-3 py-3 text-sm font-medium rounded-lg text-gray-700 hover:bg-gray-100 hover:text-[#0A9961] transition-all duration-200">
                            <i class="fas fa-warehouse w-5 mr-3 text-gray-400 group-hover:text-[#0A9961]"></i>
                            Inventory
                        </a>

                        <!-- Analytics -->
                        <a href="#" 
                           class="group flex items-center px-3 py-3 text-sm font-medium rounded-lg text-gray-700 hover:bg-gray-100 hover:text-[#0A9961] transition-all duration-200">
                            <i class="fas fa-chart-bar w-5 mr-3 text-gray-400 group-hover:text-[#0A9961]"></i>
                            Analytics
                        </a>

                        <!-- Marketing -->
                        <a href="#" 
                           class="group flex items-center px-3 py-3 text-sm font-medium rounded-lg text-gray-700 hover:bg-gray-100 hover:text-[#0A9961] transition-all duration-200">
                            <i class="fas fa-bullhorn w-5 mr-3 text-gray-400 group-hover:text-[#0A9961]"></i>
                            Marketing
                        </a>

                       <!-- Settings -->
                        <a href="<?php echo e(route('admin.settings')); ?>" 
                        class="group flex items-center px-3 py-3 text-sm font-medium rounded-lg transition-all duration-200 
                                <?php echo e(request()->routeIs('admin.settings.*') ? 'active-link' : 'text-gray-700 hover:bg-gray-100 hover:text-[#0A9961]'); ?> mt-6 pt-4 border-t border-gray-200">
                            <i class="fas fa-cog w-5 mr-3 <?php echo e(request()->routeIs('admin.settings.*') ? 'text-[#0A9961]' : 'text-gray-400 group-hover:text-[#0A9961]'); ?>"></i>
                            Settings
                        </a>
                    </div>
                </nav>
            </div>

            <!-- Sidebar Footer (Fixed at bottom) -->
            <div class="border-t border-gray-200 p-4 bg-white">
                <form method="POST" action="<?php echo e(route('logout')); ?>">
                    <?php echo csrf_field(); ?>
                    <button type="submit" 
                            class="w-full flex items-center justify-center px-4 py-2 text-sm font-medium text-gray-700 hover:text-red-600 hover:bg-red-50 rounded-lg transition-all duration-200">
                        <i class="fas fa-sign-out-alt mr-2"></i>
                        Logout
                    </button>
                </form>
            </div>
        </div>
    </aside>

    <!-- Main Container -->
    <div class="lg:ml-64 main-container">
        <!-- Top Navigation -->
        <header class="sticky top-0 z-40 bg-white border-b border-gray-200 shadow-sm">
            <div class="flex items-center justify-between px-6 py-4">
                <!-- Left: Hamburger menu for mobile -->
                <button @click="sidebarOpen = true" class="lg:hidden text-gray-600 hover:text-gray-900">
                    <i class="fas fa-bars text-xl"></i>
                </button>

                <!-- Center: Search bar -->
                <div class="flex-1 max-w-2xl mx-4">
                    <div class="relative">
                        <i class="fas fa-search absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-400"></i>
                        <input type="search" 
                               placeholder="Search orders, customers, products..." 
                               class="w-full pl-10 pr-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#0A9961] focus:border-transparent">
                    </div>
                </div>

                <!-- Right: User actions -->
                <div class="flex items-center space-x-4">
                    <!-- Notifications -->
                    <div class="relative" x-data="{ open: false }">
                        <button @click="open = !open" class="relative p-2 text-gray-600 hover:text-gray-900">
                            <i class="fas fa-bell text-xl"></i>
                            <span class="absolute top-1 right-1 w-2 h-2 bg-red-500 rounded-full"></span>
                        </button>
                    </div>

                    <!-- Messages -->
                    <button class="relative p-2 text-gray-600 hover:text-gray-900">
                        <i class="fas fa-envelope text-xl"></i>
                        <span class="absolute top-1 right-1 w-2 h-2 bg-blue-500 rounded-full"></span>
                    </button>

                    <!-- Quick Actions -->
                    <div class="relative" x-data="{ open: false }">
                        <button @click="open = !open" class="flex items-center space-x-2 p-2 text-gray-700 hover:text-gray-900">
                            <i class="fas fa-plus-circle text-xl text-[#0A9961]"></i>
                            <span class="hidden md:inline text-sm font-medium">Profile</span>
                        </button>
                    </div>
                </div>
            </div>
        </header>

        <!-- Main Content Area -->
        <main class="main-content p-6">
            <?php echo $__env->yieldContent('content'); ?>
        </main>

        <!-- Footer - Fixed at bottom -->
        <footer class="sticky-footer py-4">
            <div class="max-w-7xl mx-auto px-6">
                <div class="text-center">
                    <p class="text-sm text-gray-600">
                        &copy; <?php echo e(date('Y')); ?> Finepoint Electronics Admin Panel. Developed by <a href="mailto:info@dicesystems.com" class="text-[#0A9961] hover:underline">info@dicesystems.com</a>
                    </p>
                    <div class="mt-2 flex justify-center space-x-4 text-xs text-gray-500">
                        <span>v1.0.0</span>
                        <span>•</span>
                        <span><?php echo e(now()->format('Y-m-d H:i:s')); ?></span>
                        <span>•</span>
                        <span>Server: <?php echo e(gethostname()); ?></span>
                    </div>
                </div>
            </div>
        </footer>
    </div>

    <script>
        // Close sidebar when clicking outside on mobile
        document.addEventListener('click', function(event) {
            const sidebar = document.querySelector('aside');
            const sidebarToggle = document.querySelector('[x-on\\:click="sidebarOpen = true"]');
            const overlay = document.querySelector('[x-show="sidebarOpen"]');
            
            if (window.innerWidth < 1024) {
                if (overlay && overlay.classList.contains('block')) {
                    Alpine.store('sidebarOpen', false);
                }
            }
        });
        
        // Auto-close sidebar on mobile when navigating
        document.querySelectorAll('aside a').forEach(link => {
            link.addEventListener('click', function() {
                if (window.innerWidth < 1024) {
                    Alpine.store('sidebarOpen', false);
                }
            });
        });
        
        // Close dropdowns when clicking outside
        document.addEventListener('click', function(event) {
            if (!event.target.closest('[x-data]')) {
                Alpine.store('quickActionsOpen', false);
                Alpine.store('notificationsOpen', false);
            }
        });
        
        // Make footer visible on scroll
        window.addEventListener('scroll', function() {
            const footer = document.querySelector('.sticky-footer');
            const scrollPosition = window.scrollY;
            const windowHeight = window.innerHeight;
            const documentHeight = document.body.clientHeight;
            
            // Show footer when scrolled to bottom
            if (scrollPosition + windowHeight >= documentHeight - 100) {
                footer.classList.add('opacity-100');
                footer.classList.remove('opacity-0');
            } else {
                footer.classList.add('opacity-100'); // Always visible
            }
        });
    </script>
</body>
</html><?php /**PATH C:\wamp64\www\finepoint\resources\views/layouts/admin-layout.blade.php ENDPATH**/ ?>