

<?php $__env->startSection('content'); ?>
<div class="bg-white rounded-lg shadow-sm p-6">
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">Orders Management</h1>
            <p class="text-gray-600 mt-1">View and manage customer orders</p>
        </div>
        <div class="flex space-x-3">
            <div class="relative">
                <select id="statusFilter" class="appearance-none bg-white border border-gray-300 rounded-lg px-4 py-2 pr-8 text-sm focus:ring-2 focus:ring-[#0A9961] focus:border-transparent">
                    <option value="">All Status</option>
                    <option value="pending">Pending</option>
                    <option value="processing">Processing</option>
                    <option value="shipped">Shipped</option>
                    <option value="delivered">Delivered</option>
                    <option value="cancelled">Cancelled</option>
                </select>
                <i class="fas fa-chevron-down absolute right-3 top-1/2 transform -translate-y-1/2 text-gray-400 pointer-events-none"></i>
            </div>
            <button onclick="printOrders()" class="bg-gray-100 hover:bg-gray-200 text-gray-700 px-4 py-2 rounded-lg text-sm font-medium transition-colors duration-200">
                <i class="fas fa-print mr-2"></i>Print
            </button>
            <button onclick="exportOrders()" class="bg-gray-100 hover:bg-gray-200 text-gray-700 px-4 py-2 rounded-lg text-sm font-medium transition-colors duration-200">
                <i class="fas fa-download mr-2"></i>Export
            </button>
        </div>
    </div>

    <!-- Stats Overview -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-6">
        <div class="bg-gradient-to-br from-blue-50 to-blue-100 border border-blue-200 rounded-lg p-4">
            <div class="flex items-center">
                <div class="bg-blue-100 p-3 rounded-lg">
                    <i class="fas fa-clock text-blue-600 text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm text-blue-800 font-medium">Pending</p>
                    <p class="text-2xl font-bold text-blue-900"><?php echo e($pendingCount ?? 0); ?></p>
                </div>
            </div>
        </div>
        
        <div class="bg-gradient-to-br from-green-50 to-green-100 border border-green-200 rounded-lg p-4">
            <div class="flex items-center">
                <div class="bg-green-100 p-3 rounded-lg">
                    <i class="fas fa-check-circle text-green-600 text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm text-green-800 font-medium">Completed</p>
                    <p class="text-2xl font-bold text-green-900"><?php echo e($completedCount ?? 0); ?></p>
                </div>
            </div>
        </div>
        
        <div class="bg-gradient-to-br from-purple-50 to-purple-100 border border-purple-200 rounded-lg p-4">
            <div class="flex items-center">
                <div class="bg-purple-100 p-3 rounded-lg">
                    <i class="fas fa-truck text-purple-600 text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm text-purple-800 font-medium">Processing</p>
                    <p class="text-2xl font-bold text-purple-900"><?php echo e($processingCount ?? 0); ?></p>
                </div>
            </div>
        </div>
        
        <div class="bg-gradient-to-br from-red-50 to-red-100 border border-red-200 rounded-lg p-4">
            <div class="flex items-center">
                <div class="bg-red-100 p-3 rounded-lg">
                    <i class="fas fa-times-circle text-red-600 text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm text-red-800 font-medium">Cancelled</p>
                    <p class="text-2xl font-bold text-red-900"><?php echo e($cancelledCount ?? 0); ?></p>
                </div>
            </div>
        </div>
    </div>

    <!-- Orders Table -->
    <div class="overflow-x-auto rounded-lg border border-gray-200">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Order ID</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Customer</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Date</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Total</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Payment</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr class="hover:bg-gray-50 transition-colors duration-150">
                    <td class="px-6 py-4 whitespace-nowrap">
                        <div class="text-sm font-medium text-gray-900"><?php echo e($order->order_number); ?></div>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <div class="flex items-center">
                            <div class="flex-shrink-0 h-8 w-8">
                                <div class="h-8 w-8 rounded-full bg-gradient-to-br from-[#0A9961] to-[#10B981] flex items-center justify-center text-white font-semibold">
                                    <?php echo e(strtoupper(substr($order->customer_name, 0, 1))); ?>

                                </div>
                            </div>
                            <div class="ml-4">
                                <div class="text-sm font-medium text-gray-900"><?php echo e($order->customer_name); ?></div>
                                <div class="text-sm text-gray-500"><?php echo e($order->customer_email); ?></div>
                            </div>
                        </div>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <div class="text-sm text-gray-900"><?php echo e($order->created_at->format('M d, Y')); ?></div>
                        <div class="text-sm text-gray-500"><?php echo e($order->created_at->format('h:i A')); ?></div>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <div class="text-sm font-bold text-gray-900">$<?php echo e(number_format($order->total, 2)); ?></div>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <span class="px-3 py-1 inline-flex text-xs leading-5 font-semibold rounded-full <?php echo e($order->getStatusBadgeColor()); ?>">
                            <?php echo e(ucfirst($order->status)); ?>

                        </span>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <span class="px-3 py-1 inline-flex text-xs leading-5 font-semibold rounded-full <?php echo e($order->getPaymentStatusBadgeColor()); ?>">
                            <?php echo e(ucfirst($order->payment_status)); ?>

                        </span>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                        <div class="flex space-x-2">
                            <a href="<?php echo e(route('admin.orders.show', $order)); ?>" 
                               class="text-[#0A9961] hover:text-[#088753] hover:bg-[#0A9961]/10 p-2 rounded-lg transition-colors duration-200"
                               title="View Details">
                                <i class="fas fa-eye"></i>
                            </a>
                            <a href="<?php echo e(route('admin.orders.edit', $order)); ?>" 
                               class="text-blue-600 hover:text-blue-800 hover:bg-blue-50 p-2 rounded-lg transition-colors duration-200"
                               title="Edit Order">
                                <i class="fas fa-edit"></i>
                            </a>
                            <form action="<?php echo e(route('admin.orders.destroy', $order)); ?>" method="POST" class="inline" onsubmit="return confirm('Are you sure you want to delete this order?')">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" 
                                        class="text-red-600 hover:text-red-800 hover:bg-red-50 p-2 rounded-lg transition-colors duration-200"
                                        title="Delete Order">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </form>
                            <a href="<?php echo e(route('admin.orders.show', $order)); ?>?print=invoice" 
                               target="_blank"
                               class="text-purple-600 hover:text-purple-800 hover:bg-purple-50 p-2 rounded-lg transition-colors duration-200"
                               title="Print Invoice">
                                <i class="fas fa-receipt"></i>
                            </a>
                        </div>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="7" class="px-6 py-12 text-center">
                        <div class="text-gray-400">
                            <i class="fas fa-shopping-cart text-4xl mb-3"></i>
                            <p class="text-lg font-medium text-gray-500">No orders found</p>
                            <p class="text-gray-400 mt-1">Orders will appear here once customers make purchases</p>
                        </div>
                    </td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    <?php if($orders->hasPages()): ?>
    <div class="mt-6">
        <?php echo e($orders->links()); ?>

    </div>
    <?php endif; ?>
</div>

<script>
function printOrders() {
    window.print();
}

function exportOrders() {
    // Implement export functionality
    alert('Export feature coming soon!');
}

// Filter orders by status
document.getElementById('statusFilter').addEventListener('change', function() {
    const status = this.value;
    if(status) {
        window.location.href = "<?php echo e(route('admin.orders.index')); ?>?status=" + status;
    } else {
        window.location.href = "<?php echo e(route('admin.orders.index')); ?>";
    }
});
</script>

<style>
@media  print {
    header, footer, aside, .no-print {
        display: none !important;
    }
    
    body {
        padding: 0 !important;
        margin: 0 !important;
    }
    
    .rounded-lg, .shadow-sm {
        border-radius: 0 !important;
        box-shadow: none !important;
    }
}
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\finepoint\resources\views/admin/orders/index.blade.php ENDPATH**/ ?>