

<?php $__env->startSection('content'); ?>
<div class="bg-white rounded-lg shadow-sm">
    <!-- Order Header -->
    <div class="border-b border-gray-200 px-6 py-4">
        <div class="flex justify-between items-start">
            <div>
                <h1 class="text-2xl font-bold text-gray-900">Order #<?php echo e($order->order_number); ?></h1>
                <div class="flex items-center space-x-4 mt-2">
                    <span class="px-3 py-1 inline-flex text-sm leading-5 font-semibold rounded-full <?php echo e($order->getStatusBadgeColor()); ?>">
                        <?php echo e(ucfirst($order->status)); ?>

                    </span>
                    <span class="px-3 py-1 inline-flex text-sm leading-5 font-semibold rounded-full <?php echo e($order->getPaymentStatusBadgeColor()); ?>">
                        Payment: <?php echo e(ucfirst($order->payment_status)); ?>

                    </span>
                    <span class="text-gray-500">
                        <i class="far fa-calendar mr-1"></i>
                        <?php echo e($order->created_at->format('F d, Y h:i A')); ?>

                    </span>
                </div>
            </div>
            <div class="flex space-x-3">
                <a href="<?php echo e(route('admin.orders.index')); ?>" 
                   class="bg-gray-100 hover:bg-gray-200 text-gray-700 px-4 py-2 rounded-lg text-sm font-medium transition-colors duration-200">
                    <i class="fas fa-arrow-left mr-2"></i>Back
                </a>
                <a href="<?php echo e(route('admin.orders.invoice', $order)); ?>" target="_blank"
                 class="bg-[#0A9961] hover:bg-[#088753] text-white px-4 py-2 rounded-lg text-sm font-medium transition-colors duration-200">
                 <i class="fas fa-print mr-2"></i>Print Invoice
                </a>
            </div>
        </div>
    </div>

    <div class="p-6">
        <!-- Paybill Payment Verification Section -->
        <?php if($order->payment_method === 'paybill' && $order->payment_status === 'pending_verification'): ?>
        <div class="mb-6 bg-yellow-50 border border-yellow-200 rounded-lg p-5">
            <div class="flex items-center mb-4">
                <div class="flex-shrink-0 bg-yellow-100 p-3 rounded-lg">
                    <i class="fas fa-exclamation-triangle text-yellow-600 text-xl"></i>
                </div>
                <div class="ml-4">
                    <h3 class="text-lg font-semibold text-gray-900">⚠️ Paybill Payment Verification Required</h3>
                    <p class="text-sm text-gray-600">Customer has selected Direct Paybill. Please verify their payment before processing this order.</p>
                </div>
            </div>
            
            <div class="bg-white border border-yellow-300 rounded-lg p-4 mb-4">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <h4 class="text-sm font-medium text-gray-700 mb-2">Payment Details</h4>
                        <div class="space-y-2">
                            <p class="text-sm">
                                <span class="font-medium">Amount to Verify:</span> 
                                <span class="text-lg font-bold text-green-600">Ksh <?php echo e(number_format($order->total, 2)); ?></span>
                            </p>
                            <p class="text-sm">
                                <span class="font-medium">Payment Method:</span> 
                                <span class="bg-yellow-100 text-yellow-800 px-2 py-1 rounded text-xs font-medium">Direct Paybill</span>
                            </p>
                        </div>
                    </div>
                    <div>
                        <h4 class="text-sm font-medium text-gray-700 mb-2">Customer Information</h4>
                        <div class="space-y-2">
                            <p class="text-sm"><span class="font-medium">Name:</span> <?php echo e($order->customer_name); ?></p>
                            <p class="text-sm"><span class="font-medium">Phone:</span> <?php echo e($order->customer_phone); ?></p>
                            <p class="text-sm"><span class="font-medium">Email:</span> <?php echo e($order->customer_email); ?></p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Paybill Verification Actions -->
            <div class="border-t border-yellow-200 pt-4">
                <h4 class="text-md font-medium text-gray-900 mb-3">Payment Verification Actions</h4>
                <div class="flex flex-col sm:flex-row space-y-3 sm:space-y-0 sm:space-x-3">
                    <!-- Verify Payment Form -->
                    <form action="<?php echo e(route('checkout.verify-paybill', $order)); ?>" method="POST" class="flex-1">
                        <?php echo csrf_field(); ?>
                        <div class="bg-green-50 border border-green-200 rounded-lg p-4">
                            <div class="flex items-start mb-3">
                                <div class="flex-shrink-0 mt-1">
                                    <i class="fas fa-check-circle text-green-600"></i>
                                </div>
                                <div class="ml-3">
                                    <h5 class="text-sm font-medium text-green-900">Verify Payment</h5>
                                    <p class="text-xs text-green-700">Confirm that the customer has paid the correct amount.</p>
                                </div>
                            </div>
                            <div class="mb-3">
                                <label for="verification_notes" class="block text-xs font-medium text-gray-700 mb-1">Verification Notes (Optional)</label>
                                <textarea name="verification_notes" id="verification_notes" rows="2"
                                          class="w-full px-3 py-2 text-sm border border-gray-300 rounded-lg focus:ring-2 focus:ring-green-500 focus:border-transparent"
                                          placeholder="Add any notes about the payment verification..."></textarea>
                            </div>
                            <button type="submit" 
                                    onclick="return confirm('Are you sure you want to verify this payment? This will update the order status to paid and process the order.')"
                                    class="w-full bg-green-600 hover:bg-green-700 text-white py-2 px-4 rounded-lg text-sm font-medium transition-colors duration-200 flex items-center justify-center">
                                <i class="fas fa-check-circle mr-2"></i>
                                Verify Payment & Process Order
                            </button>
                        </div>
                    </form>

                    <!-- Reject Payment Form -->
                    <form action="<?php echo e(route('checkout.reject-paybill', $order)); ?>" method="POST" class="flex-1" id="reject-payment-form">
                        <?php echo csrf_field(); ?>
                        <div class="bg-red-50 border border-red-200 rounded-lg p-4">
                            <div class="flex items-start mb-3">
                                <div class="flex-shrink-0 mt-1">
                                    <i class="fas fa-times-circle text-red-600"></i>
                                </div>
                                <div class="ml-3">
                                    <h5 class="text-sm font-medium text-red-900">Reject Payment</h5>
                                    <p class="text-xs text-red-700">If payment is insufficient or not received.</p>
                                </div>
                            </div>
                            <div class="mb-3">
                                <label for="rejection_reason" class="block text-xs font-medium text-gray-700 mb-1">Rejection Reason *</label>
                                <textarea name="rejection_reason" id="rejection_reason" rows="2" required
                                          class="w-full px-3 py-2 text-sm border border-gray-300 rounded-lg focus:ring-2 focus:ring-red-500 focus:border-transparent"
                                          placeholder="Please provide a reason for rejecting this payment..."></textarea>
                                <p class="text-xs text-gray-500 mt-1">This will be sent to the customer</p>
                            </div>
                            <button type="submit" 
                                    onclick="return confirmRejection()"
                                    class="w-full bg-red-600 hover:bg-red-700 text-white py-2 px-4 rounded-lg text-sm font-medium transition-colors duration-200 flex items-center justify-center">
                                <i class="fas fa-times-circle mr-2"></i>
                                Reject Payment
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <!-- Order Details Grid -->
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-6 mb-8">
            <!-- Customer Information -->
            <div class="bg-gray-50 rounded-lg p-5">
                <h3 class="text-lg font-semibold text-gray-900 mb-4 pb-2 border-b border-gray-200">
                    <i class="fas fa-user-circle mr-2 text-[#0A9961]"></i>Customer Information
                </h3>
                <div class="space-y-3">
                    <div>
                        <p class="text-sm text-gray-500">Name</p>
                        <p class="font-medium"><?php echo e($order->customer_name); ?></p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500">Email</p>
                        <p class="font-medium"><?php echo e($order->customer_email); ?></p>
                    </div>
                    <?php if($order->customer_phone): ?>
                    <div>
                        <p class="text-sm text-gray-500">Phone</p>
                        <p class="font-medium"><?php echo e($order->customer_phone); ?></p>
                    </div>
                    <?php endif; ?>
                    <?php if($order->user): ?>
                    <div>
                        <p class="text-sm text-gray-500">Account</p>
                        <p class="font-medium"><?php echo e($order->user->name); ?> (ID: <?php echo e($order->user->id); ?>)</p>
                    </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Shipping Information -->
            <div class="bg-gray-50 rounded-lg p-5">
                <h3 class="text-lg font-semibold text-gray-900 mb-4 pb-2 border-b border-gray-200">
                    <i class="fas fa-truck mr-2 text-[#0A9961]"></i>Shipping Information
                </h3>
                <?php
                    $shipping = is_array($order->shipping_address) ? $order->shipping_address : json_decode($order->shipping_address, true);
                ?>
                <?php if(is_array($shipping)): ?>
                    <div class="space-y-2">
                        <p class="font-medium"><?php echo e($shipping['name'] ?? $order->customer_name); ?></p>
                        <p class="text-gray-700"><?php echo e($shipping['address'] ?? ''); ?></p>
                        <p class="text-gray-700">
                            <?php echo e($shipping['city'] ?? ''); ?>, 
                            <?php echo e($shipping['state'] ?? ''); ?> 
                            <?php echo e($shipping['zip'] ?? ''); ?>

                        </p>
                        <p class="text-gray-700"><?php echo e($shipping['country'] ?? ''); ?></p>
                        <?php if(isset($shipping['phone'])): ?>
                        <p class="text-gray-700 mt-2">
                            <i class="fas fa-phone mr-2"></i><?php echo e($shipping['phone']); ?>

                        </p>
                        <?php endif; ?>
                    </div>
                <?php else: ?>
                    <p class="text-gray-700"><?php echo e($order->shipping_address); ?></p>
                <?php endif; ?>
            </div>

            <!-- Order Summary -->
            <div class="bg-gray-50 rounded-lg p-5">
                <h3 class="text-lg font-semibold text-gray-900 mb-4 pb-2 border-b border-gray-200">
                    <i class="fas fa-receipt mr-2 text-[#0A9961]"></i>Order Summary
                </h3>
                <div class="space-y-2">
                    <div class="flex justify-between">
                        <span class="text-gray-600">Subtotal</span>
                        <span class="font-medium">Ksh<?php echo e(number_format($order->subtotal, 2)); ?></span>
                    </div>
                    <?php if($order->tax > 0): ?>
                    <div class="flex justify-between">
                        <span class="text-gray-600">Tax</span>
                        <span class="font-medium">Ksh<?php echo e(number_format($order->tax, 2)); ?></span>
                    </div>
                    <?php endif; ?>
                    <?php if($order->shipping > 0): ?>
                    <div class="flex justify-between">
                        <span class="text-gray-600">Shipping</span>
                        <span class="font-medium">Ksh<?php echo e(number_format($order->shipping, 2)); ?></span>
                    </div>
                    <?php endif; ?>
                    <div class="flex justify-between text-lg font-bold pt-2 border-t border-gray-300 mt-2">
                        <span>Total</span>
                        <span class="text-[#0A9961]">Ksh<?php echo e(number_format($order->total, 2)); ?></span>
                    </div>
                    <?php if($order->payment_method): ?>
                    <div class="flex justify-between pt-2">
                        <span class="text-gray-600">Payment Method</span>
                        <span class="font-medium">
                            <?php echo e(ucfirst($order->payment_method)); ?>

                            <?php if($order->payment_method === 'paybill' && $order->payment_status === 'pending_verification'): ?>
                            <span class="ml-2 bg-yellow-100 text-yellow-800 px-2 py-1 rounded text-xs">Verification Required</span>
                            <?php endif; ?>
                        </span>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

      <!-- Order Items -->
<div class="bg-white border border-gray-200 rounded-lg">
    <div class="px-6 py-4 border-b border-gray-200">
        <h3 class="text-lg font-semibold text-gray-900">Order Items</h3>
    </div>
    <div class="overflow-x-auto">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Product</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Price</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Quantity</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Total</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-200">
                <?php $__currentLoopData = $order->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td class="px-6 py-4">
                        <div class="flex items-center">
                            <div class="flex-shrink-0 h-12 w-12 mr-4">
                                <?php if($item->product && $item->product->image): ?>
                                    <img class="h-12 w-12 rounded-lg object-cover border border-gray-200" 
                                         src="<?php echo e(asset($item->product->image)); ?>" 
                                         alt="<?php echo e($item->product_name); ?>">
                                <?php else: ?>
                                    <div class="h-12 w-12 rounded-lg bg-gray-100 border border-gray-200 flex items-center justify-center">
                                        <svg class="w-6 h-6 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                                        </svg>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <div>
                                <div class="text-sm font-medium text-gray-900">
                                    <?php echo e($item->product_name); ?>

                                </div>
                                <?php if($item->product && $item->product->sku): ?>
                                <div class="text-sm text-gray-500">
                                    SKU: <?php echo e($item->product->sku); ?>

                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <div class="text-sm text-gray-900">Ksh<?php echo e(number_format($item->price, 2)); ?></div>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <div class="text-sm text-gray-900"><?php echo e($item->quantity); ?></div>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <div class="text-sm font-bold text-gray-900">Ksh<?php echo e(number_format($item->total, 2)); ?></div>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>

        <!-- M-Pesa Transactions -->
        <?php if($order->payment_method === 'mpesa' && $order->mpesaTransactions->count() > 0): ?>
        <div class="mt-6 bg-white border border-gray-200 rounded-lg">
            <div class="px-6 py-4 border-b border-gray-200">
                <h3 class="text-lg font-semibold text-gray-900 flex items-center">
                    <i class="fas fa-mobile-alt mr-2 text-[#0A9961]"></i>
                    M-Pesa Transactions
                </h3>
                <p class="text-sm text-gray-500 mt-1">Payment transactions for this order</p>
            </div>
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Transaction Details</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Phone</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Amount</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Time</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-200">
                        <?php $__currentLoopData = $order->mpesaTransactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td class="px-6 py-4">
                                <div class="text-sm font-mono text-gray-900">
                                    <?php if($transaction->transaction_id): ?>
                                        <?php echo e($transaction->transaction_id); ?>

                                    <?php else: ?>
                                        <span class="text-gray-400">Not assigned</span>
                                    <?php endif; ?>
                                </div>
                                <?php if($transaction->checkout_request_id): ?>
                                <div class="text-xs text-gray-500 mt-1">
                                    Checkout ID: <?php echo e(substr($transaction->checkout_request_id, 0, 12)); ?>...
                                </div>
                                <?php endif; ?>
                                <?php if($transaction->merchant_request_id): ?>
                                <div class="text-xs text-gray-500">
                                    Merchant ID: <?php echo e(substr($transaction->merchant_request_id, 0, 10)); ?>...
                                </div>
                                <?php endif; ?>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-sm text-gray-900">
                                    <i class="fas fa-phone text-gray-400 mr-1"></i>
                                    <?php echo e($transaction->phone_number); ?>

                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-sm font-bold text-gray-900">Ksh <?php echo e(number_format($transaction->amount, 2)); ?></div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <?php
                                    $statusColors = [
                                        'success' => 'bg-green-100 text-green-800',
                                        'pending' => 'bg-yellow-100 text-yellow-800',
                                        'failed' => 'bg-red-100 text-red-800'
                                    ];
                                    $color = $statusColors[$transaction->status] ?? 'bg-gray-100 text-gray-800';
                                ?>
                                <span class="px-3 py-1 inline-flex text-xs leading-5 font-semibold rounded-full <?php echo e($color); ?>">
                                    <?php echo e(ucfirst($transaction->status)); ?>

                                </span>
                                <?php if($transaction->response_code && $transaction->response_code != '0'): ?>
                                <div class="text-xs text-red-600 mt-1">
                                    Code: <?php echo e($transaction->response_code); ?>

                                </div>
                                <?php endif; ?>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <?php if($transaction->transaction_time): ?>
                                <div class="text-sm text-gray-900"><?php echo e($transaction->transaction_time->format('M d, Y')); ?></div>
                                <div class="text-xs text-gray-500"><?php echo e($transaction->transaction_time->format('h:i A')); ?></div>
                                <?php else: ?>
                                <div class="text-sm text-gray-500">N/A</div>
                                <?php endif; ?>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                <a href="<?php echo e(route('admin.transactions.show', $transaction)); ?>" 
                                   class="text-[#0A9961] hover:text-[#088753] hover:bg-[#0A9961]/10 p-2 rounded-lg transition-colors duration-200 inline-block"
                                   title="View Details">
                                    <i class="fas fa-eye"></i>
                                </a>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
        <?php endif; ?>

        <!-- Notes -->
        <?php if($order->notes): ?>
        <div class="mt-6 bg-yellow-50 border border-yellow-200 rounded-lg p-5">
            <h3 class="text-lg font-semibold text-gray-900 mb-2">
                <i class="fas fa-sticky-note mr-2 text-yellow-600"></i>Order Notes
            </h3>
            <p class="text-gray-700 whitespace-pre-line"><?php echo e($order->notes); ?></p>
        </div>
        <?php endif; ?>

        <!-- Order Actions -->
        <div class="mt-6 flex justify-between items-center pt-6 border-t border-gray-200">
            <a href="<?php echo e(route('admin.orders.edit', $order)); ?>" 
               class="bg-[#0A9961] hover:bg-[#088753] text-white px-6 py-3 rounded-lg font-medium transition-colors duration-200">
                <i class="fas fa-edit mr-2"></i>Update Order Status
            </a>
            
            <?php if($order->status !== 'cancelled'): ?>
            <form action="<?php echo e(route('admin.orders.update', $order)); ?>" method="POST" class="inline">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <input type="hidden" name="status" value="cancelled">
                <button type="submit" 
                        onclick="return confirm('Are you sure you want to cancel this order?')"
                        class="bg-red-100 hover:bg-red-200 text-red-700 px-6 py-3 rounded-lg font-medium transition-colors duration-200">
                    <i class="fas fa-times mr-2"></i>Cancel Order
                </button>
            </form>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php if(request()->has('print') && request()->get('print') === 'invoice'): ?>
<script>
    window.onload = function() {
        window.print();
    }
</script>
<?php endif; ?>

<script>
function confirmRejection() {
    const reason = document.getElementById('rejection_reason').value.trim();
    if (!reason) {
        alert('Please provide a reason for rejecting this payment.');
        document.getElementById('rejection_reason').focus();
        return false;
    }
    
    return confirm('Are you sure you want to reject this payment? This will cancel the order and notify the customer.');
}

// Form validation for rejection
document.getElementById('reject-payment-form').addEventListener('submit', function(e) {
    const reason = document.getElementById('rejection_reason').value.trim();
    if (!reason) {
        e.preventDefault();
        alert('Please provide a reason for rejecting this payment.');
        document.getElementById('rejection_reason').focus();
    }
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\finepoint\resources\views/admin/orders/show.blade.php ENDPATH**/ ?>