

<?php $__env->startSection('title', 'Categories - Finepoint Electronics'); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .category-card { 
        transition: all 0.2s ease-in-out; 
    }
    
    .category-card:hover { 
        transform: translateY(-2px); 
        box-shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04); 
    }
    
    .line-clamp-1 { 
        display: -webkit-box; 
        -webkit-line-clamp: 1; 
        -webkit-box-orient: vertical; 
        overflow: hidden; 
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<!-- Hero Section for Categories -->
<div class="bg-gradient-to-r from-[#0A9961] to-[#10B981] text-white">
    <div class="max-w-7xl mx-auto px-4 py-12">
        <div class="text-center">
            <h1 class="text-3xl font-bold mb-3">Browse Categories</h1>
            <p class="text-gray-100 mb-6">Find your favorite electronics by category</p>
            <div class="flex justify-center space-x-4">
                <a href="<?php echo e(route('products.public')); ?>" 
                   class="inline-block bg-white text-[#0A9961] hover:bg-gray-100 font-medium py-2 px-6 rounded transition duration-200 no-underline">
                    View All Products
                </a>
                <?php if(auth()->guard()->check()): ?>
                    <?php if(auth()->user()->isAdmin()): ?>
                        <a href="<?php echo e(route('admin.categories.create')); ?>" 
                           class="inline-block bg-transparent border border-white text-white hover:bg-white hover:text-[#0A9961] font-medium py-2 px-6 rounded transition duration-200 no-underline">
                            Add New Category
                        </a>
                    <?php endif; ?>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Categories Grid -->
<div class="max-w-7xl mx-auto px-4 py-8">
    <!-- Stats Bar -->
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">All Categories</h1>
            <p class="text-gray-600 text-sm mt-1"><?php echo e($categories->count()); ?> categories available</p>
        </div>
        <div class="flex items-center space-x-2">
            <span class="text-gray-500 text-sm">Sort by:</span>
            <select class="border border-gray-300 rounded px-3 py-1 text-sm focus:outline-none focus:border-[#0A9961]">
                <option value="name">Name (A-Z)</option>
                <option value="products">Most Products</option>
                <option value="newest">Newest First</option>
            </select>
        </div>
    </div>
    
    <?php if($categories->count() > 0): ?>
    <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 xl:grid-cols-5 gap-6">
        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <a href="<?php echo e(route('category.products', $category)); ?>" 
           class="bg-white rounded-lg border border-gray-200 hover:border-[#0A9961] hover:shadow-md transition-all duration-200 category-card no-underline block">
            <div class="p-5">
                <!-- Category Icon/Image -->
                <div class="flex justify-center mb-4">
                    <?php if($category->image_url): ?>
                        <div class="w-20 h-20 rounded-full bg-gray-50 flex items-center justify-center overflow-hidden">
                            <img src="<?php echo e($category->image_url); ?>" 
                                 alt="<?php echo e($category->name); ?>"
                                 class="w-full h-full object-cover">
                        </div>
                    <?php else: ?>
                        <div class="w-20 h-20 rounded-full bg-gradient-to-br from-[#0A9961]/10 to-[#10B981]/10 flex items-center justify-center">
                            <i class="fas fa-folder text-[#0A9961] text-2xl"></i>
                        </div>
                    <?php endif; ?>
                </div>
                
                <!-- Category Info -->
                <h3 class="font-semibold text-gray-900 text-center line-clamp-1 mb-2"><?php echo e($category->name); ?></h3>
                
                <!-- Product Count -->
                <div class="text-center mb-3">
                    <span class="inline-block bg-gray-100 text-gray-700 text-xs font-medium px-3 py-1 rounded-full">
                        <?php if($category->products_count > 0): ?>
                            <?php echo e($category->products_count); ?> <?php echo e($category->products_count == 1 ? 'product' : 'products'); ?>

                        <?php else: ?>
                            No products yet
                        <?php endif; ?>
                    </span>
                </div>
                
                <!-- View Button -->
                <div class="text-center">
                    <span class="inline-flex items-center text-[#0A9961] text-sm font-medium">
                        Browse Category
                        <i class="fas fa-arrow-right ml-2 text-xs"></i>
                    </span>
                </div>
            </div>
        </a>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
    <?php else: ?>
    <!-- Empty State -->
    <div class="text-center py-16 bg-white rounded-lg border border-gray-200">
        <div class="w-24 h-24 rounded-full bg-gray-100 flex items-center justify-center mx-auto mb-6">
            <i class="fas fa-folder-open text-gray-400 text-3xl"></i>
        </div>
        <h3 class="text-xl font-semibold text-gray-900 mb-2">No categories yet</h3>
        <p class="text-gray-600 mb-6 max-w-md mx-auto">Product categories will appear here once they are added to the store.</p>
        <?php if(auth()->guard()->check()): ?>
            <?php if(auth()->user()->isAdmin()): ?>
                <a href="<?php echo e(route('admin.categories.create')); ?>" 
                   class="inline-block bg-[#0A9961] hover:bg-[#088552] text-white font-medium py-2.5 px-8 rounded transition duration-200 no-underline">
                    <i class="fas fa-plus mr-2"></i>Create Your First Category
                </a>
            <?php else: ?>
                <p class="text-gray-500 text-sm">Please check back later or contact the store administrator.</p>
            <?php endif; ?>
        <?php else: ?>
            <p class="text-gray-500 text-sm">Please check back later for product categories.</p>
        <?php endif; ?>
    </div>
    <?php endif; ?>
</div>

<!-- Features Section (Matching Welcome Page) -->
<div class="bg-gray-50 py-12 border-t border-gray-200">
    <div class="max-w-7xl mx-auto px-4">
        <h2 class="text-xl font-bold text-gray-900 mb-8 text-center">Why Shop With Us</h2>
        <div class="grid grid-cols-2 md:grid-cols-4 gap-6">
            <div class="text-center">
                <div class="w-12 h-12 rounded-full bg-[#0A9961] flex items-center justify-center mx-auto mb-3">
                    <i class="fas fa-shipping-fast text-white text-lg"></i>
                </div>
                <h3 class="font-medium text-gray-900 text-sm mb-1">Free Shipping</h3>
                <p class="text-xs text-gray-600">Over Ksh 10,000</p>
            </div>
            <div class="text-center">
                <div class="w-12 h-12 rounded-full bg-[#0A9961] flex items-center justify-center mx-auto mb-3">
                    <i class="fas fa-undo text-white text-lg"></i>
                </div>
                <h3 class="font-medium text-gray-900 text-sm mb-1">30-Day Returns</h3>
                <p class="text-xs text-gray-600">Easy returns</p>
            </div>
            <div class="text-center">
                <div class="w-12 h-12 rounded-full bg-[#0A9961] flex items-center justify-center mx-auto mb-3">
                    <i class="fas fa-shield-alt text-white text-lg"></i>
                </div>
                <h3 class="font-medium text-gray-900 text-sm mb-1">1 Year Warranty</h3>
                <p class="text-xs text-gray-600">On all products</p>
            </div>
            <div class="text-center">
                <div class="w-12 h-12 rounded-full bg-[#0A9961] flex items-center justify-center mx-auto mb-3">
                    <i class="fas fa-headset text-white text-lg"></i>
                </div>
                <h3 class="font-medium text-gray-900 text-sm mb-1">24/7 Support</h3>
                <p class="text-xs text-gray-600">Dedicated help</p>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\finepoint\resources\views/categories.blade.php ENDPATH**/ ?>