

<?php $__env->startSection('title', 'Shopping Cart - Finepoint Electronics'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto px-4 py-8">
    <h1 class="text-2xl font-bold text-gray-900 mb-6">Shopping Cart</h1>
    
    <?php if(($cartItems ?? collect())->count() > 0): ?>
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
        <!-- Cart Items -->
        <div class="lg:col-span-2">
            <div class="bg-white rounded-lg shadow-sm border border-gray-200">
                <!-- Cart Header -->
                <div class="px-6 py-4 border-b border-gray-200 flex justify-between items-center">
                    <h2 class="font-medium text-gray-900">Your Items (<?php echo e($cartItems->count()); ?>)</h2>
                    <button onclick="clearCart()" class="text-red-600 hover:text-red-800 text-sm">
                        <i class="fas fa-trash-alt mr-1"></i> Clear Cart
                    </button>
                </div>
                
                <!-- Discount Alert -->
                <?php if($totalDiscount > 0): ?>
                <div class="px-6 py-3 bg-green-50 border-b border-green-100">
                    <div class="flex items-center">
                        <i class="fas fa-tag text-green-600 mr-2"></i>
                        <span class="text-green-800 font-medium">You're saving Ksh <?php echo e(number_format($totalDiscount)); ?> with deals!</span>
                    </div>
                </div>
                <?php endif; ?>
                
                <!-- Cart Items List -->
                <div class="divide-y divide-gray-100">
                    <?php $__currentLoopData = $cartItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cartItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $product = $cartItem->product;
                        
                        // Determine cart item ID based on auth status
                        if (Auth::check()) {
                            $cartItemId = $cartItem->id;
                            $cartKey = $cartItemId;
                        } else {
                            $cartItemId = $cartItem->cart_key ?? $product->id;
                            $cartKey = $cartItemId;
                        }
                        
                        // Get prices
                        $originalPrice = $cartItem->original_price ?? $product->price;
                        $actualPrice = $cartItem->actual_price ?? $product->price;
                        $quantity = $cartItem->quantity;
                        $hasDeal = $cartItem->has_deal ?? (!empty($cartItem->deal_id));
                        
                        // Calculate totals
                        $itemOriginalTotal = $originalPrice * $quantity;
                        $itemActualTotal = $actualPrice * $quantity;
                        $itemDiscount = $itemOriginalTotal - $itemActualTotal;
                    ?>
                    
                    <div id="cart-row-<?php echo e($cartKey); ?>" class="px-6 py-4 flex items-center" 
                         data-price="<?php echo e($actualPrice); ?>" 
                         data-original-price="<?php echo e($originalPrice); ?>"
                         data-product-id="<?php echo e($product->id); ?>"
                         data-has-deal="<?php echo e($hasDeal ? '1' : '0'); ?>">
                        
                        <!-- Product Image -->
                        <div class="w-20 h-20 flex-shrink-0">
                            <?php if($product->image): ?>
                                <img src="<?php echo e($product->image_url); ?>" 
                                     alt="<?php echo e($product->name); ?>"
                                     class="w-full h-full object-contain">
                            <?php else: ?>
                                <div class="w-full h-full bg-gray-100 rounded flex items-center justify-center">
                                    <i class="fas fa-box text-gray-300"></i>
                                </div>
                            <?php endif; ?>
                        </div>
                        
                        <!-- Product Info -->
                        <div class="ml-4 flex-grow">
                            <a href="<?php echo e(route('products.public.show', $product)); ?>" 
                               class="font-medium text-gray-900 hover:text-[#0A9961] block">
                                <?php echo e($product->name); ?>

                            </a>
                            
                            <!-- Price Display -->
                            <div class="mt-1">
                                <?php if($hasDeal && $originalPrice > $actualPrice): ?>
                                    <div class="flex items-center">
                                        <span class="text-[#0A9961] font-bold">
                                            Ksh <?php echo e(number_format($actualPrice)); ?>

                                        </span>
                                        <span class="text-gray-500 text-sm line-through ml-2">
                                            Ksh <?php echo e(number_format($originalPrice)); ?>

                                        </span>
                                        <span class="ml-2 bg-red-100 text-red-800 text-xs font-medium px-2 py-0.5 rounded">
                                            <?php if($cartItem->deal_type == 'percentage'): ?>
                                                <?php echo e($cartItem->deal_discount_value); ?>% OFF
                                            <?php else: ?>
                                                SAVE Ksh <?php echo e(number_format($itemDiscount / $quantity)); ?>

                                            <?php endif; ?>
                                        </span>
                                    </div>
                                <?php else: ?>
                                    <span class="text-[#0A9961] font-bold">
                                        Ksh <?php echo e(number_format($actualPrice)); ?>

                                    </span>
                                <?php endif; ?>
                            </div>
                            
                            <!-- Deal Info -->
                            <?php if($hasDeal && isset($cartItem->deal_type)): ?>
                                <div class="text-xs text-gray-600 mt-1">
                                    <i class="fas fa-bolt text-yellow-500 mr-1"></i>
                                    <?php echo e($cartItem->deal_type == 'percentage' ? $cartItem->deal_discount_value . '% Discount' : 'Fixed Discount'); ?>

                                </div>
                            <?php endif; ?>
                            
                            <!-- Stock Warning -->
                            <?php if($product->stock < $quantity): ?>
                                <p class="text-red-600 text-xs mt-1">
                                    <i class="fas fa-exclamation-triangle"></i> 
                                    Only <?php echo e($product->stock); ?> in stock
                                </p>
                            <?php endif; ?>
                        </div>
                        
                        <!-- Quantity Controls -->
                        <div class="flex items-center">
                            <button type="button" onclick="updateQuantity('<?php echo e($cartKey); ?>', -1)" 
                                    class="w-8 h-8 flex items-center justify-center border border-gray-300 rounded-l hover:bg-gray-50">
                                <i class="fas fa-minus text-gray-600 text-xs"></i>
                            </button>
                            <input type="number" 
                                   id="quantity-input-<?php echo e($cartKey); ?>"
                                   value="<?php echo e($quantity); ?>"
                                   min="1"
                                   max="<?php echo e($product->stock); ?>"
                                   class="w-12 h-8 text-center border-t border-b border-gray-300 focus:outline-none focus:border-[#0A9961]">
                            <button type="button" onclick="updateQuantity('<?php echo e($cartKey); ?>', 1)" 
                                    class="w-8 h-8 flex items-center justify-center border border-gray-300 rounded-r hover:bg-gray-50">
                                <i class="fas fa-plus text-gray-600 text-xs"></i>
                            </button>
                        </div>
                        
                        <!-- Item Total -->
                        <div class="ml-6 text-right">
                            <?php if($hasDeal && $itemDiscount > 0): ?>
                                <div class="mb-1">
                                    <span id="item-total-<?php echo e($cartKey); ?>" class="font-bold text-gray-900">
                                        Ksh <?php echo e(number_format($itemActualTotal)); ?>

                                    </span>
                                    <div class="text-xs text-gray-500 line-through">
                                        Ksh <?php echo e(number_format($itemOriginalTotal)); ?>

                                    </div>
                                </div>
                            <?php else: ?>
                                <p id="item-total-<?php echo e($cartKey); ?>" class="font-bold text-gray-900">
                                    Ksh <?php echo e(number_format($itemActualTotal)); ?>

                                </p>
                            <?php endif; ?>
                            
                            <button type="button" onclick="removeFromCart('<?php echo e($cartKey); ?>', '<?php echo e(addslashes($product->name)); ?>')" 
                                    class="text-red-600 hover:text-red-800 text-sm mt-1">
                                <i class="fas fa-trash-alt mr-1"></i> Remove
                            </button>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                
                <!-- Cart Summary (Mobile) -->
                <div class="lg:hidden border-t border-gray-200 p-6">
                    <div class="space-y-3">
                        <?php if($totalDiscount > 0): ?>
                        <div class="flex justify-between">
                            <span class="text-gray-600">Original Subtotal</span>
                            <span class="line-through text-gray-500">Ksh <?php echo e(number_format($originalSubtotal ?? $subtotal)); ?></span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-gray-600">Discount</span>
                            <span class="text-green-600 font-medium">- Ksh <?php echo e(number_format($totalDiscount)); ?></span>
                        </div>
                        <?php endif; ?>
                        <div class="flex justify-between">
                            <span class="text-gray-600">Subtotal</span>
                            <span class="font-medium">Ksh <?php echo e(number_format($subtotal)); ?></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Order Summary -->
        <div class="lg:col-span-1">
            <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6 sticky top-24">
                <h2 class="font-bold text-gray-900 text-lg mb-4">Order Summary</h2>
                
                <div class="space-y-3 mb-6">
                    <?php if($totalDiscount > 0): ?>
                    <div class="flex justify-between">
                        <span class="text-gray-600">Original Subtotal</span>
                        <span class="line-through text-gray-500">Ksh <?php echo e(number_format($originalSubtotal ?? $subtotal)); ?></span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-600">Discount</span>
                        <span class="text-green-600 font-medium">- Ksh <?php echo e(number_format($totalDiscount)); ?></span>
                    </div>
                    <?php endif; ?>
                    
                    <div class="flex justify-between">
                        <span class="text-gray-600">Subtotal</span>
                        <span id="subtotal" class="font-medium">Ksh <?php echo e(number_format($subtotal)); ?></span>
                    </div>
                    
                    <div class="flex justify-between">
                        <span class="text-gray-600">Shipping</span>
                        <span class="font-medium text-[#0A9961]">Calculated at checkout</span>
                    </div>
                    
                    <div class="border-t border-gray-200 pt-3">
                        <div class="flex justify-between">
                            <span class="font-bold text-gray-900">Total</span>
                            <span id="total" class="font-bold text-[#0A9961] text-xl">Ksh <?php echo e(number_format($subtotal)); ?></span>
                        </div>
                    </div>
                    
                    <?php if($totalDiscount > 0): ?>
                    <div class="bg-green-50 border border-green-200 rounded-lg p-3 mt-2">
                        <div class="flex items-center">
                            <i class="fas fa-tag text-green-600 mr-2"></i>
                            <div>
                                <p class="text-green-800 text-sm font-medium">Great deal!</p>
                                <p class="text-green-700 text-xs">You saved Ksh <?php echo e(number_format($totalDiscount)); ?></p>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
                
                <?php if($cartItems->count() > 0): ?>
                    <div class="mt-6">
                        <?php if(auth()->check()): ?>
                            <a href="<?php echo e(route('checkout')); ?>" 
                            class="w-full bg-[#0A9961] hover:bg-[#088753] text-white py-3 px-4 rounded-lg font-medium text-center transition-colors duration-200 block">
                                Proceed to Checkout
                            </a>
                        <?php else: ?>
                            <button onclick="redirectToLogin()" 
                                    class="w-full bg-[#0A9961] hover:bg-[#088753] text-white py-3 px-4 rounded-lg font-medium text-center transition-colors duration-200 block">
                                Login to Checkout
                            </button>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
                
                <!-- Continue Shopping -->
                <div class="mt-6">
                    <a href="<?php echo e(route('products.public')); ?>" 
                       class="w-full border border-[#0A9961] text-[#0A9961] hover:bg-[#0A9961] hover:text-white py-2 px-4 rounded-lg font-medium text-center transition-colors duration-200 block">
                        Continue Shopping
                    </a>
                </div>
                
                <!-- Security Info -->
                <div class="mt-6 pt-6 border-t border-gray-200">
                    <div class="flex items-center text-xs text-gray-500">
                        <i class="fas fa-lock mr-2"></i>
                        <span>Secure checkout · Your payment information is encrypted</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php else: ?>
    <!-- Empty Cart -->
    <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-12 text-center">
        <div class="w-16 h-16 rounded-full bg-gray-100 flex items-center justify-center mx-auto mb-4">
            <i class="fas fa-shopping-cart text-gray-400 text-xl"></i>
        </div>
        <h2 class="text-xl font-bold text-gray-900 mb-2">Your cart is empty</h2>
        <p class="text-gray-600 mb-6">Add some products to get started!</p>
        <a href="<?php echo e(route('products.public')); ?>" 
           class="inline-block bg-[#0A9961] hover:bg-[#088552] text-white font-medium py-2 px-6 rounded transition duration-200">
            Browse Products
        </a>
    </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    // Simple notification function
    function showNotification(message, type = 'success') {
        // Create a simple toast notification
        const toast = document.createElement('div');
        toast.className = `fixed top-4 right-4 px-4 py-2 rounded-md text-white ${
            type === 'success' ? 'bg-green-500' : 'bg-red-500'
        }`;
        toast.textContent = message;
        document.body.appendChild(toast);
        
        setTimeout(() => {
            toast.remove();
        }, 3000);
    }
    
    // FIXED: Calculate and update cart totals WITHOUT recursion
    function updateCartTotals() {
        let subtotal = 0;
        let originalSubtotal = 0;
        
        // Get all cart items and calculate totals
        document.querySelectorAll('[id^="cart-row-"]').forEach(row => {
            const cartKey = row.id.replace('cart-row-', '');
            const input = document.getElementById(`quantity-input-${cartKey}`);
            
            if (input) {
                const quantity = parseInt(input.value) || 0;
                const price = parseFloat(row.getAttribute('data-price')) || 0;
                const originalPrice = parseFloat(row.getAttribute('data-original-price')) || price;
                
                subtotal += price * quantity;
                originalSubtotal += originalPrice * quantity;
            }
        });
        
        // Update display
        const subtotalElement = document.getElementById('subtotal');
        const totalElement = document.getElementById('total');
        
        if (subtotalElement) {
            subtotalElement.textContent = `Ksh ${subtotal.toLocaleString()}`;
        }
        
        if (totalElement) {
            totalElement.textContent = `Ksh ${subtotal.toLocaleString()}`;
        }
    }
    
    // FIXED: Update single item total display
    function updateSingleItemTotal(cartKey) {
        const row = document.getElementById(`cart-row-${cartKey}`);
        if (!row) return;
        
        const input = document.getElementById(`quantity-input-${cartKey}`);
        if (!input) return;
        
        const quantity = parseInt(input.value) || 0;
        const price = parseFloat(row.getAttribute('data-price')) || 0;
        const originalPrice = parseFloat(row.getAttribute('data-original-price')) || price;
        const hasDeal = row.getAttribute('data-has-deal') === '1';
        
        const itemActualTotal = price * quantity;
        const itemOriginalTotal = originalPrice * quantity;
        
        const itemTotalElement = document.getElementById(`item-total-${cartKey}`);
        
        if (itemTotalElement) {
            if (hasDeal && itemOriginalTotal > itemActualTotal) {
                itemTotalElement.innerHTML = `
                    <span class="font-bold text-gray-900">Ksh ${itemActualTotal.toLocaleString()}</span>
                    <div class="text-xs text-gray-500 line-through">Ksh ${itemOriginalTotal.toLocaleString()}</div>
                `;
            } else {
                itemTotalElement.textContent = `Ksh ${itemActualTotal.toLocaleString()}`;
            }
        }
        
        // Return the calculated totals for this item
        return {
            subtotal: itemActualTotal,
            originalSubtotal: itemOriginalTotal
        };
    }
    
    // FIXED: Update quantity function - calls updateCartTotals separately
    function updateQuantity(cartKey, change) {
        const input = document.getElementById(`quantity-input-${cartKey}`);
        if (!input) return;
        
        let newQuantity = parseInt(input.value) + change;
        
        if (newQuantity < 1) {
            newQuantity = 1;
        }
        
        // Check max stock
        const maxStock = parseInt(input.getAttribute('max')) || 999;
        if (newQuantity > maxStock) {
            newQuantity = maxStock;
            showNotification(`Maximum ${maxStock} items available`, 'error');
            return;
        }
        
        input.value = newQuantity;
        
        // Update this item's total display
        updateSingleItemTotal(cartKey);
        
        // Update cart totals separately
        updateCartTotals();
        
        // Send to server
        saveQuantityToServer(cartKey, newQuantity);
    }
    
    // Save quantity to server
    function saveQuantityToServer(cartKey, quantity) {
        const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
        
        // Use FormData for better compatibility
        const formData = new FormData();
        formData.append('_token', csrfToken);
        formData.append('quantity', quantity);
        
        // Determine if we're updating by cart item ID or cart key
        const isCartItemId = cartKey.toString().match(/^\d+$/); // Check if it's numeric ID
        
        let url = isCartItemId 
            ? `/cart/update/${cartKey}` 
            : `/cart/update/${cartKey}`; // For guests, cartKey is the productId_dealId
        
        fetch(url, {
            method: 'POST',
            body: formData
        })
        .then(response => {
            if (!response.ok) {
                throw new Error(`HTTP error! status: ${response.status}`);
            }
            return response.json();
        })
        .then(data => {
            if (data.success) {
                // Update cart count in navbar
                updateCartCount();
                showNotification('Cart updated successfully');
            } else {
                showNotification(data.message || 'Failed to update quantity', 'error');
                // Reload to get correct values
                window.location.reload();
            }
        })
        .catch(error => {
            console.error('Error:', error);
            showNotification('An error occurred. Please try again.', 'error');
            window.location.reload();
        });
    }
    
    // Remove item from cart
    function removeFromCart(cartKey, productName) {
        if (!confirm(`Remove "${productName}" from cart?`)) {
            return;
        }
        
        const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
        
        // Use FormData
        const formData = new FormData();
        formData.append('_token', csrfToken);
        
        // Determine if we're removing by cart item ID or cart key
        const isCartItemId = cartKey.toString().match(/^\d+$/); // Check if it's numeric ID
        
        let url = isCartItemId 
            ? `/cart/remove/${cartKey}` 
            : `/cart/remove/${cartKey}`; // For guests, cartKey is the productId_dealId
        
        fetch(url, {
            method: 'POST',
            body: formData
        })
        .then(response => {
            if (!response.ok) {
                throw new Error(`HTTP error! status: ${response.status}`);
            }
            return response.json();
        })
        .then(data => {
            if (data.success) {
                showNotification('Item removed from cart');
                // Remove the row from table
                const row = document.getElementById(`cart-row-${cartKey}`);
                if (row) {
                    row.remove();
                }
                
                // Update cart count in navbar
                updateCartCount();
                
                // Update cart totals
                updateCartTotals();
                
                // Reload if cart is now empty
                if (document.querySelectorAll('[id^="cart-row-"]').length === 0) {
                    setTimeout(() => {
                        window.location.reload();
                    }, 500);
                }
            } else {
                showNotification(data.message || 'Failed to remove item', 'error');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            showNotification('An error occurred. Please try again.', 'error');
        });
    }
    
    // Clear entire cart
    function clearCart() {
        if (!confirm('Clear all items from cart?')) {
            return;
        }
        
        const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
        
        // Use FormData
        const formData = new FormData();
        formData.append('_token', csrfToken);
        
        fetch('/cart/clear', {
            method: 'POST',
            body: formData
        })
        .then(response => {
            if (!response.ok) {
                throw new Error(`HTTP error! status: ${response.status}`);
            }
            return response.json();
        })
        .then(data => {
            if (data.success) {
                showNotification('Cart cleared');
                // Remove all rows
                document.querySelectorAll('[id^="cart-row-"]').forEach(row => row.remove());
                updateCartCount();
                // Reload to show empty cart message
                setTimeout(() => {
                    window.location.reload();
                }, 500);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            showNotification('An error occurred. Please try again.', 'error');
        });
    }
    
    // Update cart count in navbar
    function updateCartCount() {
        fetch('/cart/count')
            .then(response => {
                if (!response.ok) {
                    throw new Error(`HTTP error! status: ${response.status}`);
                }
                return response.json();
            })
            .then(data => {
                const cartCountElement = document.getElementById('cart-count');
                if (cartCountElement) {
                    cartCountElement.textContent = data.cart_count || 0;
                }
            })
            .catch(error => {
                console.error('Error fetching cart count:', error);
            });
    }

    function redirectToLogin() {
        // Store current URL in session so we can redirect back after login
        const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
        const formData = new FormData();
        formData.append('_token', csrfToken);
        formData.append('redirect_url', window.location.href);
        
        fetch('/store-redirect-url', {
            method: 'POST',
            body: formData
        })
        .then(() => {
            // Redirect to login page
            window.location.href = '<?php echo e(route("login")); ?>';
        })
        .catch(error => {
            console.error('Error:', error);
            // Fallback: redirect without storing URL
            window.location.href = '<?php echo e(route("login")); ?>';
        });
    }
    
    // FIXED: Add event listener for manual input changes
    document.addEventListener('DOMContentLoaded', function() {
        document.querySelectorAll('input[id^="quantity-input-"]').forEach(input => {
            input.addEventListener('change', function() {
                const cartKey = this.id.replace('quantity-input-', '');
                const quantity = parseInt(this.value) || 1;
                
                // Update this item's total
                updateSingleItemTotal(cartKey);
                
                // Update cart totals
                updateCartTotals();
                
                // Save to server
                saveQuantityToServer(cartKey, quantity);
            });
            
            // Also handle blur event
            input.addEventListener('blur', function() {
                const cartKey = this.id.replace('quantity-input-', '');
                const quantity = parseInt(this.value) || 1;
                
                // Make sure quantity is within bounds
                const min = parseInt(this.getAttribute('min')) || 1;
                const max = parseInt(this.getAttribute('max')) || 999;
                
                if (quantity < min) {
                    this.value = min;
                    updateSingleItemTotal(cartKey);
                    updateCartTotals();
                } else if (quantity > max) {
                    this.value = max;
                    showNotification(`Maximum ${max} items available`, 'error');
                    updateSingleItemTotal(cartKey);
                    updateCartTotals();
                }
            });
        });
        
        // Initialize all item totals
        document.querySelectorAll('[id^="cart-row-"]').forEach(row => {
            const cartKey = row.id.replace('cart-row-', '');
            updateSingleItemTotal(cartKey);
        });
        
        // Initialize cart totals
        updateCartTotals();
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\finepoint\resources\views/cart.blade.php ENDPATH**/ ?>