<!DOCTYPE html>
<html>
<head>
    <title>Order Confirmation</title>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
        .container { max-width: 600px; margin: 0 auto; padding: 20px; }
        .header { 
            background: <?php echo e($isPaybill ? '#FF9800' : '#0A9961'); ?>; 
            color: white; 
            padding: 20px; 
            text-align: center; 
            border-radius: 8px 8px 0 0;
        }
        .content { padding: 20px; background: #f9f9f9; }
        .footer { text-align: center; padding: 20px; color: #666; font-size: 12px; }
        .order-details { background: white; padding: 15px; border-radius: 5px; margin: 15px 0; }
        .highlight { color: #0A9961; font-weight: bold; }
        .deal-savings { background: #d4edda; border: 1px solid #c3e6cb; padding: 15px; border-radius: 5px; margin: 15px 0; }
        .paybill-warning { 
            background: #fff3cd; 
            border: 1px solid #ffeaa7; 
            padding: 20px; 
            border-radius: 5px; 
            margin: 15px 0;
            border-left: 4px solid #ff9800;
        }
        .paybill-instructions {
            background: #e3f2fd;
            border: 1px solid #bbdefb;
            padding: 20px;
            border-radius: 5px;
            margin: 15px 0;
            border-left: 4px solid #2196f3;
        }
        .items-table { width: 100%; border-collapse: collapse; margin: 15px 0; }
        .items-table th, .items-table td { padding: 10px; text-align: left; border-bottom: 1px solid #ddd; }
        .deal-badge { background: #ffc107; color: #856404; padding: 2px 6px; border-radius: 3px; font-size: 11px; font-weight: bold; margin-left: 5px; }
        .original-price { text-decoration: line-through; color: #999; font-size: 0.9em; }
        .savings { color: #28a745; font-weight: bold; }
        .paybill-number {
            font-family: monospace;
            font-size: 18px;
            background: #fff;
            padding: 10px 15px;
            border-radius: 5px;
            border: 2px dashed #2196f3;
            text-align: center;
            margin: 10px 0;
        }
        .status-badge {
            display: inline-block;
            padding: 5px 12px;
            background-color: <?php echo e($isPaybill ? '#ff9800' : '#0A9961'); ?>;
            color: white;
            border-radius: 20px;
            font-size: 12px;
            font-weight: bold;
            margin-left: 10px;
            text-transform: uppercase;
        }
        .step-number {
            display: inline-block;
            width: 30px;
            height: 30px;
            background: #2196f3;
            color: white;
            border-radius: 50%;
            text-align: center;
            line-height: 30px;
            margin-right: 10px;
            font-weight: bold;
        }
        .step {
            margin: 10px 0;
            padding: 5px 0;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>
                <?php if($isPaybill): ?>
                    ⚠️ Payment Verification Required
                <?php elseif($paymentMethod === 'cod'): ?>
                    Thank You For Your Order!
                <?php else: ?>
                    Thank You For Your Order!
                <?php endif; ?>
            </h1>
            <p>
                Order #<?php echo e($order->order_number); ?>

                <?php if($isPaybill): ?>
                    <span class="status-badge">VERIFICATION NEEDED</span>
                <?php else: ?>
                    <span class="status-badge">RECEIVED</span>
                <?php endif; ?>
            </p>
        </div>
        
        <div class="content">
            <p>Hello <?php echo e($order->customer_name); ?>,</p>
            
            <?php if($isPaybill): ?>
            <div class="paybill-warning">
                <h3 style="margin-top: 0; color: #856404;">⚠️ Important Payment Instructions</h3>
                <p>You have selected <strong>Direct Paybill</strong> as your payment method.</p>
                <p>Your order will be processed <strong>only after</strong> we verify your payment.</p>
            </div>
            <?php endif; ?>
            
            <?php if($totalDiscount > 0): ?>
            <div class="deal-savings">
                <h3 style="margin-top: 0; color: #155724;">🎉 Great Deal!</h3>
                <p>You saved <strong class="savings">Ksh <?php echo e(number_format($totalDiscount, 2)); ?></strong> with our special offers!</p>
            </div>
            <?php endif; ?>
            
            <div class="order-details">
                <h3>Order Information</h3>
                <p><strong>Order Number:</strong> <span class="highlight"><?php echo e($order->order_number); ?></span></p>
                <p><strong>Order Date:</strong> <?php echo e($order->created_at->format('F j, Y h:i A')); ?></p>
                <p><strong>Payment Method:</strong> 
                    <?php echo e($paymentMethod === 'cod' ? 'Cash on Delivery' : ($paymentMethod === 'paybill' ? 'Direct Paybill' : 'M-Pesa')); ?>

                </p>
                <p><strong>Total Amount:</strong> <span class="highlight">Ksh <?php echo e(number_format($order->total, 2)); ?></span></p>
                
                <?php if($paymentMethod === 'cod'): ?>
                <div style="background: #fff3cd; padding: 10px; border-radius: 5px; margin: 10px 0;">
                    <strong>Important:</strong> Our team will contact you within 24 hours to confirm shipping costs and finalize your order.
                </div>
                <?php endif; ?>
            </div>
            
            <?php if($isPaybill): ?>
            <div class="paybill-instructions">
                <h3 style="margin-top: 0; color: #0d47a1;">💳 How to Complete Your Payment</h3>
                
                <div class="step">
                    <span class="step-number">1</span>
                    <strong>Go to M-Pesa Menu</strong>
                    <p style="margin-left: 40px; margin-top: 5px;">
                        Select <strong>Lipa na M-Pesa</strong> → <strong>Paybill</strong>
                    </p>
                </div>
                
                <div class="step">
                    <span class="step-number">2</span>
                    <strong>Enter Paybill Number</strong>
                    <div class="paybill-number">
                        <strong>247247</strong>
                    </div>
                </div>
                
                <div class="step">
                    <span class="step-number">3</span>
                    <strong>Enter Account Number</strong>
                    <div class="paybill-number">
                        <strong>0715822306</strong>
                    </div>
                    <p style="margin-left: 40px; margin-top: 5px;">
                        Use <strong>your name</strong> or <strong>order number #<?php echo e($order->order_number); ?></strong> as reference
                    </p>
                </div>
                
                <div class="step">
                    <span class="step-number">4</span>
                    <strong>Enter Amount</strong>
                    <div class="paybill-number" style="border-color: #4caf50;">
                        <strong>Ksh <?php echo e(number_format($order->total, 2)); ?></strong> (Products Only)
                    </div>
                    <p style="margin-left: 40px; margin-top: 5px; color: #ff5722;">
                        <strong>Note:</strong> Shipping fee will be calculated separately
                    </p>
                </div>
                
                <div class="step">
                    <span class="step-number">5</span>
                    <strong>Complete Payment</strong>
                    <p style="margin-left: 40px; margin-top: 5px;">
                        Enter your M-Pesa PIN and wait for confirmation
                    </p>
                </div>
                
                <div style="background: #e8f5e9; padding: 15px; border-radius: 5px; margin-top: 20px;">
                    <p><strong>⏰ What happens next?</strong></p>
                    <ol style="margin: 10px 0 0 20px;">
                        <li>Our admin will verify your payment (within 24 hours)</li>
                        <li>You'll receive another email when payment is verified</li>
                        <li>Your order will then be processed for shipping</li>
                    </ol>
                </div>
            </div>
            <?php endif; ?>
            
            <div class="order-details">
                <h3>📦 Order Items</h3>
                <table class="items-table">
                    <thead>
                        <tr>
                            <th>Product</th>
                            <th>Qty</th>
                            <th>Price</th>
                            <th>Total</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $order->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $hasDeal = !empty($item->deal_id);
                            $itemDiscount = $hasDeal && $item->original_price ? ($item->original_price - $item->price) * $item->quantity : 0;
                        ?>
                        <tr>
                            <td>
                                <?php echo e($item->product_name); ?>

                                <?php if($hasDeal): ?>
                                <span class="deal-badge">
                                    <?php if($item->deal_type == 'percentage'): ?>
                                        <?php echo e($item->deal_discount_value); ?>% OFF
                                    <?php else: ?>
                                        SAVE Ksh <?php echo e(number_format($item->deal_discount_value)); ?>

                                    <?php endif; ?>
                                </span>
                                <?php endif; ?>
                            </td>
                            <td><?php echo e($item->quantity); ?></td>
                            <td>
                                <?php if($hasDeal && $item->original_price): ?>
                                    <div>Ksh <?php echo e(number_format($item->price, 2)); ?></div>
                                    <div class="original-price">Ksh <?php echo e(number_format($item->original_price, 2)); ?></div>
                                <?php else: ?>
                                    Ksh <?php echo e(number_format($item->price, 2)); ?>

                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($itemDiscount > 0): ?>
                                    <div>Ksh <?php echo e(number_format($item->price * $item->quantity, 2)); ?></div>
                                    <div class="original-price">Ksh <?php echo e(number_format($item->original_price * $item->quantity, 2)); ?></div>
                                <?php else: ?>
                                    Ksh <?php echo e(number_format($item->price * $item->quantity, 2)); ?>

                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                    <tfoot>
                        <?php if($totalDiscount > 0): ?>
                        <tr>
                            <td colspan="3" style="text-align: right;"><strong>Original Subtotal:</strong></td>
                            <td><span class="original-price">Ksh <?php echo e(number_format($order->items->sum(function($item) { return ($item->original_price ?? $item->price) * $item->quantity; }), 2)); ?></span></td>
                        </tr>
                        <tr>
                            <td colspan="3" style="text-align: right;"><strong>Discount:</strong></td>
                            <td class="savings">- Ksh <?php echo e(number_format($totalDiscount, 2)); ?></td>
                        </tr>
                        <?php endif; ?>
                        <tr>
                            <td colspan="3" style="text-align: right;"><strong>Subtotal:</strong></td>
                            <td>Ksh <?php echo e(number_format($order->subtotal, 2)); ?></td>
                        </tr>
                        <tr>
                            <td colspan="3" style="text-align: right;"><strong>Shipping:</strong></td>
                            <td>To be calculated</td>
                        </tr>
                        <tr style="border-top: 2px solid <?php echo e($isPaybill ? '#FF9800' : '#0A9961'); ?>;">
                            <td colspan="3" style="text-align: right;"><strong>Total:</strong></td>
                            <td><strong class="highlight">Ksh <?php echo e(number_format($order->total, 2)); ?></strong></td>
                        </tr>
                    </tfoot>
                </table>
            </div>
            
            <div class="order-details">
                <h3>🚚 Shipping Address</h3>
                <?php
                    $shipping = json_decode($order->shipping_address, true);
                ?>
                <p><strong><?php echo e($shipping['name'] ?? ''); ?></strong></p>
                <p><?php echo e($shipping['address'] ?? ''); ?></p>
                <p><?php echo e($shipping['city'] ?? ''); ?>, <?php echo e($shipping['state'] ?? ''); ?> <?php echo e($shipping['zip'] ?? ''); ?></p>
                <p><?php echo e($shipping['country'] ?? ''); ?></p>
                <p>📞 <?php echo e($shipping['phone'] ?? ''); ?></p>
                <p>📧 <?php echo e($shipping['email'] ?? ''); ?></p>
            </div>
            
            <?php if($isPaybill): ?>
            <div class="order-details" style="border-left: 4px solid #ff9800;">
                <h3>⏰ Next Steps</h3>
                <p>After you make the payment:</p>
                <ol>
                    <li><strong>Wait for verification</strong> (we'll check within 24 hours)</li>
                    <li><strong>Receive confirmation email</strong> when payment is verified</li>
                    <li><strong>We'll contact you</strong> to discuss shipping options and costs</li>
                    <li><strong>Your order will be shipped</strong> once everything is confirmed</li>
                </ol>
                <p>If you have any questions about the payment process, please reply to this email.</p>
            </div>
            <?php else: ?>
            <p>We'll notify you when your order ships. If you have any questions, please contact our customer support.</p>
            <?php endif; ?>
            
            <p>Thank you for shopping with us!</p>
        </div>
        
        <div class="footer">
            <p><strong><?php echo e(config('app.name')); ?></strong></p>
            <p>This is an automated message, please do not reply to this email.</p>
            <p>Need help? Contact our support team at <?php echo e(config('mail.from.address', 'support@example.com')); ?></p>
        </div>
    </div>
</body>
</html><?php /**PATH C:\wamp64\www\finepoint\resources\views/emails/order-placed.blade.php ENDPATH**/ ?>