

<?php $__env->startSection('content'); ?>
<div class="bg-white rounded-lg shadow-sm">
    <!-- Header -->
    <div class="border-b border-gray-200 px-6 py-4">
        <div class="flex justify-between items-center">
            <div>
                <h1 class="text-2xl font-bold text-gray-900">Update Order #<?php echo e($order->order_number); ?></h1>
                <p class="text-gray-600 mt-1">Update order status and details</p>
            </div>
            <a href="<?php echo e(route('admin.orders.show', $order)); ?>" 
               class="bg-gray-100 hover:bg-gray-200 text-gray-700 px-4 py-2 rounded-lg text-sm font-medium transition-colors duration-200">
                <i class="fas fa-arrow-left mr-2"></i>Back to Order
            </a>
        </div>
    </div>

    <div class="p-6">
        <form action="<?php echo e(route('admin.orders.update', $order)); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>
            
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
                <!-- Order Status -->
                <div class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Order Status</label>
                        <div class="grid grid-cols-2 md:grid-cols-3 gap-2">
                            <?php $__currentLoopData = ['pending', 'processing', 'shipped', 'delivered', 'cancelled', 'refunded']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label class="relative">
                                <input type="radio" name="status" value="<?php echo e($status); ?>" 
                                       class="sr-only peer" 
                                       <?php echo e($order->status === $status ? 'checked' : ''); ?>>
                                <div class="p-4 border-2 border-gray-200 rounded-lg cursor-pointer transition-all duration-200 
                                            peer-checked:border-[#0A9961] peer-checked:bg-[#0A9961]/5 
                                            hover:border-gray-300 hover:bg-gray-50">
                                    <div class="flex items-center">
                                        <?php switch($status):
                                            case ('pending'): ?>
                                                <i class="fas fa-clock text-yellow-500 mr-3"></i>
                                                <?php break; ?>
                                            <?php case ('processing'): ?>
                                                <i class="fas fa-cog text-blue-500 mr-3"></i>
                                                <?php break; ?>
                                            <?php case ('shipped'): ?>
                                                <i class="fas fa-truck text-purple-500 mr-3"></i>
                                                <?php break; ?>
                                            <?php case ('delivered'): ?>
                                                <i class="fas fa-check-circle text-green-500 mr-3"></i>
                                                <?php break; ?>
                                            <?php case ('cancelled'): ?>
                                                <i class="fas fa-times-circle text-red-500 mr-3"></i>
                                                <?php break; ?>
                                            <?php case ('refunded'): ?>
                                                <i class="fas fa-undo text-gray-500 mr-3"></i>
                                                <?php break; ?>
                                        <?php endswitch; ?>
                                        <div>
                                            <div class="font-medium text-gray-900"><?php echo e(ucfirst($status)); ?></div>
                                        </div>
                                    </div>
                                </div>
                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>

                <!-- Payment Status -->
                <div class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Payment Status</label>
                        <div class="grid grid-cols-3 gap-2">
                            <?php $__currentLoopData = ['pending', 'paid', 'failed']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $paymentStatus): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label class="relative">
                                <input type="radio" name="payment_status" value="<?php echo e($paymentStatus); ?>" 
                                       class="sr-only peer" 
                                       <?php echo e($order->payment_status === $paymentStatus ? 'checked' : ''); ?>>
                                <div class="p-4 border-2 border-gray-200 rounded-lg cursor-pointer transition-all duration-200 
                                            peer-checked:border-[#0A9961] peer-checked:bg-[#0A9961]/5 
                                            hover:border-gray-300 hover:bg-gray-50">
                                    <div class="flex flex-col items-center text-center">
                                        <?php switch($paymentStatus):
                                            case ('pending'): ?>
                                                <i class="fas fa-clock text-yellow-500 text-xl mb-2"></i>
                                                <?php break; ?>
                                            <?php case ('paid'): ?>
                                                <i class="fas fa-check-circle text-green-500 text-xl mb-2"></i>
                                                <?php break; ?>
                                            <?php case ('failed'): ?>
                                                <i class="fas fa-exclamation-circle text-red-500 text-xl mb-2"></i>
                                                <?php break; ?>
                                        <?php endswitch; ?>
                                        <div class="font-medium text-gray-900"><?php echo e(ucfirst($paymentStatus)); ?></div>
                                    </div>
                                </div>
                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <?php $__errorArgs = ['payment_status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            </div>

            <!-- Notes -->
            <div class="mt-6">
                <label for="notes" class="block text-sm font-medium text-gray-700 mb-2">Order Notes</label>
                <textarea name="notes" id="notes" rows="4" 
                          class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-[#0A9961] focus:border-transparent"
                          placeholder="Add any notes or comments about this order..."><?php echo e(old('notes', $order->notes)); ?></textarea>
                <p class="mt-1 text-sm text-gray-500">These notes are visible to admin only.</p>
            </div>

            <!-- Action Buttons -->
            <div class="mt-8 flex justify-end space-x-4 pt-6 border-t border-gray-200">
                <a href="<?php echo e(route('admin.orders.show', $order)); ?>" 
                   class="bg-gray-100 hover:bg-gray-200 text-gray-700 px-6 py-3 rounded-lg font-medium transition-colors duration-200">
                    Cancel
                </a>
                <button type="submit" 
                        class="bg-[#0A9961] hover:bg-[#088753] text-white px-6 py-3 rounded-lg font-medium transition-colors duration-200">
                    <i class="fas fa-save mr-2"></i>Update Order
                </button>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\finepoint\resources\views/admin/orders/edit.blade.php ENDPATH**/ ?>