@extends('layouts.admin-layout')

@section('content')
<div class="max-w-4xl mx-auto">
    <!-- Header -->
    <div class="mb-6">
        <h1 class="text-2xl font-bold text-gray-900">Edit Product</h1>
        <p class="text-gray-600 mt-2">Update product information</p>
    </div>

    <!-- Form Card -->
    <div class="bg-white rounded-xl shadow-lg overflow-hidden border border-gray-100">
      
      <!-- Card Header -->
      <div class="px-6 py-4 bg-gradient-to-r from-[#0A9961] to-[#10B981]">
        <div class="flex items-center">
          <div class="p-3 rounded-lg bg-white/20 backdrop-blur-sm mr-4">
            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/>
            </svg>
          </div>
          <div>
            <h2 class="text-lg font-semibold text-white">Edit Product Information</h2>
            <p class="text-green-100 text-sm">Update the product details</p>
          </div>
        </div>
      </div>
      
      <!-- Form Content -->
      <div class="p-6">
        @if($errors->any())
        <div class="mb-6 p-4 bg-red-50 border-l-4 border-red-500 rounded-r-lg shadow-sm">
          <div class="flex items-center">
            <svg class="w-5 h-5 text-red-500 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
            </svg>
            <div class="flex-1">
              <p class="font-medium text-red-800">Please fix the following errors:</p>
              <ul class="mt-1 text-sm text-red-700 list-disc list-inside">
                @foreach($errors->all() as $error)
                  <li>{{ $error }}</li>
                @endforeach
              </ul>
            </div>
          </div>
        </div>
        @endif

        <form method="POST" action="{{ route('admin.products.update', $product) }}" enctype="multipart/form-data">
          @csrf
          @method('PUT')

          <!-- Product Name -->
          <div class="mb-6">
            <label for="name" class="block text-sm font-medium text-gray-700 mb-2">
              Product Name *
            </label>
            <div class="relative">
              <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                <svg class="h-5 w-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                </svg>
              </div>
              <input type="text" id="name" name="name" value="{{ old('name', $product->name) }}" required
                     class="w-full pl-10 pr-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[#0A9961] focus:border-transparent transition duration-200"
                     placeholder="Enter product name">
            </div>
          </div>

          <!-- Slug -->
          <div class="mb-6">
            <label for="slug" class="block text-sm font-medium text-gray-700 mb-2">
              URL Slug *
            </label>
            <div class="relative">
              <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                <svg class="h-5 w-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.828 10.172a4 4 0 00-5.656 0l-4 4a4 4 0 105.656 5.656l1.102-1.101m-.758-4.899a4 4 0 005.656 0l4-4a4 4 0 00-5.656-5.656l-1.1 1.1"/>
                </svg>
              </div>
              <input type="text" id="slug" name="slug" value="{{ old('slug', $product->slug) }}" required
                     class="w-full pl-10 pr-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[#0A9961] focus:border-transparent transition duration-200"
                     placeholder="product-url-slug">
            </div>
            <p class="mt-1 text-xs text-gray-500">This will be used in the product URL. Use lowercase letters, numbers, and hyphens only.</p>
          </div>

          <!-- Brand, Price, and Category (Grid) -->
          <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-6">
            <!-- Brand -->
            <div>
              <label for="brand" class="block text-sm font-medium text-gray-700 mb-2">
                Brand
              </label>
              <div class="relative">
                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                  <svg class="h-5 w-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"/>
                  </svg>
                </div>
                <input type="text" id="brand" name="brand" value="{{ old('brand', $product->brand) }}"
                       class="w-full pl-10 pr-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[#0A9961] focus:border-transparent transition duration-200"
                       placeholder="Brand name">
              </div>
            </div>

            <!-- Price -->
            <div>
              <label for="price" class="block text-sm font-medium text-gray-700 mb-2">
                Price (Ksh) *
              </label>
              <div class="relative">
                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                  <span class="text-gray-500">Ksh</span>
                </div>
                <input type="number" id="price" name="price" value="{{ old('price', $product->price) }}" required step="0.01" min="0"
                       class="w-full pl-10 pr-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[#0A9961] focus:border-transparent transition duration-200"
                       placeholder="0.00">
              </div>
            </div>

            <!-- Category -->
            <div>
              <label for="category_id" class="block text-sm font-medium text-gray-700 mb-2">
                Category *
              </label>
              <select id="category_id" name="category_id" required
                      class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[#0A9961] focus:border-transparent transition duration-200">
                <option value="">Select Category</option>
                @foreach($categories as $category)
                  <option value="{{ $category->id }}" {{ old('category_id', $product->category_id) == $category->id ? 'selected' : '' }}>
                    {{ $category->name }}
                  </option>
                @endforeach
              </select>
              <p class="mt-1 text-xs text-gray-500">
                <a href="{{ route('admin.categories.create') }}" class="text-[#0A9961] hover:underline">
                  + Create new category
                </a>
              </p>
            </div>
          </div>

          <!-- Stock and SKU (Grid) -->
          <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
            <!-- Stock -->
            <div>
              <label for="stock" class="block text-sm font-medium text-gray-700 mb-2">
                Stock Quantity *
              </label>
              <div class="relative">
                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                  <svg class="h-5 w-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 13V6a2 2 0 00-2-2H6a2 2 0 00-2 2v7m16 0v5a2 2 0 01-2 2H6a2 2 0 01-2-2v-5m16 0h-2.586a1 1 0 00-.707.293l-2.414 2.414a1 1 0 01-.707.293h-3.172a1 1 0 01-.707-.293l-2.414-2.414A1 1 0 006.586 13H4"/>
                  </svg>
                </div>
                <input type="number" id="stock" name="stock" value="{{ old('stock', $product->stock) }}" required min="0"
                       class="w-full pl-10 pr-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[#0A9961] focus:border-transparent transition duration-200"
                       placeholder="Enter stock quantity">
              </div>
            </div>

            <!-- SKU -->
            <div>
              <label for="sku" class="block text-sm font-medium text-gray-700 mb-2">
                SKU (Stock Keeping Unit)
              </label>
              <div class="relative">
                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                  <svg class="h-5 w-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 20l4-16m4 4l4 4-4 4M6 16l-4-4 4-4"/>
                  </svg>
                </div>
                <input type="text" id="sku" name="sku" value="{{ old('sku', $product->sku) }}"
                       class="w-full pl-10 pr-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[#0A9961] focus:border-transparent transition duration-200"
                       placeholder="e.g., PROD-001">
              </div>
            </div>
          </div>

          <!-- Image Upload -->
          <div class="mb-6">
            <label for="image" class="block text-sm font-medium text-gray-700 mb-2">
              Product Image
            </label>
            
            <!-- Current Image Preview -->
            @if($product->image)
            <div class="mb-4">
              <p class="text-sm text-gray-600 mb-2">Current Image:</p>
              <div class="relative w-32 h-32">
                <img src="{{ asset($product->image) }}" alt="{{ $product->name }}" class="w-full h-full object-cover rounded-lg border border-gray-200">
              </div>
            </div>
            @endif
            
            <div class="border-2 border-dashed border-gray-300 rounded-lg p-6 text-center hover:border-[#0A9961] transition-colors duration-200">
              <div class="space-y-2">
                <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                </svg>
                <div>
                  <label for="image" class="cursor-pointer inline-flex items-center px-4 py-2 bg-[#0A9961] hover:bg-[#088551] text-white font-medium rounded-lg transition duration-200">
                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                      <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12"/>
                    </svg>
                    Choose New Image
                  </label>
                  <input type="file" id="image" name="image" class="hidden" accept="image/*">
                </div>
                <p class="text-xs text-gray-500">PNG, JPG, GIF up to 5MB</p>
                <p id="fileName" class="text-sm text-gray-900 font-medium">Leave empty to keep current image</p>
              </div>
            </div>
          </div>

          <!-- Description -->
          <div class="mb-6">
            <label for="description" class="block text-sm font-medium text-gray-700 mb-2">
              Description
            </label>
            <textarea id="description" name="description" rows="4"
                      class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[#0A9961] focus:border-transparent transition duration-200"
                      placeholder="Enter product description">{{ old('description', $product->description) }}</textarea>
          </div>

          <!-- SEO Settings -->
          <div class="mb-6 p-4 bg-gray-50 rounded-lg border border-gray-200">
            <h3 class="text-sm font-medium text-gray-900 mb-3">SEO Settings (Optional)</h3>
            
            <div class="space-y-4">
              <div>
                <label for="meta_title" class="block text-xs font-medium text-gray-700 mb-1">
                  Meta Title
                </label>
                <input type="text" id="meta_title" name="meta_title" value="{{ old('meta_title', $product->meta_title) }}"
                       class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm focus:outline-none focus:ring-1 focus:ring-[#0A9961] focus:border-transparent"
                       placeholder="Meta title for search engines">
              </div>
              
              <div>
                <label for="meta_description" class="block text-xs font-medium text-gray-700 mb-1">
                  Meta Description
                </label>
                <textarea id="meta_description" name="meta_description" rows="2"
                          class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm focus:outline-none focus:ring-1 focus:ring-[#0A9961] focus:border-transparent"
                          placeholder="Meta description for search engines">{{ old('meta_description', $product->meta_description) }}</textarea>
              </div>
              
              <div>
                <label for="meta_keywords" class="block text-xs font-medium text-gray-700 mb-1">
                  Meta Keywords
                </label>
                <input type="text" id="meta_keywords" name="meta_keywords" value="{{ old('meta_keywords', $product->meta_keywords) }}"
                       class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm focus:outline-none focus:ring-1 focus:ring-[#0A9961] focus:border-transparent"
                       placeholder="keyword1, keyword2, keyword3">
              </div>
            </div>
          </div>

          <!-- Form Actions -->
          <div class="flex items-center justify-between pt-6 border-t border-gray-200">
            <a href="{{ route('admin.products.index') }}" 
               class="px-4 py-2 border border-gray-300 text-gray-700 rounded-lg hover:bg-gray-50 transition duration-200">
              Cancel
            </a>
            <div class="flex space-x-3">
              <button type="button" 
                      onclick="if(confirm('Are you sure you want to delete this product?')) { document.getElementById('delete-form').submit(); }"
                      class="px-4 py-2 border border-red-300 text-red-700 rounded-lg hover:bg-red-50 transition duration-200">
                Delete
              </button>
              <button type="submit"
                      class="px-6 py-2 bg-[#0A9961] hover:bg-[#088551] text-white font-medium rounded-lg transition duration-200">
                Update Product
              </button>
            </div>
          </div>
        </form>

        <!-- Delete Form (Hidden) -->
        <form id="delete-form" action="{{ route('admin.products.destroy', $product) }}" method="POST" class="hidden">
          @csrf
          @method('DELETE')
        </form>
      </div>
    </div>
  </div>
</div>

<script>
  // File name display
  document.getElementById('image').addEventListener('change', function(e) {
    const fileName = e.target.files[0]?.name || 'Leave empty to keep current image';
    document.getElementById('fileName').textContent = fileName;
  });
  
  // Auto-generate slug from product name
  document.getElementById('name').addEventListener('input', function(e) {
    const slugInput = document.getElementById('slug');
    if (!slugInput.value || slugInput.value === '{{ $product->slug }}') {
      const slug = e.target.value
        .toLowerCase()
        .replace(/[^\w\s-]/g, '')
        .replace(/\s+/g, '-')
        .replace(/--+/g, '-');
      slugInput.value = slug;
    }
  });

  // Auto-fill SEO fields
  document.getElementById('name').addEventListener('blur', function() {
    const name = this.value;
    const metaTitle = document.getElementById('meta_title');
    const metaDescription = document.getElementById('meta_description');
    
    if (name && (!metaTitle.value || metaTitle.value === '{{ $product->meta_title }}')) {
      metaTitle.value = name + ' | ' + '{{ config("app.name", "Our Store") }}';
    }
    
    if (name && (!metaDescription.value || metaDescription.value === '{{ $product->meta_description }}')) {
      const desc = 'Buy ' + name + ' at the best price. Free shipping available.';
      metaDescription.value = desc;
    }
  });
</script>
@endsection