@extends('layouts.admin-layout')

@section('content')
<div class="mb-6">
    <!-- Welcome Banner -->
    <div class="bg-gradient-to-r from-[#0A9961] to-[#10B981] rounded-xl shadow-lg overflow-hidden">
        <div class="px-6 py-8 md:px-10 md:py-12">
            <div class="flex flex-col md:flex-row md:items-center justify-between">
                <div class="mb-6 md:mb-0">
                    <h1 class="text-2xl md:text-3xl font-bold text-white mb-2">Welcome back, {{ Auth::user()->name ?? Auth::user()->email }}! 👋</h1>
                    <p class="text-white/90 text-sm md:text-base">Here's what's happening with your store today.</p>
                </div>
                <div class="flex items-center space-x-4">
                    <span class="px-4 py-2 bg-white/20 backdrop-blur-sm text-white text-sm font-medium rounded-lg">
                        {{ now()->format('l, F j, Y') }}
                    </span>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Stats Cards -->
<div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
    <!-- Total Products -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6 hover:shadow-md transition-shadow duration-200">
        <div class="flex items-center">
            <div class="flex-shrink-0 bg-[#0A9961]/10 rounded-lg p-3">
                <i class="fas fa-box text-[#0A9961] text-xl"></i>
            </div>
            <div class="ml-4">
                <p class="text-sm font-medium text-gray-600">Total Products</p>
                <p class="text-2xl font-bold text-gray-900 mt-1">{{ $totalProducts ?? 0 }}</p>
            </div>
        </div>
        <div class="mt-4">
            <span class="text-xs font-medium text-gray-500">Active products in store</span>
        </div>
    </div>

    <!-- Total Orders -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6 hover:shadow-md transition-shadow duration-200">
        <div class="flex items-center">
            <div class="flex-shrink-0 bg-blue-50 rounded-lg p-3">
                <i class="fas fa-shopping-cart text-blue-600 text-xl"></i>
            </div>
            <div class="ml-4">
                <p class="text-sm font-medium text-gray-600">Total Orders</p>
                <p class="text-2xl font-bold text-gray-900 mt-1">{{ $totalOrders ?? 0 }}</p>
            </div>
        </div>
        <div class="mt-4">
            @php
                $todayOrders = \App\Models\Order::whereDate('created_at', today())->count();
            @endphp
            <span class="text-xs font-medium {{ $todayOrders > 0 ? 'text-green-600' : 'text-gray-500' }}">
                {{ $todayOrders }} today
            </span>
        </div>
    </div>

    <!-- M-Pesa Transactions -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6 hover:shadow-md transition-shadow duration-200">
        <div class="flex items-center">
            <div class="flex-shrink-0 bg-green-50 rounded-lg p-3">
                <i class="fas fa-mobile-alt text-green-600 text-xl"></i>
            </div>
            <div class="ml-4">
                <p class="text-sm font-medium text-gray-600">M-Pesa Transactions</p>
                <p class="text-2xl font-bold text-gray-900 mt-1">{{ $totalTransactions ?? 0 }}</p>
            </div>
        </div>
        <div class="mt-4">
            @if(isset($successfulTransactions) && $successfulTransactions > 0)
            <span class="text-xs font-medium text-green-600">
                {{ $successfulTransactions }} successful
            </span>
            @else
            <span class="text-xs font-medium text-gray-500">No transactions yet</span>
            @endif
        </div>
    </div>

    <!-- Revenue -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6 hover:shadow-md transition-shadow duration-200">
        <div class="flex items-center">
            <div class="flex-shrink-0 bg-purple-50 rounded-lg p-3">
                <i class="fas fa-money-bill-wave text-purple-600 text-xl"></i>
            </div>
            <div class="ml-4">
                <p class="text-sm font-medium text-gray-600">Revenue</p>
                <p class="text-2xl font-bold text-gray-900 mt-1">Ksh {{ number_format($totalRevenue ?? 0, 2) }}</p>
            </div>
        </div>
        <div class="mt-4">
            @if(isset($totalRevenue) && $totalRevenue > 0)
            <span class="text-xs font-medium text-green-600">From M-Pesa payments</span>
            @else
            <span class="text-xs font-medium text-gray-500">Start selling to earn</span>
            @endif
        </div>
    </div>
</div>

<!-- Quick Actions & Recent Activity -->
<div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
    <!-- Quick Actions -->
    <div class="lg:col-span-2">
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
            <div class="flex items-center justify-between mb-6">
                <h2 class="text-lg font-semibold text-gray-900">Quick Actions</h2>
                <span class="text-xs font-medium text-[#0A9961] bg-[#0A9961]/10 px-3 py-1 rounded-full">Get Started</span>
            </div>
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <!-- Add Product -->
                <a href="{{ route('admin.products.create') }}" 
                   class="group bg-gray-50 hover:bg-[#0A9961] border border-gray-200 hover:border-[#0A9961] rounded-lg p-4 transition-all duration-200">
                    <div class="flex items-center">
                        <div class="flex-shrink-0 w-10 h-10 rounded-lg bg-[#0A9961]/10 group-hover:bg-white flex items-center justify-center">
                            <i class="fas fa-plus text-[#0A9961] group-hover:text-[#0A9961]"></i>
                        </div>
                        <div class="ml-4">
                            <h3 class="text-sm font-medium text-gray-900 group-hover:text-white">Add Product</h3>
                            <p class="text-xs text-gray-500 group-hover:text-white/80 mt-1">Create your first product listing</p>
                        </div>
                    </div>
                </a>

                <!-- Manage Products -->
                <a href="{{ route('admin.products.index') }}" 
                   class="group bg-gray-50 hover:bg-[#0A9961] border border-gray-200 hover:border-[#0A9961] rounded-lg p-4 transition-all duration-200">
                    <div class="flex items-center">
                        <div class="flex-shrink-0 w-10 h-10 rounded-lg bg-blue-50 group-hover:bg-white flex items-center justify-center">
                            <i class="fas fa-boxes text-blue-600 group-hover:text-[#0A9961]"></i>
                        </div>
                        <div class="ml-4">
                            <h3 class="text-sm font-medium text-gray-900 group-hover:text-white">Manage Products</h3>
                            <p class="text-xs text-gray-500 group-hover:text-white/80 mt-1">View and edit all products</p>
                        </div>
                    </div>
                </a>

                <!-- View M-Pesa Transactions -->
                <a href="{{ route('admin.transactions.index') }}" 
                   class="group bg-gray-50 hover:bg-[#0A9961] border border-gray-200 hover:border-[#0A9961] rounded-lg p-4 transition-all duration-200">
                    <div class="flex items-center">
                        <div class="flex-shrink-0 w-10 h-10 rounded-lg bg-green-50 group-hover:bg-white flex items-center justify-center">
                            <i class="fas fa-mobile-alt text-green-600 group-hover:text-[#0A9961]"></i>
                        </div>
                        <div class="ml-4">
                            <h3 class="text-sm font-medium text-gray-900 group-hover:text-white">M-Pesa Transactions</h3>
                            <p class="text-xs text-gray-500 group-hover:text-white/80 mt-1">View all payment transactions</p>
                        </div>
                    </div>
                </a>

                <!-- View Store -->
                <a href="{{ route('home') }}" 
                   class="group bg-gray-50 hover:bg-[#0A9961] border border-gray-200 hover:border-[#0A9961] rounded-lg p-4 transition-all duration-200">
                    <div class="flex items-center">
                        <div class="flex-shrink-0 w-10 h-10 rounded-lg bg-green-50 group-hover:bg-white flex items-center justify-center">
                            <i class="fas fa-store text-green-600 group-hover:text-[#0A9961]"></i>
                        </div>
                        <div class="ml-4">
                            <h3 class="text-sm font-medium text-gray-900 group-hover:text-white">View Store</h3>
                            <p class="text-xs text-gray-500 group-hover:text-white/80 mt-1">See how customers see your store</p>
                        </div>
                    </div>
                </a>
            </div>
        </div>
    </div>

    <!-- Recent Activity -->
    <div class="lg:col-span-1">
        <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
            <div class="flex items-center justify-between mb-6">
                <h2 class="text-lg font-semibold text-gray-900">Recent Activity</h2>
                <span class="text-xs font-medium text-gray-500">Today</span>
            </div>
            
            <div class="space-y-4">
                <!-- Registration Activity -->
                <div class="flex items-start">
                    <div class="flex-shrink-0 mt-1">
                        <div class="w-8 h-8 rounded-full bg-[#0A9961]/10 flex items-center justify-center">
                            <i class="fas fa-user-plus text-[#0A9961] text-sm"></i>
                        </div>
                    </div>
                    <div class="ml-3">
                        <p class="text-sm text-gray-900">You registered successfully</p>
                        <p class="text-xs text-gray-500 mt-1">Welcome to ElectroShop Admin!</p>
                        <p class="text-xs text-gray-400 mt-1">Just now</p>
                    </div>
                </div>

                <!-- First Login -->
                <div class="flex items-start">
                    <div class="flex-shrink-0 mt-1">
                        <div class="w-8 h-8 rounded-full bg-blue-50 flex items-center justify-center">
                            <i class="fas fa-sign-in-alt text-blue-600 text-sm"></i>
                        </div>
                    </div>
                    <div class="ml-3">
                        <p class="text-sm text-gray-900">First login to dashboard</p>
                        <p class="text-xs text-gray-500 mt-1">You've accessed the admin panel</p>
                        <p class="text-xs text-gray-400 mt-1">A moment ago</p>
                    </div>
                </div>

                <!-- M-Pesa Activity -->
                @if(isset($totalTransactions) && $totalTransactions > 0)
                <div class="flex items-start">
                    <div class="flex-shrink-0 mt-1">
                        <div class="w-8 h-8 rounded-full bg-green-50 flex items-center justify-center">
                            <i class="fas fa-mobile-alt text-green-600 text-sm"></i>
                        </div>
                    </div>
                    <div class="ml-3">
                        <p class="text-sm text-gray-900">M-Pesa Transactions</p>
                        <p class="text-xs text-gray-500 mt-1">{{ $totalTransactions }} total transactions</p>
                        <p class="text-xs text-gray-400 mt-1">Active</p>
                    </div>
                </div>
                @else
                <div class="flex items-start">
                    <div class="flex-shrink-0 mt-1">
                        <div class="w-8 h-8 rounded-full bg-yellow-50 flex items-center justify-center">
                            <i class="fas fa-lightbulb text-yellow-600 text-sm"></i>
                        </div>
                    </div>
                    <div class="ml-3">
                        <p class="text-sm text-gray-900">M-Pesa Ready</p>
                        <p class="text-xs text-gray-500 mt-1">Payment system is configured</p>
                        <p class="text-xs text-gray-400 mt-1">Tip</p>
                    </div>
                </div>
                @endif
            </div>

            <div class="mt-6 pt-6 border-t border-gray-100">
                <a href="{{ route('admin.transactions.index') }}" class="text-sm font-medium text-[#0A9961] hover:text-[#088551] flex items-center">
                    View all activity
                    <i class="fas fa-arrow-right ml-2 text-xs"></i>
                </a>
            </div>
        </div>
    </div>
</div>

<!-- Recent M-Pesa Transactions -->
<div class="mt-8">
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
        <div class="flex items-center justify-between mb-6">
            <div>
                <h2 class="text-lg font-semibold text-gray-900">Recent M-Pesa Transactions</h2>
                <p class="text-sm text-gray-600 mt-1">Latest payment transactions</p>
            </div>
            <a href="{{ route('admin.transactions.index') }}" 
               class="text-sm font-medium text-[#0A9961] hover:text-[#088551] flex items-center">
                View all
                <i class="fas fa-arrow-right ml-2 text-xs"></i>
            </a>
        </div>

        @if(isset($recentTransactions) && $recentTransactions->count() > 0)
        <div class="overflow-x-auto rounded-lg border border-gray-200">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Transaction ID</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Phone</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Amount</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Time</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Order</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @foreach($recentTransactions as $transaction)
                    <tr class="hover:bg-gray-50 transition-colors duration-150">
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="text-sm font-mono text-gray-900">
                                @if($transaction->transaction_id)
                                    {{ substr($transaction->transaction_id, 0, 10) }}...
                                @else
                                    <span class="text-gray-400">Pending</span>
                                @endif
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="text-sm text-gray-900">
                                <i class="fas fa-phone text-gray-400 mr-1 text-xs"></i>
                                {{ $transaction->phone_number }}
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="text-sm font-bold text-gray-900">Ksh {{ number_format($transaction->amount, 2) }}</div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            @php
                                $statusColors = [
                                    'success' => 'bg-green-100 text-green-800',
                                    'pending' => 'bg-yellow-100 text-yellow-800',
                                    'failed' => 'bg-red-100 text-red-800'
                                ];
                                $color = $statusColors[$transaction->status] ?? 'bg-gray-100 text-gray-800';
                            @endphp
                            <span class="px-2 py-1 inline-flex text-xs leading-4 font-semibold rounded-full {{ $color }}">
                                {{ ucfirst($transaction->status) }}
                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="text-sm text-gray-900">{{ $transaction->created_at->format('h:i A') }}</div>
                            <div class="text-xs text-gray-500">{{ $transaction->created_at->format('M d') }}</div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            @if($transaction->order)
                            <a href="{{ route('admin.orders.show', $transaction->order) }}" 
                               class="text-sm text-[#0A9961] hover:text-[#088551] hover:underline">
                                {{ $transaction->order->order_number }}
                            </a>
                            @else
                            <span class="text-sm text-gray-400">No order</span>
                            @endif
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        @else
        <div class="text-center py-12">
            <div class="text-gray-400">
                <i class="fas fa-money-bill-wave text-4xl mb-3"></i>
                <p class="text-lg font-medium text-gray-500">No transactions yet</p>
                <p class="text-gray-400 mt-1">M-Pesa transactions will appear here</p>
            </div>
        </div>
        @endif
    </div>
</div>

<!-- Getting Started Guide -->
<div class="mt-8 bg-gradient-to-r from-gray-50 to-white border border-gray-200 rounded-xl p-6">
    <div class="flex items-center justify-between mb-6">
        <div>
            <h2 class="text-lg font-semibold text-gray-900">Getting Started Guide</h2>
            <p class="text-sm text-gray-600 mt-1">Follow these steps to set up your store</p>
        </div>
        <span class="px-3 py-1 bg-[#0A9961] text-white text-xs font-medium rounded-full">5 steps</span>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-5 gap-4">
        <div class="border border-gray-200 rounded-lg p-4">
            <div class="w-10 h-10 rounded-lg bg-[#0A9961] flex items-center justify-center mb-3">
                <span class="text-white font-bold">1</span>
            </div>
            <h3 class="text-sm font-medium text-gray-900">Add Products</h3>
            <p class="text-xs text-gray-500 mt-1">Start by adding your first product</p>
            <a href="{{ route('admin.products.create') }}" class="text-xs text-[#0A9961] font-medium mt-2 inline-block">Get Started →</a>
        </div>

        <div class="border border-gray-200 rounded-lg p-4">
            <div class="w-10 h-10 rounded-lg bg-green-50 flex items-center justify-center mb-3">
                <span class="text-green-600 font-bold">2</span>
            </div>
            <h3 class="text-sm font-medium text-gray-900">M-Pesa Setup</h3>
            <p class="text-xs text-gray-500 mt-1">Payment system is already configured</p>
            <a href="{{ route('admin.transactions.index') }}" class="text-xs text-[#0A9961] font-medium mt-2 inline-block">View Transactions →</a>
        </div>

        <div class="border border-gray-200 rounded-lg p-4">
            <div class="w-10 h-10 rounded-lg bg-gray-200 flex items-center justify-center mb-3">
                <span class="text-gray-600 font-bold">3</span>
            </div>
            <h3 class="text-sm font-medium text-gray-900">Setup Payment</h3>
            <p class="text-xs text-gray-500 mt-1">Configure payment methods</p>
            <span class="text-xs text-gray-400 font-medium mt-2 inline-block">Configured</span>
        </div>

        <div class="border border-gray-200 rounded-lg p-4">
            <div class="w-10 h-10 rounded-lg bg-gray-200 flex items-center justify-center mb-3">
                <span class="text-gray-600 font-bold">4</span>
            </div>
            <h3 class="text-sm font-medium text-gray-900">Customize Store</h3>
            <p class="text-xs text-gray-500 mt-1">Set your store name and logo</p>
            <span class="text-xs text-gray-400 font-medium mt-2 inline-block">Coming soon</span>
        </div>

        <div class="border border-gray-200 rounded-lg p-4">
            <div class="w-10 h-10 rounded-lg bg-gray-200 flex items-center justify-center mb-3">
                <span class="text-gray-600 font-bold">5</span>
            </div>
            <h3 class="text-sm font-medium text-gray-900">Go Live</h3>
            <p class="text-xs text-gray-500 mt-1">Launch your store to customers</p>
            <span class="text-xs text-gray-400 font-medium mt-2 inline-block">Coming soon</span>
        </div>
    </div>
</div>
@endsection