@extends('layouts.admin-layout')

@section('content')
<div class="max-w-4xl mx-auto">
    <!-- Header -->
    <div class="mb-6">
        <h1 class="text-2xl font-bold text-gray-900">Create New Category</h1>
        <p class="text-gray-600 mt-2">Add a new category to organize your products</p>
    </div>

    <!-- Form Card -->
    <div class="bg-white rounded-xl shadow-lg overflow-hidden border border-gray-100">
      
      <!-- Card Header -->
      <div class="px-6 py-4 bg-gradient-to-r from-[#0A9961] to-[#10B981]">
        <div class="flex items-center">
          <div class="p-3 rounded-lg bg-white/20 backdrop-blur-sm mr-4">
            <i class="fas fa-folder-plus text-white text-xl"></i>
          </div>
          <div>
            <h2 class="text-lg font-semibold text-white">Category Information</h2>
            <p class="text-green-100 text-sm">Enter category details</p>
          </div>
        </div>
      </div>
      
      <!-- Form Content -->
      <div class="p-6">
        @if($errors->any())
        <div class="mb-6 p-4 bg-red-50 border-l-4 border-red-500 rounded-r-lg shadow-sm">
          <div class="flex items-center">
            <i class="fas fa-exclamation-triangle text-red-500 mr-3"></i>
            <div class="flex-1">
              <p class="font-medium text-red-800">Please fix the following errors:</p>
              <ul class="mt-1 text-sm text-red-700 list-disc list-inside">
                @foreach($errors->all() as $error)
                  <li>{{ $error }}</li>
                @endforeach
              </ul>
            </div>
          </div>
        </div>
        @endif

        <form method="POST" action="{{ route('admin.categories.store') }}" enctype="multipart/form-data">
          @csrf

          <!-- Category Name -->
          <div class="mb-6">
            <label for="name" class="block text-sm font-medium text-gray-700 mb-2">
              Category Name *
            </label>
            <div class="relative">
              <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                <i class="fas fa-tag text-gray-400"></i>
              </div>
              <input type="text" id="name" name="name" value="{{ old('name') }}" required
                     class="w-full pl-10 pr-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[#0A9961] focus:border-transparent transition duration-200"
                     placeholder="Enter category name">
            </div>
          </div>

          <!-- Slug -->
          <div class="mb-6">
            <label for="slug" class="block text-sm font-medium text-gray-700 mb-2">
              URL Slug *
            </label>
            <div class="relative">
              <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                <i class="fas fa-link text-gray-400"></i>
              </div>
              <input type="text" id="slug" name="slug" value="{{ old('slug') }}" required
                     class="w-full pl-10 pr-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[#0A9961] focus:border-transparent transition duration-200"
                     placeholder="category-url-slug">
            </div>
            <p class="mt-1 text-xs text-gray-500">Used in category URLs. Auto-generated from name.</p>
          </div>

          <!-- Parent Category -->
          <div class="mb-6">
            <label for="parent_id" class="block text-sm font-medium text-gray-700 mb-2">
              Parent Category
            </label>
            <select id="parent_id" name="parent_id"
                    class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[#0A9961] focus:border-transparent transition duration-200">
              <option value="">Select Parent Category (Optional)</option>
              @foreach($parentCategories as $parent)
                <option value="{{ $parent->id }}" {{ old('parent_id') == $parent->id ? 'selected' : '' }}>
                  {{ $parent->name }}
                </option>
              @endforeach
            </select>
          </div>

          <!-- Description -->
          <div class="mb-6">
            <label for="description" class="block text-sm font-medium text-gray-700 mb-2">
              Description
            </label>
            <textarea id="description" name="description" rows="3"
                      class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-[#0A9961] focus:border-transparent transition duration-200"
                      placeholder="Enter category description">{{ old('description') }}</textarea>
          </div>

          <!-- Image Upload -->
          <div class="mb-6">
            <label for="image" class="block text-sm font-medium text-gray-700 mb-2">
              Category Image (Optional)
            </label>
            <div class="border-2 border-dashed border-gray-300 rounded-lg p-6 text-center hover:border-[#0A9961] transition-colors duration-200">
              <div class="space-y-2">
                <i class="fas fa-image text-3xl text-gray-400 mx-auto"></i>
                <div>
                  <label for="image" class="cursor-pointer inline-flex items-center px-4 py-2 bg-[#0A9961] hover:bg-[#088551] text-white font-medium rounded-lg transition duration-200">
                    <i class="fas fa-upload mr-2"></i>
                    Choose Image
                  </label>
                  <input type="file" id="image" name="image" class="hidden" accept="image/*">
                </div>
                <p class="text-xs text-gray-500">PNG, JPG, GIF up to 5MB. Recommended: 400x400px</p>
                <p id="fileName" class="text-sm text-gray-900 font-medium"></p>
              </div>
            </div>
          </div>

          <!-- Status -->
          <div class="mb-6">
            <label class="block text-sm font-medium text-gray-700 mb-2">
              Status
            </label>
            <div class="flex items-center space-x-4">
              <label class="inline-flex items-center">
                <input type="radio" name="is_active" value="1" checked 
                       class="h-4 w-4 text-[#0A9961] focus:ring-[#0A9961] border-gray-300">
                <span class="ml-2 text-sm text-gray-700">Active</span>
              </label>
              <label class="inline-flex items-center">
                <input type="radio" name="is_active" value="0" {{ old('is_active') == '0' ? 'checked' : '' }}
                       class="h-4 w-4 text-gray-600 focus:ring-gray-500 border-gray-300">
                <span class="ml-2 text-sm text-gray-700">Inactive</span>
              </label>
            </div>
          </div>

          <!-- SEO Fields -->
          <div class="mb-6 p-4 bg-gray-50 rounded-lg border border-gray-200">
            <h3 class="text-sm font-medium text-gray-900 mb-3">SEO Settings (Optional)</h3>
            
            <div class="space-y-4">
              <div>
                <label for="meta_title" class="block text-xs font-medium text-gray-700 mb-1">
                  Meta Title
                </label>
                <input type="text" id="meta_title" name="meta_title" value="{{ old('meta_title') }}"
                       class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm focus:outline-none focus:ring-1 focus:ring-[#0A9961] focus:border-transparent"
                       placeholder="Meta title for search engines">
              </div>
              
              <div>
                <label for="meta_description" class="block text-xs font-medium text-gray-700 mb-1">
                  Meta Description
                </label>
                <textarea id="meta_description" name="meta_description" rows="2"
                          class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm focus:outline-none focus:ring-1 focus:ring-[#0A9961] focus:border-transparent"
                          placeholder="Meta description for search engines">{{ old('meta_description') }}</textarea>
              </div>
              
              <div>
                <label for="meta_keywords" class="block text-xs font-medium text-gray-700 mb-1">
                  Meta Keywords
                </label>
                <input type="text" id="meta_keywords" name="meta_keywords" value="{{ old('meta_keywords') }}"
                       class="w-full px-3 py-2 border border-gray-300 rounded-lg text-sm focus:outline-none focus:ring-1 focus:ring-[#0A9961] focus:border-transparent"
                       placeholder="keyword1, keyword2, keyword3">
              </div>
            </div>
          </div>

          <!-- Form Actions -->
          <div class="flex items-center justify-between pt-6 border-t border-gray-200">
            <a href="{{ route('admin.categories.index') }}" 
               class="px-4 py-2 border border-gray-300 text-gray-700 rounded-lg hover:bg-gray-50 transition duration-200">
              Cancel
            </a>
            <div class="flex space-x-3">
              <button type="reset" 
                      class="px-4 py-2 border border-gray-300 text-gray-700 rounded-lg hover:bg-gray-50 transition duration-200">
                Reset
              </button>
              <button type="submit"
                      class="px-6 py-2 bg-[#0A9961] hover:bg-[#088551] text-white font-medium rounded-lg transition duration-200">
                Create Category
              </button>
            </div>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>

<script>
  // File name display
  document.getElementById('image').addEventListener('change', function(e) {
    const fileName = e.target.files[0]?.name || 'No file chosen';
    document.getElementById('fileName').textContent = fileName;
  });
  
  // Auto-generate slug from category name
  document.getElementById('name').addEventListener('input', function(e) {
    const slugInput = document.getElementById('slug');
    if (!slugInput.value || slugInput.value === '') {
      const slug = e.target.value
        .toLowerCase()
        .replace(/[^\w\s-]/g, '')
        .replace(/\s+/g, '-')
        .replace(/--+/g, '-');
      slugInput.value = slug;
    }
  });

  // Auto-fill meta title and description
  document.getElementById('name').addEventListener('blur', function(e) {
    const metaTitle = document.getElementById('meta_title');
    const metaDescription = document.getElementById('meta_description');
    
    if (!metaTitle.value) {
      metaTitle.value = e.target.value + ' | ' + '{{ config("app.name", "Our Store") }}';
    }
    
    if (!metaDescription.value && document.getElementById('description').value) {
      const description = document.getElementById('description').value;
      metaDescription.value = description.substring(0, 160);
    }
  });
</script>
@endsection