<?php
echo "<h3>Debugging M-Pesa Password</h3>";

require __DIR__.'/../vendor/autoload.php';
$app = require_once __DIR__.'/../bootstrap/app.php';
$app->make(Illuminate\Contracts\Console\Kernel::class)->bootstrap();

// Get credentials
$shortcode = config('services.mpesa.shortcode');
$passkey = config('services.mpesa.passkey');

echo "<p>Shortcode: $shortcode</p>";
echo "<p>Passkey length: " . strlen($passkey) . " characters</p>";
echo "<p>Passkey (first 20 chars): " . substr($passkey, 0, 20) . "...</p>";

// Generate timestamp
$timestamp = date('YmdHis');
echo "<p>Timestamp: $timestamp</p>";

// Generate password
$passwordString = $shortcode . $passkey . $timestamp;
$password = base64_encode($passwordString);

echo "<p>Password String: " . htmlspecialchars($shortcode) . " + passkey + " . $timestamp . "</p>";
echo "<p>Password (base64): $password</p>";

// Test with actual values from Daraja
echo "<hr><h4>Test with example from Daraja documentation:</h4>";

// Example from Safaricom docs
$testShortcode = '174379';
$testPasskey = 'bfb279f9aa9bdbcf158e97dd71a467cd2e0c893059b10f78e6b72ada1ed2c919';
$testTimestamp = '20191219102015'; // Example timestamp
$testPasswordString = $testShortcode . $testPasskey . $testTimestamp;
$testPassword = base64_encode($testPasswordString);

echo "<p>Test Shortcode: $testShortcode</p>";
echo "<p>Test Passkey: " . substr($testPasskey, 0, 20) . "...</p>";
echo "<p>Test Timestamp: $testTimestamp</p>";
echo "<p>Test Password: $testPassword</p>";

// Now test your actual
echo "<hr><h4>Your actual values:</h4>";
echo "<p>Your Password: $password</p>";

// Also check if passkey might have spaces
echo "<p>Passkey with trim: '" . trim($passkey) . "'</p>";
echo "<p>Passkey length after trim: " . strlen(trim($passkey)) . "</p>";