<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\SystemSetting;

class SystemSettingsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $settings = [
            // Site Information
            ['key' => 'site_name', 'value' => 'Finepoint Electronics', 'type' => 'string', 'description' => 'Website name'],
            ['key' => 'site_email', 'value' => 'admin@finepoint.com', 'type' => 'string', 'description' => 'Default admin email'],
            ['key' => 'site_phone', 'value' => '+254700 123 456', 'type' => 'string', 'description' => 'Contact phone number'],
            ['key' => 'site_address', 'value' => 'Nairobi, Kenya', 'type' => 'string', 'description' => 'Business address'],
            ['key' => 'currency', 'value' => 'KES', 'type' => 'string', 'description' => 'Default currency'],
            ['key' => 'timezone', 'value' => 'Africa/Nairobi', 'type' => 'string', 'description' => 'Default timezone'],
            
            // Payment Settings
            ['key' => 'mpesa_enabled', 'value' => '1', 'type' => 'boolean', 'description' => 'Enable M-Pesa payments'],
            ['key' => 'cash_on_delivery_enabled', 'value' => '1', 'type' => 'boolean', 'description' => 'Enable Cash on Delivery'],
            
            // Store Settings
            ['key' => 'store_status', 'value' => '1', 'type' => 'boolean', 'description' => 'Store online status (1=open, 0=closed)'],
            ['key' => 'min_order_amount', 'value' => '100', 'type' => 'integer', 'description' => 'Minimum order amount'],
            ['key' => 'free_shipping_threshold', 'value' => '1000', 'type' => 'integer', 'description' => 'Amount for free shipping'],
            ['key' => 'shipping_fee', 'value' => '200', 'type' => 'integer', 'description' => 'Default shipping fee'],
            ['key' => 'tax_rate', 'value' => '16', 'type' => 'integer', 'description' => 'Tax rate percentage'],
        ];

        foreach ($settings as $setting) {
            SystemSetting::updateOrCreate(
                ['key' => $setting['key']],
                $setting
            );
        }

        $this->command->info('System settings seeded successfully!');
    }
}