<?php

namespace App\Mail;

use App\Models\Order;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class OrderPlaced extends Mailable
{
    use Queueable, SerializesModels;

    public $order;
    public $paymentMethod;
    public $totalDiscount;
    public $isPaybill;

    public function __construct(Order $order, $paymentMethod = 'cod', $totalDiscount = 0)
    {
        $this->order = $order;
        $this->paymentMethod = $paymentMethod;
        $this->totalDiscount = $totalDiscount;
        $this->isPaybill = ($paymentMethod === 'paybill');
    }

    public function build()
    {
        $subject = '';
        
        switch ($this->paymentMethod) {
            case 'cod':
                $subject = 'Your COD Order #' . $this->order->order_number . ' Confirmation';
                break;
            case 'paybill':
                $subject = 'Order Received - Payment Verification Required #' . $this->order->order_number;
                break;
            default:
                $subject = 'Your Order #' . $this->order->order_number . ' Confirmation';
        }
            
        return $this->subject($subject)
                    ->view('emails.order-placed')
                    ->with([
                        'order' => $this->order,
                        'paymentMethod' => $this->paymentMethod,
                        'totalDiscount' => $this->totalDiscount,
                        'isPaybill' => $this->isPaybill,
                    ]);
    }
}