<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $fillable = [
        'name',
        'email',
        'password',
        'role',
    ];

    protected $hidden = [
        'password',
        'remember_token',
    ];

    protected $casts = [
        'email_verified_at' => 'datetime',
        'is_admin' => 'boolean',
        'is_customer' => 'boolean',
    ];

    /**
     * Get the is_admin virtual attribute.
     *
     * @return bool
     */
    public function getIsAdminAttribute()
    {
        return $this->role === 'admin';
    }

    /**
     * Get the is_customer virtual attribute.
     *
     * @return bool
     */
    public function getIsCustomerAttribute()
    {
        return $this->role === 'customer';
    }

    /**
     * Check if user is an admin (compatibility method)
     *
     * @return bool
     */
    public function isAdmin()
    {
        return $this->is_admin;
    }

    /**
     * Check if user is a customer (compatibility method)
     *
     * @return bool
     */
    public function isCustomer()
    {
        return $this->is_customer;
    }
}