<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\Cart;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class LoginController extends Controller
{
    use AuthenticatesUsers;

    protected $redirectTo = '/';

    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }
    
    // Override the authenticated method to merge cart
   protected function authenticated(Request $request, $user)
{
    // Merge guest cart with user cart
    if (session()->has('cart')) {
        $guestCart = session()->get('cart', []);
        
        foreach ($guestCart as $productId => $item) {
            // Check if product exists
            $cartItem = Cart::where('user_id', $user->id)
                ->where('product_id', $productId)
                ->first();
            
            if ($cartItem) {
                // Update existing item
                $cartItem->quantity += $item['quantity'];
                $cartItem->save();
            } else {
                // Create new item
                Cart::create([
                    'user_id' => $user->id,
                    'product_id' => $productId,
                    'quantity' => $item['quantity']
                ]);
            }
        }
        
        // Clear guest cart session
        session()->forget('cart');
        
        // Show notification
        $request->session()->flash('success', 'Your cart items have been saved to your account.');
    }
    
    // Redirect to stored URL or home
    $redirectUrl = session()->pull('redirect_url', route('home'));
    return redirect()->to($redirectUrl);
}
}