

<?php $__env->startSection('title', $product->name . ' - Finepoint Electronics'); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .quantity-btn:disabled { 
        opacity: 0.5; 
        cursor: not-allowed; 
    }
    
    .tab-active { 
        border-bottom-color: #0A9961; 
        color: #0A9961; 
    }
    
    /* Product card hover */
    .product-card:hover {
        transform: translateY(-4px);
        transition: transform 0.2s ease;
    }
    
    .line-clamp-2 {
        display: -webkit-box;
        -webkit-line-clamp: 2;
        -webkit-box-orient: vertical;
        overflow: hidden;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto px-4 py-8">
    <!-- Breadcrumb -->
    <nav class="flex mb-6" aria-label="Breadcrumb">
        <ol class="inline-flex items-center space-x-1 md:space-x-3">
            <li class="inline-flex items-center">
                <a href="<?php echo e(route('home')); ?>" class="inline-flex items-center text-sm text-gray-700 hover:text-[#0A9961] no-underline">
                    <i class="fas fa-home mr-2"></i>
                    Home
                </a>
            </li>
            <li>
                <div class="flex items-center">
                    <i class="fas fa-chevron-right text-gray-400 mx-2 text-xs"></i>
                    <a href="<?php echo e(route('products.public')); ?>" class="ml-1 text-sm text-gray-700 hover:text-[#0A9961] no-underline md:ml-2">
                        Products
                    </a>
                </div>
            </li>
            <?php if($product->category): ?>
            <li>
                <div class="flex items-center">
                    <i class="fas fa-chevron-right text-gray-400 mx-2 text-xs"></i>
                    <a href="<?php echo e(route('category.products', $product->category)); ?>" class="ml-1 text-sm text-gray-700 hover:text-[#0A9961] no-underline md:ml-2">
                        <?php echo e($product->category->name); ?>

                    </a>
                </div>
            </li>
            <?php endif; ?>
            <li aria-current="page">
                <div class="flex items-center">
                    <i class="fas fa-chevron-right text-gray-400 mx-2 text-xs"></i>
                    <span class="ml-1 text-sm text-gray-900 font-medium md:ml-2 truncate max-w-xs"><?php echo e($product->name); ?></span>
                </div>
            </li>
        </ol>
    </nav>

    <!-- Product Details -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
        <div class="md:flex">
            <!-- Product Image -->
            <div class="md:w-1/2 p-6 md:p-8">
                <div class="bg-gray-50 rounded-xl p-4 h-full flex items-center justify-center">
                    <?php if($product->image): ?>
                        <img src="<?php echo e($product->image_url); ?>" 
                             alt="<?php echo e($product->name); ?>"
                             class="w-full max-w-md mx-auto object-contain max-h-96">
                    <?php else: ?>
                        <div class="w-full h-64 flex items-center justify-center">
                            <div class="text-center">
                                <i class="fas fa-box text-gray-300 text-6xl mb-3"></i>
                                <p class="text-gray-400 text-sm">No image available</p>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Product Info -->
            <div class="md:w-1/2 p-6 md:p-8">
                <!-- Brand -->
                <?php if($product->brand): ?>
                <div class="mb-2">
                    <span class="text-sm text-gray-500"><?php echo e($product->brand); ?></span>
                </div>
                <?php endif; ?>

                <!-- Product Name -->
                <h1 class="text-2xl md:text-3xl font-bold text-gray-900 mb-3"><?php echo e($product->name); ?></h1>

                <!-- Price -->
                <div class="mb-4">
                    <span class="text-3xl font-bold text-[#0A9961]">
                        Ksh <?php echo e(number_format($product->price)); ?>

                    </span>
                </div>

                <!-- Stock Status -->
                <div class="mb-6">
                    <?php if($product->stock > 0): ?>
                        <div class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium 
                            <?php echo e($product->stock <= 10 ? 'bg-yellow-50 text-yellow-700' : 'bg-green-50 text-green-700'); ?>">
                            <i class="fas fa-<?php echo e($product->stock <= 10 ? 'exclamation-triangle' : 'check-circle'); ?> mr-2"></i>
                            <?php if($product->stock <= 10): ?>
                                Low Stock (<?php echo e($product->stock); ?> left)
                            <?php else: ?>
                                In Stock (<?php echo e($product->stock); ?> available)
                            <?php endif; ?>
                        </div>
                    <?php else: ?>
                        <div class="inline-flex items-center px-3 py-1 rounded-full bg-red-50 text-red-700 text-sm font-medium">
                            <i class="fas fa-times-circle mr-2"></i>
                            Out of Stock
                        </div>
                    <?php endif; ?>
                </div>

               <!-- SKU - Admin Only -->
                <?php if(auth()->guard()->check()): ?>
                    <?php if(auth()->user()->isAdmin() && $product->sku): ?>
                    <div class="mb-4 p-3 bg-gray-50 rounded-lg border-l-4 border-[#0A9961]">
                        <p class="text-sm text-gray-600">
                            <i class="fas fa-key mr-2 text-[#0A9961]"></i>
                            SKU: <span class="font-medium text-gray-900"><?php echo e($product->sku); ?></span>
                            <span class="text-xs text-gray-500 ml-2">(Admin Only)</span>
                        </p>
                    </div>
                    <?php endif; ?>
                <?php endif; ?>

                <!-- Add to Cart Section -->
                <div class="mb-6">
                    <?php if($product->stock > 0): ?>
                    <div class="space-y-4">
                        <!-- Quantity -->
                        <div class="flex items-center space-x-4">
                            <label class="text-sm font-medium text-gray-700">Quantity:</label>
                            <div class="flex items-center border border-gray-300 rounded-lg">
                                <button type="button" 
                                        onclick="updateQuantity(-1)"
                                        class="quantity-btn px-3 py-2 text-gray-600 hover:text-gray-900 hover:bg-gray-50 rounded-l-lg">
                                    <i class="fas fa-minus"></i>
                                </button>
                                <input type="number" 
                                       id="quantity" 
                                       value="1" 
                                       min="1" 
                                       max="<?php echo e($product->stock); ?>"
                                       class="w-16 text-center border-x border-gray-300 py-2 focus:outline-none focus:ring-1 focus:ring-[#0A9961]"
                                       onchange="validateQuantity()">
                                <button type="button" 
                                        onclick="updateQuantity(1)"
                                        class="quantity-btn px-3 py-2 text-gray-600 hover:text-gray-900 hover:bg-gray-50 rounded-r-lg">
                                    <i class="fas fa-plus"></i>
                                </button>
                            </div>
                        </div>
                        
                        <!-- Add to Cart Button -->
                        <button onclick="addToCartProductPage()" 
                                class="w-full bg-[#0A9961] hover:bg-[#088552] text-white font-medium py-3 px-6 rounded-lg transition duration-200 flex items-center justify-center">
                            <i class="fas fa-cart-plus mr-2"></i>
                            Add to Cart
                        </button>
                    </div>
                    <?php else: ?>
                    <button disabled class="w-full bg-gray-300 text-gray-500 font-medium py-3 px-6 rounded-lg cursor-not-allowed">
                        <i class="fas fa-ban mr-2"></i>
                        Out of Stock
                    </button>
                    <?php endif; ?>
                </div>

                <!-- Category -->
                <?php if($product->category): ?>
                <div class="mb-4 p-3 bg-gray-50 rounded-lg">
                    <p class="text-sm text-gray-600">
                        <i class="fas fa-folder mr-2"></i>
                        Category: 
                        <a href="<?php echo e(route('category.products', $product->category)); ?>" 
                           class="text-[#0A9961] hover:text-[#088551] font-medium no-underline">
                            <?php echo e($product->category->name); ?>

                        </a>
                    </p>
                </div>
                <?php endif; ?>

                <!-- Share Product -->
                <div class="mt-6 pt-6 border-t border-gray-200">
                    <p class="text-sm text-gray-600 mb-2">Share this product:</p>
                    <div class="flex space-x-2">
                        <a href="#" class="p-2 text-gray-500 hover:text-blue-600">
                            <i class="fab fa-facebook text-lg"></i>
                        </a>
                        <a href="#" class="p-2 text-gray-500 hover:text-blue-400">
                            <i class="fab fa-twitter text-lg"></i>
                        </a>
                        <a href="#" class="p-2 text-gray-500 hover:text-pink-600">
                            <i class="fab fa-instagram text-lg"></i>
                        </a>
                        <a href="#" class="p-2 text-gray-500 hover:text-blue-800">
                            <i class="fab fa-linkedin text-lg"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Description & Details Tabs -->
        <div class="border-t border-gray-200">
            <div class="p-6 md:p-8">
                <nav class="flex border-b border-gray-200 mb-6">
                    <button id="description-tab" 
                            class="py-3 px-6 text-sm font-medium text-gray-900 border-b-2 border-[#0A9961] tab-active">
                        <i class="fas fa-info-circle mr-2"></i>
                        Description
                    </button>
                    <button id="specs-tab" 
                            class="py-3 px-6 text-sm font-medium text-gray-600 hover:text-gray-900">
                        <i class="fas fa-list-alt mr-2"></i>
                        Specifications
                    </button>
                </nav>
                
                <!-- Description Content -->
                <div id="description-content" class="tab-content">
                    <?php if($product->description): ?>
                        <div class="prose max-w-none">
                            <p class="text-gray-700 whitespace-pre-line"><?php echo e($product->description); ?></p>
                        </div>
                    <?php else: ?>
                        <div class="text-center py-8">
                            <i class="fas fa-file-alt text-4xl text-gray-300 mb-3"></i>
                            <p class="text-gray-500">No description available for this product.</p>
                        </div>
                    <?php endif; ?>
                </div>

                <!-- Specifications Content -->
                <div id="specs-content" class="tab-content hidden">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div class="bg-gray-50 rounded-lg p-4">
                            <div class="flex justify-between items-center mb-2">
                                <span class="text-gray-600">Brand</span>
                                <span class="font-medium text-gray-900"><?php echo e($product->brand ?? 'N/A'); ?></span>
                            </div>
                        </div>
                        <?php if(auth()->guard()->check()): ?>
                            <?php if(auth()->user()->isAdmin()): ?>
                            <div class="bg-gray-50 rounded-lg p-4 border-l-4 border-[#0A9961]">
                                <div class="flex justify-between items-center mb-2">
                                    <span class="text-gray-600">
                                        <i class="fas fa-key mr-2 text-[#0A9961]"></i>
                                        SKU
                                    </span>
                                    <span class="font-medium text-gray-900"><?php echo e($product->sku ?? 'N/A'); ?></span>
                                </div>
                            </div>
                            <?php endif; ?>
                        <?php endif; ?>
                        <div class="bg-gray-50 rounded-lg p-4">
                            <div class="flex justify-between items-center mb-2">
                                <span class="text-gray-600">Availability</span>
                                <span class="font-medium <?php echo e($product->stock > 0 ? 'text-green-600' : 'text-red-600'); ?>">
                                    <?php echo e($product->stock > 0 ? 'In Stock' : 'Out of Stock'); ?>

                                </span>
                            </div>
                        </div>
                        <div class="bg-gray-50 rounded-lg p-4">
                            <div class="flex justify-between items-center mb-2">
                                <span class="text-gray-600">Stock Quantity</span>
                                <span class="font-medium text-gray-900"><?php echo e($product->stock); ?></span>
                            </div>
                        </div>
                    </div>
                    
                    <?php if($product->category): ?>
                    <div class="mt-6 bg-gray-50 rounded-lg p-4">
                        <div class="flex justify-between items-center mb-2">
                            <span class="text-gray-600">Category</span>
                            <a href="<?php echo e(route('category.products', $product->category)); ?>" 
                               class="font-medium text-[#0A9961] hover:text-[#088551] no-underline">
                                <?php echo e($product->category->name); ?>

                            </a>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Back to Products Link -->
    <div class="mt-6 flex justify-between items-center">
        <a href="<?php echo e(route('products.public')); ?>" class="inline-flex items-center text-[#0A9961] hover:text-[#088551] no-underline">
            <i class="fas fa-arrow-left mr-2"></i>
            Back to Products
        </a>
        
        <!-- Related Categories -->
        <?php if($product->category && $product->category->products_count > 1): ?>
        <a href="<?php echo e(route('category.products', $product->category)); ?>" 
           class="inline-flex items-center text-gray-700 hover:text-[#0A9961] no-underline">
            <i class="fas fa-eye mr-2"></i>
            View more in <?php echo e($product->category->name); ?>

        </a>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    // Function to show notifications
    function showNotification(message, type = 'success') {
        const notification = document.createElement('div');
        const bgColor = type === 'success' ? 'bg-green-500' : 'bg-red-500';
        const icon = type === 'success' ? 'fa-check-circle' : 'fa-exclamation-circle';
        
        notification.className = `${bgColor} text-white px-4 py-3 rounded-lg shadow-lg z-50 fixed top-4 right-4 transition-all duration-300 transform translate-x-full`;
        notification.innerHTML = `
            <div class="flex items-center">
                <i class="fas ${icon} mr-3"></i>
                <span>${message}</span>
                <button onclick="this.parentElement.parentElement.remove()" class="ml-4 text-white hover:text-gray-200">
                    <i class="fas fa-times"></i>
                </button>
            </div>
        `;
        
        document.body.appendChild(notification);
        
        setTimeout(() => {
            notification.classList.remove('translate-x-full');
            notification.classList.add('translate-x-0');
        }, 10);
        
        setTimeout(() => {
            notification.classList.remove('translate-x-0');
            notification.classList.add('translate-x-full');
            setTimeout(() => {
                if (notification.parentNode) {
                    notification.parentNode.removeChild(notification);
                }
            }, 300);
        }, 4000);
    }
    
    // Product page specific add to cart function
    function addToCartProductPage() {
        const quantity = parseInt(document.getElementById('quantity').value);
        const productId = <?php echo e($product->id); ?>;
        const productName = '<?php echo e(addslashes($product->name)); ?>';
        const stock = <?php echo e($product->stock); ?>;
        
        // Check if product is in stock
        if (stock <= 0) {
            showNotification('This product is out of stock', 'error');
            return;
        }
        
        if (quantity > stock) {
            showNotification(`Only ${stock} items available`, 'error');
            return;
        }
        
        // Show loading state on the button
        const button = document.querySelector('button[onclick="addToCartProductPage()"]');
        const originalHTML = button.innerHTML;
        button.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i> Adding...';
        button.disabled = true;
        
        // Get CSRF token from meta tag
        const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
        
        // Prepare data for the request
        const data = {
            product_id: productId,
            quantity: quantity,
            _token: csrfToken
        };
        
        // Make actual API call
        fetch('<?php echo e(route("cart.add")); ?>', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'Accept': 'application/json',
                'X-CSRF-TOKEN': csrfToken
            },
            body: JSON.stringify(data)
        })
        .then(response => response.json())
        .then(responseData => {
            if (responseData.success) {
                showNotification('✓ Added ' + quantity + ' ' + productName + ' to cart');
                // Update cart count in navbar
                updateCartCount(responseData.cart_count);
            } else {
                showNotification(responseData.message || 'Failed to add to cart', 'error');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            showNotification('An error occurred. Please try again.', 'error');
        })
        .finally(() => {
            // Restore button state
            button.innerHTML = originalHTML;
            button.disabled = false;
        });
    }
    
    // Function to update cart count
    function updateCartCount(count = null) {
        if (count !== null) {
            // If count is provided, update directly
            setCartCount(count);
        } else {
            // Fetch current cart count from server
            fetch('<?php echo e(route("cart.count")); ?>')
                .then(response => response.json())
                .then(data => {
                    setCartCount(data.cart_count);
                })
                .catch(error => {
                    console.error('Error fetching cart count:', error);
                });
        }
    }
    
    // Helper function to set cart count in the UI
    function setCartCount(count) {
        const cartCountElement = document.getElementById('cart-count');
        if (cartCountElement) {
            cartCountElement.textContent = count;
        }
    }

    // Quantity functions
    function updateQuantity(change) {
        const input = document.getElementById('quantity');
        let value = parseInt(input.value) + change;
        const max = parseInt(input.max);
        const min = parseInt(input.min);
        
        if (value < min) value = min;
        if (value > max) value = max;
        
        input.value = value;
        updateQuantityButtons();
    }

    function validateQuantity() {
        const input = document.getElementById('quantity');
        let value = parseInt(input.value);
        const max = parseInt(input.max);
        const min = parseInt(input.min);
        
        if (isNaN(value) || value < min) value = min;
        if (value > max) value = max;
        
        input.value = value;
        updateQuantityButtons();
    }

    function updateQuantityButtons() {
        const value = parseInt(document.getElementById('quantity').value);
        const max = parseInt(document.getElementById('quantity').max);
        const min = parseInt(document.getElementById('quantity').min);
        
        // Disable minus button if at min
        const minusBtn = document.querySelector('.quantity-btn:first-child');
        const plusBtn = document.querySelector('.quantity-btn:last-child');
        
        if (minusBtn) minusBtn.disabled = value <= min;
        if (plusBtn) plusBtn.disabled = value >= max;
    }

    // Tab switching
    document.getElementById('description-tab').addEventListener('click', function() {
        document.getElementById('description-content').classList.remove('hidden');
        document.getElementById('specs-content').classList.add('hidden');
        this.classList.add('tab-active');
        this.classList.remove('text-gray-600');
        this.classList.add('text-gray-900');
        
        document.getElementById('specs-tab').classList.remove('tab-active');
        document.getElementById('specs-tab').classList.remove('text-gray-900');
        document.getElementById('specs-tab').classList.add('text-gray-600');
    });

    document.getElementById('specs-tab').addEventListener('click', function() {
        document.getElementById('specs-content').classList.remove('hidden');
        document.getElementById('description-content').classList.add('hidden');
        this.classList.add('tab-active');
        this.classList.remove('text-gray-600');
        this.classList.add('text-gray-900');
        
        document.getElementById('description-tab').classList.remove('tab-active');
        document.getElementById('description-tab').classList.remove('text-gray-900');
        document.getElementById('description-tab').classList.add('text-gray-600');
    });

    // Initialize quantity buttons and cart count
    document.addEventListener('DOMContentLoaded', function() {
        updateQuantityButtons();
        updateCartCount();
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\finepoint\resources\views/public/products/show.blade.php ENDPATH**/ ?>