<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Paybill Payment Verification Required</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
            background-color: #f9f9f9;
        }
        .container {
            background-color: #ffffff;
            border-radius: 8px;
            padding: 30px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            border: 1px solid #e0e0e0;
        }
        .header {
            background-color: #f8f9fa;
            padding: 20px;
            border-radius: 8px 8px 0 0;
            margin: -30px -30px 30px -30px;
            border-bottom: 1px solid #e0e0e0;
        }
        .logo {
            font-size: 24px;
            font-weight: bold;
            color: #0A9961;
            margin-bottom: 10px;
        }
        .title {
            color: #333;
            font-size: 20px;
            margin: 0 0 15px 0;
            padding-bottom: 10px;
            border-bottom: 2px solid #0A9961;
        }
        .alert-box {
            background-color: #fff3cd;
            border: 1px solid #ffeaa7;
            border-radius: 5px;
            padding: 15px;
            margin: 20px 0;
        }
        .order-details {
            background-color: #f8f9fa;
            border-radius: 5px;
            padding: 20px;
            margin: 20px 0;
        }
        .payment-details {
            background-color: #e8f5e9;
            border: 1px solid #c8e6c9;
            border-radius: 5px;
            padding: 15px;
            margin: 20px 0;
        }
        .verification-section {
            background-color: #e3f2fd;
            border: 1px solid #bbdefb;
            border-radius: 5px;
            padding: 20px;
            margin: 25px 0;
            text-align: center;
        }
        .btn {
            display: inline-block;
            padding: 12px 24px;
            background-color: #0A9961;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            font-weight: bold;
            margin: 10px 5px;
            transition: background-color 0.3s;
        }
        .btn:hover {
            background-color: #088552;
        }
        .btn-verify {
            background-color: #28a745;
        }
        .btn-verify:hover {
            background-color: #218838;
        }
        .btn-reject {
            background-color: #dc3545;
        }
        .btn-reject:hover {
            background-color: #c82333;
        }
        .footer {
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #e0e0e0;
            color: #666;
            font-size: 12px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 10px 0;
        }
        table th {
            background-color: #f1f1f1;
            padding: 10px;
            text-align: left;
            border: 1px solid #ddd;
        }
        table td {
            padding: 10px;
            border: 1px solid #ddd;
        }
        .highlight {
            background-color: #fffde7;
            padding: 3px 6px;
            border-radius: 3px;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <div class="logo"><?php echo e(config('app.name', 'ElectroShop')); ?></div>
            <h1 class="title">⚠️ Paybill Payment Verification Required</h1>
        </div>

        <div class="alert-box">
            <strong>Action Required:</strong> A customer has placed an order using Direct Paybill. 
            Please verify their payment before processing the order.
        </div>

        <div class="order-details">
            <h3>📋 Order Details</h3>
            <p><strong>Order Number:</strong> #<?php echo e($order->order_number); ?></p>
            <p><strong>Customer:</strong> <?php echo e($order->customer_name); ?></p>
            <p><strong>Email:</strong> <?php echo e($order->customer_email); ?></p>
            <p><strong>Phone:</strong> <?php echo e($order->customer_phone); ?></p>
            <p><strong>Order Date:</strong> <?php echo e($order->created_at->format('F d, Y h:i A')); ?></p>
            <p><strong>Total Amount:</strong> <span class="highlight">Ksh <?php echo e(number_format($order->total, 2)); ?></span></p>
            
            <?php if($totalDiscount > 0): ?>
            <p><strong>Deal Savings:</strong> <span style="color: #28a745;">Ksh <?php echo e(number_format($totalDiscount, 2)); ?></span></p>
            <?php endif; ?>
        </div>

        <div class="payment-details">
            <h3>💳 Payment Instructions Given to Customer</h3>
            <p><strong>Paybill Number:</strong> <span class="highlight"><?php echo e($paybillDetails['paybill_number'] ?? 'Not Set'); ?></span></p>
            <p><strong>Account Number:</strong> <span class="highlight"><?php echo e($paybillDetails['account_number'] ?? 'Not Set'); ?></span></p>
            <?php if(!empty($paybillDetails['instructions'])): ?>
            <p><strong>Additional Instructions:</strong> <?php echo e($paybillDetails['instructions']); ?></p>
            <?php endif; ?>
        </div>

        <h3>📦 Order Items</h3>
        <table>
            <thead>
                <tr>
                    <th>Product</th>
                    <th>Qty</th>
                    <th>Price</th>
                    <th>Total</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $order->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($item->product_name); ?></td>
                    <td><?php echo e($item->quantity); ?></td>
                    <td>Ksh <?php echo e(number_format($item->price, 2)); ?></td>
                    <td>Ksh <?php echo e(number_format($item->total, 2)); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
            <tfoot>
                <tr>
                    <td colspan="3" style="text-align: right;"><strong>Total:</strong></td>
                    <td><strong>Ksh <?php echo e(number_format($order->total, 2)); ?></strong></td>
                </tr>
            </tfoot>
        </table>

        <div class="verification-section">
            <h3>🔍 Payment Verification</h3>
            <p>Please verify that the customer has paid <strong>Ksh <?php echo e(number_format($order->total, 2)); ?></strong> 
               to Paybill <strong><?php echo e($paybillDetails['paybill_number'] ?? 'N/A'); ?></strong> 
               Account <strong><?php echo e($paybillDetails['account_number'] ?? 'N/A'); ?></strong></p>
            
            <p>
                <a href="<?php echo e($verificationUrl); ?>" class="btn btn-verify">View Order Details</a>
            </p>
            
            <p><small>Once verified, please update the order status to "paid" in the admin panel.</small></p>
        </div>

        <h3>🚚 Shipping Information</h3>
        <?php
            $shippingAddress = is_array($order->shipping_address) ? $order->shipping_address : json_decode($order->shipping_address, true);
        ?>
        <?php if(is_array($shippingAddress)): ?>
        <p><?php echo e($shippingAddress['address'] ?? ''); ?></p>
        <p><?php echo e($shippingAddress['city'] ?? ''); ?>, <?php echo e($shippingAddress['state'] ?? ''); ?> <?php echo e($shippingAddress['zip'] ?? ''); ?></p>
        <p><?php echo e($shippingAddress['country'] ?? ''); ?></p>
        <p>📞 <?php echo e($shippingAddress['phone'] ?? $order->customer_phone); ?></p>
        <?php endif; ?>

        <?php if($order->notes): ?>
        <h3>📝 Order Notes</h3>
        <p><?php echo e($order->notes); ?></p>
        <?php endif; ?>

        <div class="footer">
            <p>This is an automated notification from <?php echo e(config('app.name', 'ElectroShop')); ?>.</p>
            <p>Please verify the payment within 24 hours to ensure timely order processing.</p>
            <p>© <?php echo e(date('Y')); ?> <?php echo e(config('app.name', 'ElectroShop')); ?>. All rights reserved.</p>
        </div>
    </div>
</body>
</html><?php /**PATH C:\wamp64\www\finepoint\resources\views/emails/paybill-verification.blade.php ENDPATH**/ ?>