<!DOCTYPE html>
<html>
<head>
    <title>New Order Notification</title>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
        .container { max-width: 600px; margin: 0 auto; padding: 20px; }
        .header { background: #dc3545; color: white; padding: 20px; text-align: center; }
        .content { padding: 20px; background: #f9f9f9; }
        .order-details { background: white; padding: 15px; border-radius: 5px; margin: 15px 0; }
        .highlight { color: #dc3545; font-weight: bold; }
        .btn { display: inline-block; padding: 10px 20px; background: #0A9961; color: white; text-decoration: none; border-radius: 5px; }
        .deal-info { background: #d4edda; border: 1px solid #c3e6cb; padding: 10px; border-radius: 5px; margin: 10px 0; }
        .items-table { width: 100%; border-collapse: collapse; margin: 15px 0; }
        .items-table th, .items-table td { padding: 8px; text-align: left; border-bottom: 1px solid #ddd; }
        .deal-badge { background: #ffc107; color: #856404; padding: 2px 6px; border-radius: 3px; font-size: 11px; font-weight: bold; }
        .original-price { text-decoration: line-through; color: #999; font-size: 0.9em; }
        .savings { color: #28a745; font-weight: bold; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>New Order Received!</h1>
        </div>
        
        <div class="content">
            <p>Hello Admin,</p>
            
            <p>A new order has been placed on the website. Here are the order details:</p>
            
            <?php if($totalDiscount > 0): ?>
            <div class="deal-info">
                <p><strong>🎯 Deal Applied:</strong> Customer saved <span class="savings">Ksh <?php echo e(number_format($totalDiscount, 2)); ?></span> with special offers!</p>
            </div>
            <?php endif; ?>
            
            <div class="order-details">
                <h3>Order Information</h3>
                <p><strong>Order Number:</strong> <span class="highlight"><?php echo e($order->order_number); ?></span></p>
                <p><strong>Order Date:</strong> <?php echo e($order->created_at->format('F j, Y H:i')); ?></p>
                <p><strong>Customer:</strong> <?php echo e($order->customer_name); ?></p>
                <p><strong>Email:</strong> <?php echo e($order->customer_email); ?></p>
                <p><strong>Phone:</strong> <?php echo e($order->customer_phone); ?></p>
                <p><strong>Payment Method:</strong> <?php echo e($paymentMethod === 'cod' ? 'Cash on Delivery' : 'M-Pesa'); ?></p>
                <p><strong>Total Amount:</strong> Ksh <?php echo e(number_format($order->total, 2)); ?></p>
                
                <?php if($paymentMethod === 'cod'): ?>
                <p><strong style="color: #dc3545;">ACTION REQUIRED:</strong> Contact customer to confirm shipping costs.</p>
                <?php endif; ?>
            </div>
            
            <div class="order-details">
                <h3>Order Items</h3>
                <table class="items-table">
                    <thead>
                        <tr>
                            <th>Product</th>
                            <th>Qty</th>
                            <th>Price</th>
                            <th>Total</th>
                            <th>Deal</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $order->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $hasDeal = !empty($item->deal_id);
                            $itemDiscount = $hasDeal && $item->original_price ? ($item->original_price - $item->price) * $item->quantity : 0;
                        ?>
                        <tr>
                            <td><?php echo e($item->product_name); ?></td>
                            <td><?php echo e($item->quantity); ?></td>
                            <td>
                                <?php if($hasDeal && $item->original_price): ?>
                                    <div>Ksh <?php echo e(number_format($item->price, 2)); ?></div>
                                    <div class="original-price">Ksh <?php echo e(number_format($item->original_price, 2)); ?></div>
                                <?php else: ?>
                                    Ksh <?php echo e(number_format($item->price, 2)); ?>

                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($itemDiscount > 0): ?>
                                    <div>Ksh <?php echo e(number_format($item->price * $item->quantity, 2)); ?></div>
                                    <div class="original-price">Ksh <?php echo e(number_format($item->original_price * $item->quantity, 2)); ?></div>
                                <?php else: ?>
                                    Ksh <?php echo e(number_format($item->price * $item->quantity, 2)); ?>

                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($hasDeal): ?>
                                    <span class="deal-badge">
                                        <?php if($item->deal_type == 'percentage'): ?>
                                            <?php echo e($item->deal_discount_value); ?>%
                                        <?php else: ?>
                                            Ksh <?php echo e(number_format($item->deal_discount_value)); ?>

                                        <?php endif; ?>
                                    </span>
                                <?php else: ?>
                                    -
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                    <tfoot>
                        <?php if($totalDiscount > 0): ?>
                        <tr>
                            <td colspan="3" style="text-align: right;"><strong>Original Subtotal:</strong></td>
                            <td><span class="original-price">Ksh <?php echo e(number_format($order->items->sum(function($item) { return ($item->original_price ?? $item->price) * $item->quantity; }), 2)); ?></span></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td colspan="3" style="text-align: right;"><strong>Discount:</strong></td>
                            <td class="savings">- Ksh <?php echo e(number_format($totalDiscount, 2)); ?></td>
                            <td></td>
                        </tr>
                        <?php endif; ?>
                        <tr>
                            <td colspan="3" style="text-align: right;"><strong>Subtotal:</strong></td>
                            <td>Ksh <?php echo e(number_format($order->subtotal, 2)); ?></td>
                            <td></td>
                        </tr>
                        <tr style="border-top: 2px solid #dc3545;">
                            <td colspan="3" style="text-align: right;"><strong>Order Total:</strong></td>
                            <td><strong>Ksh <?php echo e(number_format($order->total, 2)); ?></strong></td>
                            <td></td>
                        </tr>
                    </tfoot>
                </table>
            </div>
            
            <div class="order-details">
                <h3>Shipping Address</h3>
                <?php
                    $shipping = json_decode($order->shipping_address, true);
                ?>
                <p><strong>Name:</strong> <?php echo e($shipping['name'] ?? ''); ?></p>
                <p><strong>Address:</strong> <?php echo e($shipping['address'] ?? ''); ?></p>
                <p><strong>City:</strong> <?php echo e($shipping['city'] ?? ''); ?></p>
                <p><strong>State:</strong> <?php echo e($shipping['state'] ?? ''); ?></p>
                <p><strong>Zip:</strong> <?php echo e($shipping['zip'] ?? ''); ?></p>
                <p><strong>Country:</strong> <?php echo e($shipping['country'] ?? ''); ?></p>
                <p><strong>Phone:</strong> <?php echo e($shipping['phone'] ?? ''); ?></p>
                <p><strong>Email:</strong> <?php echo e($shipping['email'] ?? ''); ?></p>
                <?php if(!empty($shipping['notes'])): ?>
                <p><strong>Notes:</strong> <?php echo e($shipping['notes']); ?></p>
                <?php endif; ?>
            </div>
            
            <div style="text-align: center; margin: 20px 0;">
                <a href="<?php echo e(url('/admin/orders/' . $order->id)); ?>" class="btn">View Order in Admin Panel</a>
            </div>
            
            <p>Please process this order as soon as possible.</p>
        </div>
        
        <div style="text-align: center; padding: 20px; color: #666; font-size: 12px;">
            <p><?php echo e(config('app.name')); ?> - Admin Notification System</p>
            <p>This is an automated message.</p>
        </div>
    </div>
</body>
</html><?php /**PATH C:\wamp64\www\finepoint\resources\views/emails/new-order-notification.blade.php ENDPATH**/ ?>