@extends('layouts.app')

@section('content')
<div class="container mx-auto px-4 py-8">
    <div class="max-w-3xl mx-auto text-center">
        <!-- Success Icon -->
        <div class="mb-6">
            <div class="w-20 h-20 bg-green-100 rounded-full flex items-center justify-center mx-auto mb-4">
                <i class="fas fa-check text-green-600 text-3xl"></i>
            </div>
            <h1 class="text-3xl font-bold mb-2">Order Confirmed!</h1>
            <p class="text-gray-600">Thank you for your purchase. Your order has been received.</p>
        </div>
        
        <!-- Order Details -->
        <div class="bg-white rounded-lg shadow-sm p-6 mb-6">
            <h2 class="text-xl font-bold mb-4">Order Details</h2>
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                <div class="text-left">
                    <h3 class="font-bold mb-2 text-gray-800">Order Information</h3>
                    <div class="space-y-2">
                        <div class="flex justify-between">
                            <span class="text-gray-600">Order Number:</span>
                            <span class="font-medium">{{ $order->order_number }}</span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-gray-600">Order Date:</span>
                            <span class="font-medium">{{ \Carbon\Carbon::parse($order->created_at)->format('F d, Y') }}</span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-gray-600">Order Time:</span>
                            <span class="font-medium">{{ \Carbon\Carbon::parse($order->created_at)->format('h:i A') }}</span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-gray-600">Payment Status:</span>
                            @if($order->payment_status == 'paid')
                                <span class="font-medium text-green-600">Paid</span>
                            @elseif($order->payment_status == 'pending')
                                <span class="font-medium text-yellow-600">Pending</span>
                            @else
                                <span class="font-medium text-red-600">{{ ucfirst($order->payment_status) }}</span>
                            @endif
                        </div>
                        <div class="flex justify-between">
                            <span class="text-gray-600">Order Status:</span>
                            @if($order->status == 'pending')
                                <span class="font-medium text-yellow-600">Pending</span>
                            @elseif($order->status == 'processing')
                                <span class="font-medium text-blue-600">Processing</span>
                            @elseif($order->status == 'shipped')
                                <span class="font-medium text-purple-600">Shipped</span>
                            @elseif($order->status == 'delivered')
                                <span class="font-medium text-green-600">Delivered</span>
                            @else
                                <span class="font-medium">{{ ucfirst($order->status) }}</span>
                            @endif
                        </div>
                    </div>
                </div>
                
                <div class="text-left">
                    <h3 class="font-bold mb-2 text-gray-800">Customer Details</h3>
                    <div class="space-y-2">
                        <div class="flex justify-between">
                            <span class="text-gray-600">Customer Name:</span>
                            <span class="font-medium">{{ $order->customer_name }}</span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-gray-600">Email:</span>
                            <span class="font-medium">{{ $order->customer_email }}</span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-gray-600">Phone:</span>
                            <span class="font-medium">{{ $order->customer_phone }}</span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-gray-600">Payment Method:</span>
                            <span class="font-medium">
                                @if($order->payment_method == 'cod')
                                    Cash on Delivery
                                @elseif($order->payment_method == 'mpesa')
                                    M-Pesa
                                @else
                                    {{ ucfirst($order->payment_method) }}
                                @endif
                            </span>
                        </div>
                        @php
                            $shippingAddress = is_array($order->shipping_address) 
                                ? $order->shipping_address 
                                : json_decode($order->shipping_address, true);
                        @endphp
                        <div class="flex justify-between">
                            <span class="text-gray-600">Shipping To:</span>
                            <span class="font-medium text-right">
                                {{ $shippingAddress['city'] ?? '' }}, {{ $shippingAddress['state'] ?? '' }}
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Order Summary -->
            <div class="border-t border-gray-200 pt-6 mb-6">
                <h3 class="font-bold mb-4 text-gray-800">Order Summary</h3>
                <div class="space-y-3">
                    @foreach($order->items as $item)
                    <div class="flex justify-between items-center pb-3 border-b border-gray-100">
                        <div class="flex-1 text-left">
                            <p class="font-medium">{{ $item->product_name }}</p>
                            <p class="text-sm text-gray-500">Quantity: {{ $item->quantity }}</p>
                        </div>
                        <div class="text-right">
                            <p class="font-medium">Ksh {{ number_format($item->price, 2) }} × {{ $item->quantity }}</p>
                            <p class="font-bold">Ksh {{ number_format($item->total, 2) }}</p>
                        </div>
                    </div>
                    @endforeach
                    
                    <div class="pt-4 space-y-2">
                        <div class="flex justify-between">
                            <span class="text-gray-600">Subtotal:</span>
                            <span class="font-medium">Ksh {{ number_format($order->subtotal, 2) }}</span>
                        </div>
                        @if($order->tax > 0)
                        <div class="flex justify-between">
                            <span class="text-gray-600">Tax:</span>
                            <span class="font-medium">Ksh {{ number_format($order->tax, 2) }}</span>
                        </div>
                        @endif
                        @if($order->shipping > 0)
                        <div class="flex justify-between">
                            <span class="text-gray-600">Shipping:</span>
                            <span class="font-medium">Ksh {{ number_format($order->shipping, 2) }}</span>
                        </div>
                        @else
                        <div class="flex justify-between">
                            <span class="text-gray-600">Shipping:</span>
                            <span class="font-medium">To be calculated</span>
                        </div>
                        @endif
                        <div class="flex justify-between text-lg font-bold pt-2 border-t border-gray-300">
                            <span>Total Amount:</span>
                            <span class="text-[#0A9961]">Ksh {{ number_format($order->total, 2) }}</span>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Order Status Timeline -->
            <div class="border-t border-gray-200 pt-6">
                <h3 class="font-bold mb-4 text-gray-800">Order Status</h3>
                <div class="flex items-center justify-center space-x-4 md:space-x-8">
                    <!-- Order Placed -->
                    <div class="text-center">
                        <div class="w-12 h-12 rounded-full {{ $order->status == 'pending' || $order->status == 'processing' || $order->status == 'shipped' || $order->status == 'delivered' ? 'bg-[#0A9961] text-white' : 'bg-gray-100 text-gray-400' }} flex items-center justify-center mx-auto mb-2">
                            <i class="fas fa-check"></i>
                        </div>
                        <p class="text-sm font-medium">Order Placed</p>
                        <p class="text-xs text-gray-500">{{ \Carbon\Carbon::parse($order->created_at)->format('M d') }}</p>
                    </div>
                    
                    <div class="h-1 w-8 md:w-16 bg-gray-300"></div>
                    
                    <!-- Processing -->
                    <div class="text-center">
                        <div class="w-12 h-12 rounded-full {{ $order->status == 'processing' || $order->status == 'shipped' || $order->status == 'delivered' ? 'bg-[#0A9961] text-white' : 'bg-gray-100 text-gray-400' }} flex items-center justify-center mx-auto mb-2">
                            <i class="fas fa-cog"></i>
                        </div>
                        <p class="text-sm font-medium {{ $order->status == 'pending' ? 'text-gray-500' : '' }}">Processing</p>
                        <p class="text-xs {{ $order->status == 'pending' ? 'text-gray-400' : 'text-gray-500' }}">
                            @if($order->status == 'pending') Next @else 
                                {{ $order->status == 'processing' ? 'In Progress' : \Carbon\Carbon::parse($order->updated_at)->format('M d') }}
                            @endif
                        </p>
                    </div>
                    
                    <div class="h-1 w-8 md:w-16 bg-gray-300"></div>
                    
                    <!-- Shipped -->
                    <div class="text-center">
                        <div class="w-12 h-12 rounded-full {{ $order->status == 'shipped' || $order->status == 'delivered' ? 'bg-[#0A9961] text-white' : 'bg-gray-100 text-gray-400' }} flex items-center justify-center mx-auto mb-2">
                            <i class="fas fa-truck"></i>
                        </div>
                        <p class="text-sm font-medium {{ $order->status == 'pending' || $order->status == 'processing' ? 'text-gray-500' : '' }}">Shipped</p>
                        <p class="text-xs {{ $order->status == 'pending' || $order->status == 'processing' ? 'text-gray-400' : 'text-gray-500' }}">
                            {{ $order->status == 'shipped' || $order->status == 'delivered' ? '2-3 days' : 'Next' }}
                        </p>
                    </div>
                    
                    <div class="h-1 w-8 md:w-16 bg-gray-300"></div>
                    
                    <!-- Delivered -->
                    <div class="text-center">
                        <div class="w-12 h-12 rounded-full {{ $order->status == 'delivered' ? 'bg-[#0A9961] text-white' : 'bg-gray-100 text-gray-400' }} flex items-center justify-center mx-auto mb-2">
                            <i class="fas fa-home"></i>
                        </div>
                        <p class="text-sm font-medium {{ $order->status != 'delivered' ? 'text-gray-500' : '' }}">Delivered</p>
                        <p class="text-xs {{ $order->status != 'delivered' ? 'text-gray-400' : 'text-gray-500' }}">
                            {{ $order->status == 'delivered' ? 'Completed' : '3-5 days' }}
                        </p>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- What to Expect -->
        <div class="bg-blue-50 border border-blue-100 rounded-lg p-6 mb-6">
            <h3 class="text-lg font-semibold text-blue-800 mb-3">What happens next?</h3>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4 text-left">
                <div class="flex items-start">
                    <div class="bg-blue-100 p-2 rounded-lg mr-3">
                        <i class="fas fa-envelope text-blue-600"></i>
                    </div>
                    <div>
                        <h4 class="font-medium text-blue-800">Email Confirmation</h4>
                        <p class="text-sm text-blue-600">You'll receive an order confirmation email shortly</p>
                    </div>
                </div>
                <div class="flex items-start">
                    <div class="bg-blue-100 p-2 rounded-lg mr-3">
                        <i class="fas fa-shipping-fast text-blue-600"></i>
                    </div>
                    <div>
                        <h4 class="font-medium text-blue-800">Order Processing</h4>
                        @if($order->payment_method == 'cod')
                            <p class="text-sm text-blue-600">Our team will contact you within 24 hours to confirm shipping costs</p>
                        @else
                            <p class="text-sm text-blue-600">We'll prepare your order for shipment within 24 hours</p>
                        @endif
                    </div>
                </div>
                <div class="flex items-start">
                    <div class="bg-blue-100 p-2 rounded-lg mr-3">
                        <i class="fas fa-phone-alt text-blue-600"></i>
                    </div>
                    <div>
                        <h4 class="font-medium text-blue-800">Delivery Updates</h4>
                        <p class="text-sm text-blue-600">We'll notify you when your order is on the way</p>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Action Buttons -->
        <div class="flex flex-col sm:flex-row gap-4 justify-center">
            <a href="{{ route('home') }}" 
               class="px-6 py-3 bg-[#0A9961] text-white font-medium rounded-lg hover:bg-[#088753] transition-colors duration-200 text-center">
                Continue Shopping
            </a>
            <a href="{{ route('order.confirmation', $order->id) }}" 
               class="px-6 py-3 bg-white border border-gray-300 text-gray-700 font-medium rounded-lg hover:bg-gray-50 transition-colors duration-200 text-center">
                Track Order
            </a>
            <a href="{{ route('products.public') }}" 
               class="px-6 py-3 bg-gray-100 text-gray-700 font-medium rounded-lg hover:bg-gray-200 transition-colors duration-200 text-center">
                Browse More Products
            </a>
        </div>
        
        <!-- Help Section -->
        <div class="mt-8 pt-6 border-t border-gray-200">
            <h4 class="font-medium text-gray-700 mb-2">Need help with your order?</h4>
            <div class="flex flex-col sm:flex-row gap-3 justify-center">
                <a href="#" class="text-sm text-[#0A9961] hover:underline">
                    <i class="fas fa-question-circle mr-1"></i> FAQ
                </a>
                <span class="hidden sm:inline text-gray-300">|</span>
                <a href="#" class="text-sm text-[#0A9961] hover:underline">
                    <i class="fas fa-headset mr-1"></i> Contact Support
                </a>
                <span class="hidden sm:inline text-gray-300">|</span>
                <a href="{{ route('order.confirmation', $order->id) }}" class="text-sm text-[#0A9961] hover:underline">
                    <i class="fas fa-file-invoice mr-1"></i> View Invoice
                </a>
            </div>
        </div>
    </div>
</div>

<!-- Font Awesome for icons (if not already included) -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
@endsection