<nav x-data="{ open: false }" class="bg-white border-b border-gray-100 shadow-sm">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex justify-between h-16">
            <div class="flex">
                <!-- Logo -->
                <div class="shrink-0 flex items-center">
                    <a href="{{ route('home') }}" class="flex items-center"> <!-- Public home -->
                        <div class="h-8 w-8 rounded-md bg-[#0A9961] flex items-center justify-center mr-2">
                            <i class="fas fa-store text-white text-sm"></i>
                        </div>
                        <span class="text-lg font-bold text-gray-900">Electro<span class="text-[#0A9961]">Shop</span></span>
                    </a>
                </div>

                <!-- Navigation Links -->
                <div class="hidden space-x-8 sm:-my-px sm:ml-10 sm:flex">
                    <!-- Public Store Link (for everyone) -->
                    <x-nav-link :href="route('home')" :active="request()->routeIs('home')">
                        <i class="fas fa-home mr-2"></i> {{ __('Store') }}
                    </x-nav-link>
                    
                    <!-- Deals Link (ADDED) -->
                    <x-nav-link :href="route('deals.index')" :active="request()->routeIs('deals.*')">
                        <i class="fas fa-tag mr-2"></i> {{ __('Deals') }}
                    </x-nav-link>
                    
                    <!-- Public Products Link -->
                    <x-nav-link :href="route('products.public')" :active="request()->routeIs('products.public*')">
                        <i class="fas fa-shopping-bag mr-2"></i> {{ __('Shop') }}
                    </x-nav-link>
                    
                    <!-- Admin Links (only for authenticated users) -->
                    @auth
                        <x-nav-link :href="route('admin.dashboard')" :active="request()->routeIs('admin.dashboard')">
                            <i class="fas fa-tachometer-alt mr-2"></i> {{ __('Dashboard') }}
                        </x-nav-link>
                        <x-nav-link :href="route('admin.products.index')" :active="request()->routeIs('admin.products.*')">
                            <i class="fas fa-box mr-2"></i> {{ __('Products') }}
                        </x-nav-link>
                        <x-nav-link href="#" class="text-gray-500 hover:text-gray-700">
                            <i class="fas fa-shopping-cart mr-2"></i> {{ __('Orders') }}
                        </x-nav-link>
                        <x-nav-link href="#" class="text-gray-500 hover:text-gray-700">
                            <i class="fas fa-users mr-2"></i> {{ __('Customers') }}
                        </x-nav-link>
                    @endauth
                </div>
            </div>

            <!-- Right Side -->
            <div class="flex items-center space-x-4">
                <!-- Quick Actions (only for authenticated users) -->
                @auth
                <div class="hidden md:flex items-center space-x-3">
                    <a href="{{ route('admin.products.create') }}" 
                       class="inline-flex items-center px-3 py-1.5 bg-[#0A9961] hover:bg-[#088552] text-white text-sm font-medium rounded-lg transition-colors">
                        <i class="fas fa-plus mr-1.5"></i>
                        Add Product
                    </a>
                    
                    <!-- Notifications -->
                    <button class="relative p-2 text-gray-500 hover:text-gray-700">
                        <i class="fas fa-bell"></i>
                        <span class="absolute top-1 right-1 w-2 h-2 bg-red-500 rounded-full"></span>
                    </button>
                </div>
                @endauth

                <!-- Settings Dropdown -->
                <div class="hidden sm:flex sm:items-center sm:ml-0">
                    @auth
                        <x-dropdown align="right" width="48">
                            <x-slot name="trigger">
                                <button class="flex items-center text-sm font-medium text-gray-700 hover:text-gray-900 focus:outline-none transition duration-150 ease-in-out">
                                    <div class="w-8 h-8 rounded-full bg-gray-200 flex items-center justify-center mr-2">
                                        <span class="text-sm font-semibold text-gray-700">
                                            {{ strtoupper(substr(Auth::user()->name, 0, 1)) }}
                                        </span>
                                    </div>
                                    <div>{{ Auth::user()->name }}</div>
                                    <div class="ml-1">
                                        <svg class="fill-current h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20">
                                            <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                                        </svg>
                                    </div>
                                </button>
                            </x-slot>

                            <x-slot name="content">
                                <x-dropdown-link :href="route('admin.dashboard')">
                                    <i class="fas fa-tachometer-alt mr-2 text-gray-400"></i> Admin Dashboard
                                </x-dropdown-link>
                                <x-dropdown-link :href="route('admin.products.index')">
                                    <i class="fas fa-box mr-2 text-gray-400"></i> Products
                                </x-dropdown-link>
                                <x-dropdown-link :href="route('home')">
                                    <i class="fas fa-store mr-2 text-gray-400"></i> Visit Store
                                </x-dropdown-link>
                                <div class="border-t border-gray-100"></div>
                                <form method="POST" action="{{ route('logout') }}">
                                    @csrf
                                    <x-dropdown-link :href="route('logout')"
                                            onclick="event.preventDefault();
                                                        this.closest('form').submit();">
                                        <i class="fas fa-sign-out-alt mr-2 text-gray-400"></i> {{ __('Log Out') }}
                                    </x-dropdown-link>
                                </form>
                            </x-slot>
                        </x-dropdown>
                    @else
                        <!-- Guest user links -->
                        <div class="flex items-center space-x-4">
                            <a href="{{ route('products.public') }}" class="text-sm text-gray-700 hover:text-gray-900">
                                <i class="fas fa-shopping-bag mr-1"></i> Shop
                            </a>
                            <a href="{{ route('deals.index') }}" class="text-sm text-gray-700 hover:text-gray-900">
                                <i class="fas fa-tag mr-1"></i> Deals
                            </a>
                            <a href="{{ route('login') }}" class="text-sm text-gray-700 hover:text-gray-900">
                                <i class="fas fa-sign-in-alt mr-1"></i> Login
                            </a>
                            <a href="{{ route('register') }}" 
                               class="inline-flex items-center px-3 py-1 bg-[#0A9961] hover:bg-[#088552] text-white text-sm font-medium rounded-lg transition-colors">
                                <i class="fas fa-user-plus mr-1.5"></i> Sign Up
                            </a>
                        </div>
                    @endauth
                </div>
            </div>

            <!-- Hamburger -->
            <div class="-mr-2 flex items-center sm:hidden">
                <button @click="open = ! open" class="inline-flex items-center justify-center p-2 rounded-md text-gray-400 hover:text-gray-500 hover:bg-gray-100 focus:outline-none focus:bg-gray-100 focus:text-gray-500 transition duration-150 ease-in-out">
                    <svg class="h-6 w-6" stroke="currentColor" fill="none" viewBox="0 0 24 24">
                        <path :class="{'hidden': open, 'inline-flex': ! open }" class="inline-flex" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                        <path :class="{'hidden': ! open, 'inline-flex': open }" class="hidden" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>
            </div>
        </div>
    </div>

    <!-- Responsive Navigation Menu -->
    <div :class="{'block': open, 'hidden': ! open}" class="hidden sm:hidden">
        <div class="pt-2 pb-3 space-y-1">
            <!-- Public Links -->
            <x-responsive-nav-link :href="route('home')" :active="request()->routeIs('home')">
                <i class="fas fa-home mr-3 text-gray-400"></i> {{ __('Store') }}
            </x-responsive-nav-link>
            
            <!-- Deals Link (ADDED) -->
            <x-responsive-nav-link :href="route('deals.index')" :active="request()->routeIs('deals.*')">
                <i class="fas fa-tag mr-3 text-gray-400"></i> {{ __('Deals') }}
            </x-responsive-nav-link>
            
            <x-responsive-nav-link :href="route('products.public')" :active="request()->routeIs('products.public*')">
                <i class="fas fa-shopping-bag mr-3 text-gray-400"></i> {{ __('Shop') }}
            </x-responsive-nav-link>
            
            <!-- Admin Links (only for authenticated users) -->
            @auth
                <x-responsive-nav-link :href="route('admin.dashboard')" :active="request()->routeIs('admin.dashboard')">
                    <i class="fas fa-tachometer-alt mr-3 text-gray-400"></i> {{ __('Dashboard') }}
                </x-responsive-nav-link>
                <x-responsive-nav-link :href="route('admin.products.index')" :active="request()->routeIs('admin.products.*')">
                    <i class="fas fa-box mr-3 text-gray-400"></i> {{ __('Products') }}
                </x-responsive-nav-link>
                <x-responsive-nav-link href="#">
                    <i class="fas fa-shopping-cart mr-3 text-gray-400"></i> {{ __('Orders') }}
                </x-responsive-nav-link>
                <x-responsive-nav-link href="#">
                    <i class="fas fa-users mr-3 text-gray-400"></i> {{ __('Customers') }}
                </x-responsive-nav-link>
            @endauth
        </div>

        <!-- Responsive Settings Options -->
        <div class="pt-4 pb-1 border-t border-gray-200">
            @auth
                <div class="px-4">
                    <div class="font-medium text-base text-gray-800">{{ Auth::user()->name }}</div>
                    <div class="font-medium text-sm text-gray-500">{{ Auth::user()->email }}</div>
                </div>

                <div class="mt-3 space-y-1">
                    <x-responsive-nav-link :href="route('admin.products.create')">
                        <i class="fas fa-plus mr-3 text-gray-400"></i> Add Product
                    </x-responsive-nav-link>
                    <x-responsive-nav-link :href="route('home')">
                        <i class="fas fa-store mr-3 text-gray-400"></i> Visit Store
                    </x-responsive-nav-link>
                    <form method="POST" action="{{ route('logout') }}">
                        @csrf
                        <x-responsive-nav-link :href="route('logout')"
                                onclick="event.preventDefault();
                                            this.closest('form').submit();">
                            <i class="fas fa-sign-out-alt mr-3 text-gray-400"></i> {{ __('Log Out') }}
                        </x-responsive-nav-link>
                    </form>
                </div>
            @else
                <div class="px-4 py-2 space-y-2">
                    <a href="{{ route('login') }}" class="block text-sm text-gray-700 hover:text-gray-900">
                        <i class="fas fa-sign-in-alt mr-2 text-gray-400"></i> Login
                    </a>
                    <a href="{{ route('register') }}" class="block text-sm text-gray-700 hover:text-gray-900">
                        <i class="fas fa-user-plus mr-2 text-gray-400"></i> Register
                    </a>
                </div>
            @endauth
        </div>
    </div>
</nav>

<!-- Add Font Awesome for icons -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<style>
    /* Custom styles for navigation */
    .bg-\[\#0A9961\] {
        background-color: #0A9961;
    }
    
    .hover\:bg-\[\#088552\]:hover {
        background-color: #088552;
    }
    
    .text-\[\#0A9961\] {
        color: #0A9961;
    }
</style>