<!DOCTYPE html>
<html>
<head>
    <title>New Order Notification</title>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
        .container { max-width: 600px; margin: 0 auto; padding: 20px; }
        .header { background: #dc3545; color: white; padding: 20px; text-align: center; }
        .content { padding: 20px; background: #f9f9f9; }
        .order-details { background: white; padding: 15px; border-radius: 5px; margin: 15px 0; }
        .highlight { color: #dc3545; font-weight: bold; }
        .btn { display: inline-block; padding: 10px 20px; background: #0A9961; color: white; text-decoration: none; border-radius: 5px; }
        .deal-info { background: #d4edda; border: 1px solid #c3e6cb; padding: 10px; border-radius: 5px; margin: 10px 0; }
        .items-table { width: 100%; border-collapse: collapse; margin: 15px 0; }
        .items-table th, .items-table td { padding: 8px; text-align: left; border-bottom: 1px solid #ddd; }
        .deal-badge { background: #ffc107; color: #856404; padding: 2px 6px; border-radius: 3px; font-size: 11px; font-weight: bold; }
        .original-price { text-decoration: line-through; color: #999; font-size: 0.9em; }
        .savings { color: #28a745; font-weight: bold; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>New Order Received!</h1>
        </div>
        
        <div class="content">
            <p>Hello Admin,</p>
            
            <p>A new order has been placed on the website. Here are the order details:</p>
            
            @if($totalDiscount > 0)
            <div class="deal-info">
                <p><strong>🎯 Deal Applied:</strong> Customer saved <span class="savings">Ksh {{ number_format($totalDiscount, 2) }}</span> with special offers!</p>
            </div>
            @endif
            
            <div class="order-details">
                <h3>Order Information</h3>
                <p><strong>Order Number:</strong> <span class="highlight">{{ $order->order_number }}</span></p>
                <p><strong>Order Date:</strong> {{ $order->created_at->format('F j, Y H:i') }}</p>
                <p><strong>Customer:</strong> {{ $order->customer_name }}</p>
                <p><strong>Email:</strong> {{ $order->customer_email }}</p>
                <p><strong>Phone:</strong> {{ $order->customer_phone }}</p>
                <p><strong>Payment Method:</strong> {{ $paymentMethod === 'cod' ? 'Cash on Delivery' : 'M-Pesa' }}</p>
                <p><strong>Total Amount:</strong> Ksh {{ number_format($order->total, 2) }}</p>
                
                @if($paymentMethod === 'cod')
                <p><strong style="color: #dc3545;">ACTION REQUIRED:</strong> Contact customer to confirm shipping costs.</p>
                @endif
            </div>
            
            <div class="order-details">
                <h3>Order Items</h3>
                <table class="items-table">
                    <thead>
                        <tr>
                            <th>Product</th>
                            <th>Qty</th>
                            <th>Price</th>
                            <th>Total</th>
                            <th>Deal</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($order->items as $item)
                        @php
                            $hasDeal = !empty($item->deal_id);
                            $itemDiscount = $hasDeal && $item->original_price ? ($item->original_price - $item->price) * $item->quantity : 0;
                        @endphp
                        <tr>
                            <td>{{ $item->product_name }}</td>
                            <td>{{ $item->quantity }}</td>
                            <td>
                                @if($hasDeal && $item->original_price)
                                    <div>Ksh {{ number_format($item->price, 2) }}</div>
                                    <div class="original-price">Ksh {{ number_format($item->original_price, 2) }}</div>
                                @else
                                    Ksh {{ number_format($item->price, 2) }}
                                @endif
                            </td>
                            <td>
                                @if($itemDiscount > 0)
                                    <div>Ksh {{ number_format($item->price * $item->quantity, 2) }}</div>
                                    <div class="original-price">Ksh {{ number_format($item->original_price * $item->quantity, 2) }}</div>
                                @else
                                    Ksh {{ number_format($item->price * $item->quantity, 2) }}
                                @endif
                            </td>
                            <td>
                                @if($hasDeal)
                                    <span class="deal-badge">
                                        @if($item->deal_type == 'percentage')
                                            {{ $item->deal_discount_value }}%
                                        @else
                                            Ksh {{ number_format($item->deal_discount_value) }}
                                        @endif
                                    </span>
                                @else
                                    -
                                @endif
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        @if($totalDiscount > 0)
                        <tr>
                            <td colspan="3" style="text-align: right;"><strong>Original Subtotal:</strong></td>
                            <td><span class="original-price">Ksh {{ number_format($order->items->sum(function($item) { return ($item->original_price ?? $item->price) * $item->quantity; }), 2) }}</span></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td colspan="3" style="text-align: right;"><strong>Discount:</strong></td>
                            <td class="savings">- Ksh {{ number_format($totalDiscount, 2) }}</td>
                            <td></td>
                        </tr>
                        @endif
                        <tr>
                            <td colspan="3" style="text-align: right;"><strong>Subtotal:</strong></td>
                            <td>Ksh {{ number_format($order->subtotal, 2) }}</td>
                            <td></td>
                        </tr>
                        <tr style="border-top: 2px solid #dc3545;">
                            <td colspan="3" style="text-align: right;"><strong>Order Total:</strong></td>
                            <td><strong>Ksh {{ number_format($order->total, 2) }}</strong></td>
                            <td></td>
                        </tr>
                    </tfoot>
                </table>
            </div>
            
            <div class="order-details">
                <h3>Shipping Address</h3>
                @php
                    $shipping = json_decode($order->shipping_address, true);
                @endphp
                <p><strong>Name:</strong> {{ $shipping['name'] ?? '' }}</p>
                <p><strong>Address:</strong> {{ $shipping['address'] ?? '' }}</p>
                <p><strong>City:</strong> {{ $shipping['city'] ?? '' }}</p>
                <p><strong>State:</strong> {{ $shipping['state'] ?? '' }}</p>
                <p><strong>Zip:</strong> {{ $shipping['zip'] ?? '' }}</p>
                <p><strong>Country:</strong> {{ $shipping['country'] ?? '' }}</p>
                <p><strong>Phone:</strong> {{ $shipping['phone'] ?? '' }}</p>
                <p><strong>Email:</strong> {{ $shipping['email'] ?? '' }}</p>
                @if(!empty($shipping['notes']))
                <p><strong>Notes:</strong> {{ $shipping['notes'] }}</p>
                @endif
            </div>
            
            <div style="text-align: center; margin: 20px 0;">
                <a href="{{ url('/admin/orders/' . $order->id) }}" class="btn">View Order in Admin Panel</a>
            </div>
            
            <p>Please process this order as soon as possible.</p>
        </div>
        
        <div style="text-align: center; padding: 20px; color: #666; font-size: 12px;">
            <p>{{ config('app.name') }} - Admin Notification System</p>
            <p>This is an automated message.</p>
        </div>
    </div>
</body>
</html>