@extends('layouts.app')

@section('header')
    <h2 class="font-semibold text-xl text-gray-800 leading-tight">
        {{ __('Admin Dashboard') }}
    </h2>
@endsection

@section('content')
<div class="py-6">
    <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
        <!-- Welcome Card -->
        <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg mb-6">
            <div class="p-6 bg-gradient-to-r from-[#0A9961] to-[#10B981] text-white rounded-lg">
                <div class="flex flex-col md:flex-row md:items-center justify-between">
                    <div>
                        <h1 class="text-2xl font-bold mb-2">Welcome back, Admin! 👋</h1>
                        <p class="text-green-100">Manage your store from the admin panel</p>
                    </div>
                    <div class="mt-4 md:mt-0">
                        <a href="{{ route('home') }}" target="_blank" 
                           class="inline-flex items-center bg-white text-[#0A9961] hover:bg-gray-100 font-medium py-2 px-4 rounded-lg transition-colors">
                            <i class="fas fa-external-link-alt mr-2"></i> View Store
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Quick Stats -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
            <!-- Total Products -->
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-sm font-medium text-gray-600">Total Products</p>
                            <p class="text-2xl font-bold text-gray-900 mt-1">{{ \App\Models\Product::count() }}</p>
                        </div>
                        <div class="p-3 rounded-lg bg-purple-50">
                            <i class="fas fa-box text-xl text-purple-600"></i>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Out of Stock -->
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-sm font-medium text-gray-600">Out of Stock</p>
                            <p class="text-2xl font-bold text-gray-900 mt-1">{{ \App\Models\Product::where('stock', 0)->count() }}</p>
                        </div>
                        <div class="p-3 rounded-lg bg-red-50">
                            <i class="fas fa-exclamation-triangle text-xl text-red-600"></i>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Low Stock -->
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-sm font-medium text-gray-600">Low Stock</p>
                            <p class="text-2xl font-bold text-gray-900 mt-1">{{ \App\Models\Product::where('stock', '>', 0)->where('stock', '<', 10)->count() }}</p>
                        </div>
                        <div class="p-3 rounded-lg bg-yellow-50">
                            <i class="fas fa-exclamation-circle text-xl text-yellow-600"></i>
                        </div>
                    </div>
                </div>
            </div>

            <!-- In Stock -->
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-sm font-medium text-gray-600">In Stock</p>
                            <p class="text-2xl font-bold text-gray-900 mt-1">{{ \App\Models\Product::where('stock', '>', 10)->count() }}</p>
                        </div>
                        <div class="p-3 rounded-lg bg-green-50">
                            <i class="fas fa-check-circle text-xl text-green-600"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Quick Actions -->
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <!-- Manage Products -->
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">Manage Products</h3>
                    <div class="space-y-3">
                        <a href="{{ route('admin.products.index') }}" 
                           class="flex items-center justify-between p-3 border border-gray-200 rounded-lg hover:bg-gray-50 transition-colors">
                            <div class="flex items-center">
                                <div class="w-10 h-10 rounded-lg bg-blue-50 flex items-center justify-center mr-3">
                                    <i class="fas fa-list text-blue-600"></i>
                                </div>
                                <span class="font-medium text-gray-900">View All Products</span>
                            </div>
                            <i class="fas fa-chevron-right text-gray-400"></i>
                        </a>
                        
                        <a href="{{ route('admin.products.create') }}" 
                           class="flex items-center justify-between p-3 border border-gray-200 rounded-lg hover:bg-gray-50 transition-colors">
                            <div class="flex items-center">
                                <div class="w-10 h-10 rounded-lg bg-green-50 flex items-center justify-center mr-3">
                                    <i class="fas fa-plus text-green-600"></i>
                                </div>
                                <span class="font-medium text-gray-900">Add New Product</span>
                            </div>
                            <i class="fas fa-chevron-right text-gray-400"></i>
                        </a>
                    </div>
                </div>
            </div>

            <!-- Store Overview -->
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">Store Overview</h3>
                    <div class="space-y-4">
                        <div class="flex items-center justify-between">
                            <div class="flex items-center">
                                <i class="fas fa-store text-gray-400 mr-3"></i>
                                <span class="text-gray-700">Store Status</span>
                            </div>
                            <span class="px-3 py-1 bg-green-100 text-green-800 text-sm font-medium rounded-full">Active</span>
                        </div>
                        <div class="flex items-center justify-between">
                            <div class="flex items-center">
                                <i class="fas fa-users text-gray-400 mr-3"></i>
                                <span class="text-gray-700">Today's Visitors</span>
                            </div>
                            <span class="font-medium text-gray-900">124</span>
                        </div>
                        <div class="flex items-center justify-between">
                            <div class="flex items-center">
                                <i class="fas fa-shopping-cart text-gray-400 mr-3"></i>
                                <span class="text-gray-700">Pending Orders</span>
                            </div>
                            <span class="font-medium text-gray-900">15</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add Font Awesome -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
@endsection