@extends('layouts.app')

@section('content')
<div class="min-h-screen flex items-center justify-center bg-gradient-to-br from-gray-50 to-green-50 py-12">
    <div class="bg-white rounded-2xl w-full max-w-md p-8 shadow-2xl border border-green-100">
        <!-- Header -->
        <div class="text-center mb-8">
            <div class="w-20 h-20 bg-[#0A9961] rounded-2xl flex items-center justify-center mx-auto mb-4 shadow-lg">
                <svg class="w-10 h-10 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M18 9v3m0 0v3m0-3h3m-3 0h-3m-2-5a4 4 0 11-8 0 4 4 0 018 0zM3 20a6 6 0 0112 0v1H3v-1z" />
                </svg>
            </div>
            <h1 class="text-2xl font-bold text-gray-800 mb-2">Admin Registration</h1>
            <p class="text-gray-600 text-sm">Create admin account for ElectroShop</p>
        </div>

        <!-- Validation Errors -->
        @if ($errors->any())
            <div class="mb-6 p-4 bg-red-50 border border-red-200 rounded-xl">
                <div class="text-red-600 text-sm">
                    <ul class="list-disc list-inside space-y-1">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            </div>
        @endif

        <form method="POST" action="{{ route('admin.register') }}">
            @csrf

            <!-- Admin Secret Key -->
            <div class="mb-6">
                <label class="block text-gray-700 font-medium mb-3 text-sm uppercase tracking-wide" for="admin_key">Admin Secret Key</label>
                <div class="relative">
                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                        <svg class="h-5 w-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"/>
                        </svg>
                    </div>
                    <input id="admin_key" type="password" name="admin_key" required
                        class="w-full pl-10 pr-4 py-3 bg-white border border-gray-300 rounded-xl text-gray-800 placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-[#0A9961] focus:border-transparent transition duration-200"
                        placeholder="Enter admin secret key">
                </div>
                <p class="text-xs text-gray-500 mt-2">Contact system administrator for the secret key</p>
            </div>

            <!-- Name -->
            <div class="mb-6">
                <label class="block text-gray-700 font-medium mb-3 text-sm uppercase tracking-wide" for="name">Full Name</label>
                <div class="relative">
                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                        <svg class="h-5 w-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                        </svg>
                    </div>
                    <input id="name" type="text" name="name" value="{{ old('name') }}" required autofocus
                        class="w-full pl-10 pr-4 py-3 bg-white border border-gray-300 rounded-xl text-gray-800 placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-[#0A9961] focus:border-transparent transition duration-200"
                        placeholder="Enter your full name">
                </div>
                @error('name')
                    <span class="text-red-500 text-sm mt-2 block">{{ $message }}</span>
                @enderror
            </div>

            <!-- Email -->
            <div class="mb-6">
                <label class="block text-gray-700 font-medium mb-3 text-sm uppercase tracking-wide" for="email">Email Address</label>
                <div class="relative">
                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                        <svg class="h-5 w-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 12a4 4 0 10-8 0 4 4 0 008 0zm0 0v1.5a2.5 2.5 0 005 0V12a9 9 0 10-9 9m4.5-1.206a8.959 8.959 0 01-4.5 1.207"/>
                        </svg>
                    </div>
                    <input id="email" type="email" name="email" value="{{ old('email') }}" required
                        class="w-full pl-10 pr-4 py-3 bg-white border border-gray-300 rounded-xl text-gray-800 placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-[#0A9961] focus:border-transparent transition duration-200"
                        placeholder="Enter your email address">
                </div>
                @error('email')
                    <span class="text-red-500 text-sm mt-2 block">{{ $message }}</span>
                @enderror
            </div>

            <!-- Password -->
            <div class="mb-6">
                <label class="block text-gray-700 font-medium mb-3 text-sm uppercase tracking-wide" for="password">Create Password</label>
                <div class="relative">
                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                        <svg class="h-5 w-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"/>
                        </svg>
                    </div>
                    <input id="password" type="password" name="password" required autocomplete="new-password"
                        class="w-full pl-10 pr-12 py-3 bg-white border border-gray-300 rounded-xl text-gray-800 placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-[#0A9961] focus:border-transparent transition duration-200"
                        placeholder="Create a secure password">
                </div>
                @error('password')
                    <span class="text-red-500 text-sm mt-2 block">{{ $message }}</span>
                @enderror
            </div>

            <!-- Confirm Password -->
            <div class="mb-6">
                <label class="block text-gray-700 font-medium mb-3 text-sm uppercase tracking-wide" for="password_confirmation">Confirm Password</label>
                <div class="relative">
                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                        <svg class="h-5 w-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"/>
                        </svg>
                    </div>
                    <input id="password_confirmation" type="password" name="password_confirmation" required
                        class="w-full pl-10 pr-4 py-3 bg-white border border-gray-300 rounded-xl text-gray-800 placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-[#0A9961] focus:border-transparent transition duration-200"
                        placeholder="Re-enter your password">
                </div>
                @error('password_confirmation')
                    <span class="text-red-500 text-sm mt-2 block">{{ $message }}</span>
                @enderror
            </div>

            <!-- Submit -->
            <button type="submit"
                class="w-full bg-[#0A9961] hover:bg-[#088551] text-white font-semibold py-3.5 rounded-xl transition duration-300 transform hover:scale-[1.02] shadow-lg hover:shadow-xl mb-4">
                Create Admin Account
            </button>
        </form>

        <!-- Additional Info -->
        <div class="text-center mt-6 pt-6 border-t border-gray-200">
            <p class="text-gray-600 text-sm mb-3">
                Already have an account?
            </p>
            <a href="{{ route('login') }}" 
               class="inline-block border-2 border-[#0A9961] text-[#0A9961] hover:bg-[#0A9961] hover:text-white py-2 px-6 rounded-xl text-sm font-medium transition duration-200">
                Sign In
            </a>
        </div>

        <!-- Support Info -->
        <div class="text-center mt-6">
            <p class="text-gray-500 text-xs">
                Need help? Contact system administrator
                <br>
                <span class="text-[#0A9961]">admin@electroshop.com</span>
            </p>
        </div>
    </div>
</div>
@endsection