@extends('layouts.admin-layout')

@section('content')
<div class="bg-white rounded-lg shadow-sm">
    <!-- Transaction Header -->
    <div class="border-b border-gray-200 px-6 py-4">
        <div class="flex justify-between items-start">
            <div>
                <h1 class="text-2xl font-bold text-gray-900">M-Pesa Transaction Details</h1>
                <div class="flex items-center space-x-4 mt-2">
                    @php
                        $statusColors = [
                            'success' => 'bg-green-100 text-green-800',
                            'pending' => 'bg-yellow-100 text-yellow-800',
                            'failed' => 'bg-red-100 text-red-800'
                        ];
                        $color = $statusColors[$transaction->status] ?? 'bg-gray-100 text-gray-800';
                    @endphp
                    <span class="px-3 py-1 inline-flex text-sm leading-5 font-semibold rounded-full {{ $color }}">
                        {{ ucfirst($transaction->status) }}
                    </span>
                    @if($transaction->order)
                    <a href="{{ route('admin.orders.show', $transaction->order) }}" 
                       class="text-[#0A9961] hover:text-[#088753] hover:underline text-sm font-medium">
                        Order: {{ $transaction->order->order_number }}
                    </a>
                    @endif
                    <span class="text-gray-500">
                        <i class="far fa-calendar mr-1"></i>
                        {{ $transaction->created_at->format('F d, Y h:i A') }}
                    </span>
                </div>
            </div>
            <div class="flex space-x-3">
                <a href="{{ route('admin.transactions.index') }}" 
                   class="bg-gray-100 hover:bg-gray-200 text-gray-700 px-4 py-2 rounded-lg text-sm font-medium transition-colors duration-200">
                    <i class="fas fa-arrow-left mr-2"></i>Back to Transactions
                </a>
            </div>
        </div>
    </div>

    <div class="p-6">
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-6 mb-8">
            <!-- Transaction Information -->
            <div class="bg-gray-50 rounded-lg p-5">
                <h3 class="text-lg font-semibold text-gray-900 mb-4 pb-2 border-b border-gray-200">
                    <i class="fas fa-info-circle mr-2 text-[#0A9961]"></i>Transaction Information
                </h3>
                <div class="space-y-3">
                    <div>
                        <p class="text-sm text-gray-500">Transaction ID</p>
                        <p class="font-mono font-medium">
                            @if($transaction->transaction_id)
                                {{ $transaction->transaction_id }}
                            @else
                                <span class="text-gray-400">Not assigned</span>
                            @endif
                        </p>
                    </div>
                    @if($transaction->checkout_request_id)
                    <div>
                        <p class="text-sm text-gray-500">Checkout Request ID</p>
                        <p class="font-mono text-sm">{{ $transaction->checkout_request_id }}</p>
                    </div>
                    @endif
                    @if($transaction->merchant_request_id)
                    <div>
                        <p class="text-sm text-gray-500">Merchant Request ID</p>
                        <p class="font-mono text-sm">{{ $transaction->merchant_request_id }}</p>
                    </div>
                    @endif
                    <div>
                        <p class="text-sm text-gray-500">Amount</p>
                        <p class="text-xl font-bold text-gray-900">Ksh {{ number_format($transaction->amount, 2) }}</p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500">Transaction Time</p>
                        <p class="font-medium">
                            @if($transaction->transaction_time)
                                {{ $transaction->transaction_time->format('F d, Y h:i A') }}
                            @else
                                <span class="text-gray-400">N/A</span>
                            @endif
                        </p>
                    </div>
                </div>
            </div>

            <!-- Customer Information -->
            <div class="bg-gray-50 rounded-lg p-5">
                <h3 class="text-lg font-semibold text-gray-900 mb-4 pb-2 border-b border-gray-200">
                    <i class="fas fa-user mr-2 text-[#0A9961]"></i>Customer Information
                </h3>
                <div class="space-y-3">
                    <div>
                        <p class="text-sm text-gray-500">Phone Number</p>
                        <p class="font-medium flex items-center">
                            <i class="fas fa-phone text-gray-400 mr-2"></i>
                            {{ $transaction->phone_number }}
                        </p>
                    </div>
                    @if($transaction->user)
                    <div>
                        <p class="text-sm text-gray-500">Customer Name</p>
                        <p class="font-medium">{{ $transaction->user->name }}</p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500">Customer Email</p>
                        <p class="font-medium">{{ $transaction->user->email }}</p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500">User ID</p>
                        <p class="font-medium">{{ $transaction->user->id }}</p>
                    </div>
                    @else
                    <div>
                        <p class="text-sm text-gray-500">Customer Type</p>
                        <p class="font-medium text-gray-400">Guest</p>
                    </div>
                    @endif
                </div>
            </div>

            <!-- Response Information -->
            <div class="bg-gray-50 rounded-lg p-5">
                <h3 class="text-lg font-semibold text-gray-900 mb-4 pb-2 border-b border-gray-200">
                    <i class="fas fa-exchange-alt mr-2 text-[#0A9961]"></i>Response Information
                </h3>
                <div class="space-y-3">
                    <div>
                        <p class="text-sm text-gray-500">Response Code</p>
                        <p class="font-medium">
                            @if($transaction->response_code)
                                <span class="{{ $transaction->response_code == '0' ? 'text-green-600' : 'text-red-600' }}">
                                    {{ $transaction->response_code }}
                                </span>
                            @else
                                <span class="text-gray-400">N/A</span>
                            @endif
                        </p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500">Response Description</p>
                        <p class="font-medium">{{ $transaction->response_description ?? 'N/A' }}</p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500">Customer Message</p>
                        <p class="font-medium">{{ $transaction->customer_message ?? 'N/A' }}</p>
                    </div>
                    @if($transaction->account_reference)
                    <div>
                        <p class="text-sm text-gray-500">Account Reference</p>
                        <p class="font-mono text-sm">{{ $transaction->account_reference }}</p>
                    </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- Raw Data -->
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
            <!-- Request Data -->
            @if($transaction->request_data)
            <div class="bg-white border border-gray-200 rounded-lg">
                <div class="px-6 py-4 border-b border-gray-200">
                    <h3 class="text-lg font-semibold text-gray-900">
                        <i class="fas fa-paper-plane mr-2 text-blue-600"></i>
                        Request Data
                    </h3>
                </div>
                <div class="p-4">
                    <pre class="bg-gray-50 p-4 rounded-lg text-sm overflow-x-auto max-h-96"><code>{{ json_encode($transaction->request_data, JSON_PRETTY_PRINT) }}</code></pre>
                </div>
            </div>
            @endif

            <!-- Response Data -->
            @if($transaction->response_data)
            <div class="bg-white border border-gray-200 rounded-lg">
                <div class="px-6 py-4 border-b border-gray-200">
                    <h3 class="text-lg font-semibold text-gray-900">
                        <i class="fas fa-reply mr-2 text-green-600"></i>
                        Response Data
                    </h3>
                </div>
                <div class="p-4">
                    <pre class="bg-gray-50 p-4 rounded-lg text-sm overflow-x-auto max-h-96"><code>{{ json_encode($transaction->response_data, JSON_PRETTY_PRINT) }}</code></pre>
                </div>
            </div>
            @endif
        </div>

        <!-- Action Buttons -->
        <div class="mt-8 flex justify-end space-x-4 pt-6 border-t border-gray-200">
            @if($transaction->order)
            <a href="{{ route('admin.orders.show', $transaction->order) }}" 
               class="bg-[#0A9961] hover:bg-[#088753] text-white px-6 py-3 rounded-lg font-medium transition-colors duration-200">
                <i class="fas fa-shopping-cart mr-2"></i>View Order
            </a>
            @endif
            <button onclick="window.print()" 
                    class="bg-gray-100 hover:bg-gray-200 text-gray-700 px-6 py-3 rounded-lg font-medium transition-colors duration-200">
                <i class="fas fa-print mr-2"></i>Print Details
            </button>
        </div>
    </div>
</div>

@if(request()->has('print'))
<script>
    window.onload = function() {
        window.print();
    }
</script>
@endif
@endsection