<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Invoice - Finepoint Electronics</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        @media print {
            @page {
                size: A4;
                margin: 0;
            }
            body {
                margin: 1.5cm;
            }
            .no-print {
                display: none !important;
            }
            .break-after {
                page-break-after: always;
            }
        }
        body {
            font-family: 'Inter', sans-serif;
        }
        .logo-wrapper {
            background: linear-gradient(135deg, #0A9961 0%, #088753 100%);
        }
    </style>
</head>
<body class="bg-white text-gray-800">
    <div class="max-w-4xl mx-auto">
        <!-- Print Header -->
        <div class="no-print mb-6">
            <div class="flex justify-between items-center">
                <h1 class="text-2xl font-bold text-gray-900">Invoice Preview</h1>
                <div class="flex space-x-3">
                    <button onclick="window.history.back()" class="px-4 py-2 bg-gray-100 hover:bg-gray-200 text-gray-700 rounded-lg font-medium">
                        Back
                    </button>
                    <button onclick="window.print()" class="px-4 py-2 bg-[#0A9961] hover:bg-[#088753] text-white rounded-lg font-medium">
                        🖨️ Print Invoice
                    </button>
                </div>
            </div>
        </div>

        <!-- Invoice Content -->
        <div class="bg-white border border-gray-200 rounded-xl shadow-sm p-8">
            <!-- Invoice Header -->
            <div class="flex justify-between items-start border-b border-gray-300 pb-8 mb-8">
                <div>
                    <div class="logo-wrapper w-64 h-18 rounded-lg flex items-center justify-center mb-4">
                        <div class="text-white text-center">
                            <h1 class="text-2xl font-bold">FINEPOINT ELECTRONICS</h1>
                            <p class="text-sm opacity-90">Quality Electronics & Gadgets</p>
                        </div>
                    </div>
                    <div class="text-gray-600">
                        <p>Nairobi, Kenya</p>
                        <p>Email: info@finepoint.co.ke</p>
                        <p>Phone: +254 700 000 000</p>
                        <p>Website: www.finepoint.co.ke</p>
                    </div>
                </div>
                
                <div class="text-right">
                    <h2 class="text-3xl font-bold text-gray-900 mb-2">INVOICE</h2>
                    <div class="space-y-1">
                        <p class="text-gray-600">
                            <span class="font-medium">Invoice No:</span> 
                            <span class="font-bold text-[#0A9961]">{{ $order->order_number }}</span>
                        </p>
                        <p class="text-gray-600">
                            <span class="font-medium">Date:</span> 
                            {{ $order->created_at->format('F d, Y') }}
                        </p>
                        <p class="text-gray-600">
                            <span class="font-medium">Time:</span> 
                            {{ $order->created_at->format('h:i A') }}
                        </p>
                        <p class="text-gray-600">
                            <span class="font-medium">Status:</span> 
                            <span class="font-bold uppercase">{{ ucfirst($order->status) }}</span>
                        </p>
                    </div>
                </div>
            </div>

            <!-- Bill To & Invoice Details -->
            <div class="grid grid-cols-2 gap-8 mb-8">
                <div>
                    <h3 class="text-lg font-semibold text-gray-900 mb-3">Bill To</h3>
                    <div class="bg-gray-50 p-4 rounded-lg">
                        <p class="font-bold text-gray-900">{{ $order->customer_name }}</p>
                        <p class="text-gray-600">{{ $order->customer_email }}</p>
                        <p class="text-gray-600">{{ $order->customer_phone }}</p>
                        
                        @php
                            $shipping = is_array($order->shipping_address) ? $order->shipping_address : json_decode($order->shipping_address, true);
                        @endphp
                        @if(is_array($shipping))
                            <div class="mt-2">
                                <p class="text-gray-600">{{ $shipping['address'] ?? '' }}</p>
                                <p class="text-gray-600">
                                    {{ $shipping['city'] ?? '' }}, 
                                    {{ $shipping['state'] ?? '' }}
                                </p>
                                <p class="text-gray-600">{{ $shipping['country'] ?? '' }}</p>
                            </div>
                        @else
                            <p class="text-gray-600 mt-2">{{ $order->shipping_address }}</p>
                        @endif
                    </div>
                </div>
                
                <div>
                    <h3 class="text-lg font-semibold text-gray-900 mb-3">Payment Details</h3>
                    <div class="bg-gray-50 p-4 rounded-lg">
                        <div class="space-y-2">
                            <div class="flex justify-between">
                                <span class="text-gray-600">Payment Method:</span>
                                <span class="font-medium">{{ strtoupper($order->payment_method) }}</span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-gray-600">Payment Status:</span>
                                <span class="font-bold {{ $order->payment_status === 'paid' ? 'text-green-600' : 'text-yellow-600' }}">
                                    {{ strtoupper($order->payment_status) }}
                                </span>
                            </div>
                            @if($order->payment_method === 'paybill')
                           <!-- <div class="mt-3 p-3 bg-yellow-50 border border-yellow-200 rounded">
                                <p class="text-sm font-medium text-yellow-800">Paybill Instructions:</p>
                                <p class="text-sm text-yellow-700">Pay to: 123456</p>
                                <p class="text-sm text-yellow-700">Account: {{ $order->order_number }}</p>
                            </div>-->
                            @endif
                        </div>
                    </div>
                </div>
            </div>

            <!-- Order Items Table -->
            <div class="mb-8">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Order Items</h3>
                <table class="w-full border-collapse">
                    <thead>
                        <tr class="bg-gray-100">
                            <th class="py-3 px-4 text-left font-semibold text-gray-700 border-b border-gray-300">Description</th>
                            <th class="py-3 px-4 text-right font-semibold text-gray-700 border-b border-gray-300">Unit Price</th>
                            <th class="py-3 px-4 text-right font-semibold text-gray-700 border-b border-gray-300">Qty</th>
                            <th class="py-3 px-4 text-right font-semibold text-gray-700 border-b border-gray-300">Amount</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($order->items as $item)
                        <tr class="border-b border-gray-200">
                            <td class="py-4 px-4">
                                <div class="flex items-center">
                                    <div class="mr-4">
                                        @if($item->product && $item->product->image)
                                            <img src="{{ asset($item->product->image) }}" 
                                                 alt="{{ $item->product_name }}"
                                                 class="w-12 h-12 object-cover rounded border border-gray-200">
                                        @else
                                            <div class="w-12 h-12 bg-gray-100 rounded border border-gray-200 flex items-center justify-center">
                                                <span class="text-gray-400 text-xs">IMG</span>
                                            </div>
                                        @endif
                                    </div>
                                    <div>
                                        <p class="font-medium text-gray-900">{{ $item->product_name }}</p>
                                        @if($item->product && $item->product->sku)
                                        <p class="text-sm text-gray-500">SKU: {{ $item->product->sku }}</p>
                                        @endif
                                    </div>
                                </div>
                            </td>
                            <td class="py-4 px-4 text-right">Ksh {{ number_format($item->price, 2) }}</td>
                            <td class="py-4 px-4 text-right">{{ $item->quantity }}</td>
                            <td class="py-4 px-4 text-right font-medium">Ksh {{ number_format($item->total, 2) }}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <!-- Totals -->
            <div class="flex justify-end">
                <div class="w-80">
                    <div class="space-y-3">
                        <div class="flex justify-between">
                            <span class="text-gray-600">Subtotal:</span>
                            <span class="font-medium">Ksh {{ number_format($order->subtotal, 2) }}</span>
                        </div>
                        @if($order->tax > 0)
                        <div class="flex justify-between">
                            <span class="text-gray-600">Tax (16%):</span>
                            <span class="font-medium">Ksh {{ number_format($order->tax, 2) }}</span>
                        </div>
                        @endif
                        @if($order->shipping > 0)
                        <div class="flex justify-between">
                            <span class="text-gray-600">Shipping:</span>
                            <span class="font-medium">Ksh {{ number_format($order->shipping, 2) }}</span>
                        </div>
                        @endif
                        <div class="flex justify-between pt-3 border-t border-gray-300">
                            <span class="text-lg font-bold text-gray-900">TOTAL:</span>
                            <span class="text-lg font-bold text-[#0A9961]">Ksh {{ number_format($order->total, 2) }}</span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Terms & Footer -->
            <div class="mt-12 pt-8 border-t border-gray-300">
                <div class="grid grid-cols-2 gap-8">
                    <div>
                        <h4 class="font-semibold text-gray-900 mb-2">Payment Terms</h4>
                        <ul class="text-sm text-gray-600 list-disc pl-5 space-y-1">
                            <li>Payment due upon receipt</li>
                        </ul>
                    </div>
                    <div>
                        <h4 class="font-semibold text-gray-900 mb-2">Thank You!</h4>
                    </div>
                </div>
                
                <div class="mt-8 text-center text-gray-500 text-sm">
                    <p>Finepoint Electronics &copy; {{ date('Y') }} | Nairobi, Kenya</p>
                    <p>Email: info@finepoint.co.ke | Phone: +254 723 210 538</p>
                    <p class="mt-2 font-medium">This is a computer-generated invoice. No signature required.</p>
                </div>
            </div>
        </div>


    <script>
        // Auto-print if coming from print button
        @if(request()->has('print'))
        window.onload = function() {
            setTimeout(function() {
                window.print();
            }, 1000);
        };
        @endif
        
        // Close window after printing (optional)
        window.onafterprint = function() {
            // You can close the window or redirect back
            // window.close();
        };
    </script>
</body>
</html>