<?php
echo "<h3>Simple M-Pesa Test</h3>";

// Include Laravel
require __DIR__.'/../vendor/autoload.php';
$app = require_once __DIR__.'/../bootstrap/app.php';
$app->make(Illuminate\Contracts\Console\Kernel::class)->bootstrap();

// Test 1: Check config
echo "<p>1. Checking configuration...</p>";
echo "<p>Consumer Key: " . (config('services.mpesa.consumer_key') ? 'Set' : 'Not set') . "</p>";
echo "<p>Shortcode: " . config('services.mpesa.shortcode') . "</p>";
echo "<p>Environment: " . config('services.mpesa.environment') . "</p>";

// Test 2: Manual phone formatting
echo "<p>2. Testing phone formatting manually...</p>";

$testPhone = '0712345678';
echo "<p>Input: $testPhone</p>";

// Manual cleaning (no regex)
$cleaned = '';
for ($i = 0; $i < strlen($testPhone); $i++) {
    $char = $testPhone[$i];
    if ($char >= '0' && $char <= '9') {
        $cleaned .= $char;
    }
}
echo "<p>Cleaned: $cleaned</p>";

// Format to 254
if (strlen($cleaned) > 0 && $cleaned[0] == '0') {
    $formatted = '254' . substr($cleaned, 1);
} elseif (strlen($cleaned) == 9) {
    $formatted = '254' . $cleaned;
} else {
    $formatted = $cleaned;
}

echo "<p>Formatted: $formatted (Expected: 254712345678)</p>";

if ($formatted === '254712345678') {
    echo "<p style='color: green;'>✓ Phone formatting works!</p>";
} else {
    echo "<p style='color: red;'>✗ Phone formatting failed</p>";
}

// Test 3: Direct API call
echo "<p>3. Testing direct API call...</p>";

$consumerKey = config('services.mpesa.consumer_key');
$consumerSecret = config('services.mpesa.consumer_secret');
$url = 'https://sandbox.safaricom.co.ke/oauth/v1/generate?grant_type=client_credentials';

$ch = curl_init($url);
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HEADER, false);
curl_setopt($ch, CURLOPT_USERPWD, $consumerKey . ':' . $consumerSecret);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

if (curl_errno($ch)) {
    echo "<p style='color: red;'>cURL Error: " . curl_error($ch) . "</p>";
} else {
    echo "<p style='color: green;'>HTTP Code: $httpCode</p>";
    
    $data = json_decode($response);
    if (isset($data->access_token)) {
        echo "<p style='color: green;'>✓ Access Token: " . substr($data->access_token, 0, 20) . "...</p>";
        
        // Now test STK push directly
        echo "<p>4. Testing STK Push...</p>";
        
        $timestamp = date('YmdHis');
        $password = base64_encode(config('services.mpesa.shortcode') . config('services.mpesa.passkey') . $timestamp);
        
        $stkData = [
            'BusinessShortCode' => config('services.mpesa.shortcode'),
            'Password' => $password,
            'Timestamp' => $timestamp,
            'TransactionType' => 'CustomerPayBillOnline',
            'Amount' => 1,
            'PartyA' => '254708374149',
            'PartyB' => config('services.mpesa.shortcode'),
            'PhoneNumber' => '254708374149',
            'CallBackURL' => config('services.mpesa.callback_url'),
            'AccountReference' => 'TEST123',
            'TransactionDesc' => 'Test Payment'
        ];
        
        $ch2 = curl_init('https://sandbox.safaricom.co.ke/mpesa/stkpush/v1/processrequest');
        curl_setopt($ch2, CURLOPT_HTTPHEADER, [
            'Authorization: Bearer ' . $data->access_token,
            'Content-Type: application/json'
        ]);
        curl_setopt($ch2, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch2, CURLOPT_POST, true);
        curl_setopt($ch2, CURLOPT_POSTFIELDS, json_encode($stkData));
        curl_setopt($ch2, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch2, CURLOPT_TIMEOUT, 30);
        
        $stkResponse = curl_exec($ch2);
        $stkHttpCode = curl_getinfo($ch2, CURLINFO_HTTP_CODE);
        
        if (curl_errno($ch2)) {
            echo "<p style='color: red;'>STK cURL Error: " . curl_error($ch2) . "</p>";
        } else {
            echo "<p style='color: green;'>STK HTTP Code: $stkHttpCode</p>";
            echo "<p>STK Response: " . htmlspecialchars($stkResponse) . "</p>";
            
            $stkResult = json_decode($stkResponse);
            if (isset($stkResult->ResponseCode) && $stkResult->ResponseCode == "0") {
                echo "<p style='color: green; font-weight: bold;'>✓ STK Push Successful!</p>";
                echo "<p>Customer Message: " . ($stkResult->CustomerMessage ?? 'Check your phone') . "</p>";
            } else {
                echo "<p style='color: red;'>✗ STK Push Failed</p>";
                if (isset($stkResult->errorMessage)) {
                    echo "<p>Error: " . $stkResult->errorMessage . "</p>";
                }
            }
        }
        curl_close($ch2);
        
    } else {
        echo "<p style='color: red;'>✗ No access token in response</p>";
        echo "<p>Response: " . htmlspecialchars($response) . "</p>";
    }
}
curl_close($ch);