<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use App\Models\SystemSetting;

return new class extends Migration
{
    public function up()
    {
        // Add Direct Paybill settings (empty by default)
        SystemSetting::setValue('direct_paybill_enabled', '0', 'boolean', 'Enable/disable Direct Paybill payments');
        SystemSetting::setValue('paybill_number', '', 'string', 'Bank Paybill number for manual payments');
        SystemSetting::setValue('paybill_account_number', '', 'string', 'Account number for paybill payments');
        SystemSetting::setValue('paybill_instructions', '', 'text', 'Instructions shown to customers for paybill payments');
    }

    public function down()
    {
        // Remove the settings
        SystemSetting::whereIn('key', [
            'direct_paybill_enabled',
            'paybill_number', 
            'paybill_account_number',
            'paybill_instructions'
        ])->delete();
    }
};