<?php

namespace App\Mail;

use App\Models\Order;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class PaybillPaymentApproved extends Mailable
{
    use Queueable, SerializesModels;

    public $order;
    public $orderUrl;

    /**
     * Create a new message instance.
     */
    public function __construct(Order $order)
    {
        $this->order = $order;
        $this->orderUrl = route('order.confirmation', ['order' => $order->id]);
    }

    /**
     * Build the message.
     */
    public function build()
    {
        return $this->subject('✅ Payment Verified - Order #' . $this->order->order_number)
                   ->view('emails.paybill-approved')
                   ->with([
                       'order' => $this->order,
                       'orderUrl' => $this->orderUrl,
                   ]);
    }
}