<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class WelcomeNotification extends Notification implements ShouldQueue
{
    use Queueable;

    public $user;

    /**
     * Create a new notification instance.
     */
    public function __construct($user)
    {
        $this->user = $user;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
                    ->subject('👋 Welcome to Finepoint Electronics!')
                    ->greeting('Hello ' . $this->user->name . '!')
                    ->line('Welcome to Finepoint Electronics - Your trusted electronics store!')
                    ->line('We\'re excited to have you on board.')
                    ->line('**Your account is now active and you can:**')
                    ->line('• Browse our latest products and deals')
                    ->line('• Add items to your cart')
                    ->line('• Checkout securely with M-Pesa')
                    ->line('• Track your orders')
                    ->action('Start Shopping', url('/products'))
                    ->line('Need help? Contact our support team at support@finepoint.com')
                    ->line('Thank you for joining us!')
                    ->salutation('Best Regards,<br>The Finepoint Electronics Team');
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            'user_id' => $this->user->id,
            'user_name' => $this->user->name,
        ];
    }
}