<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class NewDealNotification extends Notification implements ShouldQueue
{
    use Queueable;

    public $deal;

    /**
     * Create a new notification instance.
     */
    public function __construct($deal)
    {
        $this->deal = $deal;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
                    ->subject('🔥 Hot New Deal: ' . $this->deal->title . '!')
                    ->greeting('Hello ' . $notifiable->name . '!')
                    ->line('Check out our latest hot deal just for you!')
                    ->line('**' . $this->deal->title . '**')
                    ->line($this->deal->description)
                    ->line('**Deal Details:**')
                    ->line('Discount: ' . ($this->deal->type == 'percentage' ? $this->deal->discount_value . '% OFF' : 'Ksh ' . number_format($this->deal->discount_value) . ' OFF'))
                    ->line('Valid Until: ' . $this->deal->end_date->format('F d, Y'))
                    ->line('Time Left: ' . $this->deal->end_date->diffForHumans(['parts' => 2]))
                    ->action('View Deal & Shop Now', url('/deals/' . $this->deal->slug))
                    ->line('Hurry up! This offer won\'t last long!')
                    ->line('Thank you for being a valued Finepoint Electronics customer!');
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            'deal_id' => $this->deal->id,
            'deal_title' => $this->deal->title,
            'discount' => $this->deal->discount_value . ($this->deal->type == 'percentage' ? '%' : ' Ksh'),
        ];
    }
}