<?php
/**
 * TEMPORARY CACHE CLEARING ROUTE
 * 
 * Add this to your routes/web.php file on the HOSTED server
 * Use this if you don't have SSH access to run artisan commands
 * 
 * After uploading new files, visit:
 * http://66.29.134.231/~finepoint/public/deploy-clear
 * 
 * IMPORTANT: Remove this route after deployment is complete!
 */

Route::get('/deploy-clear', function() {
    try {
        // Clear all caches
        Artisan::call('config:clear');
        Artisan::call('cache:clear');
        Artisan::call('route:clear');
        Artisan::call('view:clear');
        Artisan::call('optimize:clear');
        
        $output = [
            'status' => 'success',
            'message' => 'All caches cleared successfully!',
            'cleared' => [
                'config' => 'Configuration cache cleared',
                'cache' => 'Application cache cleared',
                'route' => 'Route cache cleared',
                'view' => 'View cache cleared',
                'optimize' => 'Optimized cache cleared'
            ],
            'timestamp' => now()->toDateTimeString(),
            'next_steps' => [
                '1. Test COD checkout',
                '2. Test M-Pesa payment',
                '3. Remove this /deploy-clear route from web.php'
            ]
        ];
        
        return response()->json($output, 200);
        
    } catch (\Exception $e) {
        return response()->json([
            'status' => 'error',
            'message' => 'Error clearing cache: ' . $e->getMessage()
        ], 500);
    }
})->name('deploy.clear');

/**
 * USAGE:
 * 1. Add this code to routes/web.php on hosted server
 * 2. Visit: http://66.29.134.231/~finepoint/public/deploy-clear
 * 3. You should see JSON response confirming cache was cleared
 * 4. Test your checkout functionality
 * 5. REMOVE THIS ROUTE after successful deployment
 */
