# PuTTY SSH Connection Guide - Finepoint Hosted Server

## Step 1: Download PuTTY (if you don't have it)

**Download Link:** https://www.putty.org/

Download: **putty.exe** (64-bit x86)

---

## Step 2: Get Your SSH Credentials

You need these details (usually from your hosting provider):

1. **Host Name/IP Address:** `66.29.134.231`
2. **Port:** `22` (default SSH port)
3. **Username:** Usually your cPanel username (e.g., `finepoint` or similar)
4. **Password:** Your cPanel password or SSH password

### Where to Find SSH Credentials:

**Via cPanel:**
1. Login to cPanel
2. Look for **"SSH Access"** or **"Terminal"** section
3. You should see:
   - SSH Host/IP
   - SSH Port
   - Username
   - Option to enable SSH access (if disabled)

**Common Usernames:**
- `finepoint`
- Your domain name without extension
- Check your hosting welcome email

---

## Step 3: Open PuTTY and Configure

### Launch PuTTY:
1. Open `putty.exe`
2. You'll see the PuTTY Configuration window

### Configure Connection:
```
┌─────────────────────────────────────┐
│ PuTTY Configuration                 │
├─────────────────────────────────────┤
│                                     │
│ Category: Session                   │
│                                     │
│ Host Name (or IP address):          │
│ ┌─────────────────────────────────┐ │
│ │ 66.29.134.231                   │ │
│ └─────────────────────────────────┘ │
│                                     │
│ Port: ┌────┐                        │
│       │ 22 │                        │
│       └────┘                        │
│                                     │
│ Connection type:                    │
│ ○ Raw  ○ Telnet  ● SSH  ○ Other    │
│                                     │
│ Saved Sessions:                     │
│ ┌─────────────────────────────────┐ │
│ │ Finepoint Server                │ │
│ └─────────────────────────────────┘ │
│                                     │
│ [Load] [Save] [Delete]              │
│                                     │
│                    [Open] [Cancel]  │
└─────────────────────────────────────┘
```

**Settings:**
- **Host Name:** `66.29.134.231`
- **Port:** `22`
- **Connection type:** Select **SSH** (radio button)

### Save Session (Optional but Recommended):
1. In "Saved Sessions" box, type: `Finepoint Server`
2. Click **[Save]** button
3. Next time you can just double-click "Finepoint Server" to connect

### Click **[Open]** to Connect

---

## Step 4: First Connection - Security Alert

**You'll see a security alert:**
```
┌──────────────────────────────────────────┐
│ PuTTY Security Alert                     │
├──────────────────────────────────────────┤
│                                          │
│ The server's host key is not cached...  │
│                                          │
│ Do you trust this host?                  │
│                                          │
│   [Yes]  [No]  [Cancel]                  │
└──────────────────────────────────────────┘
```

**Click [Yes]** - This is normal for first-time connections.

---

## Step 5: Login

### You'll see a black terminal window:
```
login as: _
```

**Type your username** (e.g., `finepoint`) and press **Enter**

```
login as: finepoint
finepoint@66.29.134.231's password: _
```

**Type your password** and press **Enter**
- **Note:** The password won't show as you type (not even dots) - this is normal!
- Just type it and press Enter

### Successful Login:
```
Welcome to your server!
Last login: Tue Dec 17 19:30:00 2025

[finepoint@server ~]$ _
```

You're now connected! ✅

---

## Step 6: Navigate to Your Project Directory

Run these commands one by one:

### 1. Check current directory:
```bash
pwd
```
**Output:** Shows current directory (e.g., `/home/finepoint`)

### 2. Navigate to your project:
```bash
cd public_html
```

### 3. Verify you're in the right place:
```bash
ls -la
```
**You should see:** `app`, `bootstrap`, `config`, `database`, `public`, `routes`, etc.

### 4. Check if composer exists:
```bash
which composer
```
**OR**
```bash
ls -la composer.phar
```

---

## Step 7: Run the Fix Commands

### Option A: If composer is in PATH:
```bash
composer dump-autoload
php artisan config:clear
php artisan cache:clear
php artisan route:clear
php artisan view:clear
php artisan optimize:clear
```

### Option B: If using composer.phar:
```bash
php composer.phar dump-autoload
php artisan config:clear
php artisan cache:clear
php artisan route:clear
php artisan view:clear
php artisan optimize:clear
```

### Expected Output:
```
Loading composer repositories with package information
Generating optimized autoload files
Generated optimized autoload files containing 1234 classes

Configuration cache cleared!
Application cache cleared!
Route cache cleared!
Compiled views cleared!
Compiled services and packages files removed!
Caches cleared successfully!
```

---

## Step 8: Verify Mail Classes Exist

Run this command to check if the Mail classes are now recognized:

```bash
php artisan tinker
```

Then inside tinker, type:
```php
class_exists('App\Mail\OrderPlaced')
```
**Expected:** `=> true`

Type `exit` to leave tinker.

---

## Step 9: Test Your Application

1. Exit SSH (type `exit` or close PuTTY)
2. Go to your website
3. Try COD checkout again
4. It should work now! ✅

---

## Common Issues & Solutions

### Issue 1: "Permission denied (publickey)"
**Solution:** SSH is not enabled or wrong credentials
- Check cPanel → SSH Access → Enable SSH
- Verify username and password

### Issue 2: "Connection refused"
**Solution:** 
- Port might not be 22
- Check with hosting provider
- Try port 2222 or 2083

### Issue 3: "composer: command not found"
**Solution:** Use composer.phar instead:
```bash
php composer.phar dump-autoload
```

### Issue 4: "php: command not found"
**Solution:** Use full path:
```bash
/usr/bin/php composer.phar dump-autoload
```
OR
```bash
/usr/local/bin/php composer.phar dump-autoload
```

### Issue 5: Can't find composer.phar
**Solution:** Download it:
```bash
curl -sS https://getcomposer.org/installer | php
php composer.phar dump-autoload
```

---

## Quick Command Reference

### Navigate:
```bash
pwd                    # Show current directory
cd public_html         # Go to project
cd ..                  # Go up one level
ls -la                 # List all files
```

### Laravel Artisan:
```bash
php artisan list       # Show all commands
php artisan cache:clear
php artisan config:clear
php artisan route:clear
php artisan view:clear
```

### Composer:
```bash
composer dump-autoload
composer install
composer update
```

### File Operations:
```bash
cat filename.php       # View file contents
nano filename.php      # Edit file (Ctrl+X to exit)
tail -f storage/logs/laravel.log  # Watch logs
```

### Exit SSH:
```bash
exit
```
OR just close PuTTY window

---

## Alternative: cPanel Terminal

If PuTTY doesn't work, try cPanel Terminal:

1. Login to cPanel
2. Find **"Terminal"** icon (usually in Advanced section)
3. Click it - opens a web-based terminal
4. You're already logged in!
5. Run the same commands as Step 7

---

## Need Help?

If you get stuck:
1. Take a screenshot of the error
2. Note which step you're on
3. Share the error message

The most important command is:
```bash
composer dump-autoload
```

This regenerates the autoload files so Laravel can find your Mail classes.

Good luck! 🚀
