# Hosted Server 500 Error Troubleshooting Guide

## Issue
Cash on Delivery checkout works on localhost but gives 500 error on hosted server:
- URL: `http://66.29.134.231/~finepoint/public/process-cod-checkout`
- Error: 500 Internal Server Error

## Possible Causes & Solutions

### 1. **Old Code Still on Server** ⚠️ MOST LIKELY
The hosted server probably still has the old `CheckoutController.php` with the `actual_payment_method` validation.

**Solution:**
- Upload the updated `CheckoutController.php` to the server
- Path on server: `/home/finepoint/public_html/app/Http/Controllers/CheckoutController.php`

**Files to Upload:**
1. `app/Http/Controllers/CheckoutController.php` (removed `actual_payment_method` validation)
2. `app/Http/Controllers/PaymentController.php` (removed tax & shipping)
3. `routes/web.php` (added Mail facade)

---

### 2. **Check Laravel Error Logs**
**Location on Server:**
```
/home/finepoint/public_html/storage/logs/laravel.log
```

**Via cPanel:**
1. Login to cPanel
2. File Manager → Navigate to `public_html/storage/logs/`
3. Open `laravel.log` (latest entries at bottom)
4. Look for errors around the time you tested

**What to Look For:**
- Validation errors mentioning `actual_payment_method`
- Missing class/namespace errors
- Database connection errors
- Permission errors

---

### 3. **Clear Cache on Server**
After uploading new files, run these commands via SSH or cPanel Terminal:

```bash
cd /home/finepoint/public_html
php artisan config:clear
php artisan cache:clear
php artisan route:clear
php artisan view:clear
```

**If no SSH access:**
Create a temporary route in `web.php`:
```php
Route::get('/clear-cache', function() {
    Artisan::call('config:clear');
    Artisan::call('cache:clear');
    Artisan::call('route:clear');
    Artisan::call('view:clear');
    return 'Cache cleared!';
});
```
Then visit: `http://66.29.134.231/~finepoint/public/clear-cache`

---

### 4. **Check File Permissions**
Ensure these directories are writable (755 or 775):
```
storage/
storage/logs/
storage/framework/
storage/framework/cache/
storage/framework/sessions/
storage/framework/views/
bootstrap/cache/
```

**Fix via cPanel:**
1. File Manager → Select folder
2. Right-click → Change Permissions
3. Set to 755 or 775

---

### 5. **Check .env Configuration**
Ensure the hosted `.env` file has:
```env
APP_ENV=production
APP_DEBUG=false  # Set to true temporarily to see errors
APP_URL=http://66.29.134.231/~finepoint/public

DB_CONNECTION=mysql
DB_HOST=localhost
DB_PORT=3306
DB_DATABASE=your_database_name
DB_USERNAME=your_database_user
DB_PASSWORD=your_database_password
```

**Temporarily enable debug mode:**
```env
APP_DEBUG=true
```
This will show the actual error on screen instead of generic 500 error.

---

### 6. **Check PHP Version**
Ensure server is running PHP 8.0 or higher (same as localhost).

**Check via cPanel:**
- MultiPHP Manager → Select domain → Choose PHP version

---

### 7. **Database Issues**
Check if:
- Database connection is working
- `orders` table exists
- `order_items` table exists
- User has permissions to INSERT

---

## Quick Fix Steps (In Order)

### Step 1: Enable Debug Mode
1. Edit `.env` on server
2. Set `APP_DEBUG=true`
3. Try checkout again
4. Note the exact error message

### Step 2: Upload Updated Files
Upload these 3 files from localhost to server:
1. `app/Http/Controllers/CheckoutController.php`
2. `app/Http/Controllers/PaymentController.php`
3. `routes/web.php`

### Step 3: Clear All Cache
Run cache clear commands (see section 3 above)

### Step 4: Test Again
Try COD checkout again

### Step 5: Check Logs
If still failing, check `storage/logs/laravel.log`

---

## Most Likely Solution

Based on the symptoms, the issue is almost certainly that **the hosted server has the old code** with the `actual_payment_method` validation that we just removed.

**Action Required:**
1. Upload the updated `CheckoutController.php` to the server
2. Clear the cache
3. Test again

---

## Need More Help?

If the issue persists after uploading files and clearing cache:
1. Check the Laravel log file
2. Enable APP_DEBUG=true temporarily
3. Share the exact error message
