# Deployment Checklist - Upload These Files to Hosted Server

## Files Modified (Need to Upload)

### ✅ 1. CheckoutController.php
**Local Path:** `c:\wamp64\www\finepoint\app\Http\Controllers\CheckoutController.php`
**Server Path:** `/home/finepoint/public_html/app/Http/Controllers/CheckoutController.php`

**Changes Made:**
- Removed `actual_payment_method` validation (line 121)

---

### ✅ 2. PaymentController.php
**Local Path:** `c:\wamp64\www\finepoint\app\Http\Controllers\PaymentController.php`
**Server Path:** `/home/finepoint/public_html/app/Http/Controllers/PaymentController.php`

**Changes Made:**
- Removed tax calculation (16% VAT)
- Removed shipping fee calculation
- Set tax = 0, shipping = 0

---

### ✅ 3. web.php
**Local Path:** `c:\wamp64\www\finepoint\routes\web.php`
**Server Path:** `/home/finepoint/public_html/routes/web.php`

**Changes Made:**
- Added `use Illuminate\Support\Facades\Mail;` import

---

## Upload Methods

### Option 1: FTP/SFTP (Recommended)
1. Use FileZilla or similar FTP client
2. Connect to: `66.29.134.231`
3. Navigate to `/home/finepoint/public_html/`
4. Upload the 3 files to their respective paths
5. Overwrite existing files

### Option 2: cPanel File Manager
1. Login to cPanel
2. File Manager → Navigate to `public_html`
3. Upload files one by one to correct directories
4. Confirm overwrite

### Option 3: Git (If Available)
```bash
# On server via SSH
cd /home/finepoint/public_html
git pull origin main
```

---

## After Upload - IMPORTANT!

### Clear All Cache (Required)
Run these commands via SSH or create a temporary route:

**Via SSH:**
```bash
cd /home/finepoint/public_html
php artisan config:clear
php artisan cache:clear
php artisan route:clear
php artisan view:clear
php artisan optimize:clear
```

**Via Temporary Route (if no SSH):**
Add to `routes/web.php` temporarily:
```php
Route::get('/deploy-clear', function() {
    Artisan::call('config:clear');
    Artisan::call('cache:clear');
    Artisan::call('route:clear');
    Artisan::call('view:clear');
    Artisan::call('optimize:clear');
    return 'Deployment cache cleared! You can now remove this route.';
});
```
Visit: `http://66.29.134.231/~finepoint/public/deploy-clear`

---

## Testing After Deployment

### Test 1: Cash on Delivery
1. Add product to cart
2. Go to checkout
3. Fill in shipping details
4. Select "Cash on Delivery"
5. Submit form
6. **Expected:** Should redirect to order confirmation
7. **Should NOT see:** "actual payment method field is required" error

### Test 2: M-Pesa Payment
1. Add product to cart (e.g., Ksh 1.00 product)
2. Go to checkout
3. Fill in shipping details
4. Select "M-Pesa"
5. Enter phone number
6. Complete payment
7. **Expected:** Payment amount should match product price exactly
8. **Should NOT see:** "Payment amount does not match order total" error

---

## If Still Getting 500 Error

### Enable Debug Mode Temporarily
Edit `.env` on server:
```env
APP_DEBUG=true
```

This will show the actual error instead of generic 500 error.

**Remember to set back to false after debugging:**
```env
APP_DEBUG=false
```

### Check Laravel Logs
Location: `/home/finepoint/public_html/storage/logs/laravel.log`

Look for the most recent error entries.

---

## Quick Command Reference

### Clear Cache (All Methods)
```bash
php artisan optimize:clear
```

### Check Routes
```bash
php artisan route:list | grep checkout
```

### Check Config
```bash
php artisan config:show
```

### View Logs (Last 50 lines)
```bash
tail -n 50 storage/logs/laravel.log
```

---

## Rollback Plan (If Something Goes Wrong)

If the deployment causes issues:

1. **Restore from backup** (if you made one)
2. **Or revert files** via cPanel File Manager
3. **Clear cache again**
4. **Contact me with error logs**

---

## Success Indicators

✅ COD checkout completes without errors
✅ M-Pesa payment amount matches product price
✅ Orders are created in database
✅ No 500 errors
✅ Redirect to order confirmation page works

---

## Notes

- The hosted server URL includes `/public/` in the path, which is normal for shared hosting
- Make sure to clear cache after every file upload
- Keep APP_DEBUG=false in production for security
- Monitor the error logs for the first few orders

---

## Contact Info

If you encounter issues:
1. Check the Laravel log file first
2. Enable APP_DEBUG temporarily to see exact error
3. Share the error message for further assistance
