<?php
/**
 * TEMPORARY AUTOLOAD FIX ROUTE
 * 
 * Add this to routes/web.php on the HOSTED server
 * This will regenerate the autoload files and clear all caches
 * 
 * Visit: http://66.29.134.231/~finepoint/public/fix-autoload
 * 
 * IMPORTANT: Remove this route after running it once!
 */

Route::get('/fix-autoload', function() {
    try {
        $results = [];
        
        // 1. Regenerate composer autoload files
        $composerPath = base_path('composer.phar');
        if (file_exists($composerPath)) {
            exec('cd ' . base_path() . ' && php composer.phar dump-autoload 2>&1', $output, $return);
            $results['composer_dump_autoload'] = [
                'status' => $return === 0 ? 'success' : 'failed',
                'output' => implode("\n", $output)
            ];
        } else {
            // Try system composer
            exec('cd ' . base_path() . ' && composer dump-autoload 2>&1', $output, $return);
            $results['composer_dump_autoload'] = [
                'status' => $return === 0 ? 'success' : 'failed',
                'output' => implode("\n", $output)
            ];
        }
        
        // 2. Clear all Laravel caches
        Artisan::call('config:clear');
        $results['config_clear'] = 'success';
        
        Artisan::call('cache:clear');
        $results['cache_clear'] = 'success';
        
        Artisan::call('route:clear');
        $results['route_clear'] = 'success';
        
        Artisan::call('view:clear');
        $results['view_clear'] = 'success';
        
        Artisan::call('optimize:clear');
        $results['optimize_clear'] = 'success';
        
        // 3. Check if Mail classes exist
        $mailClasses = [
            'App\Mail\OrderPlaced',
            'App\Mail\NewOrderNotification',
            'App\Mail\PaybillPaymentVerification',
            'App\Mail\PaybillPaymentApproved'
        ];
        
        $classCheck = [];
        foreach ($mailClasses as $class) {
            $classCheck[$class] = class_exists($class) ? 'EXISTS' : 'NOT FOUND';
        }
        
        return response()->json([
            'status' => 'completed',
            'message' => 'Autoload regenerated and caches cleared',
            'results' => $results,
            'mail_classes_check' => $classCheck,
            'timestamp' => now()->toDateTimeString(),
            'next_steps' => [
                '1. Check that all Mail classes show "EXISTS"',
                '2. Test COD checkout again',
                '3. Remove this /fix-autoload route from web.php'
            ]
        ], 200);
        
    } catch (\Exception $e) {
        return response()->json([
            'status' => 'error',
            'message' => 'Error: ' . $e->getMessage(),
            'trace' => $e->getTraceAsString()
        ], 500);
    }
})->name('fix.autoload');

/**
 * ALTERNATIVE: Manual Composer Dump Autoload
 * 
 * If the above doesn't work, you can manually run composer dump-autoload
 * via cPanel Terminal or SSH:
 * 
 * cd /home/finepoint/public_html
 * composer dump-autoload
 * 
 * OR if composer is not in PATH:
 * 
 * cd /home/finepoint/public_html
 * php composer.phar dump-autoload
 */
